/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.alg.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.IAlg;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IVector;

public class LineAlg
implements IAlg {
    protected int S_NOTSTARTED = 0;
    protected int S_GENERATING = 1;
    protected int S_ENDED = 2;
    protected int x1_;
    protected int y1_;
    protected int x2_;
    protected int y2_;
    protected int state_;
    protected int xd;
    protected int yd;
    protected int px_;
    protected int py_;
    protected int ax;
    protected int ay;
    protected int sx;
    protected int sy;
    protected double tgx_;
    protected double tgy_;
    protected boolean update_tangent_;

    public LineAlg(int _x1, int _y1, int _x2, int _y2) {
        this.setLine(_x1, _y1, _x2, _y2);
    }

    public LineAlg() {
        this.setLine(0, 0, 0, 0);
    }

    public void setLine(int _x1, int _y1, int _x2, int _y2) {
        this.x1_ = _x1;
        this.y1_ = _y1;
        this.x2_ = _x2;
        this.y2_ = _y2;
        this.state_ = this.S_NOTSTARTED;
        this.update_tangent_ = true;
    }

    public int getX1() {
        return this.x1_;
    }

    public int getY1() {
        return this.y1_;
    }

    public int getX2() {
        return this.x2_;
    }

    public int getY2() {
        return this.y2_;
    }

    public void restart() {
        this.state_ = this.S_NOTSTARTED;
    }

    public int getX() {
        return this.px_;
    }

    public int getY() {
        return this.py_;
    }

    public boolean nextPoint(IPoint point) {
        if (this.state_ == this.S_ENDED) {
            return false;
        }
        if (this.state_ == this.S_NOTSTARTED) {
            int dx = this.x2_ - this.x1_;
            int dy = this.y2_ - this.y1_;
            this.ax = (dx >= 0 ? dx : -dx) << 1;
            this.ay = (dy >= 0 ? dy : -dy) << 1;
            int n = dx > 0 ? 1 : (this.sx = dx == 0 ? 0 : -1);
            this.sy = dy > 0 ? 1 : (dy == 0 ? 0 : -1);
            this.px_ = this.x1_;
            this.py_ = this.y1_;
            this.state_ = this.S_GENERATING;
            if (this.ax >= this.ay) {
                this.yd = this.ay - (this.ax >> 1);
            } else {
                this.xd = this.ax - (this.ay >> 1);
            }
        } else if (this.ax >= this.ay) {
            if (this.px_ == this.x2_) {
                this.state_ = this.S_ENDED;
                return false;
            }
            if (this.yd >= 0) {
                this.py_ += this.sy;
                this.yd -= this.ax;
            }
            this.px_ += this.sx;
            this.yd += this.ay;
        } else {
            if (this.py_ == this.y2_) {
                this.state_ = this.S_ENDED;
                return false;
            }
            if (this.xd >= 0) {
                this.px_ += this.sx;
                this.xd -= this.ay;
            }
            this.py_ += this.sy;
            this.xd += this.ax;
        }
        if (point != null) {
            point.setPoint(this.px_, this.py_);
        }
        return true;
    }

    public boolean clipTo(IRect rect) {
        return this.clipTo(rect.getX(), rect.getY(), rect.getW(), rect.getH());
    }

    protected int code(int x, int y, int xn, int yn, int xx, int yx) {
        int code = 0;
        if (y < yn) {
            code |= 0x100;
        } else if (y > yx) {
            code |= 0x1000;
        }
        if (x < xn) {
            code |= 1;
        } else if (x > xx) {
            code |= 0x10;
        }
        return code;
    }

    public boolean clipTo(int x, int y, int w, int h) {
        int xn = x;
        int xx = x + w - 1;
        int yn = y;
        int yx = y + h - 1;
        if (xn > xx) {
            xx = xn = xx;
        }
        if (yn > yx) {
            int t = yn;
            yn = yx;
            yx = t;
        }
        return this.clipToBounds(xn, yn, xx, yx);
    }

    public boolean clipToBounds(int xn, int yn, int xx, int yx) {
        int code_p1 = this.code(this.x1_, this.y1_, xn, yn, xx, yx);
        int code_p2 = this.code(this.x2_, this.y2_, xn, yn, xx, yx);
        while (true) {
            if (code_p1 == 0 && code_p2 == 0) {
                return true;
            }
            if ((code_p1 & code_p2) != 0) {
                return false;
            }
            if ((code_p1 & 1) != 0) {
                this.y1_ += (this.y2_ - this.y1_) * (xn - this.x1_) / (this.x2_ - this.x1_);
                this.x1_ = xn;
                code_p1 = this.code(this.x1_, this.y1_, xn, yn, xx, yx);
                continue;
            }
            if ((code_p2 & 1) != 0) {
                this.y2_ = this.y1_ + (this.y2_ - this.y1_) * (xn - this.x1_) / (this.x2_ - this.x1_);
                this.x2_ = xn;
                code_p2 = this.code(this.x2_, this.y2_, xn, yn, xx, yx);
                continue;
            }
            if ((code_p1 & 0x10) != 0) {
                this.y1_ += (this.y2_ - this.y1_) * (xx - this.x1_) / (this.x2_ - this.x1_);
                this.x1_ = xx;
                code_p1 = this.code(this.x1_, this.y1_, xn, yn, xx, yx);
                continue;
            }
            if ((code_p2 & 0x10) != 0) {
                this.y2_ = this.y1_ + (this.y2_ - this.y1_) * (xx - this.x1_) / (this.x2_ - this.x1_);
                this.x2_ = xx;
                code_p2 = this.code(this.x2_, this.y2_, xn, yn, xx, yx);
                continue;
            }
            if ((code_p1 & 0x100) != 0) {
                this.x1_ += (yn - this.y1_) * (this.x2_ - this.x1_) / (this.y2_ - this.y1_);
                this.y1_ = yn;
                code_p1 = this.code(this.x1_, this.y1_, xn, yn, xx, yx);
                continue;
            }
            if ((code_p2 & 0x100) != 0) {
                this.x2_ = this.x1_ + (yn - this.y1_) * (this.x2_ - this.x1_) / (this.y2_ - this.y1_);
                this.y2_ = yn;
                code_p2 = this.code(this.x2_, this.y2_, xn, yn, xx, yx);
                continue;
            }
            if ((code_p1 & 0x1000) != 0) {
                this.x1_ += (yx - this.y1_) * (this.x2_ - this.x1_) / (this.y2_ - this.y1_);
                this.y1_ = yx;
                code_p1 = this.code(this.x1_, this.y1_, xn, yn, xx, yx);
                continue;
            }
            if ((code_p2 & 0x1000) == 0) break;
            this.x2_ = this.x1_ + (yx - this.y1_) * (this.x2_ - this.x1_) / (this.y2_ - this.y1_);
            this.y2_ = yx;
            code_p2 = this.code(this.x2_, this.y2_, xn, yn, xx, yx);
        }
        throw new Error("Assertion failed in clipToBounds()");
    }

    public String toString() {
        return String.valueOf(super.toString()) + "{p1=" + this.x1_ + "," + this.y1_ + ", p2=" + this.x2_ + "," + this.y2_ + "}";
    }

    public void tangent(IVector vector) {
        if (this.update_tangent_) {
            double tgx_ = this.x2_ - this.x1_;
            double tgy_ = this.y2_ - this.y1_;
            double n = Math.sqrt(tgx_ * tgx_ + tgy_ * tgy_);
            if (n != 1.0 && n != 0.0) {
                tgx_ /= n;
                tgy_ /= n;
            }
            this.update_tangent_ = false;
        }
        vector.setVector(this.tgx_, this.tgy_);
    }

    public void backTangent(IVector vector) {
        this.tangent(vector);
    }

    public void frontTangent(IVector vector) {
        this.tangent(vector);
    }
}

