/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.alg.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ModelMap {
    protected HashMap models_ = new HashMap();
    protected AbstractModel[] last_accessed_;
    protected int max_model_usage_;
    protected int max_count_;
    protected int keep_more_used_count_;

    public ModelMap(int last_accessed_count, int max_count, int keep_more_used_count) {
        this.last_accessed_ = new AbstractModel[last_accessed_count];
        this.max_model_usage_ = 0;
        this.max_count_ = max_count;
        this.keep_more_used_count_ = keep_more_used_count;
    }

    public AbstractModel getModel(Object key) {
        AbstractModel model = (AbstractModel)this.models_.get(key);
        if (model == null) {
            return null;
        }
        boolean in_last_accessed = false;
        int i = this.last_accessed_.length - 1;
        while (i >= 0) {
            if (this.last_accessed_[i] == model) {
                in_last_accessed = true;
                int j = i + 1;
                while (j < this.last_accessed_.length - 1) {
                    this.last_accessed_[j - 1] = this.last_accessed_[j];
                    ++j;
                }
                this.last_accessed_[this.last_accessed_.length - 1] = model;
                break;
            }
            --i;
        }
        if (!in_last_accessed) {
            i = 1;
            while (i < this.last_accessed_.length) {
                this.last_accessed_[i - 1] = this.last_accessed_[i];
                ++i;
            }
            this.last_accessed_[this.last_accessed_.length - 1] = model;
        }
        AbstractModel abstractModel = model;
        abstractModel.usage_ = abstractModel.usage_ + 1;
        this.max_model_usage_ = Math.max(this.max_model_usage_, model.usage_);
        return model;
    }

    public void addModel(AbstractModel model) {
        if (model == null) {
            if (this.models_.size() > this.max_count_) {
                AbstractModel[] more_used = new AbstractModel[this.keep_more_used_count_];
                int i = 0;
                while (i < more_used.length) {
                    Set set = this.models_.entrySet();
                    int usage = 0;
                    Map.Entry max_usage_entry = null;
                    for (Map.Entry entry : set) {
                        AbstractModel m = (AbstractModel)entry.getValue();
                        if (m.usage_ <= usage) continue;
                        usage = m.usage_;
                        max_usage_entry = entry;
                    }
                    more_used[i] = (AbstractModel)max_usage_entry.getValue();
                    this.models_.remove(max_usage_entry.getKey());
                    ++i;
                }
                this.models_.clear();
                i = 0;
                while (i < more_used.length) {
                    this.models_.put(more_used[i].getKey(), more_used[i]);
                    more_used[i].usage_ = 0;
                    ++i;
                }
                i = 0;
                while (i < this.last_accessed_.length) {
                    if (this.last_accessed_[i] != null) {
                        this.last_accessed_[i].usage_ = 0;
                        this.models_.put(this.last_accessed_[i].getKey(), this.last_accessed_[i]);
                    }
                    ++i;
                }
            }
            this.models_.put(model.getKey(), model);
            int i = 1;
            while (i < this.last_accessed_.length) {
                this.last_accessed_[i - 1] = this.last_accessed_[i];
                ++i;
            }
            this.last_accessed_[this.last_accessed_.length - 1] = model;
        }
    }

    public static abstract class AbstractModel {
        private int usage_;

        public abstract Object getKey();
    }
}

