/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.alg.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.SplineAlg;

public class Spline4Alg
extends SplineAlg {
    protected int xa_;
    protected int ya_;
    protected int xb_;
    protected int yb_;
    protected int xc_;
    protected int yc_;
    protected int xd_;
    protected int yd_;

    public Spline4Alg(int _xa, int _ya, int _xb, int _yb, int _xc, int _yc, int _xd, int _yd) {
        this.xa_ = _xa;
        this.ya_ = _ya;
        this.xb_ = _xb;
        this.yb_ = _yb;
        this.xc_ = _xc;
        this.yc_ = _yc;
        this.xd_ = _xd;
        this.yd_ = _yd;
        this.flags_ = (byte)(this.flags_ & 0xFFFFFFFD);
    }

    public Spline4Alg() {
    }

    public void setA(int _xa, int _ya) {
        if (this.xa_ == _xa && this.ya_ == _ya) {
            return;
        }
        this.xa_ = _xa;
        this.ya_ = _ya;
        this.flags_ = (byte)(this.flags_ & 0xFFFFFFFD);
    }

    public void setB(int _xb, int _yb) {
        if (this.xb_ == _xb && this.yb_ == _yb) {
            return;
        }
        this.xb_ = _xb;
        this.yb_ = _yb;
        this.flags_ = (byte)(this.flags_ & 0xFFFFFFFD);
    }

    public void setC(int _xc, int _yc) {
        if (this.xc_ == _xc && this.yc_ == _yc) {
            return;
        }
        this.xc_ = _xc;
        this.yc_ = _yc;
        this.flags_ = (byte)(this.flags_ & 0xFFFFFFFD);
    }

    public void setD(int _xd, int _yd) {
        if (this.xd_ == _xd && this.yd_ == _yd) {
            return;
        }
        this.xd_ = _xd;
        this.yd_ = _yd;
        this.flags_ = (byte)(this.flags_ & 0xFFFFFFFD);
    }

    public void setSpline(int _xa, int _ya, int _xb, int _yb, int _xc, int _yc, int _xd, int _yd) {
        this.xa_ = _xa;
        this.ya_ = _ya;
        this.xb_ = _xb;
        this.yb_ = _yb;
        this.xc_ = _xc;
        this.yc_ = _yc;
        this.xd_ = _xd;
        this.yd_ = _yd;
        this.flags_ = (byte)(this.flags_ & 0xFFFFFFFD);
    }

    public int getXA() {
        return this.xa_;
    }

    public int getYA() {
        return this.ya_;
    }

    public int getXB() {
        return this.xb_;
    }

    public int getYB() {
        return this.yb_;
    }

    public int getXC() {
        return this.xc_;
    }

    public int getYC() {
        return this.yc_;
    }

    public int getXD() {
        return this.xd_;
    }

    public int getYD() {
        return this.yd_;
    }

    protected int divide(int index, double xa, double ya, double xb, double yb, double xc, double yc, double xd, double yd, int level) {
        if (level < 5) {
            double xb2 = (xa + xb) / 2.0;
            double yb2 = (ya + yb) / 2.0;
            double xc2 = (xa + 2.0 * xb + xc) / 4.0;
            double yc2 = (ya + 2.0 * yb + yc) / 4.0;
            double xb3 = (xb + 2.0 * xc + xd) / 4.0;
            double yb3 = (yb + 2.0 * yc + yd) / 4.0;
            double xc3 = (xc + xd) / 2.0;
            double yc3 = (yc + yd) / 2.0;
            double xp = (xa + 3.0 * (xb + xc) + xd) / 8.0;
            double yp = (ya + 3.0 * (yb + yc) + yd) / 8.0;
            index = this.divide(index, xa, ya, xb2, yb2, xc2, yc2, xp, yp, level + 1);
            this.points_[index++] = (int)Math.round(xp);
            this.points_[index++] = (int)Math.round(yp);
            index = this.divide(index, xp, yp, xb3, yb3, xc3, yc3, xd, yd, level + 1);
        }
        return index;
    }

    public void prepareDPoints() {
        if (this.points_ == null) {
            this.points_ = new int[66];
        }
        if ((this.flags_ & 8) != 0) {
            this.points_[0] = this.xa_;
            this.points_[1] = this.ya_;
            this.points_[2] = this.xb_;
            this.points_[3] = this.yb_;
            this.points_[4] = this.xc_;
            this.points_[5] = this.yc_;
            this.points_[6] = this.xd_;
            this.points_[7] = this.yd_;
            this.num_points_ = 8;
        } else {
            this.points_[0] = this.xa_;
            this.points_[1] = this.ya_;
            int i = this.divide(2, this.xa_, this.ya_, this.xb_, this.yb_, this.xc_, this.yc_, this.xd_, this.yd_, 0);
            this.points_[i++] = this.xd_;
            this.points_[i++] = this.yd_;
            this.num_points_ = i;
        }
        this.flags_ = (byte)(this.flags_ | 2);
    }
}

