/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.alg.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.IAlg;
import org.eclipse.tptp.platform.report.igc.alg.internal.LineAlg;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IVector;

public abstract class SplineAlg
implements IAlg {
    protected static final byte F_TGT_SEGMENT_CHANGED = 1;
    protected static final byte F_POINTS_VALID = 2;
    protected static final byte F_HULL = 8;
    protected byte state_ = 0;
    protected byte flags_;
    protected int[] points_;
    protected int curr_index_;
    protected int num_points_;
    protected static final int MAX_LEVEL = 5;
    protected LineAlg la_;
    protected double tgx_;
    protected double tgy_;

    public void setHullPath(boolean b) {
        this.flags_ = b ? (byte)(this.flags_ | 8) : (byte)(this.flags_ & 0xFFFFFFF7);
        this.flags_ = (byte)(this.flags_ & 0xFFFFFFFD);
        this.state_ = 0;
    }

    public int getX() {
        return this.la_.getX();
    }

    public int getY() {
        return this.la_.getY();
    }

    public void restart() {
        this.state_ = 0;
    }

    protected abstract void prepareDPoints();

    public boolean nextPoint(IPoint point) {
        if (this.state_ == 0) {
            this.prepareDPoints();
            if (this.num_points_ < 4) {
                return false;
            }
            if (this.la_ == null) {
                this.la_ = new LineAlg(this.points_[0], this.points_[1], this.points_[2], this.points_[3]);
            } else {
                this.la_.setLine(this.points_[0], this.points_[1], this.points_[2], this.points_[3]);
            }
            this.curr_index_ = 2;
            this.state_ = 1;
            this.flags_ = (byte)(this.flags_ | 1);
            return this.la_.nextPoint(point);
        }
        if (this.state_ == 1) {
            if (this.la_.nextPoint(point)) {
                return true;
            }
            do {
                if (this.curr_index_ >= this.num_points_ - 2) {
                    this.state_ = (byte)2;
                    return false;
                }
                this.la_.setLine(this.points_[this.curr_index_++], this.points_[this.curr_index_++], this.points_[this.curr_index_], this.points_[this.curr_index_ + 1]);
                this.flags_ = (byte)(this.flags_ | 1);
            } while (!this.la_.nextPoint(point) || !this.la_.nextPoint(point));
            return true;
        }
        return false;
    }

    protected void tangent(IVector vector) {
        if ((this.flags_ & 1) != 0) {
            this.tgx_ = this.la_.getX2() - this.la_.getX1();
            this.tgy_ = this.la_.getY2() - this.la_.getY1();
            double n = Math.sqrt(this.tgx_ * this.tgx_ + this.tgy_ * this.tgy_);
            if (n != 1.0 && n != 0.0) {
                this.tgx_ /= n;
                this.tgy_ /= n;
            }
            this.flags_ = (byte)(this.flags_ & 0xFFFFFFFE);
        }
        vector.setVector(this.tgx_, this.tgy_);
    }

    public void backTangent(IVector vector) {
        this.tangent(vector);
    }

    public void frontTangent(IVector vector) {
        this.tangent(vector);
    }
}

