/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.awt.internal;

import com.ibm.icu.util.ULocale;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import org.eclipse.tptp.platform.report.igc.awt.internal.AWTImage;
import org.eclipse.tptp.platform.report.igc.brushes.internal.GradientBrush;
import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IFont;
import org.eclipse.tptp.platform.report.igc.internal.IFontMetrics;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPen;
import org.eclipse.tptp.platform.report.igc.internal.IPolygon;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.IShapeFiller;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.ImageProxy;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.Oval;
import org.eclipse.tptp.platform.report.igc.util.internal.Polygon;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBAImage;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.Size;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;

public class AWTGC
implements IGC {
    protected Graphics gc_;
    protected IBrush brush_;
    protected IPen pen_;
    protected Color brush_color_;
    protected Color pen_color_;
    protected IFont font_;
    protected boolean brush_awt_compliant_;
    protected IGCDirect gd_;

    public AWTGC(Graphics graphics) {
        this.gc_ = graphics;
        this.gd_ = new GCDirect();
    }

    public IGCDirect getIGCDirect() {
        return this.gd_;
    }

    protected int rgbaFromColor(Color c) {
        return RGBA.Get(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
    }

    protected Color createColor(int _rgba) {
        return new Color(RGBA.GetR(_rgba), RGBA.GetG(_rgba), RGBA.GetB(_rgba), RGBA.GetA(_rgba));
    }

    public IBrush getBrush() {
        return this.getBrushInternal().copyBrush();
    }

    private IBrush getBrushInternal() {
        if (this.brush_ == null) {
            this.brush_color_ = this.gc_.getColor();
            this.brush_ = new SolidBrush(this.rgbaFromColor(this.gc_.getColor()));
        }
        return this.brush_;
    }

    public IBrush setBrush(IBrush brush) {
        if (this.brush_ == null) {
            this.brush_ = this.getBrush();
        }
        if (brush instanceof SolidBrush) {
            SolidBrush b = (SolidBrush)brush;
            IBrush old = this.brush_;
            this.brush_ = new SolidBrush(b);
            this.brush_color_ = this.createColor(b.getRGBA());
            this.gc_.setColor(this.brush_color_);
            this.brush_awt_compliant_ = true;
            return old;
        }
        boolean bl = this.brush_awt_compliant_ = this.brush_ == null;
        if (brush instanceof GradientBrush) {
            GradientBrush b = (GradientBrush)brush;
            IBrush old = this.brush_;
            this.brush_ = b.copyBrush();
            this.brush_color_ = this.createColor(b.getRGBA1());
            this.gc_.setColor(this.brush_color_);
            return old;
        }
        IBrush old = this.brush_;
        this.brush_ = brush;
        return old;
    }

    public IPen getPen() {
        return this.getPenInternal().copyPen();
    }

    private IPen getPenInternal() {
        if (this.pen_ == null) {
            this.pen_color_ = this.gc_.getColor();
            this.pen_ = new LineStylePen(this.rgbaFromColor(this.pen_color_));
        }
        return this.pen_;
    }

    public IPen setPen(IPen pen) {
        if (this.pen_ == null) {
            this.pen_ = this.getPen();
        }
        if (pen instanceof LineStylePen) {
            LineStylePen p = (LineStylePen)pen;
            IPen old = this.pen_;
            this.pen_color_ = this.createColor(p.getRGBA());
            this.gc_.setColor(this.pen_color_);
            this.pen_ = new LineStylePen(p);
            return old;
        }
        IPen old = this.pen_;
        this.pen_ = pen;
        return old;
    }

    public IFont getFont() {
        if (this.font_ == null) {
            Font f = this.gc_.getFont();
            if (f == null) {
                return null;
            }
            int awtsty = f.getStyle();
            int sty = 0;
            if ((awtsty & 1) != 0) {
                sty |= 1;
            }
            if ((awtsty & 2) != 0) {
                sty |= 2;
            }
            this.font_ = new org.eclipse.tptp.platform.report.igc.util.internal.Font(ULocale.getDefault().toString(), f.getFontName(), f.getSize(), sty);
        }
        return this.font_.copy();
    }

    public IFont setFont(IFont font) {
        if (this.font_ == null) {
            this.font_ = this.getFont();
        }
        if (font != null) {
            int awtsty = 0;
            int sty = font.getFontStyle();
            if ((sty & 1) != 0) {
                awtsty |= 1;
            }
            if ((sty & 2) != 0) {
                awtsty |= 2;
            }
            Font f = new Font(font.getFontName(), awtsty, font.getFontSize());
            IFont old = this.font_;
            this.font_ = font;
            this.gc_.setFont(f);
            return old;
        }
        return this.font_.copy();
    }

    public IFontMetrics getFontMetrics() {
        final FontMetrics fm = this.gc_.getFontMetrics();
        return new IFontMetrics(){

            public int getAscent() {
                return fm.getAscent();
            }

            public int getDescent() {
                return fm.getDescent();
            }

            public int getHeight() {
                return fm.getHeight();
            }

            public int getLeading() {
                return fm.getLeading();
            }
        };
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.gc_.setColor(this.pen_color_);
        this.gc_.drawLine(x1, y1, x2, y2);
    }

    public int getPoint(int x, int y) {
        return 0;
    }

    public void drawPoint(int x, int y) {
        this.gc_.setColor(this.brush_color_);
        this.gc_.drawLine(x, y, x, y);
    }

    public void drawCircle(int cx, int cy, int radius) {
        this.gc_.setColor(this.pen_color_);
        int r2 = radius + radius;
        this.gc_.drawOval(cx - radius, cy - radius, r2, r2);
    }

    public void fillCircle(int cx, int cy, int radius) {
        this.gc_.setColor(this.brush_color_);
        int r2 = radius + radius;
        this.gc_.fillOval(cx - radius, cy - radius, r2, r2);
    }

    public void drawOval(int x, int y, int w, int h) {
        this.gc_.setColor(this.pen_color_);
        this.gc_.drawOval(x, y, w, h);
    }

    public void fillOval(int x, int y, int w, int h) {
        if (this.brush_awt_compliant_) {
            this.gc_.setColor(this.brush_color_);
            this.gc_.fillOval(x, y, w, h);
        } else {
            int rx = w / 2;
            int ry = h / 2;
            Oval oval = new Oval(x + rx, y + ry, rx, ry);
            oval.fillShape(this, this.gd_, this.getBrushInternal(), oval);
        }
    }

    public void drawArc(int xc, int yc, double _r1_angle, int r1, int r2, double _start_angle, double _arc_length) {
        double a = Radian.normalize(_r1_angle);
        if (a == 0.0) {
            this.gc_.setColor(this.pen_color_);
            this.gc_.drawArc(xc - r1, yc - r2, 2 * r1, 2 * r2, Radian.iR2D(_start_angle), Radian.iR2D(_arc_length));
            return;
        }
        this.Unsupported("drawArc: with _r1_angle !=0");
    }

    public void fillArc(int xc, int yc, double _r1_angle, int r1, int r2, double _start_angle, double _arc_length) {
        double a = Radian.normalize(_r1_angle);
        if (a == 0.0) {
            this.gc_.setColor(this.brush_color_);
            this.gc_.fillArc(xc - r1, yc - r2, 2 * r1, 2 * r2, Radian.iR2D(_start_angle), Radian.iR2D(_arc_length));
            return;
        }
        this.Unsupported("fillArc: with _r1_angle !=0");
    }

    public void drawEllipse(int xc, int yc, double _r1_angle, int r1, int r2) {
        double a = Radian.normalize(_r1_angle);
        if (a == 0.0) {
            this.gc_.setColor(this.pen_color_);
            this.gc_.drawOval(xc - r1, yc - r2, 2 * r1, 2 * r2);
            return;
        }
        this.Unsupported("drawEllipse: with _r1_angle !=0");
    }

    public void fillEllipse(int xc, int yc, double _r1_angle, int r1, int r2) {
        double a = Radian.normalize(_r1_angle);
        if (a == 0.0) {
            this.gc_.setColor(this.brush_color_);
            this.gc_.fillOval(xc - r1, yc - r2, 2 * r1, 2 * r2);
            return;
        }
        this.Unsupported("fillEllipse: with _r1_angle !=0");
    }

    public void fillRect(int x, int y, int w, int h) {
        if (this.brush_ == null || this.brush_ instanceof SolidBrush) {
            this.gc_.setColor(this.brush_color_);
            this.gc_.fillRect(x, y, w, h);
        } else if (this.brush_ instanceof GradientBrush) {
            ((GradientBrush)this.brush_).fillRectWT(this, this.gd_, x, y, w, h);
        } else {
            this.gd_.fillRectDirect(this.gd_.devX(x), this.gd_.devY(y), this.gd_.devX(w), this.gd_.devY(h));
        }
    }

    public void drawRect(int x, int y, int w, int h) {
        this.gc_.setColor(this.pen_color_);
        this.gc_.drawRect(x, y, w, h);
    }

    public void fillRect(IRect r) {
        this.fillRect(r.getX(), r.getY(), r.getW(), r.getH());
    }

    public void drawRect(IRect r) {
        this.gc_.setColor(this.pen_color_);
        this.gc_.drawRect(r.getX(), r.getY(), r.getW(), r.getH());
    }

    public void drawImage(IImage image, int x, int y) {
        if (image instanceof ImageProxy) {
            ImageProxy proxy = (ImageProxy)image;
            if (!proxy.isLoaded()) {
                proxy.loadImage();
            }
            image = proxy.getLoaded();
        }
        if (image instanceof AWTImage) {
            AWTImage img = (AWTImage)image;
            ImageObserver observer = null;
            this.gc_.drawImage(img.getImage(), x, y, observer);
            return;
        }
        this.Unsupported("drawImage(int,intIImage) where IImage isn't an instance of SWTImage");
    }

    public void drawImage(IImage image, int x, int y, int w, int h) {
        if (image instanceof ImageProxy) {
            ImageProxy proxy = (ImageProxy)image;
            if (!proxy.isLoaded()) {
                proxy.loadImage();
            }
            image = proxy.getLoaded();
        }
        if (image instanceof AWTImage) {
            AWTImage img = (AWTImage)image;
            ImageObserver observer = null;
            this.gc_.drawImage(img.getImage(), x, y, w, h, observer);
            return;
        }
        this.Unsupported("drawImage(IImage,int,int,int,int) where IImage isn't an instance of SWTImage");
    }

    public void drawImage(IImage image, int srcX, int srcY, int srcW, int srcH, int dstX, int dstY, int dstW, int dstH) {
        if (image instanceof ImageProxy) {
            ImageProxy proxy = (ImageProxy)image;
            if (!proxy.isLoaded()) {
                proxy.loadImage();
            }
            image = proxy.getLoaded();
        }
        if (image instanceof AWTImage) {
            AWTImage img = (AWTImage)image;
            ImageObserver observer = null;
            this.gc_.drawImage(img.getImage(), dstX, dstY, dstX + dstW, dstY + dstH, srcX, srcY, srcX + srcW, srcY + srcH, observer);
            return;
        }
        this.Unsupported("drawImage(IImage,...) where IImage isn't an instance of SWTImage");
    }

    public void drawPoly(IPolygon poly) {
        if (this.pen_ == null || this.pen_ instanceof LineStylePen) {
            this.gc_.setColor(this.pen_color_);
            int size = poly.getPolySize();
            int[] x = new int[size];
            int[] y = new int[size];
            int i = 0;
            while (i < size) {
                x[i] = poly.getPolyX(i);
                y[i] = poly.getPolyY(i);
                ++i;
            }
            if (poly.isPolyClosed()) {
                this.gc_.drawPolygon(x, y, size);
            } else {
                this.gc_.drawPolyline(x, y, size);
            }
            return;
        }
        if (poly instanceof IPath) {
            this.pen_.drawPath(this, this.gd_, (IPath)((Object)poly));
        }
        this.Unsupported("drawPoly() with pen=" + this.pen_);
    }

    public void fillPoly(IPolygon poly) {
        int size = poly.getPolySize();
        int[] x = new int[size];
        int[] y = new int[size];
        int i = 0;
        while (i < size) {
            x[i] = poly.getPolyX(i);
            y[i] = poly.getPolyY(i);
            ++i;
        }
        this.gc_.setColor(this.brush_color_);
        this.gc_.fillPolygon(x, y, size);
    }

    public ISize textExtent(String text) {
        FontMetrics fm = this.gc_.getFontMetrics();
        return new Size(fm.bytesWidth(text.getBytes(), 0, text.length()), fm.getHeight());
    }

    public void drawText(String text, int x, int y) {
        this.gc_.setColor(this.brush_color_);
        int th = this.gc_.getFontMetrics().getAscent();
        this.gc_.drawString(text, x, th + y);
    }

    public ISize textExtent(String text, double angle) {
        double a = Radian.normalize(angle);
        ISize size = this.textExtent(text);
        return RGBAImage.rotateImageSize(size.getW(), size.getH(), a);
    }

    public IPolygon textExtent(String text, int x, int y, double angle) {
        double a = Radian.normalize(angle);
        ISize size = this.textExtent(text);
        return RGBAImage.rotateImageBounds(x, y, size.getW(), size.getH(), a);
    }

    public void drawText(String text, int x, int y, double angle) {
        double a = Radian.normalize(angle);
        if (a == 0.0) {
            this.drawText(text, x, y);
        }
        int tx = this.gd_.devX(x);
        int ty = this.gd_.devY(y);
        ISize size = this.textExtent(text);
        RGBAImage s = this.getTextImage(text, size);
        RGBAImage r = s.rotateImage(a, 0, true);
        Polygon rte = RGBAImage.rotateImageBounds(tx, ty, size.getW(), size.getH(), a);
        IRect rb = rte.getBounds();
        this.drawTextImage(r, tx + rb.getX() - rte.getPolyX(0), ty + rb.getY() - rte.getPolyY(0));
    }

    public void drawFocus(int x, int y, int w, int h) {
        Color c = this.createColor(17);
        this.gc_.setColor(c);
        this.gc_.setXORMode(c);
        IPen oldpen = this.setPen(new LineStylePen(2));
        this.drawRect(x, y, w, h);
        this.gc_.setColor(this.brush_color_);
        this.gc_.setPaintMode();
        this.setPen(oldpen);
    }

    public void drawFocus(IRect rect) {
        this.drawFocus(rect.getX(), rect.getY(), rect.getW(), rect.getH());
    }

    private void drawTextImage(RGBAImage img, int x, int y) {
        Image image = AWTGC.ToImage(img);
        this.gc_.drawImage(image, x, y, null);
    }

    private RGBAImage getTextImage(String text, ISize size) {
        int w = size.getW();
        int h = size.getH();
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics g = ((Image)img).getGraphics();
        g.setFont(this.gc_.getFont());
        g.setColor(this.createColor(0));
        g.setColor(this.brush_color_);
        int th = g.getFontMetrics().getAscent();
        g.drawString(text, 0, th + 0);
        int font_style = this.font_ != null ? this.font_.getFontStyle() : 0;
        AWTGC.DrawFontLineStyle(g, 0, 0, size.getW(), font_style, this.gd_.devX(5));
        return AWTGC.ToRGBAImage(img, w, h);
    }

    private static Image ToImage(RGBAImage img) {
        int w = img.getWidth();
        int h = img.getHeight();
        int[] src = img.getImage();
        int[] dst = new int[w * h];
        int s = w * h;
        int i = 0;
        while (i < s) {
            int p = src[i];
            int a = p & 0xFF;
            dst[i] = p >> 8 | a << 24;
            ++i;
        }
        MemoryImageSource source = new MemoryImageSource(img.getWidth(), img.getHeight(), dst, 0, img.getWidth());
        Image res = Toolkit.getDefaultToolkit().createImage(source);
        return res;
    }

    private static RGBAImage ToRGBAImage(Image img, int w, int h) {
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return null;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return null;
        }
        int index = 0;
        int j = 0;
        while (j < h) {
            int i = 0;
            while (i < w) {
                int pixel = pixels[index];
                int a = (pixel & 0xFF000000) >> 24;
                pixels[index] = pixel = pixel << 8 | a & 0xFF;
                ++i;
                ++index;
            }
            ++j;
        }
        return new RGBAImage(w, h, pixels);
    }

    public IShape getClipping() {
        Shape s = this.gc_.getClip();
        if (s == null) {
            return null;
        }
        Rectangle r = s.getBounds();
        return new Rect(r.x, r.y, r.width, r.height);
    }

    public IShape setClipping(IShape s) {
        IShape old = this.getClipping();
        if (s == null) {
            this.gc_.setClip(null);
        } else if (s instanceof IRect) {
            IRect r = (IRect)s;
            this.gc_.setClip(r.getX(), r.getY(), r.getW(), r.getH());
        } else {
            this.Unsupported("setClipping() with shape=" + s);
        }
        return old;
    }

    public void fillShape(IShape shape) {
        if (shape instanceof IRect) {
            this.fillRect((IRect)shape);
            return;
        }
        if (shape instanceof Oval) {
            Oval o = (Oval)shape;
            int cx = o.getCenterX();
            int cy = o.getCenterY();
            int rx = o.getRadiusX();
            int ry = o.getRadiusY();
            this.fillOval(cx - rx, cy - ry, 2 * rx, 2 * ry);
            return;
        }
        if (this.brush_ instanceof IShapeFiller && ((IShapeFiller)((Object)this.brush_)).fillShape(this, this.gd_, this.brush_, shape)) {
            return;
        }
        if (shape instanceof IShapeFiller && ((IShapeFiller)((Object)shape)).fillShape(this, this.gd_, this.getBrushInternal(), shape)) {
            return;
        }
        this.Unsupported("fillShape() for shape=" + shape);
    }

    public void drawPath(IPath path) {
        if (path instanceof IPolygon) {
            this.drawPoly((IPolygon)((Object)path));
        } else if (this.pen_ != null) {
            this.pen_.drawPath(this, this.gd_, path);
        }
    }

    protected void Unsupported(String what) {
        System.err.println("AWTGC: Unsupported method: " + what);
    }

    public int getSystemColor(int id) {
        switch (id) {
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                return -2139062017;
            }
            case 9: {
                return 255;
            }
            case 10: {
                return -1;
            }
            case 11: {
                return 255;
            }
            case 13: {
                return 255;
            }
            case 14: {
                return -1;
            }
            case 16: {
                return 65535;
            }
            case 17: {
                return -1;
            }
            case 19: {
                return 255;
            }
            case 20: {
                return 0xFFFFC0;
            }
            case 21: {
                return 255;
            }
            case 22: {
                return -1;
            }
            case 24: {
                return 65535;
            }
            case 25: {
                return 255;
            }
            case 26: {
                return -1061109505;
            }
            case 30: {
                return -2139062017;
            }
        }
        if ((id & 1) == 0) {
            return -1;
        }
        return 255;
    }

    private static void DrawFontLineStyle(Graphics _gc, int dtx, int dty, int dtw, int ifont_style, int dev_dash_size) {
        if (ifont_style == 0) {
            return;
        }
        if ((ifont_style & 0xF0) == 0) {
            return;
        }
        FontMetrics fm = _gc.getFontMetrics();
        int descent = fm.getDescent();
        int psize = fm.getHeight();
        int linesize = psize / 10;
        if (linesize == 0) {
            linesize = 1;
        }
        int linesize2 = linesize / 2;
        if ((ifont_style & 1) != 0 && (linesize += linesize2) == 1) {
            linesize = 2;
            linesize2 = 1;
        }
        int space = linesize2 + 2;
        int _txth = fm.getHeight();
        int ly = dty + _txth - descent + space;
        if (org.eclipse.tptp.platform.report.igc.util.internal.Font.HaveStyle(ifont_style, 16)) {
            _gc.drawLine(dtx, ly, dtx + dtw, ly);
        } else if (org.eclipse.tptp.platform.report.igc.util.internal.Font.HaveStyle(ifont_style, 64)) {
            int size = dev_dash_size;
            int size2 = 2 * size;
            int xx = size * ((dtx + dtw) / size);
            int x = size * (int)Math.ceil(dtx / size);
            if (x < dtx) {
                x += size2;
            }
            while (x < xx) {
                _gc.drawLine(x, ly, x + size, ly);
                x += size2;
            }
        }
        if (org.eclipse.tptp.platform.report.igc.util.internal.Font.HaveStyle(ifont_style, 32)) {
            ly = dty + linesize / 2;
            _gc.drawLine(dtx, ly, dtx + dtw, ly);
        }
        if (org.eclipse.tptp.platform.report.igc.util.internal.Font.HaveStyle(ifont_style, 128)) {
            ly = dty + fm.getLeading() + fm.getAscent() / 2 + linesize2;
            _gc.drawLine(dtx, ly, dtx + dtw, ly);
        }
    }

    private class GCDirect
    implements IGCDirect {
        private GCDirect() {
        }

        public IGC getIGC() {
            return AWTGC.this;
        }

        public int devX(int x) {
            return x;
        }

        public int devY(int y) {
            return y;
        }

        public int pixX(int x) {
            return x;
        }

        public int pixY(int y) {
            return y;
        }

        public boolean usePixelCoordinates() {
            return true;
        }

        public void drawHLineDirect(int x1, int x2, int y) {
            if (AWTGC.this.brush_awt_compliant_) {
                AWTGC.this.gc_.setColor(AWTGC.this.brush_color_);
                AWTGC.this.gc_.drawLine(x1, y, x2, y);
            } else if (AWTGC.this.brush_ != null) {
                Color c = AWTGC.this.gc_.getColor();
                int x = x1;
                while (x <= x2) {
                    int curr = this.getPointDirect(x, y);
                    int rgba = AWTGC.this.brush_.getBrushColor(x, y, curr);
                    if (rgba != curr) {
                        AWTGC.this.gc_.setColor(AWTGC.this.createColor(rgba));
                        AWTGC.this.gc_.drawLine(x, y, x, y);
                    }
                    ++x;
                }
                AWTGC.this.gc_.setColor(c);
            } else {
                AWTGC.this.Unsupported("drawHLineDirect() without brush.");
            }
        }

        public void drawVLineDirect(int x, int y1, int y2) {
            if (AWTGC.this.brush_awt_compliant_) {
                AWTGC.this.gc_.setColor(AWTGC.this.brush_color_);
                AWTGC.this.gc_.drawLine(x, y1, x, y2);
            } else if (AWTGC.this.brush_ != null) {
                Color c = AWTGC.this.gc_.getColor();
                int y = y1;
                while (y <= y2) {
                    int rgba = AWTGC.this.brush_.getBrushColor(x, y, 0);
                    AWTGC.this.gc_.setColor(AWTGC.this.createColor(rgba));
                    AWTGC.this.gc_.drawLine(x, y, x, y);
                    ++x;
                }
                AWTGC.this.gc_.setColor(c);
            } else {
                AWTGC.this.Unsupported("drawVLineDirect() without brush.");
            }
        }

        public void drawLineDirect(int x1, int y1, int x2, int y2) {
            AWTGC.this.gc_.setColor(AWTGC.this.brush_color_);
            AWTGC.this.gc_.drawLine(x1, y1, x2, y2);
        }

        public void fillRectDirect(int x, int y, int w, int h) {
            if (AWTGC.this.brush_ == null || AWTGC.this.brush_ instanceof SolidBrush) {
                AWTGC.this.gc_.setColor(AWTGC.this.brush_color_);
                AWTGC.this.gc_.fillRect(x, y, w, h);
            } else {
                AWTGC.this.brush_.brushBegin(AWTGC.this, this);
                int X = x + w;
                int Y = y + h;
                int j = y;
                while (j < Y) {
                    int i = x;
                    while (i < X) {
                        int rgba = AWTGC.this.brush_.getBrushColor(i, j, 0);
                        AWTGC.this.gc_.setColor(AWTGC.this.createColor(rgba));
                        AWTGC.this.gc_.drawLine(i, j, i, j);
                        ++i;
                    }
                    ++j;
                }
                AWTGC.this.brush_.brushEnd();
            }
        }

        public void drawRectDirect(int x, int y, int w, int h) {
            AWTGC.this.brush_.brushBegin(AWTGC.this, this);
            int x2 = x + w - 1;
            int y2 = y + h - 1;
            this.drawHLineDirect(x, x2, y);
            this.drawHLineDirect(x, x2, y2);
            this.drawVLineDirect(x, ++y, --y2);
            this.drawVLineDirect(x2, y, y2);
            AWTGC.this.brush_.brushEnd();
        }

        public int getPointDirect(int x, int y) {
            return 0;
        }

        public void drawPointDirect(int x, int y, int _rgba) {
            AWTGC.this.gc_.setColor(AWTGC.this.createColor(_rgba));
            AWTGC.this.gc_.drawLine(x, y, x, y);
        }
    }
}

