/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.brushes.internal;

import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;

public class BlurBrush
implements IBrush {
    protected int size_;
    protected IGCDirect gd_;
    protected int dev_size_x_;
    protected int dev_size_y_;
    protected int dev_area_;

    public BlurBrush(int size) {
        this.size_ = size;
    }

    public IBrush copyBrush() {
        return new BlurBrush(this.size_);
    }

    public int getBrushColor(int x, int y, int curr_rgba) {
        int sumR = 0;
        int sumG = 0;
        int sumB = 0;
        int sumA = 0;
        int YX = y + this.dev_size_y_;
        int XX = x + this.dev_size_x_;
        int Y = y - this.dev_size_y_;
        while (Y <= YX) {
            int X = x - this.dev_size_x_;
            while (X <= XX) {
                int rgba = this.gd_.getPointDirect(X, Y);
                sumR += RGBA.GetR(rgba);
                sumG += RGBA.GetG(rgba);
                sumB += RGBA.GetB(rgba);
                sumA += RGBA.GetA(rgba);
                ++X;
            }
            ++Y;
        }
        return RGBA.Get(sumR /= this.dev_area_, sumG /= this.dev_area_, sumB /= this.dev_area_, sumA /= this.dev_area_);
    }

    public void brushBegin(IGC gc, IGCDirect gd) {
        this.gd_ = gd;
        this.dev_size_x_ = gd.devX(this.size_);
        this.dev_size_y_ = gd.devY(this.size_);
        this.dev_area_ = (2 * this.dev_size_x_ + 1) * (2 * this.dev_size_y_ + 1);
    }

    public void brushEnd() {
        this.gd_ = null;
    }
}

