/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.brushes.internal;

import org.eclipse.tptp.platform.report.igc.brushes.internal.BlurBrush;
import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;

public class BlurFilterBrush
implements IBrush {
    protected int size_;
    int r_;
    int g_;
    int b_;
    int a_;
    boolean sr_;
    boolean sg_;
    boolean sb_;
    boolean sa_;
    protected IGCDirect gd_;
    protected int dev_size_x_;
    protected int dev_size_y_;
    protected int dev_255_area_;

    public BlurFilterBrush(int size, int rgba) {
        this.size_ = size;
        this.r_ = RGBA.GetR(rgba);
        this.sr_ = this.r_ != 0;
        this.g_ = RGBA.GetG(rgba);
        this.sg_ = this.g_ != 0;
        this.b_ = RGBA.GetB(rgba);
        this.sb_ = this.b_ != 0;
        this.a_ = RGBA.GetA(rgba);
        this.sa_ = this.a_ != 0;
    }

    public BlurFilterBrush(BlurFilterBrush b) {
        this.size_ = b.size_;
        this.r_ = b.r_;
        this.sr_ = b.sr_;
        this.g_ = b.g_;
        this.sg_ = b.sg_;
        this.b_ = b.b_;
        this.sb_ = b.sb_;
        this.a_ = b.a_;
        this.sa_ = b.sa_;
    }

    public IBrush copyBrush() {
        return new BlurBrush(this.size_);
    }

    public int getBrushColor(int x, int y, int curr_rgba) {
        int sumR = 0;
        int sumG = 0;
        int sumB = 0;
        int sumA = 0;
        int YX = y + this.dev_size_y_;
        int XN = x - this.dev_size_x_;
        int XX = x + this.dev_size_x_;
        int Y = y - this.dev_size_y_;
        while (Y <= YX) {
            int X = XN;
            while (X <= XX) {
                int rgba = this.gd_.getPointDirect(X, Y);
                if (this.sr_) {
                    sumR += RGBA.GetR(rgba);
                }
                if (this.sg_) {
                    sumG += RGBA.GetG(rgba);
                }
                if (this.sb_) {
                    sumB += RGBA.GetB(rgba);
                }
                if (this.sa_) {
                    sumA += RGBA.GetA(rgba);
                }
                ++X;
            }
            ++Y;
        }
        if (this.sr_) {
            sumR = sumR * this.r_ / this.dev_255_area_;
        }
        if (this.sg_) {
            sumG = sumG * this.g_ / this.dev_255_area_;
        }
        if (this.sb_) {
            sumB = sumB * this.b_ / this.dev_255_area_;
        }
        if (this.sa_) {
            sumA = sumA * this.a_ / this.dev_255_area_;
        }
        return RGBA.Get(sumR, sumG, sumB, sumA);
    }

    public void brushBegin(IGC gc, IGCDirect gd) {
        this.gd_ = gd;
        this.dev_size_x_ = gd.devX(this.size_);
        this.dev_size_y_ = gd.devY(this.size_);
        this.dev_255_area_ = 255 * (2 * this.dev_size_x_ + 1) * (2 * this.dev_size_y_ + 1);
    }

    public void brushEnd() {
        this.gd_ = null;
    }
}

