/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.brushes.internal;

import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;

public class RGBFilterBrush
implements IBrush {
    int r_;
    int g_;
    int b_;
    int a_;
    boolean sr_;
    boolean sg_;
    boolean sb_;
    boolean sa_;

    public RGBFilterBrush(int rgba) {
        this.r_ = RGBA.GetR(rgba);
        this.sr_ = this.r_ != 0;
        this.g_ = RGBA.GetG(rgba);
        this.sg_ = this.g_ != 0;
        this.b_ = RGBA.GetB(rgba);
        this.sb_ = this.b_ != 0;
        this.a_ = RGBA.GetA(rgba);
        this.sa_ = this.a_ != 0;
    }

    public RGBFilterBrush(RGBFilterBrush b) {
        this.r_ = b.r_;
        this.sr_ = this.r_ != 0;
        this.g_ = b.g_;
        this.sg_ = this.g_ != 0;
        this.b_ = b.b_;
        this.sb_ = this.b_ != 0;
        this.a_ = b.a_;
        this.sa_ = this.a_ != 0;
    }

    public IBrush copyBrush() {
        return new RGBFilterBrush(this);
    }

    public void brushBegin(IGC gc, IGCDirect gd) {
    }

    public void brushEnd() {
    }

    public int getBrushColor(int x, int y, int curr_rgba) {
        int r = this.sr_ ? RGBA.GetR(curr_rgba) * this.r_ / 255 : 0;
        int g = this.sg_ ? RGBA.GetG(curr_rgba) * this.g_ / 255 : 0;
        int b = this.sb_ ? RGBA.GetB(curr_rgba) * this.b_ / 255 : 0;
        int a = this.sa_ ? RGBA.GetA(curr_rgba) * this.a_ / 255 : 0;
        return RGBA.Get(r, g, b, a);
    }
}

