/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.ogc.internal;

import java.util.Arrays;
import org.eclipse.tptp.platform.report.igc.alg.internal.FillPolygonAlg;
import org.eclipse.tptp.platform.report.igc.alg.internal.LineAlg;
import org.eclipse.tptp.platform.report.igc.alg.internal.OvalAlg;
import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IFont;
import org.eclipse.tptp.platform.report.igc.internal.IFontMetrics;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPen;
import org.eclipse.tptp.platform.report.igc.internal.IPolygon;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.IShapeFiller;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.ogc.internal.IOGCAdapter;
import org.eclipse.tptp.platform.report.igc.util.internal.Ellipse;
import org.eclipse.tptp.platform.report.igc.util.internal.ImageProxy;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.Oval;
import org.eclipse.tptp.platform.report.igc.util.internal.Polygon;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBAImage;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.Segment;
import org.eclipse.tptp.platform.report.igc.util.internal.Size;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;

public class OGC
implements IGC {
    protected IBrush brush_;
    protected IPen pen_;
    protected IFont font_;
    protected IGCDirect gd_;
    protected int width_;
    protected int height_;
    protected int background_rgba_;
    protected int[] buf_;
    private IOGCAdapter adapter_;
    protected LineAlg line_alg_ = new LineAlg();
    private Segment segment_;
    protected Oval oval_ = new Oval(0, 0, 0, 0);
    protected FillPolygonAlg fill_poly_alg_;

    public OGC(IOGCAdapter adapter, int width, int height, int background_rgba) {
        this.adapter_ = adapter;
        this.background_rgba_ = background_rgba;
        this.gd_ = new GCDirect();
        this.resize(width, height);
    }

    protected boolean haveNoBrush() {
        if (this.brush_ == null) {
            return true;
        }
        return this.brush_ instanceof SolidBrush && RGBA.IsInvisible(((SolidBrush)this.brush_).getRGBA());
    }

    protected boolean haveNoPen() {
        if (this.pen_ == null) {
            return true;
        }
        if (this.pen_ instanceof LineStylePen) {
            return RGBA.IsInvisible(((LineStylePen)this.pen_).getRGBA());
        }
        return false;
    }

    public IGCDirect getIGCDirect() {
        return this.gd_;
    }

    public void resize(int width, int height) {
        if (this.width_ != width || this.height_ != height) {
            this.width_ = width;
            this.height_ = height;
            int nlen = this.width_ * this.height_;
            if (this.buf_ == null || nlen != this.buf_.length) {
                this.buf_ = new int[nlen];
            }
        }
        this.restart();
    }

    public void restart() {
        Arrays.fill(this.buf_, this.background_rgba_);
        this.adapter_.restart();
        this.font_ = null;
    }

    public RGBAImage getBuffer() {
        return new RGBAImage(this.width_, this.height_, this.buf_);
    }

    private IBrush getBrushInternal() {
        if (this.brush_ == null) {
            this.brush_ = new SolidBrush(this.background_rgba_);
        }
        return this.brush_;
    }

    public IBrush getBrush() {
        return this.getBrushInternal().copyBrush();
    }

    public IBrush setBrush(IBrush _brush) {
        if (this.brush_ == null) {
            this.brush_ = this.getBrush();
        }
        IBrush old = this.brush_;
        this.brush_ = _brush;
        return old;
    }

    public IPen getPen() {
        return this.getPenInternal().copyPen();
    }

    private IPen getPenInternal() {
        if (this.pen_ == null) {
            this.pen_ = new LineStylePen(255, 0, 0);
        }
        return this.pen_;
    }

    public IPen setPen(IPen _pen) {
        if (this.pen_ == null) {
            this.pen_ = this.getPenInternal();
        }
        IPen old = this.pen_;
        this.pen_ = _pen;
        return old;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.pen_ != null) {
            this.pen_.drawPath(this, this.gd_, this.getSegment(x1, y1, x2, y2));
        } else {
            this.Unsupported("drawLine(): without pen");
        }
    }

    private Segment getSegment(int x1, int y1, int x2, int y2) {
        if (this.segment_ == null) {
            this.segment_ = new Segment(x1, y1, x2, y2){

                public boolean pathBegin(IGC gc, IGCDirect gd) {
                    boolean r = super.pathBegin(gc, gd);
                    if (!r) {
                        return false;
                    }
                    return this.clipTo(0, 0, OGC.this.width_ - 1, OGC.this.height_ - 1);
                }
            };
        } else {
            this.segment_.setLine(x1, y1, x2, y2);
        }
        return this.segment_;
    }

    public int getPoint(int x, int y) {
        int px = this.gd_.devX(x);
        int py = this.gd_.devY(y);
        if (px < 0 || py < 0 || px >= this.width_ || py >= this.height_) {
            return 0;
        }
        return this.buf_[py * this.width_ + px];
    }

    public void drawPoint(int x, int y) {
        int px = this.gd_.devX(x);
        int py = this.gd_.devY(y);
        if (px < 0 || py < 0 || px >= this.width_ || py >= this.height_) {
            return;
        }
        int index = py * this.width_ + px;
        this.buf_[index] = this.brush_.getBrushColor(px, py, this.buf_[index]);
    }

    public void drawCircle(int cx, int cy, int radius) {
        if (this.pen_ != null) {
            if (this.haveNoPen()) {
                return;
            }
            int dcx = this.gd_.devX(cx);
            int dcy = this.gd_.devY(cy);
            int drx = this.gd_.devX(radius);
            int dry = this.gd_.devY(radius);
            if (dcx - drx >= this.width_ || dcy + dry >= this.height_ || dcx + drx < 0 || dcy + dry < 0) {
                return;
            }
            this.oval_.setOval(cx, cy, radius, radius);
            this.pen_.drawPath(this, this.gd_, this.oval_);
        } else {
            this.Unsupported("drawOval() without pen");
        }
    }

    public void fillCircle(int cx, int cy, int radius) {
        if (this.brush_ != null) {
            if (this.haveNoPen()) {
                return;
            }
            int dcx = this.gd_.devX(cx);
            int dcy = this.gd_.devY(cy);
            int drx = this.gd_.devX(radius);
            int dry = this.gd_.devY(radius);
            if (dcx - drx >= this.width_ || dcy + dry >= this.height_ || dcx + drx < 0 || dcy + dry < 0) {
                return;
            }
            this.oval_.setOval(dcx, dcy, drx, dry);
            this.fillShapeInternal(this.oval_);
        } else {
            this.Unsupported("fillCircle() without brush_");
        }
    }

    public void drawOval(int x, int y, int w, int h) {
        if (this.pen_ != null) {
            if (this.haveNoPen()) {
                return;
            }
            int dx = this.gd_.devX(x);
            int dy = this.gd_.devY(y);
            int dw = this.gd_.devX(w);
            int dh = this.gd_.devY(h);
            if (dx >= this.width_ || dy >= this.height_ || dx + dw - 1 < 0 || dy + dh - 1 < 0) {
                return;
            }
            int rx = dw / 2;
            int ry = dh / 2;
            this.oval_.setOval(dx + rx, dy + ry, rx, ry);
            this.pen_.drawPath(this, this.gd_, this.oval_);
        } else {
            this.Unsupported("drawOval() without pen");
        }
    }

    public void fillOval(int x, int y, int w, int h) {
        if (x >= this.width_ || x + h < 0 || y + h < 0 || y >= this.height_) {
            return;
        }
        if (this.brush_ != null) {
            int dx = this.gd_.devX(x);
            if (dx >= this.width_) {
                return;
            }
            int dy = this.gd_.devY(y);
            if (dy >= this.height_) {
                return;
            }
            int dX = dx + this.gd_.devX(w) - 1;
            if (dX < 0) {
                return;
            }
            int dY = dy + this.gd_.devY(h) - 1;
            if (dY < 0) {
                return;
            }
            int rx = w / 2;
            int ry = h / 2;
            this.brush_.brushBegin(this, this.gd_);
            OvalAlg.FillOval(this.gd_, x + rx, y + ry, rx, ry);
            this.brush_.brushEnd();
        } else {
            this.Unsupported("fillOval() without brush");
        }
    }

    public void drawArc(int xc, int yc, double _r1_angle, int r1, int r2, double _start_angle, double _arc_length) {
        if (this.pen_ == null) {
            this.Unsupported("drawArc() without pen");
            return;
        }
        if (this.haveNoPen()) {
            return;
        }
        double ar1 = Radian.normalize(_r1_angle);
        if (ar1 == 0.0) {
            Oval oval = new Oval(xc, yc, r1, r2, _start_angle, _arc_length);
            this.pen_.drawPath(this, this.gd_, oval);
        } else {
            System.out.println("OGC DRAW ARC USE EllipseAlg ar1=" + ar1);
            Ellipse ellipse = new Ellipse(xc, yc, _r1_angle, r1, r2, _start_angle, _arc_length);
            this.pen_.drawPath(this, this.gd_, ellipse);
        }
    }

    public void fillArc(int xc, int yc, double _r1_angle, int r1, int r2, double _start_angle, double _arc_length) {
        if (this.brush_ == null) {
            this.Unsupported("fillArc() without brush");
            return;
        }
        if (this.haveNoBrush()) {
            return;
        }
        double ar1 = Radian.normalize(_r1_angle);
        if (ar1 == 0.0) {
            Oval oval = new Oval(xc, yc, r1, r2, _start_angle, _arc_length);
            oval.fillShape(this, this.gd_, this.brush_, oval);
        } else {
            System.out.println("OGC FILL ARC USE EllipseAlg ar1=" + ar1);
            Ellipse ellipse = new Ellipse(xc, yc, _r1_angle, r1, r2, _start_angle, _arc_length);
            ellipse.fillShape(this, this.gd_, this.brush_, ellipse);
        }
    }

    public void drawEllipse(int xc, int yc, double _r1_angle, int r1, int r2) {
        if (this.pen_ == null) {
            this.Unsupported("drawEllipse() without pen");
            return;
        }
        this.pen_.drawPath(this, this.gd_, new Ellipse(xc, yc, _r1_angle, r1, r2));
    }

    public void fillEllipse(int xc, int yc, double _r1_angle, int r1, int r2) {
        if (this.brush_ == null) {
            this.Unsupported("fillEllipse() without brush");
            return;
        }
        Ellipse ellipse = new Ellipse(xc, yc, _r1_angle, r1, r2);
        ellipse.fillShape(this, this.gd_, this.brush_, ellipse);
    }

    public void drawRect(int x, int y, int w, int h) {
        if (this.pen_ == null) {
            this.Unsupported("drawRect() without pen_");
            return;
        }
        this.drawPath(new Rect(x, y, w, h));
    }

    public void fillRect(IRect r) {
        this.fillRect(r.getX(), r.getY(), r.getW(), r.getH());
    }

    public void drawRect(IRect r) {
        if (r instanceof IPath) {
            this.drawPath((IPath)((Object)r));
        } else {
            this.drawPath(new Rect(r));
        }
    }

    public void fillRect(int x, int y, int w, int h) {
        if (this.gd_.usePixelCoordinates()) {
            this.gd_.fillRectDirect(x, y, w, h);
        } else {
            this.gd_.fillRectDirect(this.gd_.devX(x), this.gd_.devY(y), this.gd_.devX(w), this.gd_.devY(h));
        }
    }

    public void drawImage(IImage image, int _x, int _y) {
        int x = this.gd_.devX(_x);
        int y = this.gd_.devY(_y);
        if (x >= this.width_ || y >= this.height_) {
            return;
        }
        if (image instanceof ImageProxy) {
            ImageProxy proxy = (ImageProxy)image;
            if (!proxy.isLoaded()) {
                proxy.loadImage();
            }
            image = proxy.getLoaded();
        }
        if (!this.adapter_.drawImage(this.buf_, this.width_, this.height_, image, _x, _y)) {
            this.Unsupported("drawImage(IImage,int,int) with IImage = " + image);
        }
    }

    public void drawImage(IImage _image, int _x, int _y, int _w, int _h) {
        int x = this.gd_.devX(_x);
        int y = this.gd_.devY(_y);
        if (x >= this.width_ || y >= this.height_) {
            return;
        }
        if (_image instanceof ImageProxy) {
            ImageProxy proxy = (ImageProxy)_image;
            if (!proxy.isLoaded()) {
                proxy.loadImage();
            }
            _image = proxy.getLoaded();
        }
        if (!this.adapter_.drawImage(this.buf_, this.width_, this.height_, _image, _x, _y, _w, _h)) {
            this.Unsupported("drawImage(IImage,int,int,int,int) with IImage = " + _image);
        }
    }

    public void drawImage(IImage image, int srcX, int srcY, int srcW, int srcH, int dstX, int dstY, int dstW, int dstH) {
        int x = this.gd_.devX(dstX);
        int y = this.gd_.devY(dstY);
        if (x >= this.width_ || y >= this.height_) {
            return;
        }
        if (image instanceof ImageProxy) {
            ImageProxy proxy = (ImageProxy)image;
            if (!proxy.isLoaded()) {
                proxy.loadImage();
            }
            image = proxy.getLoaded();
        }
        if (!this.adapter_.drawImage(this.buf_, this.width_, this.height_, image, srcX, srcY, srcW, srcH, dstX, dstY, dstW, dstH)) {
            this.Unsupported("drawImage(IImage,...) with IImage = " + image);
        }
    }

    public void drawPoly(IPolygon poly) {
        if (this.pen_ == null) {
            this.Unsupported("drawPoly() without pen");
            return;
        }
        if (poly instanceof IPath) {
            this.pen_.drawPath(this, this.gd_, (IPath)((Object)poly));
            return;
        }
        Polygon p = new Polygon(poly);
        this.pen_.drawPath(this, this.gd_, p);
    }

    public void fillPoly(IPolygon poly) {
        if (this.brush_ == null) {
            this.Unsupported("fillPoly() without brush");
            return;
        }
        if (poly instanceof IShape) {
            if (this.brush_ instanceof IShapeFiller && ((IShapeFiller)((Object)this.brush_)).fillShape(this, this.gd_, this.brush_, poly)) {
                return;
            }
            if (poly instanceof IShapeFiller && ((IShapeFiller)((Object)poly)).fillShape(this, this.gd_, this.brush_, poly)) {
                return;
            }
        }
        if (this.gd_.usePixelCoordinates()) {
            if (this.fill_poly_alg_ == null) {
                this.fill_poly_alg_ = new FillPolygonAlg();
            }
            if (this.brush_ != null) {
                this.brush_.brushBegin(this, this.gd_);
            }
            this.fill_poly_alg_.fillPoly(this.gd_, poly, 0, 0, this.width_, this.height_);
            if (this.brush_ != null) {
                this.brush_.brushEnd();
            }
        } else {
            int size = poly.getPolySize();
            Polygon dev_poly = new Polygon(size);
            int i = 0;
            while (i < size) {
                dev_poly.setPoint(i, this.gd_.devX(poly.getPolyX(i)), this.gd_.devY(poly.getPolyY(i)));
                ++i;
            }
            if (this.fill_poly_alg_ == null) {
                this.fill_poly_alg_ = new FillPolygonAlg();
            }
            if (this.brush_ != null) {
                this.brush_.brushBegin(this, this.gd_);
            }
            this.fill_poly_alg_.fillPoly(this.gd_, dev_poly, 0, 0, this.width_, this.height_);
            if (this.brush_ != null) {
                this.brush_.brushEnd();
            }
        }
    }

    public ISize textExtent(String text) {
        Size size = this.adapter_.textExtent(text);
        return new Size(this.gd_.pixX(size.getW()), this.gd_.pixY(size.getH()));
    }

    public ISize textExtent(String text, double angle) {
        double a = Radian.normalize(angle);
        Size size = this.adapter_.textExtent(text);
        return RGBAImage.rotateImageSize(size.getW(), size.getH(), a);
    }

    public IPolygon textExtent(String text, int x, int y, double angle) {
        double a = Radian.normalize(angle);
        Size size = this.adapter_.textExtent(text);
        return RGBAImage.rotateImageBounds(x, y, size.getW(), size.getH(), a);
    }

    protected void drawTextImage(RGBAImage data, int devx, int devy, boolean transparent) {
        boolean no_transp;
        int white = -1;
        int black = 255;
        boolean bl = no_transp = !transparent && this.brush_ != null;
        if (no_transp) {
            // empty if block
        }
        int brush_rgba = 255;
        boolean solid_brush = this.brush_ instanceof SolidBrush;
        if (solid_brush) {
            brush_rgba = ((SolidBrush)this.brush_).getRGBA();
        }
        int brush_rgb_ = brush_rgba & 0xFFFFFF00;
        int brush_alpha = brush_rgba & 0xFF;
        this.brush_.brushBegin(this, this.gd_);
        int Y = devy;
        int height = data.getHeight();
        int width = data.getWidth();
        int[] image = data.getImage();
        int index0 = devy * this.width_ + devx;
        int ir0 = 0;
        int iy = 0;
        while (iy < height && Y < this.height_) {
            if (Y >= 0) {
                int X = devx;
                int ix = 0;
                int index = index0;
                int ir = ir0;
                while (ix < width && X < this.width_) {
                    if (X >= 0) {
                        int rgba = image[ir];
                        if (rgba == black) {
                            this.buf_[index] = solid_brush ? RGBA.Combine(brush_rgba, this.buf_[index]) : this.brush_.getBrushColor(X, Y, this.buf_[index]);
                        } else if (rgba != white) {
                            int alpha = 255 - RGBA.GetB(rgba);
                            if (solid_brush) {
                                alpha = alpha * brush_alpha / 255;
                                this.buf_[index] = RGBA.Combine(brush_rgb_ + alpha, this.buf_[index]);
                            } else {
                                int bck = this.buf_[index];
                                int brgba = this.brush_.getBrushColor(X, Y, bck);
                                alpha = alpha * (brgba & 0xFF) / 255;
                                this.buf_[index] = RGBA.Combine(brgba & 0xFFFFFF00 | alpha, bck);
                            }
                        }
                    }
                    ++ix;
                    ++X;
                    ++index;
                    ++ir;
                }
            }
            ++iy;
            ++Y;
            index0 += this.width_;
            ir0 += width;
        }
        this.brush_.brushEnd();
    }

    public void drawText(String text, int _x, int _y) {
        if (this.brush_ == null) {
            this.Unsupported("drawText() without brush");
            return;
        }
        int x = this.gd_.devX(_x);
        int y = this.gd_.devY(_y);
        if (x >= this.width_ || y >= this.height_) {
            return;
        }
        Size size = this.adapter_.textExtent(text);
        if (x + this.gd_.devX(size.getW()) < 0 || y + this.gd_.devY(size.getH()) < 0) {
            return;
        }
        this.drawTextImage(this.adapter_.getTextImage(text, size), x, y, true);
    }

    public void drawText(String text, int x, int y, double angle) {
        double a = Radian.normalize(angle);
        int tx = this.gd_.devX(x);
        int ty = this.gd_.devY(y);
        if (tx >= this.width_ || ty >= this.height_) {
            return;
        }
        Size size = this.adapter_.textExtent(text);
        RGBAImage s = this.adapter_.getTextImage(text, size);
        RGBAImage r = s.rotateImage(a, -1, true);
        Polygon rte = RGBAImage.rotateImageBounds(tx, ty, size.getW(), size.getH(), a);
        IRect rb = rte.getBounds();
        this.drawTextImage(r, tx + rb.getX() - rte.getPolyX(0), ty + rb.getY() - rte.getPolyY(0), true);
    }

    public void drawFocus(int x, int y, int w, int h) {
        LineStylePen npen = new LineStylePen(2);
        SolidBrush nbrush = new SolidBrush(17);
        IPen oldpen = this.setPen(npen);
        IBrush oldbrush = this.setBrush(nbrush);
        this.drawRect(x, y, w, h);
        this.setPen(oldpen);
        this.setBrush(oldbrush);
    }

    public void drawFocus(IRect rect) {
        this.drawFocus(rect.getX(), rect.getY(), rect.getW(), rect.getH());
    }

    public IFont getFont() {
        if (this.font_ == null) {
            this.font_ = this.adapter_.getFont();
        }
        return this.font_.copy();
    }

    public IFont setFont(IFont font) {
        IFont old = this.getFont();
        this.adapter_.setFont(font);
        this.font_ = font;
        return old;
    }

    public IFontMetrics getFontMetrics() {
        return this.adapter_.getFontMetrics();
    }

    public IShape getClipping() {
        return new Rect(0, 0, this.gd_.pixX(this.width_), this.gd_.pixY(this.height_));
    }

    public IShape setClipping(IShape s) {
        this.Unsupported("setClipping() TODO");
        return null;
    }

    public boolean fillShapeInternal(IShape shape) {
        if (shape instanceof IRect) {
            this.fillRect((IRect)shape);
            return true;
        }
        if (shape instanceof IPolygon) {
            this.fillPoly((IPolygon)shape);
            return true;
        }
        if (this.brush_ instanceof IShapeFiller && ((IShapeFiller)((Object)this.brush_)).fillShape(this, this.gd_, this.brush_, shape)) {
            return true;
        }
        return shape instanceof IShapeFiller && ((IShapeFiller)((Object)shape)).fillShape(this, this.gd_, this.getBrushInternal(), shape);
    }

    public void fillShape(IShape shape) {
        if (!this.fillShapeInternal(shape)) {
            this.Unsupported("fillShape() for shape=" + shape + " and brush=" + this.brush_);
        }
    }

    public void drawPath(IPath path) {
        if (path instanceof IPolygon) {
            this.drawPoly((IPolygon)((Object)path));
        } else {
            if (this.pen_ == null) {
                this.Unsupported("drawPath() without pen");
                return;
            }
            this.pen_.drawPath(this, this.gd_, path);
        }
    }

    protected void Unsupported(String what) {
        System.err.println("OGC: Unsupported method: " + what);
    }

    public int getSystemColor(int id) {
        return this.adapter_.getSystemColor(id);
    }

    private class GCDirect
    implements IGCDirect {
        float KdpiX_;
        float KdpiY_;

        public GCDirect() {
            this.KdpiX_ = OGC.this.adapter_.getKdpiX();
            this.KdpiY_ = OGC.this.adapter_.getKdpiY();
        }

        public IGC getIGC() {
            return OGC.this;
        }

        public boolean usePixelCoordinates() {
            return this.KdpiX_ == 1.0f && this.KdpiY_ == 1.0f;
        }

        public int devX(int x) {
            return (int)(this.KdpiX_ * (float)x);
        }

        public int devY(int y) {
            return (int)(this.KdpiY_ * (float)y);
        }

        public int pixX(int x) {
            return (int)((float)x / this.KdpiX_);
        }

        public int pixY(int y) {
            return (int)((float)y / this.KdpiY_);
        }

        public void drawVLineDirect(int x, int y1, int y2) {
            if (x < 0 || x >= OGC.this.width_) {
                return;
            }
            int yx = y2;
            int yn = y1;
            if (yx < yn) {
                yx = yn = yx;
            }
            if (yx < 0 || yn >= OGC.this.width_) {
                return;
            }
            int YN = Math.max(yn, 0);
            int YX = Math.min(yx, OGC.this.height_ - 1);
            if (OGC.this.brush_ instanceof SolidBrush) {
                int rgba = ((SolidBrush)OGC.this.brush_).getRGBA();
                int index = YN * OGC.this.width_ + x;
                if (RGBA.IsOpaque(rgba)) {
                    int y = YN;
                    while (y <= YX) {
                        OGC.this.buf_[index] = rgba;
                        index += OGC.this.width_;
                        ++y;
                    }
                } else {
                    int y = YN;
                    while (y <= YX) {
                        OGC.this.buf_[index] = RGBA.Combine(rgba, OGC.this.buf_[index]);
                        index += OGC.this.width_;
                        ++y;
                    }
                }
            } else if (OGC.this.brush_ != null) {
                OGC.this.brush_.brushBegin(OGC.this, this);
                int index = YN * OGC.this.width_ + x;
                int y = YN;
                while (x <= YX) {
                    OGC.this.buf_[index] = OGC.this.brush_.getBrushColor(x, y, OGC.this.buf_[index]);
                    index += OGC.this.width_;
                    ++x;
                }
                OGC.this.brush_.brushEnd();
            } else {
                OGC.this.Unsupported("drawHLineDirect() without brush.");
            }
        }

        /*
         * Unable to fully structure code
         */
        public void drawLineDirect(int x1, int y1, int x2, int y2) {
            block6: {
                block5: {
                    if (!(OGC.this.brush_ instanceof SolidBrush)) break block5;
                    rgba = ((SolidBrush)OGC.this.brush_).getRGBA();
                    OGC.this.line_alg_.setLine(x1, y1, x2, y2);
                    OGC.this.line_alg_.clipTo(0, 0, OGC.this.width_, OGC.this.height_);
                    if (!RGBA.IsOpaque(rgba)) ** GOTO lbl17
                    while (OGC.this.line_alg_.nextPoint(null)) {
                        x = OGC.this.line_alg_.getX();
                        y = OGC.this.line_alg_.getY();
                        OGC.this.buf_[y * OGC.this.width_ + x] = rgba;
                    }
                    break block6;
lbl-1000:
                    // 1 sources

                    {
                        px = OGC.this.line_alg_.getX();
                        py = OGC.this.line_alg_.getY();
                        index = py * OGC.this.width_ + px;
                        OGC.this.buf_[index] = RGBA.Combine(rgba, OGC.this.buf_[index]);
lbl17:
                        // 2 sources

                        ** while (OGC.this.line_alg_.nextPoint(null))
                    }
lbl18:
                    // 1 sources

                    break block6;
                }
                if (OGC.this.brush_ != null) {
                    OGC.this.line_alg_.setLine(x1, y1, x2, y2);
                    OGC.this.brush_.brushBegin(OGC.this, this);
                    while (OGC.this.line_alg_.nextPoint(null)) {
                        px = OGC.this.line_alg_.getX();
                        py = OGC.this.line_alg_.getY();
                        index = py * OGC.this.width_ + px;
                        OGC.this.buf_[index] = OGC.this.brush_.getBrushColor(px, py, OGC.this.buf_[index]);
                    }
                    OGC.this.brush_.brushEnd();
                } else {
                    OGC.this.Unsupported("drawHLineDirect() without brush.");
                }
            }
        }

        public void drawHLineDirect(int x1, int x2, int y) {
            if (y < 0 || y >= OGC.this.height_) {
                return;
            }
            int xx = x2;
            int xn = x1;
            if (xx < xn) {
                xx = xn = xx;
            }
            if (xx < 0 || xn >= OGC.this.width_) {
                return;
            }
            int XN = Math.max(xn, 0);
            int XX = Math.min(xx, OGC.this.width_ - 1);
            if (OGC.this.brush_ instanceof SolidBrush) {
                int rgba = ((SolidBrush)OGC.this.brush_).getRGBA();
                int index = y * OGC.this.width_ + XN;
                if (RGBA.IsOpaque(rgba)) {
                    int x = XN;
                    while (x <= XX) {
                        OGC.this.buf_[index++] = rgba;
                        ++x;
                    }
                } else {
                    int x = XN;
                    while (x <= XX) {
                        OGC.this.buf_[index] = RGBA.Combine(rgba, OGC.this.buf_[index]);
                        ++x;
                        ++index;
                    }
                }
            } else if (OGC.this.brush_ != null) {
                OGC.this.brush_.brushBegin(OGC.this, this);
                int index = y * OGC.this.width_ + XN;
                int x = XN;
                while (x <= XX) {
                    OGC.this.buf_[index] = OGC.this.brush_.getBrushColor(x, y, OGC.this.buf_[index]);
                    ++x;
                    ++index;
                }
                OGC.this.brush_.brushEnd();
            } else {
                OGC.this.Unsupported("drawHLineDirect() without brush.");
            }
        }

        public void drawPointDirect(int x, int y, int _rgba) {
            if (x < 0 || y < 0 || x >= OGC.this.width_ || y >= OGC.this.height_) {
                return;
            }
            int index = y * OGC.this.width_ + x;
            OGC.this.buf_[index] = RGBA.Combine(_rgba, OGC.this.buf_[index]);
        }

        public int getPointDirect(int x, int y) {
            if (x < 0 || y < 0 || x >= OGC.this.width_ || y >= OGC.this.height_) {
                return 0;
            }
            return OGC.this.buf_[y * OGC.this.width_ + x];
        }

        public void fillRectDirect(int x, int y, int w, int h) {
            int i;
            int x1 = x;
            int y1 = y;
            int x2 = x1 + w;
            int y2 = y1 + h;
            if (x2 < x1) {
                i = x1;
                x1 = x2;
                x2 = i;
            }
            if (y2 < y1) {
                i = y1;
                y1 = y2;
                y2 = i;
            }
            if (x2 < 0 || x1 >= OGC.this.width_ || y2 < 0 || y1 >= OGC.this.height_) {
                return;
            }
            if (x1 < 0) {
                x1 = 0;
            }
            if (x2 >= OGC.this.width_) {
                x2 = OGC.this.width_ - 1;
            }
            if (y1 < 0) {
                y1 = 0;
            }
            if (y2 >= OGC.this.height_) {
                y2 = OGC.this.height_ - 1;
            }
            if (OGC.this.brush_ instanceof SolidBrush) {
                int bclr = ((SolidBrush)OGC.this.brush_).getRGBA();
                if (RGBA.IsOpaque(bclr)) {
                    int index0 = y1 * OGC.this.width_ + x1;
                    int index1 = index0 + x2 - x1 + 1;
                    int Y = y1;
                    while (Y <= y2) {
                        int index = index0;
                        int X = x1;
                        while (X <= x2) {
                            OGC.this.buf_[index++] = bclr;
                            ++X;
                        }
                        index0 += OGC.this.width_;
                        index1 += OGC.this.width_;
                        ++Y;
                    }
                } else {
                    int index0 = y1 * OGC.this.width_ + x1;
                    int Y = y1;
                    while (Y <= y2) {
                        int index = index0;
                        int X = x1;
                        while (X <= x2) {
                            OGC.this.buf_[index] = RGBA.Combine(bclr, OGC.this.buf_[index]);
                            ++X;
                            ++index;
                        }
                        index0 += OGC.this.width_;
                        ++Y;
                    }
                }
            } else if (OGC.this.brush_ != null) {
                OGC.this.brush_.brushBegin(OGC.this, this);
                int index0 = y1 * OGC.this.width_ + x1;
                int Y = y1;
                while (Y <= y2) {
                    int index = index0;
                    int X = x1;
                    while (X <= x2) {
                        int rgba = OGC.this.buf_[index];
                        int bclr = OGC.this.brush_.getBrushColor(X, Y, rgba);
                        OGC.this.buf_[index] = RGBA.Combine(bclr, rgba);
                        ++X;
                        ++index;
                    }
                    index0 += OGC.this.width_;
                    ++Y;
                }
                OGC.this.brush_.brushEnd();
            } else {
                OGC.this.Unsupported("fillRect() without brush_");
            }
        }

        public void drawRectDirect(int x, int y, int w, int h) {
            OGC.this.brush_.brushBegin(OGC.this, this);
            int x2 = x + w;
            int y2 = y + h;
            this.drawHLineDirect(x, x2, y);
            this.drawHLineDirect(x, x2, y2);
            this.drawVLineDirect(x, ++y, --y2);
            this.drawVLineDirect(x2, y, y2);
            OGC.this.brush_.brushEnd();
        }
    }
}

