/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.svg.internal;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.tptp.platform.report.igc.brushes.internal.FullGradientBrush;
import org.eclipse.tptp.platform.report.igc.brushes.internal.GradientBrush;
import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IFont;
import org.eclipse.tptp.platform.report.igc.internal.IFontMetrics;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPen;
import org.eclipse.tptp.platform.report.igc.internal.IPolygon;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.IShapeFiller;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.ImageProxy;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.Oval;
import org.eclipse.tptp.platform.report.igc.util.internal.Polygon;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBAImage;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Size;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;

public class SVGGC
implements IGC {
    private static final int DEFAULT_FONT_SIZE = 10;
    private OutputStream os_;
    private int width_;
    private int height_;
    protected IBrush brush_;
    protected IPen pen_;
    protected IFont font_;
    protected int fill_ = 255;
    protected int stroke_ = 255;
    protected int strokedasharray_;
    protected int stroke_width_ = 1;
    protected int stroke_opacity_;
    protected int gradient_number_;
    protected GCDirect gd_;

    public SVGGC(OutputStream output, int w, int h) {
        this.os_ = output;
        this.width_ = w;
        this.height_ = h;
        this.gd_ = new GCDirect();
    }

    public IGCDirect getIGCDirect() {
        return this.gd_;
    }

    public int getSystemColor(int id) {
        return 0;
    }

    public void begin() {
        this.svgWrite("<?xml version=\"1.0\" standalone=\"no\"?><!DOCTYPE svg PUBLIC \" -//W3C//DTD SVG 1.0//EN\" \"http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd\"><svg width=\"" + this.width_ + "\" height=\"" + this.height_ + "\" >");
    }

    public void end() {
        this.svgWrite("</svg>");
    }

    public IBrush getBrush() {
        return this.brush_;
    }

    public IBrush setBrush(IBrush _brush) {
        IBrush old = this.brush_;
        this.brush_ = _brush;
        if (_brush instanceof SolidBrush) {
            this.fill_ = ((SolidBrush)this.brush_).getRGBA();
        } else if (_brush instanceof GradientBrush) {
            GradientBrush b = (GradientBrush)this.brush_;
            this.fill_ = b.getRGBA2();
            if (b.isVertical()) {
                this.svgWrite(this.svgGradient(b, b.getBounds().centerX(), b.getBounds().getY(), b.getBounds().centerX(), b.getBounds().bottom()));
            } else {
                this.svgWrite(this.svgGradient(b, b.getBounds().getX(), b.getBounds().centerY(), b.getBounds().right(), b.getBounds().centerY()));
            }
        } else if (this.brush_ instanceof FullGradientBrush) {
            FullGradientBrush b = (FullGradientBrush)this.brush_;
            this.fill_ = b.getBrushColor(b.getPoint1().getX(), b.getPoint1().getY(), 0);
            this.svgWrite(this.svgGradient(b, b.getPoint1().getX(), b.getPoint1().getY(), b.getPoint2().getX(), b.getPoint2().getY()));
        }
        return old;
    }

    public IPen getPen() {
        return this.pen_;
    }

    public int getPoint(int x, int y) {
        return 0;
    }

    public IPen setPen(IPen _pen) {
        IPen old = this.pen_;
        this.pen_ = _pen;
        if (_pen instanceof LineStylePen) {
            this.stroke_ = ((LineStylePen)_pen).getRGBA();
            this.strokedasharray_ = ((LineStylePen)_pen).getLineStyle();
            this.stroke_width_ = ((LineStylePen)_pen).getLineWidth();
        }
        return old;
    }

    public IFont getFont() {
        return this.font_;
    }

    public IFont setFont(IFont font) {
        this.font_ = font;
        return this.font_.copy();
    }

    public void drawHLine(int x1, int x2, int y) {
        this.drawLine(x1, y, x2, y);
    }

    public void drawVLine(int x, int y1, int y2) {
        this.drawLine(x, y1, x, y2);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        StringBuffer b = new StringBuffer(128);
        b.append("<line style=\"");
        this.svgStroke(b);
        b.append("\" ");
        this.svg2Coord(x1, y1, x2, y2, b);
        b.append(" />");
        this.svgWrite(b.toString());
    }

    public void drawPoint(int x, int y) {
        this.drawLine(x, y, x + 1, y);
    }

    private void svgCircle(int cx, int cy, int radius, boolean stroke) {
        StringBuffer b = new StringBuffer(128);
        b.append("<circle cx=\"");
        b.append(cx);
        b.append("\" cy=\"");
        b.append(cy);
        b.append("\" r=\"");
        b.append(radius);
        b.append("\" style=\"");
        if (stroke) {
            this.svgStroke(b);
        } else {
            this.svgFill(b);
        }
        b.append("\" />");
        this.svgWrite(b.toString());
    }

    public void drawCircle(int cx, int cy, int radius) {
        this.svgCircle(cx, cy, radius, true);
    }

    public void fillCircle(int cx, int cy, int radius) {
        this.svgCircle(cx, cy, radius, false);
    }

    public void drawOval(int x, int y, int w, int h) {
        int rx = w / 2;
        int ry = h / 2;
        if (rx == 0 || ry == 0) {
            return;
        }
        this.drawEllipse(x + rx, y + ry, 0.0, rx, ry);
    }

    public void fillOval(int x, int y, int w, int h) {
        int rx = w / 2;
        int ry = h / 2;
        if (rx == 0 || ry == 0) {
            return;
        }
        this.fillEllipse(x + rx, y + ry, 0.0, rx, ry);
    }

    private String svgArcPoints(int r1, int r2, double _start_angle, double _arc_length) {
        StringBuffer sb = new StringBuffer(512);
        sb.append("0,0");
        double da = 0.06283185307179587;
        int npt = (int)Math.round(_arc_length / da);
        da = _arc_length / (double)npt;
        double a = _start_angle;
        int i = 0;
        while (i <= npt) {
            double c = Math.cos(a);
            double s = Math.sin(a);
            int x = (int)Math.round((double)r1 * c);
            int y = -((int)Math.round((double)r2 * s));
            sb.append(' ');
            sb.append(x);
            sb.append(',');
            sb.append(y);
            a += da;
            ++i;
        }
        sb.append(" 0,0");
        return sb.toString();
    }

    private void svgArc(int xc, int yc, double _r1_angle, int r1, int r2, double _start_angle, double _arc_length, boolean stroke) {
        StringBuffer b = new StringBuffer(1024);
        b.append("<g transform=\"translate(");
        b.append(xc);
        b.append(',');
        b.append(yc);
        b.append(")\" >");
        b.append("<g transform=\"rotate(");
        b.append(-Radian.iR2D(_r1_angle));
        b.append(")\" >\n<polyline points=\"");
        b.append(this.svgArcPoints(r1, r2, _start_angle, _arc_length));
        b.append("\" style=\"");
        if (stroke) {
            this.svgStroke(b);
        } else {
            this.svgFill(b);
        }
        b.append("\" /></g></g>");
        this.svgWrite(b.toString());
    }

    public void drawArc(int xc, int yc, double _r1_angle, int r1, int r2, double _start_angle, double _arc_length) {
        this.svgArc(xc, yc, _r1_angle, r1, r2, _start_angle, _arc_length, true);
    }

    public void fillArc(int xc, int yc, double _r1_angle, int r1, int r2, double _start_angle, double _arc_length) {
        this.svgArc(xc, yc, _r1_angle, r1, r2, _start_angle, _arc_length, false);
    }

    private void svgEllipse(int xc, int yc, int rx, int ry, boolean stroke) {
        StringBuffer b = new StringBuffer(128);
        b.append("<ellipse ");
        this.svgEllipse(xc, yc, rx, ry, b);
        b.append(" style=\"");
        if (stroke) {
            this.svgStroke(b);
        } else {
            this.svgFill(b);
        }
        b.append("\" />");
        this.svgWrite(b.toString());
    }

    public void drawEllipse(int xc, int yc, double _r1_angle, int r1, int r2) {
        double a = Radian.normalize(_r1_angle);
        int ia = Radian.iR2D(a);
        if (ia == 0) {
            this.svgEllipse(xc, yc, r1, r2, true);
        } else if (ia == 90 || ia == 270) {
            this.svgEllipse(xc, yc, r2, r1, true);
        } else {
            StringBuffer b = new StringBuffer(512);
            b.append("<g transform=\"translate(");
            b.append(xc);
            b.append(',');
            b.append(yc);
            b.append(")/><g transform=\"rotate(");
            b.append(-Radian.iR2D(_r1_angle));
            b.append(")\">\n<ellipse ");
            this.svgEllipse(0, 0, r1, r2, b);
            b.append(" style=\"");
            this.svgStroke(b);
            b.append("\"/></g></g>");
            this.svgWrite(b.toString());
        }
    }

    public void fillEllipse(int xc, int yc, double _r1_angle, int r1, int r2) {
        double a = Radian.normalize(_r1_angle);
        int ia = Radian.iR2D(a);
        if (ia == 0) {
            this.svgEllipse(xc, yc, r1, r2, false);
        } else if (ia == 90 || ia == 270) {
            this.svgEllipse(xc, yc, r2, r1, false);
        } else {
            StringBuffer b = new StringBuffer(512);
            b.append("<g transform=\"translate(");
            b.append(xc);
            b.append(',');
            b.append(yc);
            b.append(")/><g transform=\"rotate(");
            b.append(-Radian.iR2D(_r1_angle));
            b.append(")\">\n<ellipse ");
            this.svgEllipse(0, 0, r1, r2, b);
            b.append(" style=\"");
            this.svgFill(b);
            b.append("\"/></g></g>");
            this.svgWrite(b.toString());
        }
    }

    private void svgRect(int x, int y, int w, int h, boolean stroke) {
        StringBuffer b = new StringBuffer(128);
        b.append("<rect ");
        this.svgRect(x, y, w, h, 0, 0, b);
        b.append(" style=\"");
        if (stroke) {
            this.svgStroke(b);
        } else {
            this.svgFill(b);
        }
        b.append("\" />");
        this.svgWrite(b.toString());
    }

    public void fillRect(int x, int y, int w, int h) {
        this.svgRect(x, y, w, h, false);
    }

    public void drawRect(int x, int y, int w, int h) {
        this.svgRect(x, y, w, h, true);
    }

    public void fillRect(IRect r) {
        this.fillRect(r.getX(), r.getY(), r.getW(), r.getH());
    }

    public void drawRect(IRect r) {
        this.drawRect(r.getX(), r.getY(), r.getW(), r.getH());
    }

    public void drawImage(IImage image, int x, int y) {
        this.drawImage(image, x, y, image.getWidth(), image.getHeight());
    }

    public void drawImage(IImage image, int srcX, int srcY, int srcW, int srcH, int dstX, int dstY, int dstW, int dstH) {
        this.drawImage(image, dstX, dstY, dstW, dstH);
    }

    public void drawImage(IImage image, int srcX, int srcY, int srcW, int srcH) {
        if (image instanceof ImageProxy) {
            ImageProxy proxy = (ImageProxy)image;
            if (!proxy.isLoaded()) {
                proxy.loadImage();
            }
            image = proxy.getLoaded();
            StringBuffer b = new StringBuffer(128);
            b.append("<image ");
            this.svgRect(srcX, srcY, srcW, srcH, 0, 0, b);
            b.append(" xlink:href=\"");
            b.append(proxy.getURL());
            b.append("\" />");
            this.svgWrite(b.toString());
        } else {
            this.Unsupported("drawImage(IImage, int,int) where IImage isn't an instance of SWTImage");
        }
    }

    private void svgPoly(IPolygon poly, boolean stroke) {
        int size = poly.getPolySize();
        int[] x = new int[size];
        int[] y = new int[size];
        int i = 0;
        while (i < size) {
            x[i] = poly.getPolyX(i);
            y[i] = poly.getPolyY(i);
            ++i;
        }
        StringBuffer b = new StringBuffer(1024);
        if (stroke) {
            b.append("<polyline ");
        } else {
            b.append("<polygon ");
        }
        this.svgPoints(x, y, b);
        b.append(" style=\"");
        if (stroke) {
            this.svgStroke(b);
        } else {
            this.svgFill(b);
        }
        b.append("\" />");
        this.svgWrite(b.toString());
    }

    public void drawPoly(IPolygon poly) {
        this.svgPoly(poly, true);
    }

    public void fillPoly(IPolygon poly) {
        this.svgPoly(poly, false);
    }

    public void drawText(String text, int x, int y) {
        this.drawText(text, x, y, 0.0);
    }

    public void drawText(String text, int x, int y, double angle) {
        double a = Radian.normalize(angle);
        int ia = Radian.iR2D(a);
        boolean no_rotation = ia == 0 || ia == 360;
        int dy = 0;
        if (this.font_ != null) {
            dy = this.font_.getFontSize();
            y += this.font_.getFontSize();
        }
        StringBuffer b = new StringBuffer(128);
        if (no_rotation) {
            b.append("<text>");
        } else {
            b.append("<g transform=\"translate(");
            b.append(x);
            b.append(',');
            b.append(y - dy);
            b.append(")\" ><g transform=\"rotate( -");
            b.append(ia);
            b.append(")\" ><text>");
        }
        b.append("<tspan ");
        if (no_rotation) {
            this.svgCoord(x, y, b);
            b.append(' ');
        }
        this.svgFont(b);
        b.append("  style=\"stroke:none;");
        this.svgFill(b);
        b.append("\" >");
        b.append(text);
        b.append("</tspan>");
        if (no_rotation) {
            b.append("</text>");
        } else {
            b.append("</text></g></g>");
        }
        this.svgWrite(b.toString());
    }

    public void drawFocus(int x, int y, int w, int h) {
    }

    public void drawFocus(IRect rect) {
    }

    public IFontMetrics getFontMetrics() {
        final int fh = this.font_ != null ? this.font_.getFontSize() : 10;
        return new IFontMetrics(){

            public int getAscent() {
                return SVGGC.this.gd_.pixY(fh);
            }

            public int getDescent() {
                return SVGGC.this.gd_.pixY(0);
            }

            public int getHeight() {
                return SVGGC.this.gd_.pixY(fh);
            }

            public int getLeading() {
                return SVGGC.this.gd_.pixY(0);
            }
        };
    }

    public IPolygon textExtent(String text, int x, int y, double angle) {
        double a = Radian.normalize(angle);
        ISize size = this.textExtent(text);
        return RGBAImage.rotateImageBounds(x, y, size.getW(), size.getH(), a);
    }

    public ISize textExtent(String text) {
        if (this.font_ != null) {
            return new Size(text.length() * this.font_.getFontSize(), this.font_.getFontSize());
        }
        return new Size(text.length() * 10, 10);
    }

    public ISize textExtent(String text, double angle) {
        double a = Radian.normalize(angle);
        int ia = Radian.iR2D(a);
        switch (ia) {
            case 0: 
            case 360: {
                return this.textExtent(text);
            }
            case 90: 
            case 270: {
                Size p = (Size)this.textExtent(text);
                p.setSize(p.getH(), p.getW());
                return p;
            }
        }
        ISize size = this.textExtent(text);
        Polygon p = RGBAImage.rotateImageBounds(0, 0, size.getW(), size.getH(), a);
        IRect r = p.getBounds();
        ((Size)size).setSize(r.getW(), r.getH());
        return size;
    }

    public IShape getClipping() {
        return null;
    }

    public IShape setClipping(IShape s) {
        IShape old = this.getClipping();
        if (s != null) {
            if (s instanceof IRect) {
                IRect cfr_ignored_0 = (IRect)s;
            } else {
                this.Unsupported("setClipping() with shape=" + s);
            }
        }
        return old;
    }

    public void fillShape(IShape shape) {
        if (shape instanceof IRect) {
            this.fillRect((IRect)shape);
        } else if (shape instanceof Oval) {
            Oval o = (Oval)shape;
            int cx = o.getCenterX();
            int cy = o.getCenterY();
            int rx = o.getRadiusX();
            int ry = o.getRadiusY();
            this.fillOval(cx - rx, cy - ry, 2 * rx, 2 * ry);
        } else if (shape instanceof IShapeFiller) {
            ((IShapeFiller)((Object)shape)).fillShape(this, this.getIGCDirect(), this.getBrush(), shape);
        } else {
            this.Unsupported("fillShape() for shape=" + shape);
        }
    }

    public void drawPath(IPath path) {
        if (path instanceof IPolygon) {
            this.drawPoly((IPolygon)((Object)path));
        } else {
            this.pen_.drawPath(this, this.gd_, path);
        }
    }

    protected void Unsupported(String what) {
        System.err.println("SVGGC: Unsupported method: " + what);
    }

    protected void svgWrite(String string) {
        try {
            this.os_.write(string.getBytes("UTF-8"));
            this.os_.write(10);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {}
    }

    protected void svgColor(int rgba, StringBuffer b) {
        int rgb = rgba >> 8;
        String hex = Long.toString((long)rgb & 0xFFFFFFL, 16);
        int miss = 6 - hex.length();
        b.append('#');
        int i = 0;
        while (i < miss) {
            b.append('0');
            ++i;
        }
        b.append(hex);
    }

    protected void svgFill(StringBuffer b) {
        b.append("stroke:none;");
        if (this.brush_ instanceof GradientBrush) {
            b.append("fill:url(#Gradient_");
            b.append(this.gradient_number_);
            b.append(')');
        } else if (this.brush_ instanceof FullGradientBrush) {
            b.append("fill:url(#Gradient_");
            b.append(this.gradient_number_);
            b.append(')');
        } else if (this.brush_ instanceof SolidBrush) {
            b.append("fill:");
            this.svgColor(this.fill_, b);
        } else {
            b.append("fill:none");
        }
        if (!RGBA.IsOpaque(this.stroke_)) {
            b.append(";opacity:");
            b.append((double)RGBA.GetA(this.fill_) / 255.0);
        }
    }

    protected void svgStroke(StringBuffer b) {
        int stroke = this.stroke_;
        if (this.brush_ instanceof GradientBrush) {
            GradientBrush brush = (GradientBrush)this.brush_;
            stroke = brush.getRGBA1();
        }
        b.append("fill:none;stroke:");
        this.svgColor(stroke, b);
        if (!RGBA.IsOpaque(stroke)) {
            b.append(";stroke-opacity:");
            b.append((double)RGBA.GetA(stroke) / 255.0);
        }
        if (this.stroke_width_ == 0) {
            b.append(";stroke-width:1");
        } else {
            b.append(";stroke-width:");
            b.append(this.stroke_width_);
        }
        switch (this.strokedasharray_) {
            case 1: {
                b.append(";stroke-dasharray:10 10");
                break;
            }
            case 2: {
                b.append(";stroke-dasharray:2 2");
                break;
            }
        }
    }

    protected void svgFont(StringBuffer b) {
        if (this.font_ != null) {
            if (this.font_.getFontName() != null) {
                b.append(" font-family=\"");
                b.append(this.font_.getFontName());
                b.append('\"');
            }
            b.append(" font-size=\"");
            b.append(this.font_.getFontSize());
            b.append('\"');
            if ((this.font_.getFontStyle() & 1) != 0) {
                b.append(" font-weight=\"bold\"");
            }
            if ((this.font_.getFontStyle() & 2) != 0) {
                b.append(" font-style=\"italic\"");
            }
        }
    }

    protected String svgGradient(GradientBrush b, int x1, int y1, int x2, int y2) {
        ++this.gradient_number_;
        StringBuffer s = new StringBuffer(512);
        s.append("<linearGradient id=\"Gradient_");
        s.append(this.gradient_number_);
        s.append("\" ");
        s.append("gradientUnits=\"userSpaceOnUse\" ");
        this.svg2Coord(x1, y1, x2, y2, s);
        s.append('>');
        s.append("<stop offset=\"0\" style=\"stop-color:");
        this.svgColor(b.getRGBA1(), s);
        s.append("\" />");
        s.append("<stop offset=\"1\" style=\"stop-color:");
        this.svgColor(b.getRGBA2(), s);
        s.append("\" />");
        s.append("</linearGradient>");
        return s.toString();
    }

    protected String svgGradient(FullGradientBrush b, int x1, int y1, int x2, int y2) {
        ++this.gradient_number_;
        StringBuffer s = new StringBuffer(512);
        s.append("<linearGradient id=\"Gradient_");
        s.append(this.gradient_number_);
        s.append("\" ");
        s.append("gradientUnits=\"userSpaceOnUse\" ");
        this.svg2Coord(x1, y1, x2, y2, s);
        s.append('>');
        s.append("<stop offset=\"0\" style=\"stop-color:");
        this.svgColor(b.getBrushColor(x1, y1, 0), s);
        s.append("\" />");
        s.append("<stop offset=\"1\" style=\"stop-color:");
        this.svgColor(b.getBrushColor(x2, y2, 0), s);
        s.append("\" />");
        s.append("</linearGradient>");
        return s.toString();
    }

    protected void svgCoord(int x, int y, StringBuffer b) {
        b.append("x=\"");
        b.append(x);
        b.append("\" y=\"");
        b.append(y);
        b.append('\"');
    }

    protected void svg2Coord(int x1, int y1, int x2, int y2, StringBuffer b) {
        b.append("x1=\"");
        b.append(x1);
        b.append("\" y1=\"");
        b.append(y1);
        b.append("\" x2=\"");
        b.append(x2);
        b.append("\" y2=\"");
        b.append(y2);
        b.append('\"');
    }

    protected void svgRect(int x, int y, int w, int h, int rx, int ry, StringBuffer b) {
        b.append("x=\"");
        b.append(x);
        b.append("\" y=\"");
        b.append(y);
        b.append("\" width=\"");
        b.append(w);
        b.append("\" height=\"");
        b.append(h);
        b.append('\"');
        if (rx > 0) {
            b.append(" rx=\"");
            b.append(rx);
            b.append('\"');
        }
        if (ry > 0) {
            b.append(" ry=\"");
            b.append(ry);
            b.append('\"');
        }
    }

    protected void svgEllipse(int cx, int cy, int rx, int ry, StringBuffer b) {
        b.append("cx=\"");
        b.append(cx);
        b.append("\" cy=\"");
        b.append(cy);
        b.append("\" rx=\"");
        b.append(rx);
        b.append("\" ry=\"");
        b.append(ry);
        b.append('\"');
    }

    protected void svgPoints(int[] x, int[] y, StringBuffer b) {
        b.append("points=\"");
        int i = 0;
        while (i < x.length && i < y.length) {
            b.append(x[i]);
            b.append(',');
            b.append(y[i]);
            b.append(' ');
            ++i;
        }
        b.append('\"');
    }

    public OutputStream getOutputStream() {
        return this.os_;
    }

    public void setOutputStream(OutputStream os_) {
        this.os_ = os_;
    }

    private class GCDirect
    implements IGCDirect {
        private GCDirect() {
        }

        public IGC getIGC() {
            return SVGGC.this;
        }

        public boolean usePixelCoordinates() {
            return true;
        }

        public int devX(int x) {
            return x;
        }

        public int devY(int y) {
            return y;
        }

        public int pixX(int x) {
            return x;
        }

        public int pixY(int y) {
            return y;
        }

        public void drawRectDirect(int x, int y, int w, int h) {
            this.getIGC().drawRect(x, y, w, h);
        }

        public void drawPointDirect(int x, int y, int _rgba) {
            this.getIGC().drawPoint(x, y);
        }

        public int getPointDirect(int x, int y) {
            return 0;
        }

        public void drawHLineDirect(int x1, int x2, int y) {
            this.getIGC().drawLine(x1, y, x2, y);
        }

        public void drawVLineDirect(int x, int y1, int y2) {
            this.getIGC().drawLine(x, y1, x, y2);
        }

        public void fillRectDirect(int x, int y, int w, int h) {
            this.getIGC().fillRect(x, y, w, h);
        }

        public void drawLineDirect(int x1, int y1, int x2, int y2) {
            this.getIGC().drawLine(x1, y1, x2, y2);
        }
    }
}

