/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.swt.internal;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Size;

public class ImageDataUtil {
    public ImageData getTextImage(Device device, GC font_gc, String text, ISize size) {
        Image img = new Image(device, size.getW(), size.getH());
        GC gc = new GC((Drawable)img);
        try {
            gc.setForeground(device.getSystemColor(2));
            gc.setBackground(device.getSystemColor(1));
            gc.setFont(font_gc.getFont());
            gc.drawText(text, 0, 0, false);
            ImageData imageData = img.getImageData();
            return imageData;
        }
        finally {
            gc.dispose();
            img.dispose();
        }
    }

    protected static int rotateX(double cos, double sin, int x, int y) {
        return (int)Math.round(cos * (double)x - sin * (double)y);
    }

    protected static int rotateY(double cos, double sin, int x, int y) {
        return (int)Math.round(sin * (double)x + cos * (double)y);
    }

    protected ISize rotateImageSize(int width, int height, double angle) {
        int angle_degree = Radian.iR2D(angle);
        switch (angle_degree % 360) {
            case 0: 
            case 180: {
                return new Size(width, height);
            }
            case 90: 
            case 270: {
                return new Size(height, width);
            }
        }
        double crot = Math.cos(angle);
        double srot = Math.sin(angle);
        int X = width - 1;
        int Y = height - 1;
        int rx0 = ImageDataUtil.rotateX(crot, srot, 0, 0);
        int ry0 = ImageDataUtil.rotateY(crot, srot, 0, 0);
        int rx1 = ImageDataUtil.rotateX(crot, srot, X, 0);
        int ry1 = ImageDataUtil.rotateY(crot, srot, X, 0);
        int rx2 = ImageDataUtil.rotateX(crot, srot, X, Y);
        int ry2 = ImageDataUtil.rotateY(crot, srot, X, Y);
        int rx3 = ImageDataUtil.rotateX(crot, srot, 0, Y);
        int ry3 = ImageDataUtil.rotateY(crot, srot, 0, Y);
        int rxmin = Math.min(rx0, Math.min(rx1, Math.min(rx2, rx3)));
        int rxmax = Math.max(rx0, Math.max(rx1, Math.max(rx2, rx3)));
        int rymin = Math.min(ry0, Math.min(ry1, Math.min(ry2, ry3)));
        int rymax = Math.max(ry0, Math.max(ry1, Math.max(ry2, ry3)));
        return new Size(rxmax - rxmin + 1, rymax - rymin + 1);
    }

    protected ImageData rotateImageData(ImageData s, int angle, boolean antialiased) {
        switch (angle % 360) {
            case 0: {
                return s;
            }
            case 90: {
                ImageData r = new ImageData(s.height, s.width, s.depth, s.palette);
                int dx = s.height - 1;
                int sy = 0;
                while (sy < s.height) {
                    int dy = 0;
                    int sx = 0;
                    while (sx < s.width) {
                        int pixel = s.getPixel(sx, sy);
                        r.setPixel(dx, dy, pixel);
                        ++sx;
                        ++dy;
                    }
                    ++sy;
                    --dx;
                }
                return r;
            }
            case 270: {
                ImageData r = new ImageData(s.height, s.width, s.depth, s.palette);
                int dx = 0;
                int sy = 0;
                while (sy < s.height) {
                    int dy = s.width - 1;
                    int sx = 0;
                    while (sx < s.width) {
                        int pixel = s.getPixel(sx, sy);
                        r.setPixel(dx, dy, pixel);
                        ++sx;
                        --dy;
                    }
                    ++sy;
                    ++dx;
                }
                return r;
            }
            case 180: {
                ImageData r = new ImageData(s.width, s.height, s.depth, s.palette);
                int dy = s.height - 1;
                int sy = 0;
                while (sy < s.height) {
                    int dx = s.width - 1;
                    int sx = 0;
                    while (sx < s.width) {
                        int pixel = s.getPixel(sx, sy);
                        r.setPixel(dx, dy, pixel);
                        ++sx;
                        --dx;
                    }
                    ++sy;
                    --dy;
                }
                return r;
            }
        }
        return this.rotateImageDataAny(s, angle, s.palette.getPixel(new RGB(255, 255, 255)), antialiased);
    }

    protected static void antialiased(double _rx, double _ry, ImageData src_, RGB rgb) {
        int sx = (int)_rx;
        int sy = (int)_ry;
        double dx = _rx - (double)sx;
        double dy = _ry - (double)sy;
        double a1 = (1.0 - dx) * (1.0 - dy);
        double a2 = (1.0 - dx) * dy;
        double a3 = dx * dy;
        double a4 = dx * (1.0 - dy);
        PaletteData spal_ = src_.palette;
        RGB c1 = spal_.getRGB(src_.getPixel(sx, sy));
        int r2 = 0;
        int g2 = 0;
        int b2 = 0;
        int r3 = 0;
        int g3 = 0;
        int b3 = 0;
        boolean incomplete = false;
        if (sy + 1 < src_.height) {
            RGB c = spal_.getRGB(src_.getPixel(sx, sy + 1));
            r2 = c.red;
            g2 = c.green;
            b2 = c.blue;
            if (sx + 1 < src_.width) {
                c = spal_.getRGB(src_.getPixel(sx + 1, sy + 1));
                r3 = c.red;
                g3 = c.green;
                b3 = c.blue;
            } else {
                incomplete = true;
                a3 = 0.0;
            }
        } else {
            incomplete = true;
            a3 = 0.0;
            a2 = 0.0;
        }
        int r4 = 0;
        int g4 = 0;
        int b4 = 0;
        if (sx + 1 < src_.width) {
            RGB c = spal_.getRGB(src_.getPixel(sx + 1, sy));
            r4 = c.red;
            g4 = c.green;
            b4 = c.blue;
        } else {
            incomplete = true;
            a4 = 0.0;
        }
        if (incomplete) {
            double sum = a1 + a2 + a3 + a4;
            double factor = 1.0 / sum;
            a1 *= factor;
            a2 *= factor;
            a3 *= factor;
            a4 *= factor;
        }
        int R = (int)Math.round(a1 * (double)c1.red + a2 * (double)r2 + a3 * (double)r3 + a4 * (double)r4);
        int G = (int)Math.round(a1 * (double)c1.green + a2 * (double)g2 + a3 * (double)g3 + a4 * (double)g4);
        int B = (int)Math.round(a1 * (double)c1.blue + a2 * (double)b2 + a3 * (double)b3 + a4 * (double)b4);
        if (R < 0 || R > 255 || G < 0 || G > 255 || B < 0 || B > 255) {
            System.out.println("BAD COLOR RGB=" + R + "," + G + "," + B);
            System.out.println(" a1=" + a1 + " a2=" + a2 + " a3=" + a3 + " a4=" + a4 + " sum=" + (a1 + a2 + a3 + a4));
            System.out.println(" dx=" + dx + " dy=" + dy);
            System.out.println(" rx=" + _rx + " sx=" + sx);
            System.out.println(" ry=" + _ry + " sy=" + sy);
        }
        rgb.red = R;
        rgb.green = G;
        rgb.blue = B;
    }

    protected ImageData rotateImageDataAny(ImageData source, int angle, int new_pixel, boolean antialiased) {
        double a = Radian.D2R(angle);
        double c = Math.cos(a);
        double s = Math.sin(a);
        int X = source.width - 1;
        int Y = source.height - 1;
        int rx0 = ImageDataUtil.rotateX(c, s, 0, 0);
        int ry0 = ImageDataUtil.rotateY(c, s, 0, 0);
        int rx1 = ImageDataUtil.rotateX(c, s, X, 0);
        int ry1 = ImageDataUtil.rotateY(c, s, X, 0);
        int rx2 = ImageDataUtil.rotateX(c, s, X, Y);
        int ry2 = ImageDataUtil.rotateY(c, s, X, Y);
        int rx3 = ImageDataUtil.rotateX(c, s, 0, Y);
        int ry3 = ImageDataUtil.rotateY(c, s, 0, Y);
        int rxmin = Math.min(rx0, Math.min(rx1, Math.min(rx2, rx3)));
        int rxmax = Math.max(rx0, Math.max(rx1, Math.max(rx2, rx3)));
        int rymin = Math.min(ry0, Math.min(ry1, Math.min(ry2, ry3)));
        int rymax = Math.max(ry0, Math.max(ry1, Math.max(ry2, ry3)));
        int destX = rxmax - rxmin;
        int destY = rymax - rymin;
        PaletteData pal = source.palette;
        ImageData dest = new ImageData(destX + 1, destY + 1, source.depth, pal);
        int dx = 0;
        int dy = 0;
        int ix = 0;
        int iy = 0;
        try {
            RGB rgb = new RGB(0, 0, 0);
            int y = 0 + rymin;
            double sy = s * (double)y;
            double cy = c * (double)y;
            dy = 0;
            while (dy <= destY) {
                int x = 0 + rxmin;
                double cx = c * (double)x;
                double sx = s * (double)x;
                dx = 0;
                while (dx <= destX) {
                    double fix = cx + sy;
                    ix = (int)Math.round(fix);
                    if (ix >= 0 && ix <= X) {
                        double fiy = -sx + cy;
                        iy = (int)Math.round(fiy);
                        if (iy >= 0 && iy <= Y) {
                            if (antialiased) {
                                ImageDataUtil.antialiased(fix, fiy, source, rgb);
                                dest.setPixel(dx, dy, dest.palette.getPixel(rgb));
                            } else {
                                dest.setPixel(dx, dy, source.getPixel(ix, iy));
                            }
                        } else {
                            dest.setPixel(dx, dy, new_pixel);
                        }
                    } else {
                        dest.setPixel(dx, dy, new_pixel);
                    }
                    ++dx;
                    ++x;
                    cx += c;
                    sx += s;
                }
                ++dy;
                ++y;
                sy += s;
                cy += c;
            }
        }
        catch (IllegalArgumentException exx) {
            System.err.println("rotateImageDataAny/ ix=" + ix + " iy=" + iy + " dx=" + dx + " dy=" + dy + " np_index=" + new_pixel + " image=" + dest.width + "x" + dest.height);
            throw exx;
        }
        return dest;
    }
}

