/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.swt.internal;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.util.internal.ImageProxy;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBAImage;

public class SWTImage
implements IImage {
    protected Image image_;
    protected ImageData data_;
    protected ImageProxy proxy_;

    public SWTImage(Image _image) {
        this.image_ = _image;
        this.data_ = this.image_.getImageData();
    }

    public SWTImage(Image _image, ImageProxy proxy) {
        this.image_ = _image;
        this.proxy_ = proxy;
        this.data_ = this.image_.getImageData();
    }

    public Image getImage() {
        return this.image_;
    }

    public ImageProxy getProxy() {
        return this.proxy_;
    }

    public void disposeImage() {
        if (this.image_ != null) {
            this.image_.dispose();
        }
        this.image_ = null;
    }

    public int getWidth() {
        return this.data_.width;
    }

    public int getHeight() {
        return this.data_.height;
    }

    public int getPixel(int x, int y) {
        int pixel = this.data_.getPixel(x, y);
        RGB rgb = this.data_.palette.getRGB(pixel);
        return RGBA.Get(rgb.red, rgb.green, rgb.blue);
    }

    public static ImageData ToImageData(RGBAImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        PaletteData pal = new PaletteData(0xFF0000, 65280, 255);
        ImageData data = new ImageData(width, height, 24, pal);
        RGB rgb = new RGB(0, 0, 0);
        int[] buf_ = image.getImage();
        int rgba = buf_[0];
        rgb.red = RGBA.GetR(rgba);
        rgb.green = RGBA.GetG(rgba);
        rgb.blue = RGBA.GetB(rgba);
        pal.getPixel(rgb);
        byte[] bytes = data.data;
        int iw = 0;
        int ir = 0;
        int pad = width % data.scanlinePad;
        int cfr_ignored_0 = buf_.length;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                rgba = buf_[ir++];
                bytes[iw++] = (byte)(rgba >> 24);
                bytes[iw++] = (byte)(rgba >> 16 & 0xFF);
                bytes[iw++] = (byte)(rgba >> 8 & 0xFF);
                ++x;
            }
            iw += pad;
            ++y;
        }
        return data;
    }

    public static RGBAImage ToRGBAImage(ImageData data) {
        RGBAImage dst = new RGBAImage(data.width, data.height);
        int[] rgba = dst.getImage();
        int iw = 0;
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                RGB rgb = data.palette.getRGB(data.getPixel(x, y));
                rgba[iw] = RGBA.Get(rgb.red, rgb.green, rgb.blue);
                ++x;
                ++iw;
            }
            ++y;
        }
        return dst;
    }
}

