/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.swt.internal;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.platform.report.igc.internal.IFont;
import org.eclipse.tptp.platform.report.igc.internal.IFontMetrics;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.ogc.internal.IOGCAdapter;
import org.eclipse.tptp.platform.report.igc.swt.internal.SWTImage;
import org.eclipse.tptp.platform.report.igc.swt.internal.SWTSystemColor;
import org.eclipse.tptp.platform.report.igc.util.internal.Font;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBAImage;
import org.eclipse.tptp.platform.report.igc.util.internal.Size;

public class SWTOGCAdapter
implements IOGCAdapter {
    protected Device device_;
    protected float KdpiX_;
    protected float KdpiY_;
    private GC font_gc_;
    private org.eclipse.swt.graphics.Font swtfont_;
    private int ifont_style_;

    public SWTOGCAdapter(Device _device) {
        this.device_ = _device;
        this.fixDPI();
        this.ifont_style_ = 0;
    }

    private void fixDPI() {
        if (this.device_ instanceof Display) {
            this.KdpiY_ = 1.0f;
            this.KdpiX_ = 1.0f;
        } else {
            Point dev_dpi = this.device_.getDPI();
            Point dsp_dpi = Display.getDefault().getDPI();
            this.KdpiX_ = (float)dev_dpi.x / (float)dsp_dpi.x;
            this.KdpiY_ = (float)dev_dpi.y / (float)dsp_dpi.y;
        }
    }

    public float getKdpiX() {
        return this.KdpiX_;
    }

    public float getKdpiY() {
        return this.KdpiY_;
    }

    public void restart() {
        if (this.font_gc_ != null) {
            this.font_gc_.setFont(null);
        }
        if (this.swtfont_ != null) {
            this.swtfont_.dispose();
            this.swtfont_ = null;
        }
    }

    public void dispose() {
        if (this.font_gc_ != null) {
            this.font_gc_.dispose();
            this.font_gc_ = null;
        }
        if (this.swtfont_ != null) {
            this.swtfont_.dispose();
            this.swtfont_ = null;
        }
    }

    public Size textExtent(String text) {
        Point te = this.getFontGC().textExtent(text);
        return new Size(te.x, te.y);
    }

    public int getSystemColor(int id) {
        return SWTSystemColor.GetSystemColor(this.device_, id);
    }

    public RGBAImage getTextImage(String text, ISize size) {
        Image img = new Image(this.device_, size.getW() + 1, size.getH() + 1);
        GC gc = new GC((Drawable)img);
        try {
            gc.setForeground(this.device_.getSystemColor(2));
            gc.setBackground(this.device_.getSystemColor(1));
            gc.setFont(this.getFontGC().getFont());
            gc.drawText(text, 0, 0, false);
            SWTOGCAdapter.DrawFontLineStyle(gc, 0, 0, size.getW(), this.ifont_style_, this.devX(5));
            RGBAImage rGBAImage = SWTImage.ToRGBAImage(img.getImageData());
            return rGBAImage;
        }
        finally {
            gc.dispose();
            img.dispose();
        }
    }

    private GC getFontGC() {
        if (this.font_gc_ == null) {
            this.font_gc_ = new GC((Drawable)this.device_);
            if (this.swtfont_ != null) {
                this.font_gc_.setFont(this.swtfont_);
            }
        }
        return this.font_gc_;
    }

    public IFont getFont() {
        org.eclipse.swt.graphics.Font sf = this.getFontGC().getFont();
        if (sf == null) {
            return null;
        }
        FontData fd = sf.getFontData()[0];
        if (fd == null) {
            return null;
        }
        int swtsty = fd.getStyle();
        int sty = 0;
        if ((swtsty & 1) != 0) {
            sty |= 1;
        }
        if ((swtsty & 2) != 0) {
            sty |= 2;
        }
        return new Font(fd.getLocale(), fd.getName(), fd.getHeight(), sty);
    }

    public IFontMetrics getFontMetrics() {
        final FontMetrics fm = this.getFontGC().getFontMetrics();
        return new IFontMetrics(){

            public int getAscent() {
                return SWTOGCAdapter.this.pixY(fm.getAscent());
            }

            public int getDescent() {
                return SWTOGCAdapter.this.pixY(fm.getDescent());
            }

            public int getHeight() {
                return SWTOGCAdapter.this.pixY(fm.getHeight());
            }

            public int getLeading() {
                return SWTOGCAdapter.this.pixY(fm.getLeading());
            }
        };
    }

    public void setFont(IFont font) {
        if (this.swtfont_ != null) {
            this.swtfont_.dispose();
            this.swtfont_ = null;
        }
        if (font == null) {
            if (this.font_gc_ != null) {
                this.font_gc_.dispose();
                this.font_gc_ = null;
            }
            this.ifont_style_ = 0;
        } else {
            this.ifont_style_ = font.getFontStyle();
            int sty = font.getFontStyle();
            int swtsty = 0;
            if ((sty & 1) != 0) {
                swtsty |= 1;
            }
            if ((sty & 2) != 0) {
                swtsty |= 2;
            }
            int size = font.getFontSize();
            this.swtfont_ = new org.eclipse.swt.graphics.Font(this.device_, font.getFontName(), size, swtsty);
            if (this.font_gc_ != null) {
                this.font_gc_.setFont(this.swtfont_);
            }
        }
    }

    protected void drawImageData(int[] buf, int width, int height, int _x, int _y, ImageData data) {
        PaletteData pal = data.palette;
        int iw = data.width;
        int ih = data.height;
        if (_x + iw - 1 < 0 || _y + ih - 1 < 0) {
            return;
        }
        int X1 = Math.max(0, -_x);
        int Y1 = Math.max(0, -_y);
        int X2 = Math.min(iw, width - _x);
        int Y2 = Math.min(ih, height - _y);
        int alpha = data.alpha < 0 ? 255 : data.alpha & 0xFF;
        byte[] pixel_alpha = data.alpha < 0 ? data.alphaData : null;
        int tt = data.getTransparencyType();
        if (tt == 1 && data.alpha >= 0) {
            if (data.alpha == 0) {
                return;
            }
            if (data.alpha == 255 || data.alpha < 0 && data.alphaData == null) {
                tt = 0;
            }
        } else if (tt == 2 && data.maskData == null) {
            tt = 0;
        }
        RGB rgb = new RGB(0, 0, 0);
        int index0 = (_y + Y1) * width + _x + X1;
        switch (data.getTransparencyType()) {
            case 0: {
                int Y = Y1;
                while (Y < Y2) {
                    int index = index0;
                    int X = X1;
                    while (X < X2) {
                        int rgba;
                        rgb = pal.getRGB(data.getPixel(X, Y));
                        buf[index] = rgba = RGBA.Get(rgb.red, rgb.green, rgb.blue);
                        ++X;
                        ++index;
                    }
                    index0 += width;
                    ++Y;
                }
                break;
            }
            case 1: {
                if (pixel_alpha == null) {
                    int Y = Y1;
                    while (Y < Y2) {
                        int index = index0;
                        int X = X1;
                        while (X < X2) {
                            rgb = pal.getRGB(data.getPixel(X, Y));
                            int rgba = RGBA.Get(rgb.red, rgb.green, rgb.blue, alpha);
                            buf[index] = RGBA.Combine(rgba, buf[index]);
                            ++X;
                            ++index;
                        }
                        index0 += width;
                        ++Y;
                    }
                } else {
                    int indexA0 = Y1 * iw + X1;
                    int Y = Y1;
                    while (Y < Y2) {
                        int index = index0;
                        int indexA = indexA0;
                        int X = X1;
                        while (X < X2) {
                            alpha = pixel_alpha[indexA];
                            if (alpha != 0) {
                                rgb = pal.getRGB(data.getPixel(X, Y));
                                int rgba = RGBA.Get(rgb.red, rgb.green, rgb.blue, alpha);
                                buf[index] = RGBA.Combine(rgba, buf[index]);
                            }
                            ++X;
                            ++index;
                            ++indexA;
                        }
                        index0 += width;
                        indexA0 += iw;
                        ++Y;
                    }
                }
                break;
            }
            case 4: {
                rgb = pal.getRGB(data.transparentPixel);
                int transparent_rgba = RGBA.Get(rgb.red, rgb.green, rgb.blue);
                int Y = Y1;
                while (Y < Y2) {
                    int index = index0;
                    int X = X1;
                    while (X < X2) {
                        rgb = pal.getRGB(data.getPixel(X, Y));
                        int rgba = RGBA.Get(rgb.red, rgb.green, rgb.blue);
                        if (rgba != transparent_rgba) {
                            buf[index] = rgba;
                        }
                        ++X;
                        ++index;
                    }
                    index0 += width;
                    ++Y;
                }
                break;
            }
            case 2: {
                int byte_per_scanline = ((iw + 7) / 8 + (data.maskPad - 1)) / data.maskPad * data.maskPad;
                int bit = -128;
                if (X1 % 8 > 0) {
                    bit = (byte)(bit >> X1 % 8);
                }
                int indexM0 = Y1 * byte_per_scanline + X1 / 8;
                byte msk = data.maskData[indexM0];
                int Y = Y1;
                while (Y < Y2) {
                    int index = index0;
                    int indexM = indexM0;
                    int X = X1;
                    while (X < X2) {
                        if ((bit & msk) != 0) {
                            int rgba;
                            rgb = pal.getRGB(data.getPixel(X, Y));
                            buf[index] = rgba = RGBA.Get(rgb.red, rgb.green, rgb.blue);
                        }
                        if ((bit = (int)((byte)(bit >> 1))) == 0) {
                            msk = data.maskData[++indexM];
                            bit = -128;
                        }
                        ++X;
                        ++index;
                    }
                    index0 += width;
                    indexM0 += byte_per_scanline;
                    ++Y;
                }
                break;
            }
        }
    }

    public boolean drawImage(int[] buf, int width, int height, IImage image, int x, int y) {
        if (image instanceof SWTImage) {
            SWTImage img = (SWTImage)image;
            this.drawImageData(buf, width, height, x, y, img.getImage().getImageData());
            return true;
        }
        return false;
    }

    public boolean drawImage(int[] buf, int width, int height, IImage image, int x, int y, int w, int h) {
        if (image instanceof SWTImage) {
            ImageData data;
            SWTImage img = (SWTImage)image;
            img.getImage().getBounds();
            ImageData scaled = data = img.getImage().getImageData();
            if (w != data.width || h != data.height) {
                scaled = data.scaledTo(w, h);
            }
            this.drawImageData(buf, width, height, x, y, scaled);
            return true;
        }
        return false;
    }

    public boolean drawImage(int[] buf, int width, int height, IImage image, int srcX, int srcY, int srcW, int srcH, int dstX, int dstY, int dstW, int dstH) {
        if (!(image instanceof SWTImage)) {
            return false;
        }
        SWTImage img = (SWTImage)image;
        ImageData data = img.getImage().getImageData();
        PaletteData pal = data.palette;
        ImageData reduced = data;
        if (srcX != 0 || srcY != 0 || srcW != data.width || srcH != data.height) {
            reduced = new ImageData(srcW, srcH, data.depth, pal);
            int Y = srcY + srcH;
            int X = srcX + srcW;
            int ry = 0;
            int sy = srcY;
            while (sy < Y) {
                int rx = 0;
                int sx = srcX;
                while (sx < X) {
                    reduced.setPixel(rx, ry, data.getPixel(sx, sy));
                    ++sx;
                    ++rx;
                }
                ++sy;
                ++ry;
            }
        }
        ImageData scaled = reduced;
        int x = this.devX(dstX);
        int y = this.devY(dstY);
        int dw = this.devX(dstW);
        int dh = this.devX(dstH);
        if (dw != srcW || srcH != dh) {
            scaled = data.scaledTo(dw, dh);
        }
        this.drawImageData(buf, width, height, x, y, scaled);
        return true;
    }

    public int devX(int x) {
        return (int)(this.KdpiX_ * (float)x);
    }

    public int devY(int y) {
        return (int)(this.KdpiY_ * (float)y);
    }

    public int pixX(int x) {
        return (int)((float)x / this.KdpiX_);
    }

    public int pixY(int y) {
        return (int)((float)y / this.KdpiY_);
    }

    public static void DrawFontLineStyle(GC _gc, int dtx, int dty, int dtw, int ifont_style, int dev_dash_size) {
        if (ifont_style == 0) {
            return;
        }
        if ((ifont_style & 0xF0) == 0) {
            return;
        }
        FontMetrics fm = _gc.getFontMetrics();
        int descent = fm.getDescent();
        int psize = fm.getHeight();
        int linesize = psize / 10;
        if (linesize == 0) {
            linesize = 1;
        }
        int linesize2 = linesize / 2;
        if ((ifont_style & 1) != 0 && (linesize += linesize2) == 1) {
            linesize = 2;
            linesize2 = 1;
        }
        int space = linesize2 + 2;
        int save_lw = _gc.getLineWidth();
        int save_ls = _gc.getLineStyle();
        _gc.setLineWidth(linesize);
        _gc.setLineStyle(1);
        int _txth = fm.getHeight();
        int ly = dty + _txth - descent + space;
        if (Font.HaveStyle(ifont_style, 16)) {
            _gc.drawLine(dtx, ly, dtx + dtw, ly);
        } else if (Font.HaveStyle(ifont_style, 64)) {
            int size = dev_dash_size;
            int size2 = 2 * size;
            int xx = size * ((dtx + dtw) / size);
            int x = size * (int)Math.ceil(dtx / size);
            if (x < dtx) {
                x += size2;
            }
            while (x < xx) {
                _gc.drawLine(x, ly, x + size, ly);
                x += size2;
            }
        }
        if (Font.HaveStyle(ifont_style, 32)) {
            ly = dty + linesize / 2;
            _gc.drawLine(dtx, ly, dtx + dtw, ly);
        }
        if (Font.HaveStyle(ifont_style, 128)) {
            ly = dty + fm.getLeading() + fm.getAscent() / 2 + linesize2;
            _gc.drawLine(dtx, ly, dtx + dtw, ly);
        }
        _gc.setLineWidth(save_lw);
        _gc.setLineStyle(save_ls);
    }
}

