/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.IAlg;
import org.eclipse.tptp.platform.report.igc.alg.internal.LineAlg;
import org.eclipse.tptp.platform.report.igc.alg.internal.Spline3Alg;
import org.eclipse.tptp.platform.report.igc.alg.internal.Spline4Alg;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IVector;

public class ComplexPath
implements IPath,
IPathElement {
    public static final int MOVE_TO = 0;
    public static final int LINE_TO = 1;
    public static final int CONIC_TO = 2;
    public static final int CUBIC_TO = 3;
    protected int[] points_;
    protected int len_;
    protected boolean hull_path_;
    protected boolean give_path_element_;
    protected int curr_;
    protected IAlg alg_;
    protected IGCDirect gd_;

    public ComplexPath() {
    }

    public ComplexPath(ComplexPath p) {
        if (p.points_ != null) {
            this.points_ = new int[p.points_.length];
            System.arraycopy(p.points_, 0, this.points_, 0, p.points_.length);
            this.len_ = this.points_.length;
        }
    }

    public boolean isHullPath() {
        return this.hull_path_;
    }

    public void setHullPath(boolean b) {
        this.hull_path_ = b;
    }

    public void reset() {
        this.len_ = 0;
    }

    public void moveTo(int x, int y) {
        this.checkSize(this.len_ + 3);
        this.points_[this.len_++] = 0;
        this.points_[this.len_++] = x;
        this.points_[this.len_++] = y;
    }

    public void lineTo(int x, int y) {
        if (this.len_ == 0) {
            throw new IllegalStateException("ComplexPath must be started by moveTo()");
        }
        this.checkSize(this.len_ + 3);
        this.points_[this.len_++] = 1;
        this.points_[this.len_++] = x;
        this.points_[this.len_++] = y;
    }

    public void conicTo(int x1, int y1, int x2, int y2) {
        if (this.len_ == 0) {
            throw new IllegalStateException("ComplexPath must be started by moveTo()");
        }
        this.checkSize(this.len_ + 6);
        this.points_[this.len_++] = 2;
        this.points_[this.len_++] = x1;
        this.points_[this.len_++] = y1;
        this.points_[this.len_++] = -1;
        this.points_[this.len_++] = x2;
        this.points_[this.len_++] = y2;
    }

    public void cubicTo(int x1, int y1, int x2, int y2, int x3, int y3) {
        if (this.len_ == 0) {
            throw new IllegalStateException("ComplexPath must be started by moveTo()");
        }
        this.checkSize(this.len_ + 9);
        this.points_[this.len_++] = 3;
        this.points_[this.len_++] = x1;
        this.points_[this.len_++] = y1;
        this.points_[this.len_++] = -1;
        this.points_[this.len_++] = x2;
        this.points_[this.len_++] = y2;
        this.points_[this.len_++] = -1;
        this.points_[this.len_++] = x3;
        this.points_[this.len_++] = y3;
    }

    protected void checkSize(int nsize) {
        if (this.points_ == null) {
            this.points_ = new int[Math.max(21, nsize)];
            this.len_ = 0;
        } else if (nsize >= this.points_.length) {
            int[] np = new int[nsize + 21];
            System.arraycopy(this.points_, 0, np, 0, this.points_.length);
            this.points_ = np;
        }
    }

    public boolean pathBegin(IGC gc, IGCDirect gd) {
        this.give_path_element_ = true;
        return true;
    }

    public void pathEnd() {
    }

    public IPathElement nextPathElement() {
        if (this.give_path_element_) {
            this.give_path_element_ = false;
            return this;
        }
        return null;
    }

    public IPathElement copyPathElement() {
        return new ComplexPath(this);
    }

    public boolean pathElementBegin(IGC gc, IGCDirect gd) {
        block13: {
            block12: {
                if (this.points_ == null || this.len_ < 6) {
                    return false;
                }
                this.curr_ = 3;
                while (this.curr_ < this.len_ && this.points_[this.curr_] == 0) {
                    this.curr_ += 3;
                }
                if (!gd.usePixelCoordinates()) break block12;
                this.gd_ = null;
                switch (this.hull_path_ ? 1 : this.points_[this.curr_]) {
                    case 1: {
                        this.alg_ = new LineAlg(this.points_[this.curr_ - 2], this.points_[this.curr_ - 1], this.points_[this.curr_ + 1], this.points_[this.curr_ + 2]);
                        break block13;
                    }
                    case 2: {
                        this.alg_ = new Spline3Alg(this.points_[this.curr_ - 2], this.points_[this.curr_ - 1], this.points_[this.curr_ + 1], this.points_[this.curr_ + 2], this.points_[this.curr_ + 4], this.points_[this.curr_ + 5]);
                        break block13;
                    }
                    case 3: {
                        this.alg_ = new Spline4Alg(this.points_[this.curr_ - 2], this.points_[this.curr_ - 1], this.points_[this.curr_ + 1], this.points_[this.curr_ + 2], this.points_[this.curr_ + 4], this.points_[this.curr_ + 5], this.points_[this.curr_ + 7], this.points_[this.curr_ + 8]);
                        break block13;
                    }
                    default: {
                        return false;
                    }
                }
            }
            this.gd_ = gd;
            switch (this.hull_path_ ? 1 : this.points_[this.curr_]) {
                case 1: {
                    this.alg_ = new LineAlg(gd.devX(this.points_[this.curr_ - 2]), gd.devY(this.points_[this.curr_ - 1]), gd.devX(this.points_[this.curr_ + 1]), gd.devY(this.points_[this.curr_ + 2]));
                    break;
                }
                case 2: {
                    this.alg_ = new Spline3Alg(gd.devX(this.points_[this.curr_ - 2]), gd.devY(this.points_[this.curr_ - 1]), gd.devX(this.points_[this.curr_ + 1]), gd.devY(this.points_[this.curr_ + 2]), gd.devX(this.points_[this.curr_ + 4]), gd.devY(this.points_[this.curr_ + 5]));
                    break;
                }
                case 3: {
                    this.alg_ = new Spline4Alg(gd.devX(this.points_[this.curr_ - 2]), gd.devY(this.points_[this.curr_ - 1]), gd.devX(this.points_[this.curr_ + 1]), gd.devY(this.points_[this.curr_ + 2]), gd.devX(this.points_[this.curr_ + 4]), gd.devY(this.points_[this.curr_ + 5]), gd.devX(this.points_[this.curr_ + 7]), gd.devY(this.points_[this.curr_ + 8]));
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public void pathElementEnd() {
        this.gd_ = null;
    }

    public boolean nextPoint(IPoint point) {
        boolean was_moveto;
        if (this.alg_.nextPoint(point)) {
            return true;
        }
        do {
            switch (this.hull_path_ ? 1 : this.points_[this.curr_]) {
                case 1: {
                    this.curr_ += 3;
                    break;
                }
                case 2: {
                    this.curr_ += 6;
                    break;
                }
                case 3: {
                    this.curr_ += 9;
                }
            }
            was_moveto = this.curr_ >= this.len_ ? false : this.points_[this.curr_] == 0;
            while (this.curr_ < this.len_ && this.points_[this.curr_] == 0) {
                this.curr_ += 3;
            }
            if (this.curr_ >= this.len_) {
                return false;
            }
            switch (this.hull_path_ ? 1 : this.points_[this.curr_]) {
                case 1: {
                    if (this.curr_ + 2 >= this.len_) {
                        return false;
                    }
                    if (this.gd_ == null) {
                        this.alg_ = new LineAlg(this.points_[this.curr_ - 2], this.points_[this.curr_ - 1], this.points_[this.curr_ + 1], this.points_[this.curr_ + 2]);
                        break;
                    }
                    this.alg_ = new LineAlg(this.gd_.devX(this.points_[this.curr_ - 2]), this.gd_.devY(this.points_[this.curr_ - 1]), this.gd_.devX(this.points_[this.curr_ + 1]), this.gd_.devY(this.points_[this.curr_ + 2]));
                    break;
                }
                case 2: {
                    if (this.curr_ + 5 >= this.len_) {
                        return false;
                    }
                    if (this.gd_ == null) {
                        this.alg_ = new Spline3Alg(this.points_[this.curr_ - 2], this.points_[this.curr_ - 1], this.points_[this.curr_ + 1], this.points_[this.curr_ + 2], this.points_[this.curr_ + 4], this.points_[this.curr_ + 5]);
                        break;
                    }
                    this.alg_ = new Spline3Alg(this.gd_.devX(this.points_[this.curr_ - 2]), this.gd_.devY(this.points_[this.curr_ - 1]), this.gd_.devX(this.points_[this.curr_ + 1]), this.gd_.devY(this.points_[this.curr_ + 2]), this.gd_.devX(this.points_[this.curr_ + 4]), this.gd_.devY(this.points_[this.curr_ + 5]));
                    break;
                }
                case 3: {
                    if (this.curr_ + 8 >= this.len_) {
                        return false;
                    }
                    if (this.gd_ == null) {
                        this.alg_ = new Spline4Alg(this.points_[this.curr_ - 2], this.points_[this.curr_ - 1], this.points_[this.curr_ + 1], this.points_[this.curr_ + 2], this.points_[this.curr_ + 4], this.points_[this.curr_ + 5], this.points_[this.curr_ + 7], this.points_[this.curr_ + 8]);
                        break;
                    }
                    this.alg_ = new Spline4Alg(this.gd_.devX(this.points_[this.curr_ - 2]), this.gd_.devY(this.points_[this.curr_ - 1]), this.gd_.devX(this.points_[this.curr_ + 1]), this.gd_.devY(this.points_[this.curr_ + 2]), this.gd_.devX(this.points_[this.curr_ + 4]), this.gd_.devY(this.points_[this.curr_ + 5]), this.gd_.devX(this.points_[this.curr_ + 7]), this.gd_.devY(this.points_[this.curr_ + 8]));
                    break;
                }
                default: {
                    return false;
                }
            }
        } while (!was_moveto && !this.alg_.nextPoint(point) || !this.alg_.nextPoint(point));
        return true;
    }

    public void backTangent(IVector vector) {
        this.alg_.backTangent(vector);
    }

    public void frontTangent(IVector vector) {
        this.alg_.frontTangent(vector);
    }
}

