/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.util.internal;

import com.ibm.icu.util.ULocale;
import org.eclipse.tptp.platform.report.igc.internal.IFont;

public class Font
implements IFont {
    protected String script_;
    protected String name_;
    protected int size_;
    protected int style_;

    public Font(String script, String name, int height, int style) {
        this.setFont(script, name, height, style);
    }

    public Font(String name, int height, int style) {
        this.setFont(ULocale.getDefault().toString(), name, height, style);
    }

    public Font(IFont font) {
        this.script_ = font.getFontScript();
        this.name_ = font.getFontName();
        this.size_ = font.getFontSize();
        this.style_ = font.getFontStyle();
    }

    public String getFontName() {
        return this.name_;
    }

    public int getFontSize() {
        return this.size_;
    }

    public int getFontStyle() {
        return this.style_;
    }

    public String getFontScript() {
        return this.script_;
    }

    public void setFontScript(String script) {
        this.script_ = script;
    }

    public void setFontName(String name) {
        this.name_ = name;
    }

    public void setFontSize(int h) {
        this.size_ = h;
    }

    public void setFontStyle(int s) {
        this.style_ = s;
    }

    public void setFont(String script, String name, int height, int style) {
        this.script_ = script;
        this.name_ = name;
        this.size_ = height;
        this.style_ = style;
    }

    public IFont copy() {
        return new Font(this);
    }

    public String toString() {
        return String.valueOf(super.toString()) + "{name='" + this.name_ + "' script=" + this.script_ + "' size=" + this.size_ + " style=" + Font.StrStyle(this.style_) + "}";
    }

    public static String StrStyle(int style) {
        if (style == 0) {
            return "NORMAL";
        }
        StringBuffer buf = new StringBuffer();
        if ((style & 1) != 0) {
            buf.append("|BOLD");
        }
        if ((style & 2) != 0) {
            buf.append("|ITALIC");
        }
        if ((style & 0x10) != 0) {
            buf.append("|UNDERLINE");
        }
        if ((style & 0x20) != 0) {
            buf.append("|OVERLINE");
        }
        if ((style & 0x80) != 0) {
            buf.append("|STRIKE");
        }
        if ((style & 0x40) != 0) {
            buf.append("|DASHED");
        }
        if (buf.length() == 0) {
            return "NORMAL";
        }
        return buf.substring(1, buf.length());
    }

    public static boolean HaveStyle(int _style, int _mask) {
        return (_style & _mask) != 0;
    }

    public boolean haveStyle(int style_mask) {
        return (this.style_ & style_mask) != 0;
    }

    public void addStyle(int style_mask) {
        this.style_ |= style_mask;
    }

    public void removeStyle(int style_mask) {
        this.style_ &= ~style_mask;
    }
}

