/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.util.internal;

import java.util.ArrayList;
import org.eclipse.tptp.platform.report.igc.internal.IImage;

public class ImageProxy
implements IImage {
    protected static ArrayList loaders_;
    protected int width_;
    protected int height_;
    protected boolean resource_stream_;
    protected String url_;
    protected IImage loaded_;
    protected ILoader loader_;

    public ImageProxy(boolean resource_stream, String url) {
        this.height_ = -1;
        this.width_ = -1;
        this.resource_stream_ = resource_stream;
        this.url_ = url;
    }

    public ImageProxy(int w, int h, boolean resource_stream, String url) {
        this.width_ = w;
        this.height_ = h;
        this.resource_stream_ = resource_stream;
        this.url_ = url;
    }

    public boolean isResourceAsStream() {
        return this.resource_stream_;
    }

    public String getURL() {
        return this.url_;
    }

    public static void addLoader(ILoader l) {
        if (loaders_ == null) {
            loaders_ = new ArrayList();
        }
        loaders_.add(l);
    }

    public static boolean removeLoader(ILoader l) {
        if (loaders_ == null) {
            return false;
        }
        boolean res = loaders_.remove(l);
        if (loaders_.size() == 0) {
            loaders_ = null;
        }
        return res;
    }

    public IImage getLoaded() {
        return this.loaded_;
    }

    public boolean isLoaded() {
        return this.loaded_ != null;
    }

    public void setLoadedImage(IImage img, ILoader loader) {
        if (this.loader_ != null) {
            this.loader_.disposeImage(this.loaded_);
        }
        this.loaded_ = img;
        this.loader_ = loader;
    }

    public void disposeImage() {
        this.setLoadedImage(null, null);
    }

    public boolean loadImage() {
        if (loaders_ == null) {
            return false;
        }
        int i = 0;
        while (i < loaders_.size()) {
            ILoader il = (ILoader)loaders_.get(i);
            this.setLoadedImage(il.loadImage(this), il);
            if (this.loaded_ != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getWidth() {
        if (this.width_ >= 0) {
            return this.width_;
        }
        if (this.loaded_ == null && !this.loadImage()) {
            return -1;
        }
        this.width_ = this.loaded_.getWidth();
        return this.width_;
    }

    public int getHeight() {
        if (this.height_ >= 0) {
            return this.width_;
        }
        if (this.loaded_ == null && !this.loadImage()) {
            return -1;
        }
        this.height_ = this.loaded_.getHeight();
        return this.height_;
    }

    public int getPixel(int x, int y) {
        if (this.loaded_ == null && !this.loadImage()) {
            return 0;
        }
        return this.loaded_.getPixel(x, y);
    }

    public static interface ILoader {
        public IImage loadImage(ImageProxy var1);

        public void disposeImage(IImage var1);
    }
}

