/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.OvalAlg;
import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.IShapeFiller;
import org.eclipse.tptp.platform.report.igc.internal.IVector;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;

public class Oval
implements IShape,
IShapeFiller,
IPath,
IPathElement {
    protected int cx_;
    protected int cy_;
    protected int rx_;
    protected int ry_;
    protected double arc_start_;
    protected double arc_length_;
    protected boolean give_path_element_;
    protected OvalAlg alg_;

    public Oval(int cx, int cy, int rx, int ry, double arc_start, double arc_length) {
        this.setArc(cx, cy, rx, ry, arc_start, arc_length);
    }

    public Oval(int cx, int cy, int rx, int ry) {
        this.setOval(cx, cy, rx, ry);
    }

    public Oval(Oval o) {
        this.setOval(o);
    }

    public int getCenterX() {
        return this.cx_;
    }

    public int getCenterY() {
        return this.cy_;
    }

    public int getRadiusX() {
        return this.rx_;
    }

    public int getRadiusY() {
        return this.ry_;
    }

    public boolean isCircle() {
        return this.rx_ == this.ry_;
    }

    public void setArc(int cx, int cy, int rx, int ry, double arc_start, double arc_length) {
        this.cx_ = cx;
        this.cy_ = cy;
        this.rx_ = rx;
        this.ry_ = ry;
        this.arc_start_ = arc_start;
        this.arc_length_ = arc_length;
    }

    public void setOval(int cx, int cy, int rx, int ry) {
        this.cx_ = cx;
        this.cy_ = cy;
        this.rx_ = rx;
        this.ry_ = ry;
        this.arc_start_ = 0.0;
        this.arc_length_ = Math.PI * 2;
    }

    public void setOval(Oval o) {
        this.cx_ = o.cx_;
        this.cy_ = o.cy_;
        this.rx_ = o.rx_;
        this.ry_ = o.ry_;
        this.arc_start_ = o.arc_start_;
        this.arc_length_ = o.arc_length_;
    }

    public IShape copyShape() {
        return new Oval(this);
    }

    public IPathElement copyPathElement() {
        return new Oval(this);
    }

    public boolean contains(int px, int py) {
        return OvalAlg.Contains(px, py, this.cx_, this.cy_, this.rx_, this.ry_, this.arc_start_, this.arc_length_);
    }

    public boolean contains(IPoint p) {
        return p != null && this.contains(p.getX(), p.getY());
    }

    public IRect getBounds() {
        int rx = Math.abs(this.rx_);
        int ry = Math.abs(this.ry_);
        return new Rect(this.cx_ - rx, this.cy_ - ry, 2 * rx, 2 * ry);
    }

    public boolean fillShape(IGC gc, IGCDirect gd, IBrush brush, IShape shape) {
        if (!(shape instanceof Oval)) {
            return false;
        }
        brush.brushBegin(gc, gd);
        if (gd.usePixelCoordinates()) {
            OvalAlg.FillArc(gd, this.cx_, this.cy_, this.rx_, this.ry_, this.arc_start_, this.arc_length_);
        } else {
            OvalAlg.FillArc(gd, gd.devX(this.cx_), gd.devY(this.cy_), gd.devX(this.rx_), gd.devY(this.ry_), this.arc_start_, this.arc_length_);
        }
        brush.brushEnd();
        return true;
    }

    public boolean pathBegin(IGC gc, IGCDirect gd) {
        this.give_path_element_ = true;
        return true;
    }

    public void pathEnd() {
        this.give_path_element_ = false;
    }

    public IPathElement nextPathElement() {
        if (this.give_path_element_) {
            this.give_path_element_ = false;
            return this;
        }
        return null;
    }

    public boolean pathElementBegin(IGC gc, IGCDirect gd) {
        this.alg_ = new OvalAlg(gd.devX(this.cx_), gd.devY(this.cy_), gd.devX(this.rx_), gd.devY(this.ry_), this.arc_start_, this.arc_length_);
        return true;
    }

    public void pathElementEnd() {
        this.alg_ = null;
    }

    public boolean nextPoint(IPoint point) {
        return this.alg_.nextPoint(point);
    }

    public void backTangent(IVector vector) {
        this.alg_.getCurrentTangent(vector);
    }

    public void frontTangent(IVector vector) {
        this.alg_.getCurrentTangent(vector);
    }

    public String toString() {
        return String.valueOf(super.toString()) + "{ctr=" + this.cx_ + "," + this.cy_ + " radius=" + this.rx_ + "," + this.ry_ + " arc_start=" + this.arc_start_ + " arc_length=" + this.arc_length_ + "}";
    }
}

