/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IPolygon;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.util.internal.Point;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.Segment;

public class Polygon
implements IPolygon,
IPath {
    protected int[] points_xy_;
    protected int size_;
    protected IGCDirect gd_;
    protected Segment path_segment_;
    protected int current_index_;

    public Polygon() {
        this.size_ = 0;
    }

    public Polygon(int _alloc_size) {
        this.size_ = _alloc_size;
        this.points_xy_ = new int[2 * this.size_];
    }

    public Polygon(int[] points) {
        this.points_xy_ = points;
        this.size_ = points == null ? 0 : points.length / 2;
    }

    public Polygon(IPolygon poly) {
        int size;
        int n = size = poly == null ? 0 : poly.getPolySize();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            this.points_xy_ = new int[2];
            this.points_xy_[0] = poly.getPolyX(0);
            this.points_xy_[1] = poly.getPolyY(0);
        } else {
            boolean swt_closed;
            boolean closed = poly.isPolyClosed();
            int x0 = poly.getPolyX(0);
            int xS = poly.getPolyX(size - 1);
            int y0 = poly.getPolyY(0);
            int yS = poly.getPolyY(size - 1);
            boolean bl = swt_closed = closed && x0 == xS && y0 == yS;
            if (swt_closed) {
                this.size_ = size;
                this.points_xy_ = new int[2 * this.size_];
                this.points_xy_[0] = x0;
                this.points_xy_[1] = y0;
                int w = 2;
                int i = 1;
                while (i < size) {
                    this.points_xy_[w++] = poly.getPolyX(i);
                    this.points_xy_[w++] = poly.getPolyY(i);
                    ++i;
                }
            } else {
                this.size_ = size + (closed ? 1 : 0);
                this.points_xy_ = new int[2 * this.size_];
                this.points_xy_[0] = x0;
                this.points_xy_[1] = y0;
                int w = 2;
                int i = 1;
                while (i < size) {
                    this.points_xy_[w++] = poly.getPolyX(i);
                    this.points_xy_[w++] = poly.getPolyY(i);
                    ++i;
                }
                if (closed) {
                    this.points_xy_[w++] = x0;
                    this.points_xy_[w++] = y0;
                }
            }
        }
    }

    public IShape copyShape() {
        return new Polygon(this);
    }

    public void setPolySize(int _size) {
        if (_size < this.size_) {
            this.size_ = _size;
        } else {
            this.resize(_size);
        }
    }

    public void resize(int _num_points) {
        if (this.points_xy_.length / 2 == _num_points) {
            return;
        }
        int[] np = new int[_num_points * 2];
        int new_size = Math.min(this.size_, _num_points);
        int min = 2 * Math.min(this.size_, _num_points);
        int i = 0;
        while (i < min) {
            np[i] = this.points_xy_[i];
            ++i;
        }
        this.size_ = new_size;
        this.points_xy_ = np;
    }

    public void compact() {
        if (this.size_ == this.points_xy_.length / 2) {
            return;
        }
        int[] np = new int[2 * this.size_];
        System.arraycopy(this.points_xy_, 0, np, 0, np.length);
        this.points_xy_ = np;
    }

    public void setPoint(int index, int x, int y) {
        int idx = 2 * index;
        if (idx + 1 >= this.points_xy_.length) {
            int[] xy = new int[idx + 21];
            System.arraycopy(this.points_xy_, 0, xy, 0, this.points_xy_.length);
            this.points_xy_ = xy;
        }
        this.points_xy_[idx] = x;
        this.points_xy_[++idx] = y;
        if (index >= this.size_) {
            this.size_ = index + 1;
        }
    }

    public int getPolySize() {
        return this.size_;
    }

    public int getPolyX(int index) {
        return this.points_xy_[2 * index];
    }

    public int getPolyY(int index) {
        return this.points_xy_[2 * index + 1];
    }

    public boolean isPolyClosed() {
        return this.size_ >= 2 && this.points_xy_[0] == this.points_xy_[2 * this.size_ - 2] && this.points_xy_[1] == this.points_xy_[2 * this.size_ - 1];
    }

    public int[] getPoints() {
        return this.points_xy_;
    }

    public void translate(int _tx, int _ty) {
        int i = 0;
        while (i < this.points_xy_.length) {
            int n = i++;
            this.points_xy_[n] = this.points_xy_[n] + _tx;
            int n2 = i++;
            this.points_xy_[n2] = this.points_xy_[n2] + _ty;
        }
    }

    public String toString() {
        String s = String.valueOf(super.toString()) + "{";
        int idx = 0;
        int cnt = this.size_ < 20 ? this.size_ : 20;
        int i = 0;
        while (i < cnt) {
            s = String.valueOf(s) + Integer.toString(this.points_xy_[idx++]) + ",";
            s = String.valueOf(s) + Integer.toString(this.points_xy_[idx++]) + ", ";
            ++i;
        }
        s = this.size_ >= 20 ? String.valueOf(s) + "...}" : String.valueOf(s) + "}";
        return s;
    }

    public boolean contains(IPoint p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(int px, int py) {
        if (this.size_ < 3) {
            return false;
        }
        int length = this.points_xy_.length;
        if ((length & 1) != 0) {
            --length;
        }
        int last_ip = length - 2;
        int lx = this.points_xy_[last_ip];
        int ly = this.points_xy_[last_ip + 1];
        int segment_count = 0;
        int i = 0;
        while (i < length) {
            int yxx;
            int xx;
            int yxn;
            int xn;
            int x = this.points_xy_[i++];
            int y = this.points_xy_[i++];
            if (lx < x) {
                xn = lx;
                yxn = ly;
                xx = x;
                yxx = y;
            } else {
                xn = x;
                yxn = y;
                xx = lx;
                yxx = ly;
            }
            if (px >= xn && px <= xx && py >= (y < ly ? y : ly)) {
                if (xn == xx) {
                    return py <= (y < ly ? ly : y);
                }
                float sy = yxn + (px - xn) * (yxx - yxn) / (xx - xn);
                if (sy == (float)py) {
                    return true;
                }
                if (sy < (float)py && (sy != (float)y || px != x)) {
                    if (sy == (float)ly && px == lx) {
                        int llx = this.points_xy_[(i - 6 + length) % length];
                        if (x < px && llx > px || x > px && llx < px) {
                            ++segment_count;
                        }
                    } else {
                        ++segment_count;
                    }
                }
            }
            lx = x;
            ly = y;
        }
        return segment_count & true;
    }

    public IRect getBounds() {
        int yn;
        int xn;
        if (this.size_ == 0) {
            return new Rect();
        }
        int xx = xn = this.points_xy_[0];
        int yx = yn = this.points_xy_[1];
        int w = 2;
        int i = 1;
        while (i < this.size_) {
            int x = this.points_xy_[w++];
            int y = this.points_xy_[w++];
            if (x < xn) {
                xn = x;
            } else if (x > xx) {
                xx = x;
            }
            if (y < yn) {
                yn = y;
            } else if (y > yx) {
                yx = y;
            }
            ++i;
        }
        return new Rect(xn, yn, xx - xn, yx - yn);
    }

    public boolean pathBegin(IGC gc, IGCDirect gd) {
        if (this.size_ == 0) {
            return false;
        }
        this.gd_ = gd;
        this.current_index_ = -1;
        this.path_segment_ = new Segment();
        return true;
    }

    public void pathEnd() {
        this.gd_ = null;
        this.path_segment_ = null;
    }

    public IPathElement nextPathElement() {
        if (this.current_index_ >= this.size_) {
            return null;
        }
        ++this.current_index_;
        if (this.current_index_ + 1 >= this.size_) {
            return null;
        }
        int ci = this.current_index_;
        this.path_segment_.setLine(this.gd_.devX(this.points_xy_[2 * ci]), this.gd_.devY(this.points_xy_[2 * ci + 1]), this.gd_.devX(this.points_xy_[2 * ci + 2]), this.gd_.devY(this.points_xy_[2 * ci + 3]));
        return this.path_segment_;
    }

    public void rotate(int cx, int cy, double _angle) {
        double c = Math.cos(_angle);
        double s = Math.sin(_angle);
        int i = 0;
        int j = 0;
        while (i < this.points_xy_.length) {
            int px = this.points_xy_[i++] - cx;
            int py = this.points_xy_[i++] - cy;
            int rx = (int)((double)px * c + (double)py * s);
            int ry = (int)((double)(-px) * s + (double)py * c);
            this.points_xy_[j++] = cx + rx;
            this.points_xy_[j++] = cy + ry;
        }
    }

    public void setPoints(int[] points) {
        this.points_xy_ = points;
        this.size_ = points == null ? 0 : points.length / 2;
    }

    public Point getCenter(Point ctr) {
        return Polygon.GetCenter(this, ctr);
    }

    public static Point GetCenter(IPolygon poly, Point ctr) {
        if (poly == null) {
            return null;
        }
        int size = poly.getPolySize();
        if (size == 0) {
            return ctr;
        }
        if (ctr == null) {
            ctr = new Point();
        }
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < size) {
            x += poly.getPolyX(i);
            y += poly.getPolyY(i);
            ++i;
        }
        ctr.setPoint(x /= size, y /= size);
        return ctr;
    }

    public static boolean Contains(IPolygon p, int px, int py) {
        int size = p.getPolySize();
        if (size < 3) {
            return false;
        }
        int last_ip = size - 1;
        int lx = p.getPolyX(last_ip);
        int ly = p.getPolyY(last_ip);
        int segment_count = 0;
        int i = 0;
        while (i < size) {
            int yxx;
            int xx;
            int yxn;
            int xn;
            int x = p.getPolyX(i);
            int y = p.getPolyY(i);
            if (lx < x) {
                xn = lx;
                yxn = ly;
                xx = x;
                yxx = y;
            } else {
                xn = x;
                yxn = y;
                xx = lx;
                yxx = ly;
            }
            if (px >= xn && px <= xx && py >= (y < ly ? y : ly)) {
                if (xn == xx) {
                    return py <= (y < ly ? ly : y);
                }
                float sy = yxn + (px - xn) * (yxx - yxn) / (xx - xn);
                if (sy == (float)py) {
                    return true;
                }
                if (sy < (float)py && (sy != (float)y || px != x)) {
                    if (sy == (float)ly && px == lx) {
                        int llx = p.getPolyX((i - 2 + size) % size);
                        if (x < px && llx > px || x > px && llx < px) {
                            ++segment_count;
                        }
                    } else {
                        ++segment_count;
                    }
                }
            }
            lx = x;
            ly = y;
            ++i;
        }
        return segment_count & true;
    }
}

