/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.util.internal;

public class RGBA {
    public static final int WHITE = -1;
    public static final int BLACK = 255;
    public static final int RED = -16776961;
    public static final int GREEN = 0xFF00FF;
    public static final int BLUE = 65535;
    public static final int YELLOW = -65281;
    public static final int CYAN = 0xFFFFFF;
    public static final int MAGENTA = -16711681;
    public static final int LIGHT_GRAY = -1061109505;
    public static final int DARK_GRAY = -2139062017;
    public static final int LIGHT_YELLOW = 0xFFFFC0;
    public static final int ORANGE = -6291201;
    public static final int DARK_RED = -2147483393;
    public static final int DARK_GREEN = 0x8000FF;
    public static final int DARK_BLUE = 33023;
    public static final int OPAQUE = 255;
    public static final int TRANSPARENT = 0;
    protected int r_;
    protected int g_;
    protected int b_;
    protected int a_;
    private static int smp = 0;

    public RGBA() {
        this.a_ = 255;
    }

    public RGBA(int _r, int _g, int _b) {
        this.r_ = _r;
        this.g_ = _g;
        this.b_ = _b;
        this.a_ = 255;
    }

    public RGBA(int _r, int _g, int _b, int _a) {
        this.r_ = _r;
        this.g_ = _g;
        this.b_ = _b;
        this.a_ = _a;
    }

    public RGBA(int _rgba) {
        this.set(_rgba);
    }

    public boolean isOpaque() {
        return this.a_ == 255;
    }

    public boolean isInvisible() {
        return this.a_ == 0;
    }

    public int getR() {
        return this.r_;
    }

    public int getG() {
        return this.g_;
    }

    public int getB() {
        return this.b_;
    }

    public int getA() {
        return this.a_;
    }

    public int get() {
        return this.r_ << 24 | this.g_ << 16 | this.b_ << 8 | this.a_;
    }

    public void setR(int v) {
        this.r_ = v;
    }

    public void setG(int v) {
        this.g_ = v;
    }

    public void setB(int v) {
        this.b_ = v;
    }

    public void setA(int v) {
        this.a_ = v;
    }

    public void set(int _r, int _g, int _b, int _a) {
        this.r_ = _r;
        this.g_ = _g;
        this.b_ = _b;
        this.a_ = _a;
    }

    public void set(int _rgba) {
        this.a_ = _rgba & 0xFF;
        this.b_ = (_rgba >>= 8) & 0xFF;
        this.g_ = (_rgba >>= 8) & 0xFF;
        this.r_ = (_rgba >>= 8) & 0xFF;
    }

    public static int Get(int _r, int _g, int _b) {
        return (_r & 0xFF) << 24 | (_g & 0xFF) << 16 | (_b & 0xFF) << 8 | 0xFF;
    }

    public static int Get(int _r, int _g, int _b, int _a) {
        return (_r & 0xFF) << 24 | (_g & 0xFF) << 16 | (_b & 0xFF) << 8 | _a & 0xFF;
    }

    public static boolean IsOpaque(int _rgba) {
        return (_rgba & 0xFF) == 255;
    }

    public static boolean IsInvisible(int _rgba) {
        return (_rgba & 0xFF) == 0;
    }

    public static int GetR(int _rgba) {
        return (_rgba & 0xFF000000) >> 24 & 0xFF;
    }

    public static int GetG(int _rgba) {
        return (_rgba & 0xFF0000) >> 16;
    }

    public static int GetB(int _rgba) {
        return (_rgba & 0xFF00) >> 8;
    }

    public static int GetA(int _rgba) {
        return _rgba & 0xFF;
    }

    public static int Combine(int _front, int _back) {
        int _af = _front & 0xFF;
        if (_af == 255) {
            return _front;
        }
        if (_af == 0) {
            return _back;
        }
        int _ab = _back & 0xFF;
        if (_ab == 0) {
            return _front;
        }
        double af = (double)_af / 255.0;
        double bf = (double)((_front >>= 8) & 0xFF) / 255.0;
        double gf = (double)((_front >>= 8) & 0xFF) / 255.0;
        double rf = (double)((_front >>= 8) & 0xFF) / 255.0;
        double ab = (double)_ab / 255.0;
        double bb = (double)((_back >>= 8) & 0xFF) / 255.0;
        double gb = (double)((_back >>= 8) & 0xFF) / 255.0;
        double rb = (double)((_back >>= 8) & 0xFF) / 255.0;
        double k = (1.0 - af) * ab;
        int r = (int)(255.0 * (af * rf + k * rb));
        int g = (int)(255.0 * (af * gf + k * gb));
        int b = (int)(255.0 * (af * bf + k * bb));
        int a = (int)(255.0 * (af + k));
        int rgba = r << 24 | g << 16 | b << 8 | a;
        return rgba;
    }

    public static int Gradient(int _rgba1, int _rgba2, double _k) {
        return RGBA.Gradient(_rgba1, _rgba2, _k, 0);
    }

    public static int Gradient(int _rgba1, int _rgba2, double _k, int _ncolors) {
        if (_k <= 0.0) {
            return _rgba1;
        }
        if (_k >= 1.0) {
            return _rgba2;
        }
        int a1 = _rgba1 & 0xFF;
        int b1 = (_rgba1 >>= 8) & 0xFF;
        int g1 = (_rgba1 >>= 8) & 0xFF;
        int r1 = (_rgba1 >>= 8) & 0xFF;
        int a2 = _rgba2 & 0xFF;
        int b2 = (_rgba2 >>= 8) & 0xFF;
        int g2 = (_rgba2 >>= 8) & 0xFF;
        int r2 = (_rgba2 >>= 8) & 0xFF;
        if (_ncolors > 0 && _ncolors < 256) {
            if (_ncolors == 1) {
                _k = 0.5;
            } else if (_k != 0.0 && _k != 1.0) {
                double range = 1.0 / (double)_ncolors;
                int cnt = 0;
                while (_k >= range) {
                    ++cnt;
                    _k -= range;
                }
                _k = (double)cnt * range;
                if (_k > 1.0) {
                    _k = 1.0;
                }
            }
        }
        int r = (int)((double)r1 + (double)(r2 - r1) * _k);
        int g = (int)((double)g1 + (double)(g2 - g1) * _k);
        int b = (int)((double)b1 + (double)(b2 - b1) * _k);
        int a = (int)((double)a1 + (double)(a2 - a1) * _k);
        int rgba = r << 24 | g << 16 | b << 8 | a;
        return rgba;
    }

    public static int Shadow(int _rgba, float k_shadow, float k_light, float cos_angle) {
        if (k_shadow < 0.0f) {
            k_shadow = 0.0f;
        } else if (k_shadow > 1.0f) {
            k_shadow = 1.0f;
        }
        if (cos_angle < 0.0f) {
            cos_angle = 0.0f;
        } else if (cos_angle > 1.0f) {
            cos_angle = 1.0f;
        }
        int r = RGBA.GetR(_rgba);
        int g = RGBA.GetG(_rgba);
        int b = RGBA.GetB(_rgba);
        cos_angle = Math.abs(cos_angle);
        if ((double)cos_angle < 0.5) {
            int dr = (int)(k_shadow * 0.0f + (1.0f - k_shadow) * (float)r);
            int dg = (int)(k_shadow * 0.0f + (1.0f - k_shadow) * (float)g);
            int db = (int)(k_shadow * 0.0f + (1.0f - k_shadow) * (float)b);
            r = (int)((cos_angle *= 2.0f) * (float)r + (1.0f - cos_angle) * (float)dr);
            g = (int)(cos_angle * (float)g + (1.0f - cos_angle) * (float)dg);
            b = (int)(cos_angle * (float)b + (1.0f - cos_angle) * (float)db);
        } else {
            int lr = (int)(k_light * 255.0f + (1.0f - k_light) * (float)r);
            int lg = (int)(k_light * 255.0f + (1.0f - k_light) * (float)g);
            int lb = (int)(k_light * 255.0f + (1.0f - k_light) * (float)b);
            cos_angle = (float)((double)cos_angle - 0.5);
            r = (int)((cos_angle *= 2.0f) * (float)lr + (1.0f - cos_angle) * (float)r);
            g = (int)(cos_angle * (float)lg + (1.0f - cos_angle) * (float)g);
            b = (int)(cos_angle * (float)lb + (1.0f - cos_angle) * (float)b);
        }
        return RGBA.Get(r, g, b, RGBA.GetA(_rgba));
    }

    public static String Str(int _rgba) {
        return Long.toString((long)_rgba & 0xFFFFFFFFL, 16);
    }

    public void toBW() {
        int bw;
        this.r_ = bw = (299 * this.r_ + 587 * this.g_ + 114 * this.b_) / 1000;
        this.g_ = bw;
        this.b_ = bw;
    }

    public static int ToBW(int _rgba) {
        int bw;
        int r = _rgba >> 24 & 0xFF;
        int g = _rgba >> 16 & 0xFF;
        int b = _rgba >> 8 & 0xFF;
        int a = _rgba & 0xFF;
        r = bw = (299 * r + 587 * g + 114 * b) / 1000;
        g = bw;
        b = bw;
        return r << 24 | g << 16 | b << 8 | a;
    }

    public void toNegativeBW() {
        int bw;
        this.r_ = bw = 255 - (299 * this.r_ + 587 * this.g_ + 114 * this.b_) / 1000;
        this.g_ = bw;
        this.b_ = bw;
    }

    public static int ToNegativeBW(int _rgba) {
        int bw;
        int r = _rgba >> 24 & 0xFF;
        int g = _rgba >> 16 & 0xFF;
        int b = _rgba >> 8 & 0xFF;
        int a = _rgba & 0xFF;
        r = bw = 255 - (299 * r + 587 * g + 114 * b) / 1000;
        g = bw;
        b = bw;
        return r << 24 | g << 16 | b << 8 | a;
    }

    public void toNegative() {
        this.r_ = 255 - this.r_;
        this.g_ = 255 - this.g_;
        this.b_ = 255 - this.b_;
    }

    public static int ToNegative(int _rgba) {
        int r = _rgba >> 24 & 0xFF;
        int g = _rgba >> 16 & 0xFF;
        int b = _rgba >> 8 & 0xFF;
        int a = _rgba & 0xFF;
        r = 255 - r;
        g = 255 - g;
        b = 255 - b;
        return r << 24 | g << 16 | b << 8 | a;
    }

    public void lighter(float _k) {
        if (_k < 0.0f) {
            _k = 0.0f;
        } else if (_k > 1.0f) {
            _k = 1.0f;
        }
        this.r_ = (int)((float)this.r_ + _k * (float)(255 - this.r_));
        this.g_ = (int)((float)this.g_ + _k * (float)(255 - this.g_));
        this.b_ = (int)((float)this.b_ + _k * (float)(255 - this.b_));
    }

    public static int Lighter(int _rgba, float _k) {
        if (_k < 0.0f) {
            _k = 0.0f;
        } else if (_k > 1.0f) {
            _k = 1.0f;
        }
        int r = RGBA.GetR(_rgba);
        int g = RGBA.GetG(_rgba);
        int b = RGBA.GetB(_rgba);
        r = (int)((float)r + _k * (float)(255 - r));
        g = (int)((float)g + _k * (float)(255 - g));
        b = (int)((float)b + _k * (float)(255 - b));
        return RGBA.Get(r, g, b, RGBA.GetA(_rgba));
    }

    public void darker(int _clr, float _k) {
        if (_k < 0.0f) {
            _k = 0.0f;
        } else if (_k > 1.0f) {
            _k = 1.0f;
        }
        this.r_ = (int)((float)this.r_ - _k * (float)this.r_);
        this.g_ = (int)((float)this.g_ - _k * (float)this.g_);
        this.b_ = (int)((float)this.b_ - _k * (float)this.b_);
    }

    public static int Darker(int _rgba, float _k) {
        if (_k < 0.0f) {
            _k = 0.0f;
        } else if (_k > 1.0f) {
            _k = 1.0f;
        }
        int r = RGBA.GetR(_rgba);
        int g = RGBA.GetG(_rgba);
        int b = RGBA.GetB(_rgba);
        r = (int)((float)r - _k * (float)r);
        g = (int)((float)g - _k * (float)g);
        b = (int)((float)b - _k * (float)b);
        return RGBA.Get(r, g, b, RGBA.GetA(_rgba));
    }
}

