/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.util.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.CircleAlg;
import org.eclipse.tptp.platform.report.igc.alg.internal.OvalAlg;
import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPath;
import org.eclipse.tptp.platform.report.igc.internal.IPathElement;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.IShapeFiller;
import org.eclipse.tptp.platform.report.igc.util.internal.Circle;
import org.eclipse.tptp.platform.report.igc.util.internal.Oval;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.Segment;

public class RoundedRect
implements IPath,
IShape,
IShapeFiller {
    protected int x_;
    protected int y_;
    protected int w_;
    protected int h_;
    protected int rx_;
    protected int ry_;
    protected Data data_;

    public RoundedRect(int x, int y, int w, int h, int radius) {
        this.setRoundedRect(x, y, w, h, radius);
    }

    public RoundedRect(IRect rect, int radius) {
        this.setRoundedRect(rect, radius);
    }

    public RoundedRect(int x, int y, int w, int h, int rx, int ry) {
        this.setRoundedRect(x, y, w, h, rx, ry);
    }

    public RoundedRect(IRect rect, int rx, int ry) {
        this.setRoundedRect(rect, rx, ry);
    }

    public RoundedRect(RoundedRect r) {
        this.setRoundedRect(r);
    }

    public void setRoundedRect(IRect r, int radius) {
        this.setRoundedRect(r.getX(), r.getY(), r.getW(), r.getH(), radius, radius);
    }

    public void setRoundedRect(IRect r, int rx, int ry) {
        this.setRoundedRect(r.getX(), r.getY(), r.getW(), r.getH(), rx, ry);
    }

    public void setRoundedRect(int x, int y, int w, int h, int radius) {
        this.setRoundedRect(x, y, w, h, radius, radius);
    }

    public void setRoundedRect(int x, int y, int w, int h, int rx, int ry) {
        this.x_ = x;
        this.y_ = y;
        this.w_ = w;
        this.h_ = h;
        this.rx_ = Math.min(this.w_ / 2, Math.abs(rx));
        this.ry_ = Math.min(this.h_ / 2, Math.abs(ry));
    }

    public void setRoundedRect(RoundedRect r) {
        this.x_ = r.x_;
        this.y_ = r.y_;
        this.w_ = r.w_;
        this.h_ = r.h_;
        this.rx_ = Math.min(this.w_ / 2, Math.abs(r.rx_));
        this.ry_ = Math.min(this.h_ / 2, Math.abs(r.ry_));
    }

    public int getX() {
        return this.x_;
    }

    public int getY() {
        return this.y_;
    }

    public int getW() {
        return this.w_;
    }

    public int getH() {
        return this.h_;
    }

    public int getRX() {
        return this.rx_;
    }

    public int getRY() {
        return this.ry_;
    }

    public boolean pathBegin(IGC gc, IGCDirect gd) {
        this.data_ = gd.usePixelCoordinates() ? new Data(this.x_, this.y_, this.w_, this.h_, this.rx_, this.ry_) : new Data(gd.devX(this.x_), gd.devY(this.y_), gd.devX(this.w_), gd.devY(this.h_), gd.devX(this.rx_), gd.devY(this.ry_));
        return true;
    }

    public void pathEnd() {
        this.data_ = null;
    }

    public IPathElement nextPathElement() {
        return this.data_.nextPathElement();
    }

    public IShape copyShape() {
        return new RoundedRect(this);
    }

    public boolean contains(int x, int y) {
        double s;
        double rpy;
        double c;
        double rpx;
        double ro2;
        double rp2;
        int xl = this.x_;
        int xr = this.x_ + this.w_ - 1;
        int yt = this.y_;
        int yb = this.y_ + this.h_ - 1;
        if (this.w_ < 0) {
            xl = this.x_ + this.w_ - 1;
            xr = this.x_;
        }
        if (this.h_ < 0) {
            yt = this.y_ + this.h_ - 1;
            yb = this.y_;
        }
        if (x < xl || x > xr || y < yb || y > yt) {
            return false;
        }
        if (this.rx_ == 0 || this.ry_ == 0) {
            return true;
        }
        int rrx = (xr - xl + 1) / 2;
        int rry = (yt - yb + 1) / 2;
        if (rrx > this.rx_) {
            rrx = this.rx_;
        }
        if (rry > this.ry_) {
            rry = this.ry_;
        }
        int x1 = xl + rrx;
        int x2 = xr - rrx;
        int corner_code = 0;
        if (x < x1) {
            corner_code = 0;
        } else {
            if (x <= x2) {
                return true;
            }
            corner_code = 1;
        }
        int y1 = yb + rry;
        int y2 = yt - rry;
        if (y < y1) {
            corner_code |= 0x10;
        } else if (y <= y2) {
            return true;
        }
        int cx = x1;
        int cy = y2;
        switch (corner_code) {
            case 1: {
                cy = y1;
                break;
            }
            case 16: {
                cx = x2;
                break;
            }
            case 17: {
                cx = x2;
                cy = y1;
            }
        }
        int dx = x - cx;
        int dy = y - cy;
        if (this.rx_ == this.ry_) {
            double rp22 = dx * dx + dy * dy;
            double r2 = this.rx_ * this.rx_;
            return rp22 <= r2;
        }
        double angle = Math.atan2(dy, dx);
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return (rp2 = (double)(dx * dx + dy * dy)) <= (ro2 = (rpx = (double)this.rx_ * (c = Math.cos(angle))) * rpx + (rpy = (double)this.ry_ * (s = Math.sin(angle))) * rpy);
    }

    public boolean contains(IPoint p) {
        return this.contains(p.getX(), p.getY());
    }

    public IRect getBounds() {
        return new Rect(this.x_, this.y_, this.w_, this.h_);
    }

    public boolean fillShape(IGC gc, IGCDirect gd, IBrush brush, IShape shape) {
        if (!(shape instanceof RoundedRect)) {
            return false;
        }
        if (this.rx_ == 0 || this.ry_ == 0) {
            gc.fillRect(this.x_, this.y_, this.w_, this.h_);
        } else {
            brush.brushBegin(gc, gd);
            this.data_ = gd.usePixelCoordinates() ? new Data(this.x_, this.y_, this.w_, this.h_, this.rx_, this.ry_) : new Data(gd.devX(this.x_), gd.devY(this.y_), gd.devX(this.w_), gd.devY(this.h_), gd.devX(this.rx_), gd.devY(this.ry_));
            this.data_.fill(gd, brush);
            brush.brushEnd();
        }
        return true;
    }

    public void translate(int tx, int ty) {
        this.x_ += tx;
        this.y_ += ty;
    }

    private class Data {
        int x1;
        int y1;
        int x2;
        int y2;
        int cx1;
        int cy1;
        int cx2;
        int cy2;
        int rx;
        int ry;
        int type;
        Circle circle;
        Oval oval;
        Segment segment;

        public Data(int x, int y, int w, int h, int rx, int ry) {
            boolean lr_oval;
            int t;
            this.rx = Math.abs(rx);
            this.ry = Math.abs(ry);
            this.x1 = x;
            this.x2 = x + w - 1;
            if (this.x1 > this.x2) {
                t = this.x1;
                this.x1 = this.x2;
                this.x2 = t;
            }
            this.y1 = y;
            this.y2 = y + h - 1;
            if (this.y1 > this.y2) {
                t = this.y1;
                this.y1 = this.y2;
                this.y2 = t;
            }
            int rrx = (this.x2 - this.x1 + 1) / 2;
            int rry = (this.y2 - this.y1 + 1) / 2;
            boolean tb_oval = rrx <= rx;
            boolean bl = lr_oval = rry <= ry;
            if (tb_oval) {
                rx = rrx;
                this.type = lr_oval ? ((ry = rry) == rx ? 10 : 20) : (ry == rx ? 30 : 40);
            } else {
                this.type = lr_oval ? (rx == (ry = rry) ? 50 : 60) : (rx == 0 || ry == 0 ? 1 : (rx == ry ? 70 : 80));
            }
            this.cx1 = this.x1 + rx;
            this.cx2 = this.x2 - rx;
            this.cy1 = this.y1 + ry;
            this.cy2 = this.y2 - ry;
        }

        public void fill(IGCDirect gc, IBrush brush) {
            switch (this.type) {
                default: {
                    return;
                }
                case 1: {
                    gc.fillRectDirect(this.x1, this.y1, this.x2 - this.x1 + 1, this.y2 - this.y1 + 1);
                    break;
                }
                case 10: {
                    CircleAlg.FillCircle(gc, this.cx1, this.cy1, this.rx);
                    break;
                }
                case 20: {
                    OvalAlg.FillOval(gc, this.cx1, this.cy1, this.rx, this.ry);
                    break;
                }
                case 30: 
                case 40: {
                    OvalAlg ov = new OvalAlg(this.cx1, this.cy1, this.rx, this.ry, 0.0, Math.PI);
                    ov.fillOval(gc);
                    gc.fillRectDirect(this.x1, this.cy1, this.x2 - this.x1 + 1, this.cy2 - this.cy1 + 1);
                    ov.setArc(this.cx2, this.cy2, this.rx, this.ry, Math.PI, Math.PI);
                    ov.fillOval(gc);
                    break;
                }
                case 50: 
                case 60: {
                    OvalAlg ov = new OvalAlg(this.cx1, this.cy1, this.rx, this.ry, 1.5707963267948966, Math.PI);
                    ov.fillOval(gc);
                    gc.fillRectDirect(this.cx1, this.y1, this.cx2 - this.cx1 + 1, this.y2 - this.y1 + 1);
                    ov.setArc(this.cx2, this.cy2, this.rx, this.ry, 4.71238898038469, Math.PI);
                    ov.fillOval(gc);
                    break;
                }
                case 70: {
                    int x;
                    CircleAlg cl = new CircleAlg(this.cx1, this.cy1, RoundedRect.this.rx_, 4.71238898038469, -1.5707963267948966);
                    CircleAlg cr = new CircleAlg(this.cx2, this.cy1, RoundedRect.this.rx_, 4.71238898038469, 1.5707963267948966);
                    int yscan = this.y1;
                    int xl = this.cx1;
                    int xr = this.cy1;
                    while (true) {
                        if (cl.nextPoint(null) && cl.getY() <= yscan) {
                            x = cl.getX();
                            if (x >= xl) continue;
                            xl = x;
                            continue;
                        }
                        while (cr.nextPoint(null) && cr.getY() <= yscan) {
                            x = cr.getX();
                            if (x <= xr) continue;
                            xr = x;
                        }
                        gc.drawHLineDirect(xl, xr, yscan);
                        xl = cl.getX();
                        xr = cr.getX();
                        if (++yscan >= this.cy1) break;
                    }
                    while (yscan <= this.cy2) {
                        gc.drawHLineDirect(this.x1, this.x2, yscan);
                        ++yscan;
                    }
                    cl.setArc(this.cx1, this.cy2, this.rx, Math.PI, -1.5707963267948966);
                    cr.setArc(this.cx2, this.cy2, this.rx, 0.0, 1.5707963267948966);
                    xl = this.x1;
                    xr = this.x2;
                    while (true) {
                        if (cl.nextPoint(null) && cl.getY() <= yscan) {
                            x = cl.getX();
                            if (x >= xl) continue;
                            xl = x;
                            continue;
                        }
                        while (cr.nextPoint(null) && cr.getY() <= yscan) {
                            x = cr.getX();
                            if (x <= xr) continue;
                            xr = x;
                        }
                        gc.drawHLineDirect(xl, xr, yscan);
                        xl = cl.getX();
                        xr = cr.getX();
                        if (++yscan >= this.y2) break;
                    }
                    gc.drawHLineDirect(this.cx1, this.cx2, this.y2);
                    break;
                }
                case 80: {
                    int x;
                    OvalAlg cl = new OvalAlg(this.cx1, this.cy1, RoundedRect.this.rx_, RoundedRect.this.ry_, 4.71238898038469, -1.5707963267948966);
                    OvalAlg cr = new OvalAlg(this.cx2, this.cy1, RoundedRect.this.rx_, RoundedRect.this.ry_, 4.71238898038469, 1.5707963267948966);
                    int yscan = this.y1;
                    int xl = this.cx1;
                    int xr = this.cy1;
                    while (true) {
                        if (cl.nextPoint(null) && cl.getY() <= yscan) {
                            x = cl.getX();
                            if (x >= xl) continue;
                            xl = x;
                            continue;
                        }
                        while (cr.nextPoint(null) && cr.getY() <= yscan) {
                            x = cr.getX();
                            if (x <= xr) continue;
                            xr = x;
                        }
                        gc.drawHLineDirect(xl, xr, yscan);
                        xl = cl.getX();
                        xr = cr.getX();
                        if (++yscan >= this.cy1) break;
                    }
                    while (yscan <= this.cy2) {
                        gc.drawHLineDirect(this.x1, this.x2, yscan);
                        ++yscan;
                    }
                    cl.setArc(this.cx1, this.cy2, this.rx, this.ry, Math.PI, -1.5707963267948966);
                    cr.setArc(this.cx2, this.cy2, this.rx, this.ry, 0.0, 1.5707963267948966);
                    xl = this.x1;
                    xr = this.x2;
                    while (true) {
                        if (cl.nextPoint(null) && cl.getY() <= yscan) {
                            x = cl.getX();
                            if (x >= xl) continue;
                            xl = x;
                            continue;
                        }
                        while (cr.nextPoint(null) && cr.getY() <= yscan) {
                            x = cr.getX();
                            if (x <= xr) continue;
                            xr = x;
                        }
                        gc.drawHLineDirect(xl, xr, yscan);
                        xl = cl.getX();
                        xr = cr.getX();
                        if (++yscan >= this.y2) break;
                    }
                    gc.drawHLineDirect(this.cx1, this.cx2, this.y2);
                }
            }
        }

        public IPathElement nextPathElement() {
            switch (this.type) {
                default: {
                    return null;
                }
                case 1: {
                    this.segment = new Segment(this.x1, this.y1, this.x2, this.y1);
                    this.type = 2;
                    return this.segment;
                }
                case 2: {
                    this.segment.setLine(this.x2, this.y1 + 1, this.x2, this.y2 - 1);
                    this.type = 3;
                    return this.segment;
                }
                case 3: {
                    this.segment.setLine(this.x2, this.y2, this.x1, this.y1);
                    this.type = 4;
                    return this.segment;
                }
                case 4: {
                    this.segment.setLine(this.x1, this.y2 - 1, this.x1, this.y1 + 1);
                    this.type = 0;
                    return this.segment;
                }
                case 10: {
                    this.circle = new Circle(this.cx1, this.cy1, this.rx);
                    this.type = 0;
                    return this.circle;
                }
                case 20: {
                    Oval oval = new Oval(this.cx1, this.cy1, this.rx, this.ry);
                    this.type = 0;
                    return oval;
                }
                case 30: {
                    this.circle = new Circle(this.cx1, this.cy1, this.rx, Math.PI, Math.PI);
                    this.type = 31;
                    return this.circle;
                }
                case 31: {
                    this.segment = new Segment(this.x2, this.cy1 + 1, this.x2, this.cy2 - 1);
                    this.type = 32;
                    return this.segment;
                }
                case 32: {
                    this.circle.setArc(this.cx2, this.cy2, this.rx, 0.0, Math.PI);
                    this.type = 33;
                    return this.circle;
                }
                case 33: {
                    this.segment.setLine(this.x1, this.cy2 - 1, this.x1, this.cy1 + 1);
                    this.type = 0;
                    return this.segment;
                }
                case 40: {
                    this.oval = new Oval(this.cx1, this.cy1, this.rx, this.ry, Math.PI, Math.PI);
                    this.type = 31;
                    return this.oval;
                }
                case 41: {
                    this.segment = new Segment(this.x2, this.cy1 + 1, this.x2, this.cy2 - 1);
                    this.type = 32;
                    return this.segment;
                }
                case 42: {
                    this.oval.setArc(this.cx2, this.cy2, this.rx, this.ry, 0.0, Math.PI);
                    this.type = 33;
                    return this.oval;
                }
                case 43: {
                    this.segment.setLine(this.x1, this.cy2 - 1, this.x1, this.cy1 + 1);
                    this.type = 0;
                    return this.segment;
                }
                case 50: {
                    this.segment = new Segment(this.cx1 + 1, this.y1, this.cx2 - 1, this.y1);
                    this.type = 51;
                    return this.segment;
                }
                case 51: {
                    this.circle = new Circle(this.cx2, this.cy2, this.rx, 4.71238898038469, Math.PI);
                    this.type = 52;
                    return this.circle;
                }
                case 52: {
                    this.segment = new Segment(this.cx2 - 1, this.y2, this.cx1 + 1, this.y2);
                    this.type = 53;
                    return this.segment;
                }
                case 53: {
                    this.circle.setArc(this.cx1, this.cy1, this.rx, 1.5707963267948966, Math.PI);
                    this.type = 0;
                    return this.circle;
                }
                case 60: {
                    this.segment = new Segment(this.cx1 + 1, this.y1, this.cx2 - 1, this.y1);
                    this.type = 61;
                    return this.segment;
                }
                case 61: {
                    this.oval = new Oval(this.cx2, this.cy2, this.rx, this.ry, 4.71238898038469, Math.PI);
                    this.type = 62;
                    return this.oval;
                }
                case 62: {
                    this.segment = new Segment(this.cx2 - 1, this.y2, this.cx1 + 1, this.y2);
                    this.type = 63;
                    return this.segment;
                }
                case 63: {
                    this.oval.setArc(this.cx1, this.cy1, this.rx, this.ry, 1.5707963267948966, Math.PI);
                    this.type = 0;
                    return this.oval;
                }
                case 70: {
                    this.segment = new Segment(this.cx1, this.y1, this.cx2 - 1, this.y1);
                    this.type = 71;
                    return this.segment;
                }
                case 71: {
                    this.circle = new Circle(this.cx2, this.cy1, this.rx, 4.71238898038469, 1.5707963267948966);
                    this.type = 72;
                    return this.circle;
                }
                case 72: {
                    this.segment.setLine(this.x2, this.cy1, this.x2, this.cy2 - 1);
                    this.type = 73;
                    return this.segment;
                }
                case 73: {
                    this.circle.setArc(this.cx2, this.cy2, this.rx, 0.0, 1.5707963267948966);
                    this.type = 74;
                    return this.circle;
                }
                case 74: {
                    this.segment.setLine(this.cx2, this.y2, this.cx1 + 1, this.y2);
                    this.type = 75;
                    return this.segment;
                }
                case 75: {
                    this.circle.setArc(this.cx1, this.cy2, this.rx, 1.5707963267948966, 1.5707963267948966);
                    this.type = 76;
                    return this.circle;
                }
                case 76: {
                    this.segment.setLine(this.x1, this.cy2, this.x1, this.cy1 + 1);
                    this.type = 77;
                    return this.segment;
                }
                case 77: {
                    this.circle.setArc(this.cx1, this.cy1, this.rx, Math.PI, 1.5707963267948966);
                    this.type = 0;
                    return this.circle;
                }
                case 80: {
                    this.segment = new Segment(this.cx1, this.y1, this.cx2 - 1, this.y1);
                    this.type = 81;
                    return this.segment;
                }
                case 81: {
                    this.oval = new Oval(this.cx2, this.cy1, this.rx, this.ry, 4.71238898038469, 1.5707963267948966);
                    this.type = 82;
                    return this.oval;
                }
                case 82: {
                    this.segment.setLine(this.x2, this.cy1, this.x2, this.cy2 - 1);
                    this.type = 83;
                    return this.segment;
                }
                case 83: {
                    this.oval.setArc(this.cx2, this.cy2, this.rx, this.ry, 0.0, 1.5707963267948966);
                    this.type = 84;
                    return this.oval;
                }
                case 84: {
                    this.segment.setLine(this.cx2, this.y2, this.cx1 + 1, this.y2);
                    this.type = 85;
                    return this.segment;
                }
                case 85: {
                    this.oval.setArc(this.cx1, this.cy2, this.rx, this.ry, 1.5707963267948966, 1.5707963267948966);
                    this.type = 86;
                    return this.oval;
                }
                case 86: {
                    this.segment.setLine(this.x1, this.cy2, this.x1, this.cy1 + 1);
                    this.type = 87;
                    return this.segment;
                }
                case 87: 
            }
            this.oval.setArc(this.cx1, this.cy1, this.rx, this.ry, Math.PI, 1.5707963267948966);
            this.type = 0;
            return this.oval;
        }
    }
}

