/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.signals.internal;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public class Signal {
    private String name_;
    private Vector receivers_;
    private boolean blocked_ = false;
    private static boolean s_blocked_ = false;
    protected static IConnectionFactory connection_factory_;

    static {
        try {
            Class.forName("org.eclipse.swt.events.DisposeListener");
            Class<?> cls = Class.forName("org.eclipse.tptp.platform.report.signals.internal.SWTConnectionFactory");
            connection_factory_ = (IConnectionFactory)cls.newInstance();
        }
        catch (Exception exception) {}
    }

    public Signal(String _name) {
        this.name_ = _name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String[] DecompileSignature(String _str) {
        if (_str == null) {
            return null;
        }
        int len = _str.length();
        if (len == 0) {
            return null;
        }
        try {
            Vector<String> v;
            int i;
            block15: {
                i = 0;
                char c = _str.charAt(i);
                while (Character.isSpaceChar(c)) {
                    c = _str.charAt(++i);
                }
                if (!Character.isJavaIdentifierStart(c)) {
                    System.err.println("method name doesn't start with a valid java identifier character");
                    return null;
                }
                int j = i + 1;
                c = _str.charAt(j);
                while (Character.isJavaIdentifierPart(c)) {
                    c = _str.charAt(++j);
                }
                String mth_name = _str.substring(i, j);
                i = j;
                while (Character.isSpaceChar(c)) {
                    c = _str.charAt(++i);
                }
                if (c != '(') {
                    System.err.println("missing '(' in signature");
                    return null;
                }
                c = _str.charAt(++i);
                v = new Vector<String>();
                v.add(mth_name);
                while (true) {
                    if (Character.isSpaceChar(c)) {
                        c = _str.charAt(++i);
                        continue;
                    }
                    if (c == ')') break block15;
                    j = i + 1;
                    c = _str.charAt(j);
                    while (Character.isJavaIdentifierPart(c) || c == '.' || c == '$') {
                        c = _str.charAt(++j);
                    }
                    String arg_class = _str.substring(i, j);
                    v.add(arg_class);
                    i = j;
                    while (Character.isSpaceChar(c)) {
                        c = _str.charAt(++i);
                    }
                    if (c != ',') break;
                    c = _str.charAt(++i);
                }
                if (c != ')') {
                    System.err.println("Unexpected character '" + c + "' in signature");
                    return null;
                }
            }
            String[] r = new String[v.size()];
            i = 0;
            while (i < v.size()) {
                r[i] = (String)v.get(i);
                ++i;
            }
            return r;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return null;
        }
    }

    public boolean haveReceiver() {
        return this.receivers_ != null && this.receivers_.size() > 0;
    }

    public boolean isBlocked() {
        return this.blocked_;
    }

    public static boolean isAllBlocked() {
        return s_blocked_;
    }

    public void setBlocked(boolean _b) {
        this.blocked_ = _b;
    }

    public static void setAllBlocked(boolean _b) {
        s_blocked_ = _b;
    }

    protected static Connection createConnection(Object _o, Method _m, String _method_sgn) {
        if (connection_factory_ == null) {
            return new Connection(_o, _m, _method_sgn);
        }
        return connection_factory_.createConnection(_o, _m, _method_sgn);
    }

    protected Class getClassOf(Object _receiver, Class _receiver_class) {
        Class<Object> co = _receiver_class;
        if (co == null) {
            co = _receiver instanceof Class ? (Class)_receiver : _receiver.getClass();
        }
        return co;
    }

    protected Method getMethodFromSignature(Object _receiver, Class _class, String _signature) {
        Class co = this.getClassOf(_receiver, _class);
        String[] s = Signal.DecompileSignature(_signature);
        if (s == null || s.length == 0) {
            System.err.println("Signal: Can't decompile signature '" + _signature + "' for receiver '" + _receiver.getClass().getName() + "'");
            return null;
        }
        Method[] ms = co.getMethods();
        int i = 0;
        while (i < ms.length) {
            Method m = ms[i];
            if (s[0].equals(m.getName())) {
                boolean match;
                Class<?>[] arg_type = m.getParameterTypes();
                boolean bl = match = s.length - 1 == arg_type.length;
                if (match) {
                    int ii = 0;
                    while (ii < arg_type.length) {
                        String java_lang_s;
                        String a = arg_type[ii].getName();
                        if (!a.equals(s[ii + 1]) && !(java_lang_s = "java.lang." + s[ii + 1]).equals(a)) {
                            match = false;
                            break;
                        }
                        ++ii;
                    }
                }
                if (match) {
                    return m;
                }
            }
            ++i;
        }
        return null;
    }

    public void connectChecked(Object _receiver, Class _receiver_class, String _method_sgn) throws MethodNotFoundException {
        Method m = this.getMethodFromSignature(_receiver, _receiver_class, _method_sgn);
        if (m != null) {
            if (this.receivers_ == null) {
                this.receivers_ = new Vector();
            }
        } else {
            throw new MethodNotFoundException("Method '" + _method_sgn + "' not found in '" + this.getClassOf(_receiver, _receiver_class) + "'");
        }
        this.receivers_.add(Signal.createConnection(_receiver, m, _method_sgn));
    }

    public final void connectChecked(Object _receiver, String _method_sgn) throws MethodNotFoundException {
        this.connectChecked(_receiver, null, _method_sgn);
    }

    public void connect(Object _receiver, Class _class, String _method_name) {
        try {
            this.connectChecked(_receiver, _class, _method_name);
        }
        catch (MethodNotFoundException _e) {
            System.err.println(_e.getMessage());
        }
    }

    public final void connect(Object _receiver, String _method_name) {
        this.connect(_receiver, null, _method_name);
    }

    public void connect(Signal _signal) {
        if (_signal == null) {
            return;
        }
        if (this.receivers_ == null) {
            this.receivers_ = new Vector();
        }
        this.receivers_.add(_signal);
    }

    public void disconnect(Signal _signal) {
        if (_signal == null) {
            return;
        }
        if (this.receivers_ == null) {
            return;
        }
        this.receivers_.remove(_signal);
    }

    public void disconnect(Object _receiver) {
        if (_receiver == null) {
            return;
        }
        int n_disconnect = 0;
        if (this.receivers_ != null) {
            int i = 0;
            while (i < this.receivers_.size()) {
                Object obj = this.receivers_.get(i);
                if (!(obj instanceof Connection)) {
                    ++i;
                    continue;
                }
                Connection p = (Connection)obj;
                Object r = p.r_receiver_.get();
                if (r == null) {
                    this.receivers_.remove(i);
                    continue;
                }
                if (r == _receiver) {
                    this.receivers_.remove(i);
                    ++n_disconnect;
                    continue;
                }
                ++i;
            }
        }
        if (n_disconnect == 0) {
            System.err.println("Signal:warning: receiver '" + _receiver.getClass().getName() + "' not disconnected, no connection found");
        }
    }

    public void disconnect(Object _receiver, String _signature) {
        if (_receiver == null) {
            return;
        }
        Method m = this.getMethodFromSignature(_receiver, null, _signature);
        if (m == null) {
            System.out.println("Signal:warning: disconnect failed can't decompile signature '" + _signature + "'");
            return;
        }
        int n_disconnect = 0;
        if (this.receivers_ != null) {
            int i = 0;
            while (i < this.receivers_.size()) {
                Object obj = this.receivers_.get(i);
                if (!(obj instanceof Connection)) {
                    ++i;
                    continue;
                }
                Connection p = (Connection)obj;
                Object r = p.r_receiver_.get();
                if (r == null) {
                    this.receivers_.remove(i);
                    continue;
                }
                if (r == _receiver && p.method_ == m) {
                    this.receivers_.remove(i);
                    ++n_disconnect;
                    continue;
                }
                ++i;
            }
        }
        if (n_disconnect == 0) {
            System.err.println("Signal:warning: receiver '" + _receiver.getClass().getName() + "' not disconnected, no connection found");
        }
    }

    public void clear() {
        if (this.receivers_ == null) {
            return;
        }
        this.receivers_.clear();
        this.receivers_ = null;
    }

    public void emit(Object[] _parameters) {
        this.emitSignal(_parameters);
    }

    public final void emit(Object _parameter) {
        Object[] pm = new Object[]{_parameter};
        this.emitSignal(pm);
    }

    public final void emit() {
        this.emitSignal(null);
    }

    protected void emitSignal(Object[] _parameters) {
        if (this.receivers_ == null) {
            return;
        }
        if (this.blocked_) {
            return;
        }
        if (s_blocked_) {
            return;
        }
        int parameters_length = _parameters == null ? 0 : _parameters.length;
        int i = 0;
        while (i < this.receivers_.size()) {
            Object obj = this.receivers_.get(i);
            if (obj instanceof Signal) {
                Signal sgn = (Signal)obj;
                sgn.emit(_parameters);
            } else {
                Connection pair = (Connection)obj;
                Object receiver = pair.r_receiver_.get();
                if (receiver == null) {
                    this.receivers_.remove(i);
                    --i;
                } else {
                    Method mth = pair.method_;
                    Class<?>[] args = mth.getParameterTypes();
                    Object[] param = null;
                    if (args.length == parameters_length) {
                        param = _parameters;
                    } else if (args.length < parameters_length) {
                        param = new Object[args.length];
                        int a = 0;
                        while (a < args.length) {
                            param[a] = _parameters[a];
                            ++a;
                        }
                    }
                    this.invokeConnection(receiver, mth, param, pair.method_sgn_);
                }
            }
            ++i;
        }
    }

    protected void invokeConnection(Object _receiver, Method _method, Object[] _params, String _method_signature) {
        block6: {
            try {
                _method.invoke(_receiver, _params);
            }
            catch (InvocationTargetException e) {
                System.err.println("Signal[" + this.name_ + "]: emit catch InvocationTargetException : " + e.getCause().getMessage());
                System.err.println("      receiver class is '" + _receiver.getClass().getName() + "'");
                if (e.getCause() != null) {
                    e.getCause().printStackTrace();
                }
            }
            catch (IllegalAccessException _e) {
                System.err.print("signal[" + this.name_ + "]: emit catch IllegalAccessException : ");
                if (_e.getCause() != null) {
                    System.err.println(_e.getCause());
                } else {
                    System.err.println(_e.getMessage());
                }
                System.err.println("  receiver '" + _receiver.getClass().getName() + "." + _method_signature + "'");
                if (_e.getCause() == null) break block6;
                _e.getCause().printStackTrace();
            }
        }
    }

    protected static class Connection {
        public WeakReference r_receiver_;
        public Method method_;
        public String method_sgn_;

        public Connection(Object _o, Method _m, String _method_sgn) {
            this.r_receiver_ = new WeakReference<Object>(_o);
            this.method_ = _m;
            this.method_sgn_ = _method_sgn;
        }
    }

    public static interface IConnectionFactory {
        public Connection createConnection(Object var1, Method var2, String var3);
    }

    public static class MethodNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MethodNotFoundException(String _mth, Class _class) {
            super("method '" + _mth + "' not found in '" + _class.getName() + "'");
        }

        public MethodNotFoundException(String _m) {
            super(_m);
        }
    }
}

