/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.sxp.internal;

import org.eclipse.tptp.platform.report.sxp.internal.SXPAttr;
import org.eclipse.tptp.platform.report.sxp.internal.SXPNamedNodeMap;
import org.eclipse.tptp.platform.report.sxp.internal.SXPNode;
import org.eclipse.tptp.platform.report.sxp.internal.SXPNodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class SXPElement
extends SXPNode
implements Element {
    private String tag_name_;
    private NamedNodeMap attributes_;

    public SXPElement(String tag_name) {
        this.tag_name_ = tag_name;
        this.attributes_ = new SXPNamedNodeMap();
    }

    public NamedNodeMap getAttributes() {
        return this.attributes_;
    }

    public String getTagName() {
        return this.tag_name_;
    }

    public String getAttribute(String name) {
        return ((Attr)this.attributes_.getNamedItem(name)).getValue();
    }

    public void setAttribute(String name, String value) throws DOMException {
        this.attributes_.setNamedItem(new SXPAttr(name, value));
    }

    public void removeAttribute(String name) throws DOMException {
        this.attributes_.removeNamedItem(name);
    }

    public Attr getAttributeNode(String name) {
        return (Attr)this.attributes_.getNamedItem(name);
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        this.attributes_.setNamedItem(newAttr);
        return newAttr;
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        if (oldAttr.getParentNode() != this) {
            return null;
        }
        this.attributes_.removeNamedItem(oldAttr.getName());
        SXPNode n = (SXPNode)((Object)oldAttr);
        n.setParent(null);
        return oldAttr;
    }

    public String getNodeName() {
        return this.tag_name_;
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
    }

    public short getNodeType() {
        return 1;
    }

    public boolean hasAttributes() {
        return this.attributes_.getLength() != 0;
    }

    public NodeList getElementsByTagName(String name) {
        int cnt = 0;
        SXPNode n = this.first_child_;
        while (n != null) {
            if (n.getNodeType() == 1 && n.getNodeName().equals(name)) {
                ++cnt;
            }
            n = (SXPNode)n.getNextSibling();
        }
        SXPNodeList nl = new SXPNodeList(cnt);
        SXPNode n2 = this.first_child_;
        while (n2 != null) {
            if (n2.getNodeType() == 1 && n2.getNodeName().equals(name)) {
                nl.addItem(n2);
            }
            n2 = (SXPNode)n2.getNextSibling();
        }
        return nl;
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return null;
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return null;
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return null;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return null;
    }

    public boolean hasAttribute(String name) {
        Node n = this.attributes_.getNamedItem(name);
        return n != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return false;
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
    }

    public void setIdAttributeNS(String namespaceUri, String localName, boolean isId) throws DOMException {
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        return 0;
    }

    public String getBaseURI() {
        return null;
    }

    public Object getFeature(String feature, String version) {
        return null;
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public Object getUserData(String key) {
        return null;
    }

    public boolean isDefaultNamespace(String namespaceUri) {
        return false;
    }

    public boolean isEqualNode(Node arg) {
        return false;
    }

    public boolean isSameNode(Node other) {
        return false;
    }

    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    public String lookupPrefix(String namespaceUri) {
        return null;
    }

    public void setTextContent(String textContent) throws DOMException {
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return null;
    }
}

