/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.sxp.internal;

import org.eclipse.tptp.platform.report.sxp.internal.SXPNodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class SXPNode
implements Node {
    protected SXPNode parent_;
    protected SXPNode prev_;
    protected SXPNode next_;
    protected SXPNode first_child_;
    protected SXPNode last_child_;

    public void setParent(SXPNode p) {
        this.parent_ = p;
    }

    public void setPrev(SXPNode p) {
        this.prev_ = p;
    }

    public void setNext(SXPNode p) {
        this.next_ = p;
    }

    public abstract String getNodeName();

    public abstract String getNodeValue() throws DOMException;

    public abstract void setNodeValue(String var1) throws DOMException;

    public abstract short getNodeType();

    public Node getParentNode() {
        return this.parent_;
    }

    public NodeList getChildNodes() {
        int cnt = 0;
        Node c = this.first_child_;
        while (c != null) {
            ++cnt;
            c = c.getNextSibling();
        }
        SXPNodeList nl = new SXPNodeList(cnt);
        Node c2 = this.first_child_;
        while (c2 != null) {
            nl.addItem(c2);
            c2 = c2.getNextSibling();
        }
        return nl;
    }

    public Node getFirstChild() {
        return this.first_child_;
    }

    public Node getLastChild() {
        return this.last_child_;
    }

    public Node getPreviousSibling() {
        return this.prev_;
    }

    public Node getNextSibling() {
        return this.next_;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        return this.parent_ != null ? this.parent_.getOwnerDocument() : null;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        SXPNode new_child = (SXPNode)newChild;
        if (new_child.getParentNode() != null) {
            new_child.getParentNode().removeChild(new_child);
        } else {
            if (new_child.getPreviousSibling() != null) {
                ((SXPNode)new_child.getPreviousSibling()).setNext((SXPNode)new_child.getNextSibling());
            }
            if (new_child.getNextSibling() != null) {
                ((SXPNode)new_child.getNextSibling()).setPrev((SXPNode)new_child.getPreviousSibling());
            }
            new_child.setParent(null);
        }
        if (refChild == null) {
            if (this.last_child_ == null) {
                this.first_child_ = this.last_child_ = new_child;
            } else {
                new_child.setPrev(this.last_child_);
                this.last_child_.setNext(new_child);
                this.last_child_ = new_child;
            }
        } else {
            SXPNode c = this.first_child_;
            while (c != null) {
                if (c == refChild) {
                    new_child.setNext(c);
                    c.setPrev(new_child);
                    if (c == this.first_child_) {
                        this.first_child_ = new_child;
                    }
                    new_child.setParent(this);
                    return new_child;
                }
                c = (SXPNode)c.getNextSibling();
            }
            return null;
        }
        new_child.setParent(this);
        return new_child;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        SXPNode new_child = (SXPNode)newChild;
        SXPNode old_child = (SXPNode)oldChild;
        SXPNode n = this.first_child_;
        while (n != null) {
            if (n == old_child) {
                SXPNode p = (SXPNode)old_child.getPreviousSibling();
                new_child.setPrev(p);
                if (p != null) {
                    p.setNext(new_child);
                }
                p = (SXPNode)old_child.getNextSibling();
                new_child.setNext(p);
                if (p != null) {
                    p.setPrev(new_child);
                }
                new_child.setParent(this);
                old_child.setPrev(null);
                old_child.setNext(null);
                old_child.setParent(null);
                if (this.first_child_ == old_child) {
                    this.first_child_ = new_child;
                }
                if (this.last_child_ == old_child) {
                    this.last_child_ = new_child;
                }
                return old_child;
            }
            n = (SXPNode)n.getNextSibling();
        }
        return null;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        if (oldChild.getParentNode() != this) {
            return null;
        }
        SXPNode old = (SXPNode)oldChild;
        old.setParent(null);
        if (old == this.first_child_) {
            this.first_child_ = (SXPNode)this.first_child_.getNextSibling();
        }
        if (old == this.last_child_) {
            this.last_child_ = (SXPNode)this.last_child_.getPreviousSibling();
        }
        old.setPrev(null);
        old.setNext(null);
        return old;
    }

    public Node appendChild(Node newChild) throws DOMException {
        SXPNode n = (SXPNode)newChild;
        if (n.getParentNode() != null) {
            n.getParentNode().removeChild(newChild);
        }
        if (this.last_child_ == null) {
            this.first_child_ = this.last_child_ = n;
            n.setPrev(null);
            n.setNext(null);
        } else {
            this.last_child_.setNext(n);
            n.setPrev(this.last_child_);
            n.setNext(null);
            this.last_child_ = n;
        }
        n.setParent(this);
        return n;
    }

    public boolean hasChildNodes() {
        return this.first_child_ != null;
    }

    public Node cloneNode(boolean deep) {
        return null;
    }

    public void normalize() {
    }

    public boolean isSupported(String feature, String version) {
        return false;
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String prefix) throws DOMException {
    }

    public String getLocalName() {
        return null;
    }

    public abstract boolean hasAttributes();

    public final void dump() {
        this.dump("");
    }

    protected void dump(String indent) {
        Element e;
        NamedNodeMap attr;
        System.out.print(String.valueOf(indent) + "Node[" + this.getNodeName() + "] value='" + this.getNodeValue() + "'");
        if (this instanceof Element && (attr = (e = (Element)((Object)this)).getAttributes()) != null) {
            int i = 0;
            while (i < attr.getLength()) {
                Attr a = (Attr)attr.item(i);
                System.out.print(" " + a.getName() + "=\"" + a.getValue() + "\"");
                ++i;
            }
        }
        if (this.hasChildNodes()) {
            System.out.print(" children={");
            System.out.println();
            ((SXPNode)this.getFirstChild()).dump(String.valueOf(indent) + "  ");
            System.out.println(String.valueOf(indent) + "}");
        } else {
            System.out.println(" children={}");
        }
        if (this.next_ != null) {
            this.next_.dump(indent);
        }
    }
}

