/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.sxp.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.eclipse.tptp.platform.report.drivers.xml.internal.IXmlParser;
import org.eclipse.tptp.platform.report.sxp.internal.SXPDocument;
import org.eclipse.tptp.platform.report.sxp.internal.SXPElement;
import org.eclipse.tptp.platform.report.sxp.internal.SXPNode;
import org.eclipse.tptp.platform.report.sxp.internal.SXPText;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class SimpleXmlParser
implements IXmlParser {
    protected InputStream input_;
    protected int curr_line_;
    protected int curr_col_;
    protected SXPDocument doc_;
    protected boolean utf8_encoding_;
    private static final int TK_END = 0;
    private static final int TK_START_PROLOG = 1;
    private static final int TK_END_PROLOG = 2;
    private static final int TK_EQ = 3;
    private static final int TK_START_ELEMENT = 4;
    private static final int TK_END_ELEMENT = 5;
    private static final int TK_END_EMPTY_ELEMENT = 6;
    private static final int TK_START_END_ELEMENT = 7;
    private static final int TK_IDENT = 8;
    private static final int TK_STRING = 9;
    private static final int TK_DATA = 10;
    private static final int TK_START_COMMENT = 11;
    private static final int TK_END_COMMENT = 12;
    private static final String[] S_TOKEN = new String[]{"TK_END", "TK_START_XML_PROLOG", "TK_END_XML_PROLOG", "TK_EQ", "TK_START_ELEMENT", "TK_END_ELEMENT", "TK_END_EMPTY_ELEMENT", "TK_START_END_ELEMENT", "TK_IDENT", "TK_STRING", "TK_DATA"};
    private static final int S_DATA = 0;
    private static final int S_ELEMENT = 1;
    private static final int S_PROLOG = 1;
    private static final int S_ERROR = 2;
    private static final int S_COMMENT = 3;
    private String s_token_;
    private int state_ = 0;
    private int[] next_input_;
    private int[] next_line_;
    private int[] next_col_;
    private int next_input_len_;
    private int curr_token_ = -1;
    private boolean escaped_;
    private boolean end_comment_parsed_;

    public Document getDocument() {
        return this.input_ != null ? null : this.doc_;
    }

    public void parse(InputSource is) {
        this.input_ = is.getByteStream();
        this.curr_line_ = 1;
        this.curr_col_ = 0;
        this.doc_ = new SXPDocument();
        this.state_ = 0;
        try {
            try {
                this.parseProlog();
                if (this.curr_token_ == 2) {
                    this.getNextToken();
                }
                this.parseDataOrElement(this.doc_, false);
            }
            catch (ParseError e) {
                e.printStackTrace();
                this.doc_ = null;
                this.input_ = null;
            }
        }
        finally {
            this.input_ = null;
        }
    }

    private void parseDataOrElement(SXPNode node, boolean allow_end_element) throws ParseError {
        block7: while (true) {
            switch (this.curr_token_) {
                case 0: {
                    break block7;
                }
                case 10: {
                    node.appendChild(new SXPText(this.s_token_));
                    break;
                }
                case 4: {
                    this.parseElement(node);
                    break;
                }
                case 7: {
                    if (allow_end_element) break block7;
                    this.unexpectedInput();
                }
                case 11: {
                    this.parseComment(node);
                    break;
                }
                default: {
                    this.unexpectedInput();
                }
            }
            this.getNextToken();
        }
    }

    private void parseComment(SXPNode node) throws ParseError {
        while (this.getNextToken() != 12) {
        }
    }

    private void unexpectedInput() throws ParseError {
        throw new ParseError("Unexpected input '" + this.s_token_ + "'");
    }

    private void parseElement(SXPNode node) throws ParseError {
        String name = null;
        if (this.getNextToken() == 8) {
            name = this.s_token_;
        } else {
            this.unexpectedInput();
        }
        SXPElement element = new SXPElement(name);
        node.appendChild(element);
        block11: while (true) {
            switch (this.getNextToken()) {
                case 6: {
                    return;
                }
                case 5: {
                    break block11;
                }
                case 8: {
                    String attr_name = this.s_token_;
                    if (this.getNextToken() != 3) {
                        throw new ParseError("Missing '=' in attribute '" + attr_name + "'");
                    }
                    if (this.getNextToken() != 9) {
                        throw new ParseError("Missing value for attribute '" + attr_name + "'");
                    }
                    element.setAttribute(attr_name, this.s_token_);
                }
                default: {
                    continue block11;
                }
            }
            break;
        }
        this.getNextToken();
        this.parseDataOrElement(element, true);
        if (this.curr_token_ != 7) {
            throw new ParseError("Missing end element for '" + name + "'");
        }
        switch (this.getNextToken()) {
            case 8: {
                if (name.equals(this.s_token_)) break;
                if (node != null && node.getNodeName().equals(this.s_token_)) {
                    throw new ParseError("Missing end element for '" + name + "'");
                }
                throw new ParseError("'" + this.s_token_ + "' can't close element '" + name + "'");
            }
            default: {
                this.unexpectedInput();
            }
        }
        switch (this.getNextToken()) {
            case 5: {
                break;
            }
            default: {
                this.unexpectedInput();
            }
        }
    }

    private void parseProlog() throws ParseError {
        block13: while (true) {
            switch (this.getNextToken()) {
                case 0: {
                    return;
                }
                case 1: {
                    break block13;
                }
                case 10: {
                    continue block13;
                }
                case 4: {
                    return;
                }
                default: {
                    throw new ParseError("Missing XML prolog");
                }
            }
            break;
        }
        boolean was_encoding = false;
        block14: while (true) {
            int tk = this.getNextToken();
            switch (tk) {
                case 2: {
                    return;
                }
                case 0: 
                case 4: 
                case 5: 
                case 6: {
                    throw new ParseError("Missing end of XML prolog, got " + this.s_token_ + "'");
                }
                case 8: {
                    was_encoding = "encoding".equals(this.s_token_);
                    continue block14;
                }
                case 3: {
                    continue block14;
                }
                case 9: {
                    if (was_encoding) {
                        if (this.s_token_ != null && "UTF-8".equals(this.s_token_.toUpperCase())) {
                            this.utf8_encoding_ = true;
                        } else {
                            throw new ParseError("Unknown xml encoding '" + this.s_token_ + "'");
                        }
                    }
                    was_encoding = false;
                    continue block14;
                }
            }
            was_encoding = false;
        }
    }

    private void addToNextInput(int c, int line, int col) {
        if (this.next_input_ == null) {
            this.next_input_ = new int[10];
            this.next_line_ = new int[10];
            this.next_col_ = new int[10];
        } else if (this.next_input_len_ >= this.next_input_.length) {
            int size = 10 + this.next_input_len_;
            int[] ni = new int[size];
            System.arraycopy(this.next_input_, 0, ni, 0, this.next_input_len_);
            this.next_input_ = ni;
            ni = new int[size];
            System.arraycopy(this.next_line_, 0, ni, 0, this.next_input_len_);
            this.next_line_ = ni;
            ni = new int[size];
            System.arraycopy(this.next_col_, 0, ni, 0, this.next_input_len_);
            this.next_col_ = ni;
        }
        this.next_input_[this.next_input_len_] = c;
        this.next_line_[this.next_input_len_] = line;
        this.next_col_[this.next_input_len_] = col;
        ++this.next_input_len_;
    }

    private int readInputStream() throws IOException, ParseError {
        int r = this.input_.read();
        ++this.curr_col_;
        if (r == 10) {
            ++this.curr_line_;
            this.curr_col_ = 1;
        }
        if (this.utf8_encoding_ && r >= 128) {
            if ((r & 0xF0) == 224) {
                int r1 = this.input_.read();
                ++this.curr_col_;
                if ((r1 & 0xC0) != 128) {
                    throw new ParseError("Malformed UTF-8 second of 3-byte form haven't 10xx xxxx bit header");
                }
                int r2 = this.input_.read();
                ++this.curr_col_;
                if ((r2 & 0xC0) != 128) {
                    throw new ParseError("Malformed UTF-8 third of 3-byte form haven't 10xx xxxx bit header");
                }
                r &= 0xF;
                r = r << 12 | (r1 &= 0x3F) << 6 | (r2 &= 0x3F);
            } else if ((r & 0xE0) == 192) {
                int r1 = this.input_.read();
                ++this.curr_col_;
                if ((r1 & 0xC0) != 128) {
                    throw new ParseError("Malformed UTF-8 third of 2-byte form haven't 10xx xxxx bit header");
                }
                r &= 0x1F;
                r = r << 6 | (r1 &= 0x3F);
            } else {
                throw new ParseError("Malformed UTF-8 input, unknown bit header=" + Integer.toString(r, 16));
            }
        }
        return r;
    }

    private int readNextInput() throws IOException, ParseError {
        if (this.next_input_len_ == 0) {
            return this.readInputStream();
        }
        int r = this.next_input_[0];
        this.curr_line_ = this.next_line_[0];
        this.curr_col_ = this.next_col_[0];
        int j = 1;
        int i = 0;
        while (j < this.next_input_len_) {
            this.next_input_[i] = this.next_input_[j];
            this.next_line_[i] = this.next_line_[j];
            this.next_col_[i] = this.next_col_[j];
            ++i;
            ++j;
        }
        --this.next_input_len_;
        return r;
    }

    private int getNextToken() throws ParseError {
        this.curr_token_ = this.getNextToken0();
        return this.curr_token_;
    }

    private int readInput() throws ParseError {
        try {
            this.escaped_ = false;
            int r = this.readInputStream();
            switch (r) {
                case -1: {
                    return r;
                }
                case 38: {
                    r = this.readInputStream();
                    this.escaped_ = true;
                    switch (r) {
                        case -1: {
                            throw new ParseError("Unexpected end of input while parsing '&' character");
                        }
                        case 35: {
                            r = this.readInputStream();
                            switch (r) {
                                case -1: {
                                    throw new ParseError("Unexpected end of input while parsing '&' character");
                                }
                                case 120: {
                                    char c;
                                    int h = 0;
                                    while (true) {
                                        if ((r = this.readInputStream()) == -1) {
                                            throw new ParseError("Unexpected end of input while parsing '&' character");
                                        }
                                        c = Character.toUpperCase((char)r);
                                        if (c >= '0' && c <= '9') {
                                            h = 16 * h + c - 48;
                                            continue;
                                        }
                                        if (c < 'A' || c > 'F') break;
                                        h = 16 * h + c - 65 + 10;
                                    }
                                    if (c == ';') {
                                        return h;
                                    }
                                    throw new ParseError("Unexpected character '" + (char)r + "' while parsing &#x..;");
                                }
                            }
                            char c = (char)r;
                            if (c >= '0' && c <= '9') {
                                int d = c - 48;
                                while (true) {
                                    if ((r = this.readInputStream()) == -1) {
                                        throw new ParseError("Unexpected end of input while parsing '&' character");
                                    }
                                    c = (char)r;
                                    if (c < '0' || c > '9') break;
                                    d = 10 * d + c - 48;
                                }
                                if (c == ';') {
                                    return d;
                                }
                                throw new ParseError("Unexpected character '" + (char)r + "' while parsing &#x..;");
                            }
                            String name = "" + c;
                            while (true) {
                                if ((r = this.readInputStream()) == -1) {
                                    throw new ParseError("Unexpected end of input while parsing '&' character");
                                }
                                if (r == 59) break;
                                name = String.valueOf(name) + (char)r;
                            }
                            return this.characterEntity(name);
                        }
                    }
                }
            }
            return r;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ParseError("IOException during parsing");
        }
    }

    private int characterEntity(String name) throws ParseError {
        if ("lt".equals(name)) {
            return 60;
        }
        if ("gt".equals(name)) {
            return 60;
        }
        if ("amp".equals(name)) {
            return 38;
        }
        if ("apos".equals(name)) {
            return 39;
        }
        if ("quot".equals(name)) {
            return 34;
        }
        throw new ParseError("Unhandled character '&" + name + ";");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int getNextToken0() throws ParseError {
        if (this.state_ == 2) {
            throw new ParseError("Error occur but parse continue to parse.");
        }
        this.s_token_ = "";
        try {
            int r = this.readNextInput();
            if (r < 0) {
                return 0;
            }
            if (this.state_ == 1 || this.state_ == 1) {
                while (r == 32 || r == 10 || r == 9 || r == 13) {
                    r = this.readInputStream();
                    if (r != -1) continue;
                    throw new ParseError("Unexpected end of input stream");
                }
                if (r == 61) {
                    this.s_token_ = "=";
                    return 3;
                }
                if (r == 47) {
                    int rr = this.readInputStream();
                    switch (rr) {
                        case 62: {
                            this.s_token_ = "/>";
                            this.state_ = 0;
                            return 6;
                        }
                    }
                    throw new ParseError("Unexpected input '/" + (char)rr + "'");
                }
                if (r == 62) {
                    this.state_ = 0;
                    this.s_token_ = ">";
                    return 5;
                }
                if (r == 34) {
                    StringBuffer buf = new StringBuffer(512);
                    while (true) {
                        r = this.readInput();
                        switch (r) {
                            case 34: {
                                if (this.escaped_) {
                                    buf.append('\"');
                                } else {
                                    this.s_token_ = buf.toString();
                                    return 9;
                                }
                            }
                            case -1: {
                                throw new ParseError("Unexpected end of input stream");
                            }
                        }
                        buf.append((char)r);
                    }
                }
                if (r == 63) {
                    r = this.readInput();
                    switch (r) {
                        case -1: {
                            throw new ParseError("Unexpected end of input stream");
                        }
                        case 62: {
                            if (this.escaped_) {
                                this.s_token_ = "?" + (char)r;
                                throw new ParseError("Unexpected input '" + this.s_token_ + "'");
                            }
                            this.s_token_ = "?>";
                            this.state_ = 0;
                            return 2;
                        }
                    }
                    this.s_token_ = "?" + (char)r;
                    throw new ParseError("Unexpected input '" + this.s_token_ + "'");
                }
                StringBuffer buf = new StringBuffer(256);
                buf.append((char)r);
                while (true) {
                    r = this.readInputStream();
                    switch (r) {
                        case -1: {
                            throw new ParseError("Unexpected end of input stream");
                        }
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: 
                        case 34: 
                        case 47: 
                        case 61: 
                        case 62: {
                            this.addToNextInput(r, this.curr_line_, this.curr_col_);
                            this.s_token_ = buf.toString();
                            return 8;
                        }
                    }
                    buf.append((char)r);
                }
            }
            if (this.state_ == 3) {
                return this.readComment(r);
            }
            StringBuffer buf = new StringBuffer(1024);
            while (true) {
                if (r == 60 && !this.escaped_) {
                    if (buf.length() != 0) {
                        this.addToNextInput(60, this.curr_line_, this.curr_col_);
                        this.s_token_ = buf.toString();
                        return 10;
                    }
                    int rr = this.readInputStream();
                    int cl1 = this.curr_line_;
                    int cc1 = this.curr_col_;
                    this.state_ = 1;
                    switch (rr) {
                        case -1: {
                            throw new ParseError("Unexpected end of input stream");
                        }
                        case 63: {
                            this.s_token_ = "<?";
                            this.state_ = 1;
                            return 1;
                        }
                        case 47: {
                            this.s_token_ = "</";
                            return 7;
                        }
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            this.s_token_ = "<";
                            return 4;
                        }
                        case 33: {
                            rr = this.readInputStream();
                            int cl2 = this.curr_line_;
                            int cc2 = this.curr_col_;
                            switch (rr) {
                                case -1: {
                                    throw new ParseError("Unexpected end of input stream");
                                }
                                case 45: {
                                    rr = this.readInputStream();
                                    switch (rr) {
                                        case 45: {
                                            this.s_token_ = "<!--";
                                            this.state_ = 3;
                                            return 11;
                                        }
                                        case -1: {
                                            throw new ParseError("Unexpected end of input stream");
                                        }
                                    }
                                    throw new ParseError("Unexpected char '" + (char)rr + "' while starting comment");
                                }
                            }
                            this.addToNextInput(33, cl1, cc1);
                            this.addToNextInput(rr, cl2, cc2);
                            this.s_token_ = "<";
                            return 4;
                        }
                    }
                    this.addToNextInput(rr, cl1, cc1);
                    this.s_token_ = "<";
                    return 4;
                }
                if (r == -1) {
                    if (buf.length() > 0) {
                        this.addToNextInput(r, this.curr_line_, this.curr_col_);
                        this.s_token_ = buf.toString();
                        return 10;
                    }
                    return 0;
                }
                buf.append((char)r);
                r = this.readInput();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ParseError("IOException during parsing");
        }
    }

    private int readComment(int r) throws ParseError {
        block16: {
            if (this.end_comment_parsed_) {
                this.s_token_ = "-->";
                this.state_ = 0;
                this.end_comment_parsed_ = false;
                return 12;
            }
            try {
                StringBuffer buf = new StringBuffer(1024);
                switch (r) {
                    case -1: {
                        throw new ParseError("Unexpected end of input stream");
                    }
                    default: {
                        buf.append((char)r);
                    }
                    case 45: 
                }
                r = this.readNextInput();
                switch (r) {
                    case -1: {
                        throw new ParseError("Unexpected end of input stream");
                    }
                    default: {
                        buf.append('-');
                        buf.append((char)r);
                    }
                    case 45: 
                }
                r = this.readNextInput();
                switch (r) {
                    case -1: {
                        throw new ParseError("Unexpected end of input stream");
                    }
                    default: {
                        buf.append('-');
                        buf.append('-');
                        buf.append((char)r);
                    }
                    case 62: 
                }
                if (buf.length() <= 0) break block16;
                this.end_comment_parsed_ = true;
                this.s_token_ = buf.toString();
                return 10;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ParseError("IOException during parsing");
            }
        }
        this.s_token_ = "-->";
        this.state_ = 0;
        return 12;
    }

    public Collection getDiagnostics() {
        return null;
    }

    private class ParseError
    extends Exception {
        private static final long serialVersionUID = 1L;
        public int line;
        public int column;

        public ParseError(String msg) {
            super(String.valueOf(Integer.toString(SimpleXmlParser.this.curr_line_)) + ":" + Integer.toString(SimpleXmlParser.this.curr_col_) + ": " + msg);
            this.line = SimpleXmlParser.this.curr_line_;
            this.column = SimpleXmlParser.this.curr_col_;
        }
    }
}

