/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.tools.internal;

import com.ibm.icu.util.Calendar;
import org.eclipse.tptp.platform.report.core.internal.IDStringSerializable;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlReader;
import org.eclipse.tptp.platform.report.drivers.xml.internal.IDXmlSerializable;
import org.w3c.dom.Node;

public class CalendarField
implements IDXmlSerializable,
IDStringSerializable {
    Calendar calendar = Calendar.getInstance();
    private int[] fields_ = new int[this.calendar.getFieldCount()];
    private boolean[] set_ = new boolean[this.calendar.getFieldCount()];

    public CalendarField() {
        this.reset();
    }

    public CalendarField(int _field, int _value) {
        this.reset();
        this.set(_field, _value);
    }

    public void reset() {
        int i = 0;
        while (i < this.fields_.length) {
            this.set_[i] = false;
            ++i;
        }
    }

    public void set(int _field, int _value) {
        this.fields_[_field] = _value;
        this.set_[_field] = true;
    }

    public int get(int _field) {
        return this.fields_[_field];
    }

    public boolean isSet(int _field) {
        return this.set_[_field];
    }

    public void unset(int _field) {
        this.set_[_field] = false;
    }

    public static String FieldName(int _field) {
        if (_field == 1) {
            return "YEAR";
        }
        if (_field == 2) {
            return "MONTH";
        }
        if (_field == 16) {
            return "DST_OFFSET";
        }
        if (_field == 5) {
            return "DAY_OF_MONTH";
        }
        if (_field == 14) {
            return "MILLISECOND";
        }
        if (_field == 13) {
            return "SECOND";
        }
        if (_field == 8) {
            return "DAY_OF_WEEK_IN_MONTHDAY";
        }
        if (_field == 6) {
            return "DAY_OF_YEAR";
        }
        if (_field == 7) {
            return "DAY_OF_WEEK";
        }
        if (_field == 0) {
            return "ERA";
        }
        if (_field == 9) {
            return "AM_PM";
        }
        if (_field == 10) {
            return "HOUR";
        }
        if (_field == 11) {
            return "HOUR_OF_DAY";
        }
        if (_field == 4) {
            return "WEEK_OF_MONTH";
        }
        if (_field == 3) {
            return "WEEK_OF_YEAR";
        }
        if (_field == 15) {
            return "ZONE_OFFSET";
        }
        return Integer.toString(_field);
    }

    public static String getFieldName(int _field) {
        if (_field == 1) {
            return "year";
        }
        if (_field == 2) {
            return "month";
        }
        if (_field == 16) {
            return "dst_offset";
        }
        if (_field == 5) {
            return "day of month";
        }
        if (_field == 14) {
            return "ms";
        }
        if (_field == 13) {
            return "s";
        }
        if (_field == 8) {
            return "day of week in monthday";
        }
        if (_field == 6) {
            return "day of year";
        }
        if (_field == 7) {
            return "day of week";
        }
        if (_field == 0) {
            return "era";
        }
        if (_field == 9) {
            return "am pm";
        }
        if (_field == 10) {
            return "h";
        }
        if (_field == 11) {
            return "hour of day";
        }
        if (_field == 4) {
            return "week of month";
        }
        if (_field == 3) {
            return "week of year";
        }
        if (_field == 15) {
            return "zone offset";
        }
        return Integer.toString(_field);
    }

    public static int getFieldIndex(String name) {
        if ("year".equals(name)) {
            return 1;
        }
        if ("month".equals(name)) {
            return 2;
        }
        if ("dst_offset".equals(name)) {
            return 16;
        }
        if ("day of month".equals(name)) {
            return 5;
        }
        if ("ms".equals(name)) {
            return 14;
        }
        if ("s".equals(name)) {
            return 13;
        }
        if ("day of week in monthday".equals(name)) {
            return 8;
        }
        if ("day of year".equals(name)) {
            return 6;
        }
        if ("day of week".equals(name)) {
            return 7;
        }
        if ("era".equals(name)) {
            return 0;
        }
        if ("am pm".equals(name)) {
            return 9;
        }
        if ("h".equals(name)) {
            return 10;
        }
        if ("hour of day".equals(name)) {
            return 11;
        }
        if ("week of month".equals(name)) {
            return 4;
        }
        if ("week of year".equals(name)) {
            return 3;
        }
        if ("zone offset".equals(name)) {
            return 15;
        }
        return -1;
    }

    public String writeXml() {
        String xml = null;
        int i = 0;
        while (i < this.fields_.length) {
            xml = xml != null ? String.valueOf(xml) + "," : "";
            if (this.set_[i]) {
                xml = String.valueOf(xml) + Integer.toString(this.fields_[i]);
            }
            ++i;
        }
        return xml;
    }

    public void readXml(Node node) {
        this.reset();
        String s = DXmlReader.getNodeText(node);
        if (s == null) {
            return;
        }
        String[] f = s.split(",");
        int i = 0;
        while (i < f.length) {
            if (f[i].length() > 0) {
                try {
                    this.fields_[i] = Integer.parseInt(f[i]);
                    this.set_[i] = true;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++i;
        }
    }

    public String serializeToString() {
        String ret = "";
        int i = 0;
        while (i < this.fields_.length) {
            if (ret.length() > 0 && this.set_[i]) {
                ret = String.valueOf(ret) + ",";
            }
            if (this.set_[i]) {
                ret = String.valueOf(ret) + CalendarField.getFieldName(i) + ", " + Integer.toString(this.fields_[i]);
            }
            ++i;
        }
        return ret;
    }

    public void serializeFromString(String s) {
        if (s == null) {
            return;
        }
        String[] f = s.split(",");
        int i = 0;
        while (i < f.length) {
            int index;
            if (f[i].length() > 0 && i + 1 < f.length && (index = CalendarField.getFieldIndex(f[i])) != -1) {
                try {
                    this.fields_[index] = Integer.parseInt(f[i + 1].trim());
                    this.set_[index] = true;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++i;
        }
    }
}

