/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.tools.internal;

import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlReader;
import org.eclipse.tptp.platform.report.tools.internal.DAlignment;
import org.w3c.dom.Node;

public class DAlignmentPair
extends DAlignment {
    int aln_secondary_;

    public DAlignmentPair() {
        this.setSecondaryAlignment(9);
    }

    public DAlignmentPair(int _align) {
        super(_align);
        this.setSecondaryAlignment(9);
    }

    public DAlignmentPair(int _align, int _secondary_alignment) {
        super(_align);
        this.setSecondaryAlignment(_secondary_alignment);
    }

    public DAlignmentPair(DAlignmentPair p) {
        super(p);
        this.setSecondaryAlignment(p.getSecondaryAlignment());
    }

    public int getSecondaryAlignment() {
        return this.aln_secondary_;
    }

    public boolean haveSecondaryAlignment(int _alignment) {
        return (this.getSecondaryAlignment() & _alignment) == _alignment;
    }

    public void setSecondaryAlignment(int _alignment) {
        this.aln_secondary_ = _alignment;
    }

    public void addSecondaryAlignment(int _alignment) {
        this.aln_secondary_ |= _alignment;
    }

    public void removeSecondaryAlignment(int _alignment) {
        this.aln_secondary_ &= ~_alignment;
    }

    public String writeXml() {
        String primary = DAlignment.AlignmentToString(this.getAlignment());
        String secondary = DAlignment.AlignmentToString(this.getSecondaryAlignment());
        if (primary == null) {
            primary = "";
        }
        if (secondary == null) {
            secondary = "";
        }
        return String.valueOf(primary) + "/" + secondary;
    }

    public void readXml(Node node) {
        String s = DXmlReader.getNodeText(node);
        String[] vs = s.split("/");
        if (vs.length >= 1) {
            this.setAlignment(DAlignmentPair.StringToAlignment(vs[0]));
        } else {
            this.setAlignment(9);
        }
        if (vs.length >= 2) {
            this.setSecondaryAlignment(DAlignmentPair.StringToAlignment(vs[1]));
        } else {
            this.setSecondaryAlignment(9);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DAlignmentPair)) {
            return false;
        }
        DAlignmentPair op = (DAlignmentPair)o;
        if (op.getAlignment() != this.getAlignment()) {
            return false;
        }
        return op.getSecondaryAlignment() == this.getSecondaryAlignment();
    }
}

