/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.tools.internal;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UFormat;
import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.tptp.platform.report.chart.internal.MinMax;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DefaultResources;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCategory;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DCoord;
import org.eclipse.tptp.platform.report.core.internal.DCoordObject;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DFont;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DI18N;
import org.eclipse.tptp.platform.report.core.internal.DMarkerLine;
import org.eclipse.tptp.platform.report.core.internal.DPalettes;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DPropertyStore;
import org.eclipse.tptp.platform.report.core.internal.DShapes;
import org.eclipse.tptp.platform.report.core.internal.DStyle;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.DSymbolRegistry;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.tools.internal.DAlignment;
import org.eclipse.tptp.platform.report.tools.internal.DParser;
import org.eclipse.tptp.platform.report.tools.internal.IPalette;
import org.eclipse.tptp.platform.report.tools.internal.Palette;

public class DChartTranslator
extends DParser {
    String[] symbols = new String[5];
    private DStyleRegistry styles = new DStyleRegistry();
    DColor white = new DColor(255, 255, 255);
    DColor black = new DColor(0, 0, 0);
    DFont chartFont = new DFont("Arial", null, 14, 0);
    DFont axisFont = new DFont("Arial", null, 8, 0);
    DFont curveFont = new DFont("Arial", null, 8, 0);
    private int nbcolor = 0;
    private int lastColor = 0;

    private void copyProperties(DPropertyStore src, DPropertyStore dest) {
        Map msrc = src.elements();
        dest.elements();
        if (msrc == null) {
            return;
        }
        Set keys = msrc.keySet();
        for (String key : keys) {
            dest.store(key, msrc.get(key));
        }
    }

    public DGraphic translate(DGraphic graph) {
        ULocale locale;
        this.symbols[0] = DSymbolRegistry.GetOval().getId();
        this.symbols[1] = DSymbolRegistry.GetDiamond().getId();
        this.symbols[2] = DSymbolRegistry.GetSquare().getId();
        this.symbols[3] = DSymbolRegistry.GetStar().getId();
        this.symbols[4] = DSymbolRegistry.GetHexagon().getId();
        this.styles.putStyle(new DStyle("Chart", this.chartFont, this.black, this.white));
        this.styles.putStyle(new DStyle("Axis", this.axisFont, this.black, this.white));
        if (graph.getStyle() == null) {
            graph.setStyle(this.styles.getFirstStyle("Chart"));
        }
        DefaultResources resources = new DefaultResources();
        String ctype = graph.getGraphicType();
        DGraphic chart = new DGraphic();
        DI18N i18n = (DI18N)graph.getChildOfClass(DI18N.class);
        if (i18n != null) {
            locale = new ULocale(i18n.getLanguage(), i18n.getCountry());
            DI18N ni18n = new DI18N();
            ni18n.setCountry(i18n.getCountry());
            ni18n.setLanguage(i18n.getLanguage());
            ni18n.setTextDirection(i18n.getTextDirection());
            ni18n.setTimeZone(i18n.getTimeZone());
            ni18n.setResourceBundle(i18n.getResourceBundle());
            chart.addChild(ni18n);
        } else {
            locale = ULocale.getDefault();
        }
        chart.setHeightScale(graph.getHeightScale());
        chart.setWidthScale(graph.getWidthScale());
        this.copyProperties(graph.getProperties(), chart.getProperties());
        chart.setStyle(graph.getStyle());
        chart.setTitle(graph.getTitle());
        Arg arg = new Arg();
        arg.graph = graph;
        arg.chart = chart;
        arg.ctype = ctype;
        arg.locale = locale;
        arg.palettes = new SVGColorPalettes(resources, arg.locale);
        this.initPalette(resources.getResourceDir(), resources.getDefaultPalettesId(), resources.getDefaultPaletteSetId().toString(), arg);
        if ("pie".equals(ctype)) {
            chart.setRenderableId("T_SECTORS.DGraphic.core.jscrib");
            arg.nbaxes = 1;
        } else if ("pie3D".equals(ctype)) {
            chart.setRenderableId("T_SECTORS3D.DGraphic.core.jscrib");
            arg.nbaxes = 1;
        } else if ("3Dpie".equals(ctype)) {
            chart.setRenderableId("T_PIE3D.DGraphic.core.jscrib");
            arg.nbaxes = 1;
        } else if ("xy".equals(ctype) || "line".equals(ctype)) {
            chart.setRenderableId("T_XY.DGraphic.core.jscrib");
            arg.nbaxes = 2;
        } else if ("horizontalBar".equals(ctype)) {
            chart.setRenderableId("T_H_HISTOGRAM_IM.DGraphic.core.jscrib");
            chart.getProperties().store("P_THIN_BAR.DGraphic.core.jscrib", true);
            arg.nbaxes = 1;
        } else if ("verticalBar".equals(ctype)) {
            chart.setRenderableId("T_HISTOGRAM_IM.DGraphic.core.jscrib");
            chart.getProperties().store("P_THIN_BAR.DGraphic.core.jscrib", true);
            arg.nbaxes = 1;
        } else if ("horizontalBar3D".equals(ctype)) {
            chart.setRenderableId("T_H_HISTOGRAM_IM.DGraphic.core.jscrib");
            chart.getProperties().store("P_3D.DGraphic.core.jscrib", true);
            chart.getProperties().store("P_THIN_BAR.DGraphic.core.jscrib", true);
            arg.nbaxes = 1;
        } else if ("verticalBar3D".equals(ctype)) {
            chart.setRenderableId("T_HISTOGRAM_IM.DGraphic.core.jscrib");
            chart.getProperties().store("P_3D.DGraphic.core.jscrib", true);
            chart.getProperties().store("P_THIN_BAR.DGraphic.core.jscrib", true);
            arg.nbaxes = 1;
        } else if ("horizontalStackedBar".equals(ctype)) {
            chart.setRenderableId("T_H_STACKBARS.DGraphic.core.jscrib");
            chart.getProperties().store("P_THIN_BAR.DGraphic.core.jscrib", true);
            arg.nbaxes = 1;
            arg.split_in_curve = false;
        } else if ("verticalStackedBar".equals(ctype)) {
            chart.setRenderableId("T_STACKBARS.DGraphic.core.jscrib");
            chart.getProperties().store("P_THIN_BAR.DGraphic.core.jscrib", true);
            arg.nbaxes = 1;
            arg.split_in_curve = false;
        } else if ("horizontalStackedBar3D".equals(ctype)) {
            chart.setRenderableId("T_H_STACKBARS.DGraphic.core.jscrib");
            chart.getProperties().store("P_3D.DGraphic.core.jscrib", true);
            chart.getProperties().store("P_THIN_BAR.DGraphic.core.jscrib", true);
            arg.nbaxes = 1;
            arg.split_in_curve = false;
        } else if ("verticalStackedBar3D".equals(ctype)) {
            chart.setRenderableId("T_STACKBARS.DGraphic.core.jscrib");
            chart.getProperties().store("P_3D.DGraphic.core.jscrib", true);
            chart.getProperties().store("P_THIN_BAR.DGraphic.core.jscrib", true);
            arg.nbaxes = 1;
            arg.split_in_curve = false;
        } else if ("meter".equals(ctype)) {
            chart.setRenderableId("T_METER.DGraphic.core.jscrib");
            arg.nbaxes = 1;
            if (!graph.getProperties().hasKey("P_UNIT_FORMAT.DAxis.core.jscrib")) {
                NumberFormat number = DecimalFormat.getIntegerInstance((ULocale)locale);
                number.setMaximumIntegerDigits(1);
                chart.getProperties().store("P_UNIT_FORMAT.DAxis.core.jscrib", number);
            }
        } else if ("xysurface".equals(ctype)) {
            chart.setRenderableId("T_XY_SURFACE.DGraphic.core.jscrib");
            arg.nbaxes = 2;
        } else if ("3Dtorus".equals(ctype)) {
            chart.setRenderableId("T_TORUS3D.DGraphic.core.jscrib");
        } else if ("xyz".equals(ctype)) {
            chart.setRenderableId("T_XYZ.DGraphic.core.jscrib");
        } else if ("wireframe".equals(ctype)) {
            chart.setRenderableId("T_WIREFRAME.DGraphic.core.jscrib");
        } else if ("radar".equals(ctype)) {
            chart.setRenderableId("T_HISTORS.DGraphic.core.jscrib");
        } else if ("3Dseries".equals(ctype)) {
            chart.setRenderableId("T_SERIES3D.DGraphic.core.jscrib");
        } else if ("area".equals(ctype) || "stackedArea".equals(ctype)) {
            chart.setRenderableId("T_XY.DGraphic.core.jscrib");
            arg.nbaxes = 2;
        } else if ("scatter".equals(ctype)) {
            chart.setRenderableId("T_XY.DGraphic.core.jscrib");
            arg.nbaxes = 2;
        } else {
            return graph;
        }
        IDItem c = graph.getFirstChild();
        while (c != null) {
            if (c instanceof DPalettes) {
                this.invokeDoMethod(c, this, arg);
            }
            c = c.getNext();
        }
        c = graph.getFirstChild();
        while (c != null) {
            if (c instanceof DAxis) {
                this.invokeDoMethod(c, this, arg);
            }
            c = c.getNext();
        }
        this.nbcolor = graph.getChildrenOfClass(DCurve.class).size();
        c = graph.getFirstChild();
        while (c != null) {
            if (!(c instanceof DAxis)) {
                this.invokeDoMethod(c, this, arg);
            }
            c = c.getNext();
        }
        if ("meter".equals(arg.ctype)) {
            Iterator<Object> it = arg.markers.iterator();
            TreeMap<Object, DMarkerLine> tm = new TreeMap<Object, DMarkerLine>();
            while (it.hasNext()) {
                DMarkerLine ml = (DMarkerLine)it.next();
                tm.put(ml.getValue(), ml);
            }
            it = tm.values().iterator();
            int i = 0;
            double max = 0.0;
            arg.chart.getLastChild();
            while (it.hasNext()) {
                DMarkerLine ml = (DMarkerLine)it.next();
                DCurve curve = new DCurve();
                curve.setName(ml.getLabel());
                DStyle s = new DStyle();
                if (ml.getColor() != null) {
                    s.setBackColor(ml.getColor());
                } else {
                    s.setBackColor(arg.palette.getColor((i + 1) % arg.palette.getNumColors()));
                }
                s.setFont(this.curveFont);
                curve.setStyle(s);
                DPoint p = new DPoint();
                curve.addChild(p);
                p.addChild(new DCoord(((Axis)arg.axes.get((Object)"y")).axis, (Double)ml.getValue()));
                max = Math.max(max, (Double)ml.getValue());
                arg.chart.addChild(curve);
            }
            DAxis ax = ((Axis)arg.axes.get((Object)"y")).axis;
            if (!ax.getProperties().hasKey("P_MAX.DAxis.core.jscrib") && tm.values().size() > 0) {
                ax.getProperties().store("P_MAX.DAxis.core.jscrib", max);
            }
        }
        this.checkGraphic(chart, arg);
        this.computeMajorAndMinorUnit(chart, arg);
        return chart;
    }

    private void calculateMinMax(DAxis ax, Arg arg) {
        if ("stackedArea".equals(arg.ctype)) {
            this.calculateStackedAreaMinMax(ax, arg);
        } else if ("verticalStackedBar".equals(arg.ctype) || "verticalStackedBar3D".equals(arg.ctype) || "horizontalStackedBar".equals(arg.ctype) || "horizontalStackedBar3D".equals(arg.ctype)) {
            this.calculateStackedBarMinMax(ax, arg);
        } else {
            arg.v_max = arg.minmax_y(ax.getName()).getVMax();
            arg.v_min = arg.minmax_y(ax.getName()).getVMin();
        }
    }

    private Object getMax(DAxis ax, Arg arg) {
        if ("stackedArea".equals(arg.ctype)) {
            return arg.minmax_y(ax.getName()).getVMax();
        }
        if ("verticalStackedBar".equals(arg.ctype) || "verticalStackedBar3D".equals(arg.ctype) || "horizontalStackedBar".equals(arg.ctype) || "horizontalStackedBar3D".equals(arg.ctype)) {
            return arg.minmax_y(ax.getName()).getVMax();
        }
        return arg.minmax_y(ax.getName()).getVMax();
    }

    private Object getMin(DAxis ax, Arg arg) {
        if ("stackedArea".equals(arg.ctype)) {
            return arg.minmax_y(ax.getName()).getVMin();
        }
        if ("verticalStackedBar".equals(arg.ctype) || "verticalStackedBar3D".equals(arg.ctype) || "horizontalStackedBar".equals(arg.ctype) || "horizontalStackedBar3D".equals(arg.ctype)) {
            return arg.minmax_y(ax.getName()).getVMin();
        }
        return arg.minmax_y(ax.getName()).getVMin();
    }

    private void computeMajorAndMinorUnit(DGraphic graph, Arg arg) {
        IDItem c = graph.getFirstChild();
        while (c != null) {
            if (c instanceof DAxis) {
                DAxis ax = (DAxis)c;
                if (ax.getProperties().hasKey("P_MAX.DAxis.core.jscrib")) {
                    ax.getProperties().hasKey("P_MIN.DAxis.core.jscrib");
                }
                if (this.isContinueAxis(ax, arg)) {
                    this.calculateMinMax(ax, arg);
                    Object maxo = null;
                    maxo = ax.getProperties().hasKey("P_MAX.DAxis.core.jscrib") ? ax.getProperties().get("P_MAX.DAxis.core.jscrib") : arg.v_max;
                    Object mino = null;
                    mino = ax.getProperties().hasKey("P_MIN.DAxis.core.jscrib") ? ax.getProperties().get("P_MIN.DAxis.core.jscrib") : arg.v_min;
                    if (maxo == null) {
                        maxo = new Double(1.0);
                    }
                    if (mino == null) {
                        mino = new Double(0.0);
                    }
                    boolean isLinear = ax.getScaleType().equals("S_LIN.DAxis.core.jscrib");
                    if (mino instanceof Double && maxo instanceof Double) {
                        boolean showGrid;
                        boolean showTick;
                        double min;
                        double max = (Double)maxo;
                        if (max == (min = ((Double)mino).doubleValue())) {
                            max += 1.0;
                            min -= 1.0;
                        }
                        boolean findOrderOfMagnitude = !ax.getProperties().hasKey("P_MAJUNIT_VALUE.DAxis.core.jscrib") && !ax.getProperties().hasKey("P_MINUNIT_VALUE.DAxis.core.jscrib");
                        double orderOfMagnitude = 1.0;
                        if (findOrderOfMagnitude) {
                            orderOfMagnitude = this.getOrderOfMagnitude(max, min);
                        }
                        double majorUnit = ax.getProperties().get("P_MAJUNIT_VALUE.DAxis.core.jscrib", 1.0);
                        double minorUnit = ax.getProperties().get("P_MINUNIT_VALUE.DAxis.core.jscrib", 1.0);
                        if (!ax.getProperties().hasKey("P_MAJUNIT_VALUE.DAxis.core.jscrib")) {
                            majorUnit = (max - min) / orderOfMagnitude > 5.0 ? orderOfMagnitude * 2.0 : orderOfMagnitude;
                        }
                        if (!ax.getProperties().hasKey("P_MINUNIT_VALUE.DAxis.core.jscrib")) {
                            minorUnit = majorUnit / 2.0;
                        }
                        if (isLinear) {
                            if (!ax.getProperties().hasKey("P_MAX.DAxis.core.jscrib")) {
                                max = max < 0.0 ? 0.0 : Math.floor(max / majorUnit) * majorUnit + majorUnit;
                            }
                            if (!ax.getProperties().hasKey("P_MIN.DAxis.core.jscrib")) {
                                min = min >= 0.0 ? 0.0 : (Math.floor(Math.abs(min) / majorUnit) * majorUnit + majorUnit) * -1.0;
                            }
                        } else {
                            if (!ax.getProperties().hasKey("P_MAX.DAxis.core.jscrib")) {
                                max = Math.round(this.getOrderOfMagnitude(max) * 10.0);
                            }
                            if (!ax.getProperties().hasKey("P_MIN.DAxis.core.jscrib")) {
                                min = this.getOrderOfMagnitude(min) / 10.0;
                            }
                        }
                        if (max < min) {
                            double tmp = max;
                            max = min;
                            min = tmp;
                        }
                        Object majorUnitValueo = ax.getProperties().get("P_MAJUNIT_VALUE.DAxis.core.jscrib", new Double(majorUnit));
                        Object minorUnitValueo = ax.getProperties().get("P_MINUNIT_VALUE.DAxis.core.jscrib", new Double(minorUnit));
                        double step_unit = (Double)majorUnitValueo;
                        double step_line = (Double)minorUnitValueo;
                        if (!ax.getProperties().hasKey("P_MAX.DAxis.core.jscrib")) {
                            ax.getProperties().store("P_MAX.DAxis.core.jscrib", max);
                        }
                        if (!ax.getProperties().hasKey("P_MIN.DAxis.core.jscrib")) {
                            ax.getProperties().store("P_MIN.DAxis.core.jscrib", min);
                        }
                        if ((showTick = ax.getProperties().get("P_MAJUNIT_SHOW_TICK.DAxis.core.jscrib", true)) && step_unit > 0.0) {
                            ax.getProperties().store("P_STEP_UNIT.DAxis.core.jscrib", step_unit);
                        }
                        if ((showGrid = ax.getProperties().get("P_MAJUNIT_SHOWGRID.DAxis.core.jscrib", true)) && step_unit > 0.0) {
                            ax.getProperties().store("P_STEP_LINE.DAxis.core.jscrib", step_line);
                        }
                    }
                }
            }
            c = c.getNext();
        }
    }

    public void doMethod(DPalettes pal, DExtensible ext, Object the_arg) {
        Arg arg = (Arg)the_arg;
        this.initPalette(pal.getLocation(), pal.getPaletteId(), pal.getPaletteSetId(), arg);
    }

    private void initPalette(String loc, String pId, String psetId, Arg arg) {
        arg.palettes.setCustomPalettes(loc, pId, psetId);
        int[] pal = new int[arg.palettes.getPalette().length];
        int i = 0;
        while (i < arg.palettes.getPalette().length) {
            DColor c = new DColor();
            c.serializeFromString(arg.palettes.getPalette()[i]);
            pal[i] = c.getRGBA() >> 8;
            ++i;
        }
        arg.palette = new Palette(pal);
    }

    public void doMethod(DAxis ax, DExtensible ext, Object the_arg) {
        Arg arg = (Arg)the_arg;
        if (ax.getStyle() == null) {
            ax.setStyle(this.styles.getFirstStyle("Axis"));
        }
        arg.current_axis = new Axis();
        arg.current_axis.axis = new DAxis(ax.getName());
        arg.current_axis.axis.setStyle(ax.getStyle());
        this.nbcolor = ax.getChildCount();
        this.doChildrenItem(ax, this, arg);
        this.copyProperties(ax.getProperties(), arg.current_axis.axis.getProperties());
        String val = arg.current_axis.axis.getProperties().get("P_LABEL_ROTATION.DAxis.core.jscrib", "zeroDegree");
        if ("minusNinetyDegrees".equals(val)) {
            arg.current_axis.axis.getProperties().store("P_LABEL_ALIGNMENT.DAxis.core.jscrib", new DAlignment(128));
        } else if ("plusNinetyDegrees".equals(val)) {
            arg.current_axis.axis.getProperties().store("P_LABEL_ALIGNMENT.DAxis.core.jscrib", new DAlignment(128));
        }
        arg.current_axis.axis.setScaleType(ax.getScaleType());
        arg.current_axis.axis.setTitle(ax.getTitle());
        arg.current_axis.axis.setTooltip(ax.getTooltip());
        arg.current_axis.axis.setUnit(ax.getUnit());
        arg.axes.put(arg.current_axis.axis.getName(), arg.current_axis);
        if (arg.current_axis.categories.size() > 0) {
            arg.current_axis.axis.getProperties().store("P_MAX.DAxis.core.jscrib", arg.current_axis.categories.size() + 1);
            arg.current_axis.axis.getProperties().store("P_MIN.DAxis.core.jscrib", 0);
        }
        if (arg.nbaxes == 1 && arg.current_axis.categories.size() == 0) {
            arg.chart.addChild(arg.current_axis.axis);
        } else if (arg.nbaxes == 2) {
            arg.chart.addChild(arg.current_axis.axis);
        }
        boolean showTick = ax.getProperties().get("P_MAJUNIT_SHOW_TICK.DAxis.core.jscrib", true);
        if (arg.current_axis.categories.size() > 0 && showTick) {
            ax.getProperties().store("P_STEP_UNIT.DAxis.core.jscrib", 1.0);
        }
        if (this.isContinueAxis(ax, arg)) {
            arg.minmax_ys.put(ax.getName(), new MinMax(arg.current_axis.axis));
        } else if (showTick) {
            arg.current_axis.axis.getProperties().store("P_STEP_UNIT.DAxis.core.jscrib", 1);
        }
    }

    public void doMethod(DCategory cat, DExtensible ext, Object the_arg) {
        Arg arg = (Arg)the_arg;
        arg.current_axis.categories.put(cat.getId(), new Double(arg.current_axis.categories.size() + 1));
        arg.curveNames.put(cat.getId(), cat.getLabel());
        DCategory categ = new DCategory();
        categ.setId(cat.getId());
        categ.setLabel(cat.getLabel());
        arg.current_axis.axis.addChild(categ);
    }

    public void doMethod(DCurve curve, DExtensible ext, Object the_arg) {
        Arg arg = (Arg)the_arg;
        IDColor color = (IDColor)curve.getProperties().get("P_COLOR.DCurve.core.jscrib");
        if (color == null) {
            color = arg.palette.getColor(this.lastColor);
        }
        DStyle sty = new DStyle();
        sty.setFont(this.curveFont);
        sty.setForeColor(this.black);
        if (!"meter".equals(arg.ctype)) {
            sty.setBackColor(color);
        } else {
            ((Axis)arg.axes.get((Object)"y")).axis.setTitle(curve.getName());
        }
        arg.current_style = sty;
        DCurve c = new DCurve();
        c.setName(curve.getName());
        c.setTooltip(curve.getTooltip());
        c.setStyle(curve.getStyle());
        DShapes shapes = (DShapes)arg.graph.getChildOfClass(DShapes.class);
        boolean showShape = true;
        if (shapes != null) {
            showShape = shapes.isShow();
        }
        this.copyProperties(curve.getProperties(), c.getProperties());
        if ("area".equals(arg.ctype)) {
            c.getProperties().store("SYMBOL.DCurve.core.jscrib", this.symbols[this.lastColor % 5]);
            if (showShape) {
                c.setType("AREA_LINE_POINTS.DCurve.core.jscrib");
            } else {
                c.setType("AREA_LINE.DCurve.core.jscrib");
            }
        } else if ("scatter".equals(arg.ctype)) {
            c.getProperties().store("SYMBOL.DCurve.core.jscrib", this.symbols[this.lastColor % 5]);
            c.setType("POINT.DCurve.core.jscrib");
        } else if ("line".equals(arg.ctype)) {
            c.getProperties().store("SYMBOL.DCurve.core.jscrib", this.symbols[this.lastColor % 5]);
            if (showShape) {
                c.setType("LINE_POINT.DCurve.core.jscrib");
            } else {
                c.setType("LINE.DCurve.core.jscrib");
            }
        } else if ("stackedArea".equals(arg.ctype)) {
            c.getProperties().store("SYMBOL.DCurve.core.jscrib", this.symbols[this.lastColor % 5]);
            if (showShape) {
                c.setType("STACKED_AREA_LINE_POINTS.DCurve.core.jscrib");
            } else {
                c.setType("STACKED_AREA_LINE.DCurve.core.jscrib");
            }
        }
        arg.chart.addChild(c);
        arg.curves.add(c);
        arg.current_curve = c;
        if ("pie".equals(arg.ctype) || "pie3D".equals(arg.ctype)) {
            IDItem ci = curve.getFirstChild();
            while (ci != null) {
                if (ci instanceof DPoint) {
                    IDItem ci2 = ((DPoint)ci).getFirstChild();
                    while (ci2 != null) {
                        if (ci2 instanceof DCoord) {
                            arg.total += ((DCoord)ci2).getValue();
                        }
                        ci2 = ci2.getNext();
                    }
                }
                ci = ci.getNext();
            }
        }
        ++this.lastColor;
        this.doChildrenItem(curve, this, arg);
    }

    public void doMethod(DMarkerLine ml, DExtensible ext, Object the_arg) {
        Arg arg = (Arg)the_arg;
        DMarkerLine ml2 = new DMarkerLine();
        ml2.setColor(ml.getColor());
        ml2.setId(ml.getId());
        ml2.setLabel(ml.getLabel());
        ml2.setStyle(ml.getStyle());
        ml2.setThickness(ml.getThickness());
        ml2.setValue(ml.getValue());
        arg.current_axis.axis.addChild(ml2);
        arg.markers.add(ml2);
    }

    public void doMethod(DPoint point, DExtensible ext, Object the_arg) {
        Arg arg = (Arg)the_arg;
        DPoint p = new DPoint();
        p.setId(point.getId());
        p.setTooltip(point.getTooltip());
        p.setType(point.getType());
        p.setStyle(point.getStyle());
        arg.current_point = p;
        this.doChildrenItem(point, this, arg);
        arg.current_curve.addChild(p);
        if (arg.current_curve.getStyle() == null) {
            arg.current_curve.setStyle(arg.current_style);
        }
    }

    boolean isContinueAxis(DAxis ax, Arg arg) {
        return ((Axis)arg.axes.get((Object)ax.getName())).categories != null && ((Axis)arg.axes.get((Object)ax.getName())).categories.size() == 0;
    }

    public void doMethod(DCoord coord, DExtensible ext, Object the_arg) {
        Arg arg = (Arg)the_arg;
        DCoord co = new DCoord();
        co.setValue(coord.getValue());
        Axis ax = (Axis)arg.axes.get(coord.getAxis().getName());
        if (ax == null) {
            System.err.println("the axis '" + coord.getAxis().getName() + "' not registred");
            throw new Error();
        }
        co.setAxis(ax.axis);
        co.setStyle(coord.getStyle());
        arg.current_point.addChild(co);
        if (this.isContinueAxis(ax.axis, arg)) {
            arg.minmax_y(ax.axis.getName()).update(coord);
            if ("pie".equals(arg.ctype) || "pie3D".equals(arg.ctype)) {
                DText t;
                boolean show_val;
                String mes = "";
                NumberFormat performat = NumberFormat.getPercentInstance((ULocale)arg.locale);
                performat.setMaximumIntegerDigits(3);
                performat.setMaximumFractionDigits(2);
                boolean show_per = arg.chart.getProperties().get("P_SHOW_PERCENTAGE.DGraphic.core.jscrib", false);
                if (show_per) {
                    mes = String.valueOf(performat.format((Object)new Double(coord.getValue() * 100.0 / arg.total))) + "%";
                }
                if (show_val = arg.chart.getProperties().get("P_SHOW_VALUES.DGraphic.core.jscrib", false)) {
                    UFormat f;
                    if (show_per) {
                        mes = String.valueOf(mes) + " - ";
                    }
                    mes = (f = (UFormat)ax.axis.getProperties().get("P_UNIT_FORMAT.DAxis.core.jscrib")) != null ? String.valueOf(mes) + f.format((Object)new Double(coord.getValue())) : String.valueOf(mes) + coord.getValue();
                }
                if ((t = (DText)arg.current_point.getChildOfClass(DText.class)) != null) {
                    t.setText(mes);
                    t.setStyle(this.styles.getFirstStyle("Axis"));
                } else {
                    DText txt = new DText(mes);
                    txt.setStyle(this.styles.getFirstStyle("Axis"));
                    arg.current_point.addChild(txt);
                }
            }
        }
    }

    public void doMethod(DCoordObject coord, DExtensible ext, Object the_arg) {
        Arg arg = (Arg)the_arg;
        Object v = coord.getValue(null);
        Axis ax = (Axis)arg.axes.get(coord.getAxis().getName());
        if (ax == null) {
            System.err.println("the axis '" + coord.getAxis().getName() + "' not registred");
            throw new Error();
        }
        if (this.isContinueAxis(ax.axis, arg)) {
            arg.minmax_y(ax.axis.getName()).update(coord);
        }
        if (ax.categories.size() > 0) {
            DCoord co = new DCoord();
            co.setValue((Double)ax.categories.get(v));
            co.setAxis(ax.axis);
            co.setStyle(coord.getStyle());
            arg.current_point.addChild(co);
            DText txt = new DText((String)arg.curveNames.get(v));
            txt.setStyle(this.styles.getFirstStyle("Axis"));
            arg.current_point.addChild(txt);
        } else {
            DCoordObject co = new DCoordObject();
            co.setValue(coord.getValue(null));
            co.setAxis(ax.axis);
            co.setStyle(coord.getStyle());
            arg.current_point.addChild(co);
        }
    }

    private void calculateStackedAreaMinMax(DAxis ax, Arg arg) {
        this.calculateStackedBarMinMax(ax, arg);
    }

    private void calculateStackedBarMinMax(DAxis ax, Arg arg) {
        Vector<Bar> bars = new Vector<Bar>();
        for (DCurve curve : arg.curves) {
            int ibar = 0;
            IDItem ip = curve.getFirstChild();
            while (ip != null) {
                if (ip instanceof DPoint) {
                    DPoint point = (DPoint)ip;
                    IDCoord coord = null;
                    IDItem ic = ip.getFirstChild();
                    while (ic != null) {
                        if (ic instanceof IDCoord) {
                            IDCoord crd = (IDCoord)((Object)ic);
                            if (coord == null && crd.getAxis() == ax) {
                                coord = crd;
                            }
                        }
                        if (coord != null) break;
                        ic = ic.getNext();
                    }
                    if (coord != null) {
                        Bar bar = null;
                        if (ibar >= bars.size()) {
                            bar = new Bar();
                            bar.sum = 0.0;
                            bars.add(bar);
                        } else {
                            bar = (Bar)bars.get(ibar);
                        }
                        Point pp = new Point();
                        pp.point = point;
                        pp.coord = coord;
                        bar.points.add(pp);
                        if (ax.useNumbers()) {
                            double vp = ((Number)coord.getValue(null)).doubleValue();
                            bar.sum += vp;
                        }
                    }
                }
                ip = ip.getNext();
                ++ibar;
            }
        }
        arg.v_min = ax.getProperties().get("P_MIN.DAxis.core.jscrib");
        arg.v_max = ax.getProperties().get("P_MAX.DAxis.core.jscrib");
        if ((arg.v_min == null || arg.v_max == null) && ax.useNumbers()) {
            if (arg.v_min == null) {
                arg.v_min = new Double(0.0);
            }
            if (arg.v_max == null) {
                double max = 0.0;
                double min = 0.0;
                boolean init = false;
                Iterator it = bars.iterator();
                while (it.hasNext()) {
                    double b_sum = ((Bar)it.next()).sum;
                    if (init) {
                        max = Math.max(max, b_sum);
                        min = Math.min(min, b_sum);
                        continue;
                    }
                    max = b_sum;
                    init = true;
                }
                if (init) {
                    arg.v_max = new Double(max);
                    arg.v_min = new Double(min);
                }
            }
        }
    }

    private void checkGraphic(DGraphic graph, Arg arg) {
        if (arg.axes.size() == 0) {
            if (arg.nbaxes == 1) {
                Axis ax = new Axis();
                ax.axis = new DAxis("y");
                graph.addChild(ax.axis);
                arg.axes.put(ax.axis.getName(), ax);
                ax.axis.setStyle(this.styles.getFirstStyle("Axis"));
                arg.minmax_ys.put(ax.axis.getName(), new MinMax(ax.axis));
            } else if (arg.nbaxes == 2) {
                Axis ax = new Axis();
                ax.axis = new DAxis("x");
                graph.addChild(ax.axis);
                arg.axes.put(ax.axis.getName(), ax);
                ax.axis.setStyle(this.styles.getFirstStyle("Axis"));
                arg.minmax_ys.put(ax.axis.getName(), new MinMax(ax.axis));
                ax = new Axis();
                ax.axis = new DAxis("y");
                graph.addChild(ax.axis);
                arg.axes.put(ax.axis.getName(), ax);
                ax.axis.setStyle(this.styles.getFirstStyle("Axis"));
                arg.minmax_ys.put(ax.axis.getName(), new MinMax(ax.axis));
            }
        }
    }

    private double getOrderOfMagnitude(double dataMax, double dataMin) {
        double magnitude = 1.0;
        double range = dataMin >= 0.0 ? dataMax : (dataMax <= 0.0 ? Math.abs(dataMin) : dataMax - dataMin);
        while (range > 10.0) {
            range /= 10.0;
            magnitude *= 10.0;
        }
        return magnitude;
    }

    private double getOrderOfMagnitude(double num) {
        double magnitude = 1.0;
        double number = Math.abs(num);
        if (number >= 1.0) {
            while (number >= 10.0) {
                number /= 10.0;
                magnitude *= 10.0;
            }
        } else if (number != 0.0) {
            while (number < 1.0) {
                number *= 10.0;
                magnitude *= 10.0;
            }
            magnitude = 1.0 / magnitude;
        }
        return magnitude;
    }

    private static class Arg {
        DGraphic graph;
        DGraphic chart;
        Axis current_axis;
        List curves = new LinkedList();
        Map curveNames = new HashMap();
        Map axes = new HashMap();
        DPoint current_point;
        DCurve current_curve;
        DStyle current_style;
        List current_coord = new LinkedList();
        String ctype;
        int nbaxes;
        IPalette palette;
        SVGColorPalettes palettes;
        boolean split_in_curve = true;
        Map minmax_ys;
        double total;
        LinkedList markers = new LinkedList();
        Object v_min;
        Object v_max;
        ULocale locale;

        public Arg() {
            this.minmax_ys = new HashMap();
        }

        public MinMax minmax_y(String axname) {
            return (MinMax)this.minmax_ys.get(axname);
        }
    }

    private static class Axis {
        Map categories = new HashMap();
        DAxis axis;
    }

    private static class Bar {
        public double sum;
        public Vector points = new Vector();

        private Bar() {
        }
    }

    private static class Point {
        DPoint point;
        IDCoord coord;

        private Point() {
        }
    }
}

