/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.tools.internal;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DFont;
import org.eclipse.tptp.platform.report.core.internal.DStyle;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.IDFont;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;

public class DJavaSourceColorizer {
    private DStyle s_number;
    private DStyle s_string;
    private DStyle s_keyword;

    public static void Colorize(IDItem parent, String source) {
        new DJavaSourceColorizer().colorize(parent, source);
    }

    public void colorize(IDItem parent, String source) {
        if (parent == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(source, this.getSeparators(), true);
        StringBuffer sb = new StringBuffer(source.length());
        IDItem last = parent.getLastChild();
        IDStyle model = parent.getAppliedStyle();
        int state = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            switch (state) {
                case 0: {
                    if (this.isStringStart(token)) {
                        if (sb.length() > 0) {
                            last = this.createText(new String(sb), null, parent, last);
                            sb.setLength(0);
                        }
                        state = 1;
                        sb.append(token);
                        break;
                    }
                    if (this.isCharacterStart(token)) {
                        if (sb.length() > 0) {
                            last = this.createText(new String(sb), null, parent, last);
                            sb.setLength(0);
                        }
                        state = 2;
                        sb.append(token);
                        break;
                    }
                    if (this.isKeyword(token)) {
                        if (sb.length() > 0) {
                            last = this.createText(new String(sb), null, parent, last);
                            sb.setLength(0);
                        }
                        last = this.createText(token, this.getKeywordStyle(model), parent, last);
                        break;
                    }
                    if (this.isNumber(token)) {
                        if (sb.length() > 0) {
                            last = this.createText(new String(sb), null, parent, last);
                            sb.setLength(0);
                        }
                        last = this.createText(token, this.getNumberStyle(model), parent, last);
                        break;
                    }
                    sb.append(token);
                    break;
                }
                case 1: {
                    if (this.isStringEnd(token)) {
                        sb.append(token);
                        last = this.createText(new String(sb), this.getStringStyle(model), parent, last);
                        state = 0;
                        sb.setLength(0);
                        break;
                    }
                    sb.append(token);
                    break;
                }
                case 2: {
                    if (this.isCharacterEnd(token)) {
                        sb.append(token);
                        last = this.createText(new String(sb), this.getCharacterStyle(model), parent, last);
                        state = 0;
                        sb.setLength(0);
                        break;
                    }
                    sb.append(token);
                }
            }
        }
        if (sb.length() > 0) {
            parent.insertChild(new DText(new String(sb)), last);
        }
    }

    protected String getSeparators() {
        return " \t\n,;.,~|&+-=^*/%:(){}[]'\"";
    }

    protected boolean isKeyword(String str) {
        if (str == null || str.length() < 2) {
            return false;
        }
        switch (str.length()) {
            case 2: {
                if ("if".equals(str)) {
                    return true;
                }
                return "do".equals(str);
            }
            case 3: {
                switch (str.charAt(0)) {
                    case 'f': {
                        return "for".equals(str);
                    }
                    case 'i': {
                        return "int".equals(str);
                    }
                    case 'n': {
                        return "new".equals(str);
                    }
                    case 't': {
                        return "try".equals(str);
                    }
                }
                return false;
            }
            case 4: {
                switch (str.charAt(0)) {
                    case 'b': {
                        return "byte".equals(str);
                    }
                    case 'c': {
                        return "case".equals(str) || "char".equals(str);
                    }
                    case 'e': {
                        return "else".equals(str);
                    }
                    case 'g': {
                        return "goto".equals(str);
                    }
                    case 'l': {
                        return "long".equals(str);
                    }
                    case 'n': {
                        return "null".equals(str);
                    }
                    case 't': {
                        return "true".equals(str) || "this".equals(str);
                    }
                    case 'v': {
                        return "void".equals(str);
                    }
                }
                return false;
            }
            case 5: {
                switch (str.charAt(0)) {
                    case 'b': {
                        return "break".equals(str);
                    }
                    case 'c': {
                        return "catch".equals(str) || "class".equals(str) || "const".equals(str);
                    }
                    case 'f': {
                        return "false".equals(str) || "final".equals(str) || "float".equals(str);
                    }
                    case 's': {
                        return "short".equals(str) || "super".equals(str);
                    }
                    case 't': {
                        return "throw".equals(str);
                    }
                    case 'w': {
                        return "while".equals(str);
                    }
                }
                return false;
            }
            case 6: {
                switch (str.charAt(0)) {
                    case 'd': {
                        return "double".equals(str);
                    }
                    case 'i': {
                        return "import".equals(str);
                    }
                    case 'n': {
                        return "native".equals(str);
                    }
                    case 'p': {
                        return "public".equals(str);
                    }
                    case 'r': {
                        return "return".equals(str);
                    }
                    case 's': {
                        return "static".equals(str) || "switch".equals(str);
                    }
                    case 't': {
                        return "throws".equals(str);
                    }
                }
                return false;
            }
            case 7: {
                switch (str.charAt(0)) {
                    case 'b': {
                        return "boolean".equals(str);
                    }
                    case 'e': {
                        return "extends".equals(str);
                    }
                    case 'd': {
                        return "default".equals(str);
                    }
                    case 'f': {
                        return "finally".equals(str);
                    }
                    case 'p': {
                        return "package".equals(str) || "private".equals(str);
                    }
                }
                return false;
            }
            case 8: {
                switch (str.charAt(0)) {
                    case 'a': {
                        return "abstract".equals(str);
                    }
                    case 'c': {
                        return "continue".equals(str);
                    }
                    case 's': {
                        return "strictfp".equals(str);
                    }
                    case 'v': {
                        return "volatile".equals(str);
                    }
                }
                return false;
            }
            case 9: {
                switch (str.charAt(0)) {
                    case 'i': {
                        return "interface".equals(str);
                    }
                    case 'p': {
                        return "protected".equals(str);
                    }
                    case 't': {
                        return "transcient".equals(str);
                    }
                }
                return false;
            }
            case 10: {
                return "implements".equals(str);
            }
            case 12: {
                return "synchronized".equals(str);
            }
        }
        return false;
    }

    protected boolean isNumber(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Integer.parseInt(str, 16);
                return true;
            }
            catch (NumberFormatException numberFormatException2) {
                return false;
            }
        }
    }

    protected boolean isStringStart(String str) {
        return "\"".equals(str);
    }

    protected boolean isStringEnd(String str) {
        return "\"".equals(str);
    }

    protected boolean isCharacterStart(String str) {
        return "'".equals(str);
    }

    protected boolean isCharacterEnd(String str) {
        return "'".equals(str);
    }

    protected IDStyle getNumberStyle(IDStyle model) {
        if (this.s_number != null) {
            return this.s_number;
        }
        this.s_number = new DStyle();
        this.s_number.setForeColor(new DColor(57, 123, 90));
        return this.s_number;
    }

    protected IDStyle getStringStyle(IDStyle model) {
        if (this.s_string != null) {
            return this.s_string;
        }
        this.s_string = new DStyle();
        this.s_string.setForeColor(new DColor(0, 0, 255));
        return this.s_string;
    }

    protected IDStyle getCharacterStyle(IDStyle model) {
        return this.getStringStyle(model);
    }

    protected IDStyle getKeywordStyle(IDStyle model) {
        if (this.s_keyword != null) {
            return this.s_keyword;
        }
        DStyle sty = new DStyle();
        if (model != null && model.getFont() != null) {
            IDFont font = model.getFont();
            sty.setFont(new DFont(font.getFamily(), font.getScript(), font.getSize(), 1));
        } else {
            sty.setFont(new DFont("courier", null, 8, 1));
        }
        sty.setForeColor(new DColor(123, 0, 82));
        this.s_keyword = sty;
        return sty;
    }

    protected IDItem createText(String text, IDStyle style, IDItem parent, IDItem last) {
        DText dt = new DText(text);
        dt.setStyle(style);
        parent.insertChild(dt, last);
        return dt;
    }
}

