/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.tools.internal;

import org.eclipse.tptp.platform.report.core.internal.DLinkUtil;
import org.eclipse.tptp.platform.report.core.internal.IDDocument;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDLink;
import org.eclipse.tptp.platform.report.core.internal.IDTaggedItem;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;

public class DLinkResolver
extends DExtensible {
    private IDLink link = null;
    private IDItem document;
    private IDTaggedItem taggedItem;
    private IDItem needRebuild;
    private boolean resolved;

    public DLinkResolver(IDLink l) {
        this.link = l;
    }

    public DLinkResolver() {
    }

    public void resolve(IDProgressMonitor pm) {
        this.taggedItem = null;
        Arg arg = new Arg();
        arg.pmonitor = pm;
        if (pm != null) {
            pm.beginTask("Resolve link", -1);
        }
        this.invokeDoMethod(this.link, this, arg);
        if (pm != null) {
            pm.done();
        }
        this.taggedItem = arg.taggedItem;
        this.document = arg.document;
        this.needRebuild = arg.needRebuild;
        this.resolved = arg.resolved;
    }

    public void doMethod(IDLink link, DExtensible ext, Object arg) {
        if (link == null) {
            return;
        }
        if (!DLinkUtil.isInternalLink(link)) {
            return;
        }
        IDItem d = link.getLinkedItem();
        if (d == null) {
            System.err.println("JSCRIB ERROR: no item associated with link.");
            return;
        }
        if ((d = d.getRoot()) == null) {
            System.err.println("JSCRIB ERROR: no root element for this item");
            return;
        }
        if (!(d instanceof IDDocument)) {
            System.err.println("JSCRIB ERROR: root element should be an IDDocument");
            return;
        }
        DLinkResolver.searchTaggedItem(d, DLinkUtil.getPathItems(link), (Arg)arg);
        ((Arg)arg).resolved = true;
    }

    private static IDTaggedItem searchChildTaggedItem(IDItem item, String tag, IDProgressMonitor pm) {
        IDItem c = item.getFirstChild();
        while (c != null) {
            IDTaggedItem f;
            IDTaggedItem tc;
            if (pm != null) {
                if (pm.isCanceled()) break;
                pm.worked(1);
            }
            if (c instanceof IDTaggedItem && (tc = (IDTaggedItem)c).getTag() != null && tc.getTag().equals(tag)) {
                return tc;
            }
            if (c.getFirstChild() != null && (f = DLinkResolver.searchChildTaggedItem(c, tag, pm)) != null) {
                return f;
            }
            c = c.getNext();
        }
        return null;
    }

    private static void searchTaggedItem(IDItem item, String[] tags, Arg arg) {
        if (item == null) {
            return;
        }
        boolean abs = tags.length > 1 && tags[0].length() == 0;
        int idxstart = 0;
        IDItem start = item;
        if (abs) {
            idxstart = 2;
            while (true) {
                if (start instanceof IDDocument && ((IDDocument)start).getTag().equals(tags[1])) {
                    arg.document = ((IDDocument)start).getDocument();
                    break;
                }
                if (start.getNext() == item) break;
                start = start.getNext();
            }
            if (start == item) {
                return;
            }
            start = arg.document;
        }
        int i = idxstart;
        while (i < tags.length) {
            if (arg.pmonitor != null) {
                if (arg.pmonitor.isCanceled()) break;
                arg.pmonitor.worked(1);
            }
            if ((start = DLinkResolver.searchChildTaggedItem(start, tags[i], arg.pmonitor)) == null) break;
            ++i;
        }
        arg.taggedItem = (IDTaggedItem)start;
    }

    public IDLink getLink() {
        return this.link;
    }

    public void setLink(IDLink aLink) {
        this.link = aLink;
    }

    public IDTaggedItem getTaggedItem() {
        return this.taggedItem;
    }

    public IDItem getItemToRebuild() {
        return this.needRebuild;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public static void makeDocumentPool(IDDocument[] docs) {
        if (docs == null || docs.length == 0) {
            return;
        }
        IDDocument first = null;
        int i = 0;
        while (i < docs.length) {
            if (docs[i] != null) {
                first = docs[i];
                break;
            }
            ++i;
        }
        IDDocument last = first;
        while (i < docs.length) {
            if (docs[i] != null) {
                last.setNext(docs[i]);
                last = docs[i];
            }
            ++i;
        }
        last.setNext(first);
    }

    public IDItem getDocument() {
        return this.document;
    }

    public static class Arg {
        public boolean resolved;
        public IDItem document;
        public IDTaggedItem taggedItem;
        public IDItem needRebuild;
        public IDProgressMonitor pmonitor;
    }
}

