/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.tools.internal;

import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.tools.internal.IPalette;

public class GradientPalette
implements IPalette {
    int num_color;
    int r0;
    int g0;
    int b0;
    int r1;
    int g1;
    int b1;

    public GradientPalette(int _num_color, int _color0, int _color1) {
        this.num_color = _num_color;
        this.r0 = _color0 >> 16 & 0xFF;
        this.g0 = _color0 >> 8 & 0xFF;
        this.b0 = _color0 & 0xFF;
        this.r1 = _color1 >> 16 & 0xFF;
        this.g1 = _color1 >> 8 & 0xFF;
        this.b1 = _color1 & 0xFF;
    }

    public int getNumColors() {
        return this.num_color;
    }

    public DColor getColor(int index) {
        double k = (double)(index %= this.num_color) / (double)(this.num_color - 1);
        int r = (int)((double)this.r0 + k * (double)(this.r1 - this.r0));
        int g = (int)((double)this.g0 + k * (double)(this.g1 - this.g0));
        int b = (int)((double)this.b0 + k * (double)(this.b1 - this.b0));
        return new DColor(r, g, b);
    }

    public int getRGBA(int index) {
        double k = (double)(index %= this.num_color) / (double)(this.num_color - 1);
        int r = (int)((double)this.r0 + k * (double)(this.r1 - this.r0));
        int g = (int)((double)this.g0 + k * (double)(this.g1 - this.g0));
        int b = (int)((double)this.b0 + k * (double)(this.b1 - this.b0));
        return RGBA.Get(r, g, b);
    }
}

