/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.tools.internal;

import java.io.InputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.swt.internal.SWTImage;
import org.eclipse.tptp.platform.report.tools.internal.AbstractIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;

public class SWTIImageProvider
extends AbstractIImageProvider {
    private Device device_;

    public SWTIImageProvider(Device device) {
        this.device_ = device;
    }

    public Device getDevice() {
        return this.device_;
    }

    protected IImage createBrokenImage() {
        SWTImage img = null;
        try {
            img = new SWTImage(new Image(this.device_, IDIImageProvider.class.getResourceAsStream("brokenImage.png")));
        }
        catch (Throwable throwable) {
            System.err.println("Cannot load image brokenImage.png");
        }
        if (img == null) {
            img = new SWTImage(new Image(this.device_, 30, 30));
        }
        return img;
    }

    public void setBrokenImage(IImage image) {
        if (this.brokenImage instanceof SWTImage) {
            ((SWTImage)this.brokenImage).getImage().dispose();
        }
        this.brokenImage = image;
    }

    protected IImage createImageFromFile(String filename) {
        if (filename == null) {
            return null;
        }
        Image img = null;
        try {
            img = new Image(this.device_, filename);
        }
        catch (Throwable throwable) {
            return null;
        }
        return new SWTImage(img);
    }

    protected IImage createImageFromInputStream(InputStream input_stream) {
        if (input_stream == null) {
            return null;
        }
        Image img = null;
        try {
            img = new Image(this.device_, input_stream);
        }
        catch (Throwable throwable) {
            return null;
        }
        return new SWTImage(img);
    }

    protected void disposeImage(IImage image) {
        if (image instanceof SWTImage) {
            ((SWTImage)image).disposeImage();
        }
    }
}

