/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.report;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.util.ExecutionUtil;
import org.eclipse.hyades.test.tools.ui.common.internal.report.ReportWindowWizardPage;
import org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib.JscribWriter;
import org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib.ReportDataUtils;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.hyades.ui.report.ReportGeneratorWizard;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DLink;
import org.eclipse.tptp.platform.report.core.internal.DSection;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDObject;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriter;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriterException;
import org.eclipse.tptp.platform.report.drivers.html.DOneDocumentPolicy;
import org.eclipse.tptp.platform.report.drivers.html.IDGenerationPolicy;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginImageManager;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle;

public class ReportWindowWizard
extends ReportGeneratorWizard {
    private TestLocationPage testLocationPage = null;
    private ReportWindowWizardPage reportWindowInputWizardPage = null;
    private boolean onlyConsiderMostRecentResult = false;
    private Map testSuiteExecutionResults = null;
    private EList selectedTestSuites = null;
    private static final String FILE_EXTENSION = "html";

    public String getEditorId() {
        return "org.eclipse.ui.browser.editorSupport";
    }

    public ReportWindowWizard() {
        this.setWindowTitle(SamplesPluginResourceBundle.ReportWindowWizardPage_Title);
        this.setDefaultPageImageDescriptor(SamplesPluginImageManager.getInstance().getImageDescriptor("report_window_wiz.gif"));
    }

    protected void initPages() {
        this.reportWindowInputWizardPage = new ReportWindowWizardPage();
        this.testLocationPage = new TestLocationPage("location", this.adjustLocation());
        this.testLocationPage.setTitle(UiPluginResourceBundle.WIZ_TST_REP_PG_TTL);
        this.testLocationPage.setDescription(UiPluginResourceBundle.WIZ_TST_REP_PG_LOC_DSC);
        this.testLocationPage.setFileExtension(FILE_EXTENSION);
    }

    protected IStructuredSelection adjustLocation() {
        IResource res;
        IContainer parent;
        IStructuredSelection structuredSelection = this.getSelection();
        Object selection = structuredSelection.getFirstElement();
        if (selection instanceof IResource && (parent = (res = (IResource)selection).getParent()) != null && parent.exists()) {
            structuredSelection = new StructuredSelection((Object)parent);
        }
        return structuredSelection;
    }

    protected void addReportPages() throws Exception {
        this.addPage((IWizardPage)this.testLocationPage);
        this.addPage((IWizardPage)this.reportWindowInputWizardPage);
    }

    public long getStartTime() {
        return this.reportWindowInputWizardPage.getStartTime();
    }

    public long getEndTime() {
        return this.reportWindowInputWizardPage.getEndTime();
    }

    public IFile generate(IProgressMonitor monitor) throws Exception {
        try {
            monitor.beginTask("", 4);
            this.testSuiteExecutionResults = ExecutionUtil.findExecutionResults((List)ReportDataUtils.getReferencedTestSuites(this.selectedTestSuites));
            long startTime = this.getStartTime();
            long endTime = this.getEndTime();
            IStructuredSelection structuredSelection = (IStructuredSelection)new StructuredSelection((Object)this.getSelection()).getFirstElement();
            Iterator structuredSelectionIterator = structuredSelection.iterator();
            while (structuredSelectionIterator.hasNext()) {
                ((ITestSuiteProxyNode)structuredSelectionIterator.next()).getTestSuite();
            }
            IFile reportFile = this.getReportFile();
            if (this.isOnlyConsiderMostRecentResult()) {
                this.filterOldExecutionResults();
            }
            DSection[] docs = new JscribWriter().generate(this.testSuiteExecutionResults, startTime, endTime, (IProgressMonitor)new SubProgressMonitor(monitor, 2, 4));
            DDocument doc = new DDocument("report_document", reportFile.getName());
            int i = 0;
            while (i < docs.length) {
                doc.addChild((IDItem)docs[i]);
                ++i;
            }
            monitor.worked(1);
            DDocument[] documents = new DDocument[]{doc};
            this.generateHtml(documents, new File(reportFile.getLocation().toOSString()));
            monitor.worked(1);
            IFile iFile = reportFile;
            return iFile;
        }
        finally {
            monitor.done();
        }
    }

    private void generateHtml(DDocument[] docs, File f) {
        IPath basePath = new Path(f.getParent()).makeAbsolute().removeTrailingSeparator();
        String rxmlFileName = f.getName();
        String htmlFileName = String.valueOf(rxmlFileName.substring(0, rxmlFileName.lastIndexOf("."))) + "." + FILE_EXTENSION;
        String htmlFilePath = String.valueOf(basePath.toOSString()) + File.separatorChar + htmlFileName;
        try {
            DHtmlWriter writer = new DHtmlWriter();
            writer.setGraphicExtensionClass("org.eclipse.tptp.platform.report.drivers.html.DHtmlGraphicSVG");
            File file = new File(htmlFilePath);
            ReportGenerationPolicy rp = new ReportGenerationPolicy(writer, file.getParent(), null);
            DOneDocumentPolicy policy = new DOneDocumentPolicy(writer, f.getParent(), null);
            policy.setImageDirectoryName(String.valueOf(f.getName()) + "_files");
            writer.setOutputStream((OutputStream)new FileOutputStream(htmlFilePath));
            ((PrintStream)writer.getOutputStream()).print("<html><head><META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></head><body>");
            writer.write((IDGenerationPolicy)rp, (IDObject[])docs);
            ((PrintStream)writer.getOutputStream()).print("</body></html>");
        }
        catch (DHtmlWriterException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)e.getMessage(), null, null);
        }
        catch (FileNotFoundException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)(String.valueOf(htmlFilePath) + "\n\nError When Generating HTML file:\n" + e.getMessage()), null, null);
        }
    }

    private IFile getReportFile() {
        IFile file = null;
        IPath path = this.testLocationPage.getContainerFullPath();
        IContainer res = this.createContainer(path);
        path = new Path(this.testLocationPage.getFileName());
        file = res.getFile(path);
        return file;
    }

    private IContainer createContainer(IPath path) {
        IFolder container = null;
        IWorkspace workbench = ResourcesPlugin.getWorkspace();
        int segCount = path.segmentCount();
        int idx = 0;
        while (idx < segCount) {
            if (idx == 0) {
                IProject project = workbench.getRoot().getProject(path.uptoSegment(idx + 1).toString());
                if (project == null || !project.exists()) {
                    try {
                        project.create(null);
                    }
                    catch (Exception e) {
                        UiPlugin.logError((Throwable)e);
                        e.printStackTrace();
                    }
                }
                try {
                    project.open(null);
                }
                catch (Exception exception) {}
                container = project;
            } else {
                IFolder folder = workbench.getRoot().getFolder(path.uptoSegment(idx + 1));
                if (folder == null || !folder.exists()) {
                    try {
                        folder.create(false, true, null);
                    }
                    catch (Exception e) {
                        UiPlugin.logError((Throwable)e);
                        e.printStackTrace();
                    }
                }
                container = folder;
            }
            ++idx;
        }
        try {
            container.getProject().refreshLocal(2, null);
        }
        catch (CoreException exc) {
            UiPlugin.logError((Throwable)exc);
            exc.printStackTrace();
        }
        return container;
    }

    public boolean isAvailable(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        this.selectedTestSuites = new BasicEList();
        for (Object testSuiteProxyNode : (IStructuredSelection)new StructuredSelection((Object)selection).getFirstElement()) {
            if (testSuiteProxyNode instanceof ITestSuiteProxyNode) {
                this.selectedTestSuites.add((Object)((ITestSuiteProxyNode)testSuiteProxyNode).getTestSuite());
                continue;
            }
            this.selectedTestSuites = null;
            return false;
        }
        if (this.selectedTestSuites.size() == 0) {
            this.selectedTestSuites = null;
            return false;
        }
        return true;
    }

    protected boolean isOnlyConsiderMostRecentResult() {
        return this.onlyConsiderMostRecentResult;
    }

    protected void setOnlyConsiderMostRecentResult(boolean onlyConsiderMostRecentResult) {
        this.onlyConsiderMostRecentResult = onlyConsiderMostRecentResult;
    }

    private void filterOldExecutionResults() {
        ArrayList keysToRemove = new ArrayList();
        for (Map.Entry entry : this.testSuiteExecutionResults.entrySet()) {
            List results = (List)entry.getValue();
            Iterator resultIter = results.iterator();
            TPFExecutionResult latestResult = null;
            long latestTimestamp = 0L;
            while (resultIter.hasNext()) {
                TPFExecutionEvent event;
                long timestamp;
                TPFExecutionResult result = (TPFExecutionResult)resultIter.next();
                TPFExecutionHistory history = result.getExecutionHistory();
                if (history == null || history.getExecutionEvents().isEmpty() || (timestamp = (event = (TPFExecutionEvent)history.getExecutionEvents().get(0)).getTimestamp()) <= latestTimestamp || timestamp <= this.getStartTime() || timestamp >= this.getEndTime()) continue;
                latestResult = result;
                latestTimestamp = timestamp;
            }
            if (latestResult != null) {
                results.clear();
                results.add(latestResult);
                continue;
            }
            keysToRemove.add(entry.getKey());
        }
        for (Object key : keysToRemove) {
            this.testSuiteExecutionResults.remove(key);
        }
    }

    public static class ReportGenerationPolicy
    extends DOneDocumentPolicy {
        public ReportGenerationPolicy(DHtmlWriter wh, String basePath, IDIImageProvider imgp) {
            super(wh, basePath, imgp);
        }

        public void doMethod(DLink item, DExtensible ext, Object arg) throws DHtmlWriterException {
            this.getWriter().doChildrenItem((IDItem)item, this.getWriter().getItem((IDItem)item), ext, arg);
        }
    }
}

