/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.test.tools.ui.common.internal.report.DescendingVisitor;
import org.eclipse.hyades.test.tools.ui.common.internal.report.Visitor;
import org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib.JscribWriter;
import org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib.ReportDataUtils;
import org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib.TestSuiteVisitor;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.tptp.platform.report.core.internal.DCellText;
import org.eclipse.tptp.platform.report.core.internal.DItem;
import org.eclipse.tptp.platform.report.core.internal.DRow;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle;

public class ExecutionVisitor
extends DescendingVisitor
implements Visitor {
    private TPFExecutionResult executionResult;
    private DItem parentItem;
    private int[] resultsSet;
    private JscribWriter jscribWriter;
    private TestSuiteVisitor testSuiteVisitor;

    public ExecutionVisitor(JscribWriter jscribWriter) {
        this.jscribWriter = jscribWriter;
    }

    public void visit(DescendingVisitor dvisitor, Object data, DItem parent) throws Exception {
        if (!(data instanceof TPFExecutionResult) || !(dvisitor instanceof TestSuiteVisitor)) {
            throw new Exception("ExecutionVisitor: invalid object");
        }
        this.executionResult = (TPFExecutionResult)data;
        this.parentItem = parent;
        this.testSuiteVisitor = (TestSuiteVisitor)dvisitor;
        this.visit();
    }

    private void visit() {
        DRow row = new DRow();
        DCellText previousCell = null;
        IDStyle cellStyle = this.jscribWriter.getStyle(SamplesPluginResourceBundle.StylesInitializer_NORMAL_CELL);
        String[] contents = this.getRowData();
        int i = 0;
        int max = contents.length;
        while (i < max) {
            DCellText cell = new DCellText(contents[i]);
            cell.setStyle(cellStyle);
            row.insertChild((IDItem)cell, previousCell);
            previousCell = cell;
            ++i;
        }
        DCellText rateCell = this.jscribWriter.generateRateCell(this.resultsSet[0], this.resultsSet[4], false, cellStyle);
        row.insertChild((IDItem)rateCell, (IDItem)previousCell);
        this.parentItem.addChild((IDItem)row);
    }

    private String[] getRowData() {
        this.resultsSet = new int[5];
        for (TPFVerdict verdict : ReportDataUtils.findAllVerdictEvents(this.executionResult.getExecutionHistory())) {
            switch (verdict.getValue()) {
                case 1: {
                    this.resultsSet[0] = this.resultsSet[0] + 1;
                    break;
                }
                case 0: {
                    this.resultsSet[1] = this.resultsSet[1] + 1;
                    break;
                }
                case 2: {
                    this.resultsSet[2] = this.resultsSet[2] + 1;
                    break;
                }
                case 3: {
                    this.resultsSet[3] = this.resultsSet[3] + 1;
                }
            }
        }
        this.resultsSet[4] = this.resultsSet[0] + this.resultsSet[1] + this.resultsSet[2] + this.resultsSet[3];
        return new String[]{this.getExecutionValue(), this.getDateValue(), ReportDataUtils.normalize(this.resultsSet[0]), ReportDataUtils.normalize(this.resultsSet[1]), ReportDataUtils.normalize(this.resultsSet[2]), ReportDataUtils.normalize(this.resultsSet[3]), ReportDataUtils.normalize(this.resultsSet[4])};
    }

    private String getDateValue() {
        return EventUtil.getTime((long)((TPFExecutionEvent)this.executionResult.getExecutionHistory().getExecutionEvents().get(0)).getTimestamp());
    }

    private String getExecutionValue() {
        return this.executionResult.getName();
    }

    public void postVisit() {
        int[] res = new int[]{this.resultsSet[0], this.resultsSet[1], this.resultsSet[2], this.resultsSet[3]};
        this.testSuiteVisitor.addToResults(res);
        this.jscribWriter.resultsByExecutionMap.put(this.executionResult, res);
    }
}

