/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.report.jscrib;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.tptp.platform.report.core.internal.DCell;
import org.eclipse.tptp.platform.report.core.internal.DImage;
import org.eclipse.tptp.platform.report.core.internal.DItem;
import org.eclipse.tptp.platform.report.core.internal.DLink;
import org.eclipse.tptp.platform.report.core.internal.DParagraph;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.DTitle;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;

public class ReportGraphicUtils {
    public static DItem createTitle(String title, int level, IDStyle style, DImage image) {
        DTitle ret = new DTitle(level);
        ret.addChild((IDItem)new DText(image != null ? String.valueOf(title) + " " : title));
        ret.setStyle(style);
        if (image != null && !image.equals("")) {
            ret.addChild((IDItem)image);
        }
        return ret;
    }

    public static DCell createStyledCell(IDStyle cellStyle, int align, String text) {
        return ReportGraphicUtils.createStyledCell(cellStyle, null, align, text);
    }

    public static DCell createStyledCell(IDStyle cellStyle, IDStyle textStyle, int align, String text) {
        DCell cell = new DCell();
        cell.setStyle(cellStyle);
        DParagraph p = new DParagraph(align);
        DText dtext = new DText(text);
        if (textStyle != null) {
            dtext.setStyle(textStyle);
        }
        p.addChild((IDItem)dtext);
        cell.addChild((IDItem)p);
        return cell;
    }

    public static DCell createReportLinksCell(Collection testSuites, IDStyle textStyle, IDStyle hLinkStyle) {
        DParagraph testSuitesCell = new DParagraph(1);
        DCell reportLinksCell = new DCell();
        reportLinksCell.addChild((IDItem)testSuitesCell);
        DLink current = null;
        DLink previous = null;
        Iterator testSuitesIterator = testSuites.iterator();
        while (testSuitesIterator.hasNext()) {
            IPath locPath;
            IFile workspaceFile;
            TPFTestSuite testSuite = (TPFTestSuite)testSuitesIterator.next();
            String location = "";
            Resource resource = testSuite.eResource();
            if (resource != null && (workspaceFile = EMFUtil.getWorkspaceFile((URI)resource.getURI())) != null && (locPath = workspaceFile.getLocation()) != null) {
                location = locPath.toOSString();
            }
            current = new DLink(location);
            current.addChild((IDItem)new DText(testSuite.getName()));
            current.setStyle(hLinkStyle);
            testSuitesCell.insertChild((IDItem)current, previous);
            if (testSuitesIterator.hasNext()) {
                DText txt = new DText(", ");
                testSuitesCell.insertChild((IDItem)txt, (IDItem)current);
                previous = txt;
                continue;
            }
            previous = current;
        }
        return reportLinksCell;
    }
}

