/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.reports;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.util.ExecutionUtil;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.ResultsSelectionWizard;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.hyades.ui.report.ReportGeneratorWizard;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractHTTPPageReportGeneratorWizard
extends ReportGeneratorWizard {
    protected TPFExecutionResult result = null;
    private TestLocationPage testLocationPage = null;
    private EList selectedTestSuites = null;
    private static final String FILE_EXTENSION = "html";

    public String getEditorId() {
        return "org.eclipse.ui.browser.editorSupport";
    }

    protected void initPages() {
        this.testLocationPage = new TestLocationPage("location", this.adjustLocation());
        this.testLocationPage.setTitle(UiPluginResourceBundle.WIZ_TST_REP_PG_TTL);
        this.testLocationPage.setDescription(UiPluginResourceBundle.WIZ_TST_REP_PG_LOC_DSC);
        this.testLocationPage.setFileExtension(FILE_EXTENSION);
    }

    protected IStructuredSelection adjustLocation() {
        IContainer parent;
        IStructuredSelection structuredSelection = this.getSelection();
        Object selection = structuredSelection.getFirstElement();
        if (selection instanceof IResource && (parent = ((IResource)selection).getParent()) != null && parent.exists()) {
            structuredSelection = new StructuredSelection((Object)parent);
        }
        return structuredSelection;
    }

    protected void addReportPages() throws Exception {
        this.addPage((IWizardPage)this.testLocationPage);
    }

    public boolean canFinish() {
        return this.testLocationPage.isPageComplete();
    }

    public boolean isAvailable(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        this.selectedTestSuites = new BasicEList();
        for (Object testSuiteProxyNode : (IStructuredSelection)new StructuredSelection((Object)selection).getFirstElement()) {
            if (testSuiteProxyNode instanceof ITestSuiteProxyNode) {
                TPFTestSuite testSuite = ((ITestSuiteProxyNode)testSuiteProxyNode).getTestSuite();
                if (testSuite.getType().equals("org.eclipse.hyades.test.http.junit.testSuite")) {
                    this.selectedTestSuites.add((Object)testSuite);
                    continue;
                }
                this.selectedTestSuites = null;
                return false;
            }
            this.selectedTestSuites = null;
            return false;
        }
        if (this.selectedTestSuites.size() == 0) {
            this.selectedTestSuites = null;
            return false;
        }
        return true;
    }

    protected void initResultSelection() {
        ArrayList results = new ArrayList();
        Iterator selectedTestSuitesIterator = this.selectedTestSuites.iterator();
        while (selectedTestSuitesIterator.hasNext()) {
            results.addAll(ExecutionUtil.findExecutionResults((TPFTest)((TPFTestSuite)selectedTestSuitesIterator.next())));
        }
        if (results.size() > 1) {
            ResultsSelectionWizard wiz = new ResultsSelectionWizard(results);
            new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wiz).open();
            this.result = wiz.getSelectedResult();
        } else {
            this.result = results.size() == 1 ? (TPFExecutionResult)results.get(0) : null;
        }
    }

    protected IFile getReportFile() {
        IFile file = null;
        IPath path = this.testLocationPage.getContainerFullPath();
        IContainer res = this.createContainer(path);
        path = new Path(this.testLocationPage.getFileName());
        file = res.getFile(path);
        return file;
    }

    private IContainer createContainer(IPath path) {
        IFolder container = null;
        IWorkspace workbench = ResourcesPlugin.getWorkspace();
        int segCount = path.segmentCount();
        int idx = 0;
        while (idx < segCount) {
            if (idx == 0) {
                IProject project = workbench.getRoot().getProject(path.uptoSegment(idx + 1).toString());
                if (project == null || !project.exists()) {
                    try {
                        project.create(null);
                    }
                    catch (Exception e) {
                        UiPlugin.logError((Throwable)e);
                        e.printStackTrace();
                    }
                }
                try {
                    project.open(null);
                }
                catch (Exception exception) {}
                container = project;
            } else {
                IFolder folder = workbench.getRoot().getFolder(path.uptoSegment(idx + 1));
                if (folder == null || !folder.exists()) {
                    try {
                        folder.create(false, true, null);
                    }
                    catch (Exception e) {
                        UiPlugin.logError((Throwable)e);
                        e.printStackTrace();
                    }
                }
                container = folder;
            }
            ++idx;
        }
        try {
            container.getProject().refreshLocal(2, null);
        }
        catch (CoreException exc) {
            UiPlugin.logError((Throwable)exc);
            exc.printStackTrace();
        }
        return container;
    }
}

