/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.reports;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.IReportGraphDataProvider;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.ReportGraphConfiguration;
import org.eclipse.tptp.platform.report.core.provisional.Generator;
import org.eclipse.tptp.platform.report.core.provisional.IChart;
import org.eclipse.tptp.platform.report.core.provisional.IRenderer;
import org.eclipse.tptp.platform.report.core.provisional.SVGRenderer;
import org.eclipse.tptp.platform.report.core.provisional.SerializerImpl;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReportGraph {
    IFile outputFile = null;
    ArrayList list = null;
    ReportGraphConfiguration config = null;

    public ReportGraph(ArrayList list, ReportGraphConfiguration configuration) {
        this.list = list;
        this.config = configuration;
    }

    public InputStream generate(IPath svgPath) throws Exception {
        ArrayList colourPalette = new ArrayList();
        Document newDoc = this.generateDataDocument(this.list, colourPalette);
        if (newDoc == null) {
            return null;
        }
        IPath svgGenPath = svgPath.removeFileExtension().addFileExtension("svg");
        FileOutputStream outputStream = new FileOutputStream(ResourcesPlugin.getWorkspace().getRoot().getFile(svgGenPath).getLocation().toFile());
        SVGRenderer renderer = new SVGRenderer();
        renderer.setProperty("tptp.output.stream", (Object)outputStream);
        IChart chart = SerializerImpl.instance().read(newDoc);
        Generator.instance().run((IRenderer)renderer, chart);
        IPath svgPathExt = svgPath.removeFileExtension().addFileExtension("svg");
        String svgURL = SamplesPluginResourceBundle.SVG_URL;
        StringBuffer sb = new StringBuffer();
        sb.append("<html>\n").append("<head>\n").append("<title>").append(this.getUserText("chart.Title")).append(" </title>").append("</head>\n");
        sb.append("<body>\n").append("<embed type=\"image/svg+xml\" src=\"");
        sb.append(svgPathExt.lastSegment()).append("\" ").append("width=\"").append(this.config.getMinWidth()).append("\" ");
        sb.append("height=\"").append(this.config.getHeight()).append("\" ");
        sb.append("name=\"mySvgDocument\"");
        sb.append("/>\n");
        sb.append("<p><font face=\"arial\" font size = \"1\"> ").append(svgURL).append(" </font> <p>");
        sb.append(" </body>").append(" </html>");
        ResourcesPlugin.getWorkspace().getRoot().getFile(svgPathExt).refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        return new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
    }

    protected Document generateDataDocument(ArrayList list, ArrayList colourPalette) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element chart = document.createElement("chart");
        chart.setAttribute("width", "800");
        chart.setAttribute("height", "500");
        chart.setAttribute("minWidth", "800");
        chart.setAttribute("minHeight", "500");
        document.appendChild(chart);
        Element legend = document.createElement("legend");
        legend.setAttribute("show", "false");
        chart.appendChild(legend);
        Element chartTitle = document.createElement("chartTitle");
        chartTitle.setAttribute("label", this.config.getTitle());
        chart.appendChild(chartTitle);
        Element plotArea = document.createElement("plotArea");
        plotArea.setAttribute("type", "verticalBar");
        chart.appendChild(plotArea);
        Element axes = document.createElement("axes");
        plotArea.appendChild(axes);
        Element xaxis = document.createElement("axis");
        xaxis.setAttribute("id", "x");
        this.addAxisCategories(document, xaxis, list);
        axes.appendChild(xaxis);
        Element yaxis = document.createElement("axis");
        yaxis.setAttribute("id", "y");
        yaxis.setAttribute("title", this.config.getYTitle());
        this.addYSegments(document, yaxis, list);
        axes.appendChild(yaxis);
        Element curves = document.createElement("datasets");
        plotArea.appendChild(curves);
        Element curve = document.createElement("dataset");
        curve.setAttribute("label", "URL.Curve1");
        curves.appendChild(curve);
        int i = 0;
        while (i < list.size()) {
            this.createBarData(document, curve, (IReportGraphDataProvider)list.get(i), i);
            ++i;
        }
        if (list.size() == 0) {
            this.createBarData(document, curve, null, 0);
        }
        return document;
    }

    protected String getUserText(String key) {
        if ("chart.Title".equals(key)) {
            return SamplesPluginResourceBundle.ReportGraph_1;
        }
        if ("chart.Legend".equals(key)) {
            return SamplesPluginResourceBundle.ReportGraph_2;
        }
        if ("chart.timestampPrefix".equals(key)) {
            return SamplesPluginResourceBundle.ReportGraph_3;
        }
        if ("chart.Xtitle".equals(key)) {
            return SamplesPluginResourceBundle.ReportGraph_4;
        }
        if ("chart.Ytitle".equals(key)) {
            return SamplesPluginResourceBundle.ReportGraph_5;
        }
        if ("chart.attempt".equals(key)) {
            return SamplesPluginResourceBundle.ReportGraph_6;
        }
        if ("chart.error".equals(key)) {
            return SamplesPluginResourceBundle.ReportGraph_7;
        }
        if ("chart.pass".equals(key)) {
            return SamplesPluginResourceBundle.ReportGraph_8;
        }
        if ("chart.fail".equals(key)) {
            return SamplesPluginResourceBundle.ReportGraph_9;
        }
        if ("chart.inconclusive".equals(key)) {
            return SamplesPluginResourceBundle.ReportGraph_10;
        }
        if ("chart.expectedAttempt".equals(key)) {
            return SamplesPluginResourceBundle.ReportGraph_11;
        }
        if ("chart.expectedError".equals(key)) {
            return SamplesPluginResourceBundle.ReportGraph_12;
        }
        if ("chart.expectedPass".equals(key)) {
            return SamplesPluginResourceBundle.ReportGraph_13;
        }
        if ("chart.expectedFail".equals(key)) {
            return SamplesPluginResourceBundle.ReportGraph_14;
        }
        if ("chart.expectedInconclusive".equals(key)) {
            return SamplesPluginResourceBundle.ReportGraph_15;
        }
        return key;
    }

    protected void addAxisCategories(Document document, Element axis, ArrayList list) {
        Element cats = document.createElement("categories");
        axis.appendChild(cats);
        int i = 0;
        while (i < list.size()) {
            Element cat = document.createElement("category");
            cat.setAttribute("id", "c" + i);
            cats.appendChild(cat);
            String id = ((IReportGraphDataProvider)list.get(i)).getId();
            if (id.substring(0, 7).equals("http://")) {
                id = id.substring(7);
            }
            id = id.replaceAll("/", "/ ");
            cat.setAttribute("label", id);
            ++i;
        }
        if (list.size() == 0) {
            Element cat = document.createElement("category");
            cat.setAttribute("id", "c0");
            cat.setAttribute("label", "");
            cats.appendChild(cat);
        }
    }

    protected void addYSegments(Document document, Element axis, ArrayList list) {
    }

    protected void createBarData(Document document, Element curve, IReportGraphDataProvider data, int count) {
        double dbl;
        Element pt = document.createElement("point");
        curve.appendChild(pt);
        Element coord = document.createElement("coord");
        coord.setAttribute("axis", "y");
        try {
            Double d = data == null ? new Double(0.0) : new Double(data.getValue());
            dbl = (double)((long)(d * 1000.0 + 0.5)) / 1000.0;
        }
        catch (NumberFormatException numberFormatException) {
            dbl = 0.0;
        }
        coord.setAttribute("value", new Double(dbl).toString());
        pt.appendChild(coord);
        Element coordObj = document.createElement("coord");
        coordObj.setAttribute("axis", "x");
        coordObj.setAttribute("value", "c" + count);
        pt.appendChild(coordObj);
    }

    protected IFile createFile(IPath svgPath, String content) throws CoreException {
        IFile file = null;
        try {
            file = ResourcesPlugin.getWorkspace().getRoot().getFile(svgPath);
            ByteArrayInputStream inputStream = null;
            try {
                inputStream = new ByteArrayInputStream(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                inputStream = new ByteArrayInputStream(content.getBytes());
            }
            if (file.exists()) {
                try {
                    file.setContents((InputStream)inputStream, true, false, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
            } else {
                file.create((InputStream)inputStream, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }
}

