/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.reports.hitrate;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.HttpAbstractReport;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.hitrate.HitRateData;

public class HitRateReport
extends HttpAbstractReport {
    protected long startTime = -1L;
    protected long stopTime = -1L;

    public HitRateReport(TPFExecutionResult result) {
        super(result);
    }

    protected void finishReport() {
        if (this.list.size() > 1) {
            HitRateData.setTestElapsedTime(this.stopTime - this.startTime);
            this.list.add(new HitRateData.OverallHitRate());
        }
    }

    protected void setupReport() {
        HitRateData.resetCounter();
    }

    protected void processMessageEvent(TPFMessageEvent event) {
        String message = event.getText();
        int responseTimeIndex = message.indexOf("Time:");
        if (responseTimeIndex != -1) {
            String pageName = message.substring(message.indexOf("ResponseURL:") + "ResponseURL:".length(), responseTimeIndex).trim();
            String responseTime = message.substring(responseTimeIndex + "Time:".length(), message.length());
            if (responseTime.indexOf("\n") > -1) {
                responseTime = responseTime.substring(0, responseTime.indexOf("\n"));
            }
            responseTime = responseTime.trim();
            HitRateData hitRateData = (HitRateData)this.findPage(pageName);
            if (hitRateData == null) {
                hitRateData = new HitRateData(pageName);
                this.list.add(hitRateData);
            }
            hitRateData.addHit(new Long(responseTime));
        }
    }

    protected void processTypedEvent(TPFTypedEvent typedEvent) {
        if (typedEvent.getType() == TPFExecutionType.STOP_LITERAL) {
            this.stopTime = typedEvent.getTimestamp();
        } else if (this.startTime == -1L) {
            this.startTime = typedEvent.getTimestamp();
        }
    }
}

