/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.reports.responsetime;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.AbstractHTTPPageReportGeneratorWizard;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.ReportGraph;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.ReportGraphConfiguration;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.responsetime.ResponseTimeData;
import org.eclipse.hyades.test.tools.ui.http.internal.reports.responsetime.ResponseTimeReport;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginImageManager;
import org.eclipse.tptp.test.samples.internal.resources.SamplesPluginResourceBundle;

public class HTTPPageResponseTimeReportGeneratorWizard
extends AbstractHTTPPageReportGeneratorWizard {
    public HTTPPageResponseTimeReportGeneratorWizard() {
        this.setWindowTitle(SamplesPluginResourceBundle.ReportWindowWizardPage_Title);
        this.setDefaultPageImageDescriptor(SamplesPluginImageManager.getInstance().getImageDescriptor("report_window_wiz.gif"));
    }

    public IFile generate(IProgressMonitor monitor) throws Exception {
        IFile outputFile = this.getReportFile();
        try {
            monitor.beginTask("", 4);
            this.initResultSelection();
            monitor.worked(1);
            ResponseTimeReport report = new ResponseTimeReport(this.result);
            ResponseTimeData.resetCumulativeValues();
            report.generate();
            monitor.worked(1);
            ReportGraphConfiguration graphConfig = this.setupConfiguration();
            IPath svgPath = outputFile.getFullPath();
            svgPath.removeFileExtension().addFileExtension("svg");
            monitor.worked(1);
            ReportGraph graph = new ReportGraph(report.getList(), graphConfig);
            if (outputFile.exists()) {
                outputFile.delete(true, true, null);
            }
            outputFile.create(graph.generate(svgPath), true, null);
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return outputFile;
    }

    private ReportGraphConfiguration setupConfiguration() {
        ReportGraphConfiguration graphConfig = new ReportGraphConfiguration();
        graphConfig.setTitle(SamplesPluginResourceBundle.ResponseTimeReportGenerator_RESPONSE_TIME);
        graphConfig.setXTitle(SamplesPluginResourceBundle.ResponseTimeReportGenerator_PAGE);
        graphConfig.setYTitle(SamplesPluginResourceBundle.ResponseTimeReportGenerator_TIME_S);
        graphConfig.setLegendTitle(SamplesPluginResourceBundle.ResponseTimeReportGenerator_LEGEND);
        graphConfig.setTimeStampPrefix("");
        graphConfig.setMinWidth(800);
        graphConfig.setHeight(500);
        graphConfig.setID("org.eclipse.hyades.test.ui.URLTest.ResponseTimeReport");
        return graphConfig;
    }
}

