/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.test.core.TestCorePlugin;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class RecorderPlugin
extends AbstractUIPlugin {
    private static RecorderPlugin plugin;
    public static final String ID = "org.eclipse.hyades.test.ui";
    private ResourceBundle resourceBundle;

    public static void storePreference(String key, String value) {
        RecorderPlugin.getDefault().getPreferenceStore().setValue(key, value);
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)ID));
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public RecorderPlugin() {
        this.getResourceBundle();
        plugin = this;
    }

    public static String getPreference(String key) {
        return RecorderPlugin.getDefault().getPreferenceStore().getString(key);
    }

    public URL getInstallURL() {
        return this.getDescriptor().getInstallURL();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = UiPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static RecorderPlugin getDefault() {
        return plugin;
    }

    public String getRAServerPort() {
        return TestCorePlugin.getDefault().getPluginPreferences().getString("default_port");
    }

    public String getRAServerHost() {
        return UiPlugin.getInstance().getPreferenceStore().getString("default_host_name");
    }

    public static void reportExceptionToUser(final Exception e1, final String consequenceDescription, final String cause, final String dlgTitle) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Status errorStatus = new Status(4, RecorderPlugin.ID, 4, cause, (Throwable)e1);
                new ErrorDialog(Display.getDefault().getActiveShell(), dlgTitle, consequenceDescription, (IStatus)errorStatus, 4).open();
            }
        });
    }

    public static String getString(String key) {
        return RecorderPlugin.getResourceString(key);
    }
}

