/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.recorder.ui;

import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RecorderUIUtility {
    public static void layoutCompositelInFormLayout(Control composite, int pixelsToTop, int verticalSpanPixels, int leftPercentWidth, int rightPercentWidth, int leftBorder, int bottomBorder, int topBorder, int rightBorder) throws RecorderHarnessUIException {
        if (!FormLayout.class.isInstance(composite.getParent().getLayout())) {
            Object[] exceptionName = new String[]{"org.eclipse.swt.layout.FormLayout"};
            String errorMessage = NLS.bind((String)UiPluginResourceBundle.RecorderUIUtility_INCORRECT_LAYOUT_MESSAGE_FORMAT_STRING, (Object[])exceptionName);
            throw new RecorderHarnessUIException(errorMessage);
        }
        FormData formData = new FormData();
        formData.left = new FormAttachment(leftPercentWidth, leftBorder);
        formData.right = new FormAttachment(rightPercentWidth, -rightBorder);
        formData.top = new FormAttachment(0, pixelsToTop + topBorder);
        formData.bottom = new FormAttachment(0, pixelsToTop + verticalSpanPixels - bottomBorder);
        composite.setLayoutData((Object)formData);
    }

    public static void layoutControlInFormLayout(Control control, int topBorder, int leftBorder, int bottomBorder, int rightBorder) throws RecorderHarnessUIException {
        if (!FormLayout.class.isInstance(control.getParent().getLayout())) {
            Object[] exceptionName = new String[]{"org.eclipse.swt.layout.FormLayout"};
            String errorMessage = NLS.bind((String)UiPluginResourceBundle.RecorderUIUtility_INCORRECT_LAYOUT_MESSAGE_FORMAT_STRING, (Object[])exceptionName);
            throw new RecorderHarnessUIException(errorMessage);
        }
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, leftBorder);
        formData.right = new FormAttachment(100, -rightBorder);
        formData.top = new FormAttachment(0, topBorder);
        formData.bottom = new FormAttachment(100, -bottomBorder);
        control.setLayoutData((Object)formData);
    }

    public static void layoutControlInGrid(Control control, int columnSpan, int gridDataOptions) throws RecorderHarnessUIException {
        if (!GridLayout.class.isInstance(control.getParent().getLayout())) {
            Object[] exceptionName = new String[]{"org.eclipse.swt.layout.GridLayout"};
            String errorMessage = NLS.bind((String)UiPluginResourceBundle.RecorderUIUtility_INCORRECT_LAYOUT_MESSAGE_FORMAT_STRING, (Object[])exceptionName);
            throw new RecorderHarnessUIException(errorMessage);
        }
        GridData gridData = new GridData(gridDataOptions);
        gridData.horizontalSpan = columnSpan;
        control.setLayoutData((Object)gridData);
    }

    public static void assignFormLayout(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
    }

    public static void assignGridLayout(Composite compsite, int numberColumns, boolean columnsEqual) {
        GridLayout gridLayout = new GridLayout(numberColumns, columnsEqual);
        compsite.setLayout((Layout)gridLayout);
    }

    public static Label createLabel(Composite parent, String labelText, Font font) {
        Label label = new Label(parent, 64);
        label.setText(labelText);
        if (font != null) {
            label.setFont(font);
        }
        return label;
    }

    public static Text createEditControl(Composite parent, String defaultText, Font font) {
        Text text = new Text(parent, 2048);
        text.setText(defaultText);
        if (font != null) {
            text.setFont(font);
        }
        return text;
    }

    public static Group createGroup(Composite controlArea, String groupDisplayName) {
        Group recorderHostGroup = new Group(controlArea, 16);
        RecorderUIUtility.assignFormLayout(controlArea);
        recorderHostGroup.setText(groupDisplayName);
        return recorderHostGroup;
    }

    public static Button createButton(Composite parent, String text, int swtOptions) {
        Button button = new Button(parent, swtOptions);
        button.setText(text);
        return button;
    }

    public static class RecorderHarnessUIException
    extends Exception {
        static final long serialVersionUID = 7833907686788055596L;

        public RecorderHarnessUIException() {
        }

        public RecorderHarnessUIException(String message) {
            super(message);
        }
    }
}

