/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.recorder.ui.actions;

import org.eclipse.hyades.execution.recorder.IRecorderListener;
import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.wizards.RecorderWizard;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class AbstractNewRecordingAction
extends Action
implements IWorkbenchWindowActionDelegate,
IRecorderListener {
    private IAction toolbarAction = null;

    public AbstractNewRecordingAction() {
        RecorderFactory.getInstance().addListener((IRecorderListener)this);
    }

    public AbstractNewRecordingAction(String text) {
        super(text);
        RecorderFactory.getInstance().addListener((IRecorderListener)this);
    }

    public AbstractNewRecordingAction(String text, ImageDescriptor image) {
        super(text, image);
        RecorderFactory.getInstance().addListener((IRecorderListener)this);
    }

    public AbstractNewRecordingAction(String text, int style) {
        super(text, style);
        RecorderFactory.getInstance().addListener((IRecorderListener)this);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        action = this.toolbarAction;
        this.run();
    }

    public void run() {
        RecorderWizard wiz = this.loadWizard();
        wiz.init(this.getWorkbench(), this.getSelection());
        WizardDialog wizDlg = new WizardDialog(this.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wiz);
        wizDlg.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.toolbarAction = action;
    }

    public abstract RecorderWizard loadWizard();

    protected IWorkbench getWorkbench() {
        return UiPlugin.getDefault().getWorkbench();
    }

    protected IStructuredSelection getSelection() {
        ISelection selection;
        IWorkbenchWindow window = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    public void updateRecorderActive(boolean active) {
        this.setEnabled(!active);
        if (this.toolbarAction != null) {
            this.toolbarAction.setEnabled(!active);
        }
    }

    public void updateStatus(String str) {
    }
}

