/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.testgen.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.ITestGenWizardPage;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public abstract class FileLocationSelectionWizardpage
extends TestLocationPage
implements ITestGenWizardPage {
    protected Listener modifyListener = this;
    protected TreeViewer tree = null;
    private boolean saveSelection = false;
    private IWorkspaceRoot workspaceRoot = null;

    public FileLocationSelectionWizardpage() {
        this(true);
    }

    public FileLocationSelectionWizardpage(boolean saveSelection) {
        this(saveSelection, null);
    }

    public FileLocationSelectionWizardpage(boolean saveSelection, IStructuredSelection selection) {
        super("fileLocation", selection);
        this.saveSelection = saveSelection;
        this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.setAllowOverwrite(true);
    }

    public abstract String getFileExtension();

    public String getFileNameLabel() {
        return "";
    }

    public abstract String getTitle();

    public abstract String getDescription();

    protected IContainer getSelectedContainer() {
        IFile file;
        String filePath = this.getFilePath();
        if (filePath != null && (file = this.workspaceRoot.getFile((IPath)new Path(filePath))) != null) {
            return file.getParent();
        }
        return null;
    }

    public String getSelectedFilePath() {
        return this.getFilePath();
    }

    protected void setSelectedFilePath(String selectedFilePath) {
        if (selectedFilePath != null && selectedFilePath.trim().length() > 0) {
            this.setContainerFullPath((IPath)new Path(selectedFilePath));
            this.saveSettings();
        }
    }

    public String getSelectedFileName() {
        return this.getFileName();
    }

    protected void autoSelectProject() {
    }

    protected Image getObjectImage(Object element) {
        return null;
    }

    public void saveSettings() {
        String filePathString;
        if (this.saveSelection && (filePathString = this.getFilePath()) != null && filePathString.length() > 0) {
            UiPlugin.getDefault().getPreferenceStore().setValue(this.getPreferenceKey(), filePathString);
        }
    }

    protected String getPreferenceKey() {
        return this.getClass().getName();
    }

    public void createControl(Composite parent) {
        String filePathString;
        this.setTitle(this.getTitle());
        this.setDescription(this.getDescription());
        String fileExtension = this.getFileExtension();
        this.setFileExtension(fileExtension);
        Image objectImage = this.getObjectImage(this.workspaceRoot.getFile((IPath)new Path("/sampleProject/sampleFile." + fileExtension)));
        if (objectImage != null) {
            this.setFileImage(objectImage);
            this.setDisplayFiles(true);
        }
        if (this.saveSelection && (filePathString = UiPlugin.getDefault().getPreferenceStore().getString(this.getPreferenceKey())) != null && filePathString.length() > 0) {
            IPath filePath = new Path(filePathString).removeFileExtension();
            this.setContainerFullPath(filePath.removeLastSegments(1));
            this.setFileName(filePath.lastSegment());
        }
        super.createControl(parent);
        this.autoSelectProject();
        this.tree = this.internal_getTreeViewer();
    }

    protected void setControl(Control control) {
        super.setControl(control);
        if (control != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(control, this.getContextHelpID());
        }
    }
}

