/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.testgen.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.internal.execution.recorder.utilities.RecorderFileUtil;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.ITestGenWizardPage;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.TestGeneratorSelectorPage;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.TestSuiteLocationSelectionPage;
import org.eclipse.hyades.test.core.testgen.TestGeneratorFactory;
import org.eclipse.hyades.test.internal.testgen.ui.TestgenUIWrapper;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;

public class RunTestGenWizard
extends HyadesNewWizard
implements INewWizard,
IRunnableWithProgress {
    private TestSuiteLocationSelectionPage testFileSelectionPage;
    private TestGeneratorSelectorPage generatorSelectorPage;
    private IFile selectedRecModelFile;

    public RunTestGenWizard(IFile recModelFile) {
        this.selectedRecModelFile = recModelFile;
        this.setWindowTitle(UiPluginResourceBundle.NewRecordingWizardPage_TITLE);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
    }

    protected boolean createObject(IFile file) throws Exception {
        return false;
    }

    public boolean performFinish() {
        this.saveSettings();
        String generatorID = this.generatorSelectorPage.getSelectedGeneratorID();
        IConfigurationElement generatorElement = TestGeneratorFactory.getInstance().getGeneratorConfigElement(generatorID);
        if (generatorElement == null) {
            UiPlugin.logError(UiPluginResourceBundle.RunTestGenWizard_UNABLE_TO_LOAD_SELECTED_GENERATOR_ERROR_MSG);
            return false;
        }
        String tsName = this.testFileSelectionPage.getFilePath();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(tsName));
        if (RecorderFileUtil.fileExists((IFile)file)) {
            boolean b = MessageDialog.openConfirm((Shell)this.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)UiPluginResourceBundle.RunTestGenWizard_TESTSUITE_EXISTS_TITLE, (String)UiPluginResourceBundle.RunTestGenWizard_TESTSUITE_EXISTS);
            if (!b) {
                return b;
            }
            RecorderFileUtil.deleteFile((IFile)file);
        }
        TestgenUIWrapper wrapper = new TestgenUIWrapper(generatorID, this.selectedRecModelFile, this.testFileSelectionPage.getFilePath());
        wrapper.launchGenerator();
        return true;
    }

    private void saveSettings() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            ((ITestGenWizardPage)pages[i]).saveSettings();
            ++i;
        }
    }

    public void addPages() {
        this.generatorSelectorPage = new TestGeneratorSelectorPage();
        this.addPage(this.generatorSelectorPage);
        this.testFileSelectionPage = new TestSuiteLocationSelectionPage(this.selectedRecModelFile);
        this.addPage(this.testFileSelectionPage);
    }

    public void dispose() {
    }
}

