/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.adapter;

import org.eclipse.hyades.edit.datapool.INamedElement;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class NamedElementPropertySource
implements IPropertySource2 {
    public static final String PROPERTY_SOURCE_NAME = "datapool.propertySource.name";
    public static final String PROPERTY_SOURCE_DESCRIPTION = "datapool.propertySource.description";
    public static final String PROPERTY_SOURCE_ID = "datapool.propertySource.id";
    private INamedElement namedElement;
    private IPropertyDescriptor[] descriptors;
    private ListenerList propertyChangeListeners = new ListenerList();

    public NamedElementPropertySource(INamedElement namedElement) {
        if (namedElement == null) {
            throw new IllegalArgumentException();
        }
        this.namedElement = namedElement;
    }

    public INamedElement getNamedElement() {
        return this.namedElement;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeListeners.add((Object)listener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeListeners.remove((Object)listener);
        }
    }

    public boolean isPropertyResettable(Object id) {
        return id == null || !id.equals(PROPERTY_SOURCE_ID);
    }

    public Object getEditableValue() {
        return this.namedElement.getName();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new IPropertyDescriptor[3];
            this.descriptors[0] = new TextPropertyDescriptor((Object)PROPERTY_SOURCE_NAME, UiPluginResourceBundle.Word_Name);
            ((PropertyDescriptor)this.descriptors[0]).setCategory(UiPluginResourceBundle.Word_Attributes);
            this.descriptors[1] = new TextPropertyDescriptor((Object)PROPERTY_SOURCE_DESCRIPTION, UiPluginResourceBundle.Word_Description);
            ((PropertyDescriptor)this.descriptors[1]).setCategory(UiPluginResourceBundle.Word_Attributes);
            this.descriptors[2] = new PropertyDescriptor((Object)PROPERTY_SOURCE_ID, UiPluginResourceBundle.Word_ID);
            ((PropertyDescriptor)this.descriptors[2]).setCategory(UiPluginResourceBundle.Word_Attributes);
        }
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        if (id != null && id.equals(PROPERTY_SOURCE_NAME)) {
            return this.namedElement.getName();
        }
        if (id != null && id.equals(PROPERTY_SOURCE_DESCRIPTION)) {
            return this.namedElement.getDescription() == null ? "" : this.namedElement.getDescription();
        }
        if (id != null && id.equals(PROPERTY_SOURCE_ID)) {
            return this.namedElement.getId();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return id != null && id.equals(PROPERTY_SOURCE_NAME);
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (id != null && id.equals(PROPERTY_SOURCE_NAME)) {
            Object oldValue = this.getPropertyValue(id);
            this.namedElement.setName(value.toString());
            this.firePropertyChangeEvent(id.toString(), oldValue, value);
        } else if (id != null && id.equals(PROPERTY_SOURCE_DESCRIPTION)) {
            Object oldValue = this.getPropertyValue(id);
            this.namedElement.setDescription(value.toString());
            this.firePropertyChangeEvent(id.toString(), oldValue, value);
        } else if (id != null && id.equals(PROPERTY_SOURCE_ID)) {
            Object oldValue = this.getPropertyValue(id);
            this.namedElement.setId(value.toString());
            this.firePropertyChangeEvent(id.toString(), oldValue, value);
        }
    }

    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, propertyName, oldValue, newValue);
        Object[] listeners = this.propertyChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(event);
            ++i;
        }
    }
}

