/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.control;

import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.action.CopyAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.CutAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.DeleteCellAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.FindReplaceAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.PasteAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.SelectAllAction;
import org.eclipse.hyades.test.ui.internal.editor.DatapoolEditorPart;
import org.eclipse.hyades.ui.internal.editor.action.ActionHandlerListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class DatapoolActionHandlerListener
extends ActionHandlerListener {
    public static final DatapoolActionHandlerListener INSTANCE = new DatapoolActionHandlerListener();
    private FindReplaceAction findReplaceAction = null;

    protected void createEditActions() {
        super.createEditActions();
        this.delete = new DeleteCellAction();
        this.selectAll = new SelectAllAction();
        this.cut = new CutAction();
        this.copy = new CopyAction();
        this.paste = new PasteAction();
    }

    protected boolean filter(IWorkbenchPart part) {
        return !(part instanceof DatapoolEditorPart);
    }

    public void partActivated(IWorkbenchPart part) {
        super.partActivated(part);
        this.connectFindReplaceAction(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        super.partBroughtToTop(part);
        this.connectFindReplaceAction(part);
    }

    public void partOpened(IWorkbenchPart part) {
        super.partOpened(part);
        this.connectFindReplaceAction(part);
    }

    private void connectFindReplaceAction(IWorkbenchPart part) {
        if (this.filter(part)) {
            return;
        }
        IActionBars actionBars = this.getActionBars(part);
        this.findReplaceAction = new FindReplaceAction(UiPlugin.getInstance().getResourceBundle(), "find_replace_action.", part);
        actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)this.findReplaceAction);
        actionBars.updateActionBars();
    }

    protected void updateActions() {
        IWorkbenchPart part = this.getWorkbenchPart();
        if (part != null && this.isRegisteredPart(part)) {
            this.revert.setWorkbenchPart(part);
            IActionBars actionBars = this.getActionBars(part);
            Control focusControl = this.cut.getFocusControl();
            if (this.isValidFocusControl()) {
                String clipboardText = this.paste.getClipboardText();
                String selectionText = this.copy.getSelectionText();
                boolean isReadOnly = this.paste.isReadOnlyFocusControl();
                boolean clipboardNotEmpty = clipboardText != null && !clipboardText.equals("");
                boolean textSelected = selectionText != null && !selectionText.equals("");
                this.cut.setEnabled(!isReadOnly && textSelected);
                this.copy.setEnabled(textSelected && (!(focusControl instanceof Combo) || !isReadOnly));
                this.paste.setEnabled(!isReadOnly && clipboardNotEmpty);
                this.delete.setEnabled(!isReadOnly && focusControl instanceof StyledText);
                this.selectAll.setEnabled(!(focusControl instanceof Combo));
                this.findReplaceAction.setEnabled(false);
            } else if (!this.isOnTableCursor()) {
                this.cut.setEnabled(false);
                this.copy.setEnabled(false);
                this.paste.setEnabled(false);
                this.delete.setEnabled(false);
                this.selectAll.setEnabled(false);
                this.findReplaceAction.setEnabled(false);
            }
            actionBars.updateActionBars();
        }
    }

    private boolean isOnTableCursor() {
        Control control = this.cut.getFocusControl();
        return control instanceof TableCursor;
    }

    public FindReplaceAction getFindReplaceAction() {
        return this.findReplaceAction;
    }
}

