/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.control;

import java.util.StringTokenizer;
import org.eclipse.hyades.edit.datapool.IDatapoolCell;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class DatapoolClipboard {
    private Clipboard clipboard = null;
    private static final String CELL_DELIMITER = "\t";
    private static final String RECORD_DELIMITER = "\n";

    public DatapoolClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    public void setStringContents(String contents) {
        if (this.clipboard != null && !this.clipboard.isDisposed() && contents != null && contents.length() > 0) {
            this.clipboard.setContents(new Object[]{contents}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    public void setCellContents(IDatapoolCell cell) {
        if (cell != null) {
            this.setStringContents(cell.getPersistedRepresentation());
        }
    }

    public void setRecordContents(IDatapoolRecord record) {
        this.setStringContents(this.serialize(record));
    }

    public void setRecordContents(IDatapoolRecord[] records) {
        this.setStringContents(this.serialize(records));
    }

    public String getStringContents() {
        if (this.clipboard != null && !this.clipboard.isDisposed()) {
            return (String)this.clipboard.getContents((Transfer)TextTransfer.getInstance());
        }
        return null;
    }

    public String getCellContents() {
        StringTokenizer cellTokenizer;
        String stringContents = this.getStringContents();
        if (stringContents != null && (cellTokenizer = new StringTokenizer(stringContents.trim(), "\t\n")).countTokens() == 1) {
            return cellTokenizer.nextToken();
        }
        return null;
    }

    public String[][] getRecordContents() {
        String[][] recordContents = null;
        String clipboardContents = this.getStringContents();
        if (clipboardContents != null) {
            StringTokenizer recordsTokenizer = new StringTokenizer(clipboardContents.trim(), RECORD_DELIMITER);
            int recordCount = recordsTokenizer.countTokens();
            int recordIndex = 0;
            while (recordIndex < recordCount) {
                StringTokenizer cellTokenizer = new StringTokenizer(recordsTokenizer.nextToken().trim(), CELL_DELIMITER);
                int cellCount = cellTokenizer.countTokens();
                if (recordContents == null) {
                    recordContents = new String[recordCount][cellCount];
                }
                int cellIndex = 0;
                while (cellIndex < cellCount) {
                    recordContents[recordIndex][cellIndex] = cellTokenizer.nextToken();
                    ++cellIndex;
                }
                ++recordIndex;
            }
        }
        return recordContents;
    }

    public boolean isEmpty() {
        return this.getStringContents() == null;
    }

    private String serialize(IDatapoolRecord[] records) {
        StringBuffer recordsStringBuffer = new StringBuffer();
        if (records != null) {
            int counter = 0;
            while (counter < records.length) {
                if (recordsStringBuffer.length() > 0) {
                    recordsStringBuffer.append(RECORD_DELIMITER);
                }
                recordsStringBuffer.append(this.serialize(records[counter]));
                ++counter;
            }
        }
        return recordsStringBuffer.toString();
    }

    private String serialize(IDatapoolRecord record) {
        StringBuffer recordStringBuffer = new StringBuffer();
        if (record != null) {
            int counter = 0;
            while (counter < record.getCellCount()) {
                IDatapoolCell cell = (IDatapoolCell)record.getCell(counter);
                if (cell != null) {
                    if (recordStringBuffer.length() > 0) {
                        recordStringBuffer.append(CELL_DELIMITER);
                    }
                    recordStringBuffer.append(cell.getPersistedRepresentation());
                }
                ++counter;
            }
        }
        return recordStringBuffer.toString();
    }
}

