/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.control;

import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.action.CopyAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.CutAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.DeleteCellAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.DeleteColumnAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.DeleteRowAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.EditColumnAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.EditRowAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.FindReplaceAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.InsertColumnAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.InsertRowAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.PasteAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.SelectAllAction;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolActionHandlerListener;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolAction;
import org.eclipse.hyades.ui.internal.editor.action.EditAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;

public class DatapoolMenuManager {
    private InsertRowAction insertRowAction = null;
    private DeleteRowAction deleteRowAction = null;
    private EditRowAction editRowAction = null;
    private InsertColumnAction insertColumnAction = null;
    private DeleteColumnAction deleteColumnAction = null;
    private EditColumnAction editColumnAction = null;
    private EditAction deleteCellAction = null;
    private EditAction selectAllAction = null;
    private EditAction cutAction = null;
    private EditAction copyAction = null;
    private EditAction pasteAction = null;
    private DatapoolTable table = null;
    private Vector customActions = null;
    private String vendorID = null;
    private boolean showColumnActions = true;
    private boolean showRowActions = true;
    private boolean showEditActions = true;
    public static final int INSERT_ROW_ACTION_ENABLED = 2;
    public static final int DELETE_ROW_ACTION_ENABLED = 4;
    public static final int EDIT_ROW_ACTION_ENABLED = 8;
    public static final int INSERT_COLUMN_ACTION_ENABLED = 16;
    public static final int DELETE_COLUMN_ACTION_ENABLED = 32;
    public static final int EDIT_COLUMN_ACTION_ENABLED = 64;
    public static final int CUT_ACTION_ENABLED = 128;
    public static final int COPY_ACTION_ENABLED = 256;
    public static final int PASTE_ACTION_ENABLED = 512;
    public static final int FIND_REPLACE_ACTION_ENABLED = 1024;
    public static final int SELECT_ALL_ACTION_ENABLED = 2048;
    public static final int DELETE_CELL_ACTION_ENABLED = 4096;

    public DatapoolMenuManager(DatapoolTable table, String vendorID, boolean showEquivalenceClassActions, boolean showVariableActions, boolean showRecordActions) {
        if (table == null) {
            return;
        }
        this.customActions = new Vector();
        this.vendorID = vendorID;
        this.showColumnActions = showVariableActions;
        this.showRowActions = showRecordActions;
        this.setTable(table);
        this.makeActions();
    }

    public void setTable(DatapoolTable table) {
        this.table = table;
        if (this.deleteCellAction instanceof DeleteCellAction) {
            ((DeleteCellAction)this.deleteCellAction).setTable(table);
        }
        if (this.selectAllAction instanceof SelectAllAction) {
            ((SelectAllAction)this.selectAllAction).setTable(table);
        }
        if (this.cutAction instanceof CutAction) {
            ((CutAction)this.cutAction).setTable(table);
        }
        if (this.copyAction instanceof CopyAction) {
            ((CopyAction)this.copyAction).setTable(table);
        }
        if (this.pasteAction instanceof PasteAction) {
            ((PasteAction)this.pasteAction).setTable(table);
        }
    }

    public void makeActions() {
        TableViewer provider = this.table.getViewer();
        this.insertRowAction = new InsertRowAction((ISelectionProvider)provider, this.table);
        this.deleteRowAction = new DeleteRowAction((ISelectionProvider)provider, this.table);
        this.editRowAction = new EditRowAction((ISelectionProvider)provider, this.table);
        this.insertColumnAction = new InsertColumnAction((ISelectionProvider)provider, this.table);
        this.deleteColumnAction = new DeleteColumnAction((ISelectionProvider)provider, this.table);
        this.editColumnAction = new EditColumnAction((ISelectionProvider)provider, this.table);
        DatapoolActionHandlerListener datapoolActionHandlerListener = new DatapoolActionHandlerListener();
        this.deleteCellAction = datapoolActionHandlerListener.getDeleteAction();
        this.selectAllAction = datapoolActionHandlerListener.getSelectAllAction();
        this.cutAction = datapoolActionHandlerListener.getCutAction();
        this.copyAction = datapoolActionHandlerListener.getCopyAction();
        this.pasteAction = datapoolActionHandlerListener.getPasteAction();
        if (this.vendorID == null) {
            return;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(UiPlugin.getID()) + ".menuExtension");
        if (extensionPoint != null) {
            try {
                IConfigurationElement[] extensionPoints = extensionPoint.getConfigurationElements();
                int i = 0;
                while (i < extensionPoints.length) {
                    String extVendorID = extensionPoints[i].getAttribute("vendorID");
                    if (this.vendorID.equals(extVendorID)) {
                        IDatapoolAction action = (IDatapoolAction)extensionPoints[i].createExecutableExtension("actionClass");
                        this.customActions.add(action);
                        action.setDatapoolTable(this.table);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
    }

    public void addActions(IMenuManager imenuMgr) {
        MenuManager menuMgr = (MenuManager)imenuMgr;
        if (this.showRowActions) {
            menuMgr.add((IAction)this.insertRowAction);
            menuMgr.add((IAction)this.deleteRowAction);
            menuMgr.add((IAction)this.editRowAction);
            menuMgr.add((IContributionItem)new Separator());
        }
        if (this.showColumnActions) {
            menuMgr.add((IAction)this.insertColumnAction);
            menuMgr.add((IAction)this.deleteColumnAction);
            menuMgr.add((IAction)this.editColumnAction);
            menuMgr.add((IContributionItem)new Separator());
        }
        if (this.showEditActions) {
            menuMgr.add((IAction)this.deleteCellAction);
            menuMgr.add((IAction)this.selectAllAction);
            menuMgr.add((IContributionItem)new Separator());
            menuMgr.add((IAction)this.cutAction);
            menuMgr.add((IAction)this.copyAction);
            menuMgr.add((IAction)this.pasteAction);
            menuMgr.add((IContributionItem)new Separator());
            FindReplaceAction findReplaceAction = DatapoolActionHandlerListener.INSTANCE.getFindReplaceAction();
            if (findReplaceAction != null) {
                menuMgr.add((IAction)findReplaceAction);
                menuMgr.add((IContributionItem)new Separator());
            }
        }
        if (this.customActions.size() > 0) {
            int i = 0;
            while (i < this.customActions.size()) {
                IAction action = (IAction)this.customActions.get(i);
                menuMgr.add(action);
                ++i;
            }
        }
    }

    public void setDisplayMode(int displayMode) {
        this.insertRowAction.aboutToShow((displayMode & 2) != 0);
        this.deleteRowAction.aboutToShow((displayMode & 4) != 0);
        this.editRowAction.aboutToShow((displayMode & 8) != 0);
        this.insertColumnAction.aboutToShow((displayMode & 0x10) != 0);
        this.deleteColumnAction.aboutToShow((displayMode & 0x20) != 0);
        this.editColumnAction.aboutToShow((displayMode & 0x40) != 0);
        this.deleteCellAction.setEnabled((displayMode & 0x1000) != 0);
        this.selectAllAction.setEnabled((displayMode & 0x800) != 0);
        this.cutAction.setEnabled((displayMode & 0x80) != 0);
        this.copyAction.setEnabled((displayMode & 0x100) != 0);
        this.pasteAction.setEnabled((displayMode & 0x200) != 0);
        FindReplaceAction findReplaceAction = DatapoolActionHandlerListener.INSTANCE.getFindReplaceAction();
        if (findReplaceAction != null) {
            findReplaceAction.setEnabled((displayMode & 0x400) != 0);
        }
    }
}

