/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.control;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolCell;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolFactory;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.models.common.datapool.internal.util.DatapoolSuggestedTypeChecker;
import org.eclipse.hyades.models.common.datapool.util.DatapoolEncryptManager;
import org.eclipse.hyades.models.common.util.EncryptionManager;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolClipboard;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolMenuManager;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTableUtil;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolColumnDialog;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolConstants;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolDeleteColumnDialog;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolInputKeyDialog;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolRowDialog;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolPart;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IValidateValueClass;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IValueClassFactory;
import org.eclipse.hyades.test.ui.datapool.internal.util.DatapoolUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.EncryptedValueObject;
import org.eclipse.hyades.test.ui.datapool.internal.util.ValueClassMap;
import org.eclipse.hyades.test.ui.datapool.internal.util.ValueObject;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DatapoolTable
implements SelectionListener,
IDatapoolListener {
    private IDatapoolEquivalenceClass equivalenceClass = null;
    private IDatapool datapool = null;
    private Table table = null;
    private DatapoolTableUtil tableUtil = null;
    private TableViewer viewer = null;
    private Composite parent = null;
    private Menu contextMenu = null;
    private TableCursor tableCursor = null;
    private ControlEditor controlEditor = null;
    private IDatapoolPart datapoolEditorPart = null;
    private IDatapoolFactory datapoolFactory = null;
    private CellEditor cellEditor = null;
    private ValueObject theValueObject = null;
    private DatapoolMenuManager datapoolMenuManager = null;
    private boolean altKeyDown = false;
    private boolean isInputValid = true;
    private boolean showVariables = true;
    private boolean showRecords = true;
    private boolean isF2Mode = false;
    private int headerSelectionIndex = -1;
    private String cellkey = null;
    private String password = null;
    private String vendorID = null;
    private DatapoolClipboard datapoolClipboard = null;
    private boolean refreshRowsScheduled = false;
    private static final int MAX_TABLE_WIDTH = 60;
    private static final int MAX_TABLE_HEIGHT = 60;
    private static final int HEADER_COLUMN_DEFAULT_WIDTH = 20;
    private static final int COLUMN_DEFAULT_WIDTH = 110;
    protected SelectionListener headerListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            DatapoolTable.this.datapoolEditorPart.notifyEdit();
            if (DatapoolTable.this.datapoolEditorPart.isReadOnly()) {
                return;
            }
            DatapoolTable.this.clearCellEditor();
            TableColumn tableColumn = (TableColumn)event.widget;
            DatapoolTable.this.editColumnAux(tableColumn);
        }
    };
    protected ControlListener resizeColumnListener = new ControlAdapter(){

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            if (DatapoolTable.this.tableCursor != null && !DatapoolTable.this.tableCursor.isDisposed() && DatapoolTable.this.table.getSelectionIndex() >= 0 && DatapoolTable.this.tableCursor.getColumn() >= 0) {
                DatapoolTable.this.tableCursor.setSelection(DatapoolTable.this.table.getSelectionIndex(), DatapoolTable.this.tableCursor.getColumn());
            }
        }
    };

    public DatapoolTable(Composite parent, IDatapoolPart datapoolPart, IDatapool datapool, IDatapoolFactory datapoolFactory, String vendorID) {
        this.vendorID = vendorID;
        ValueClassMap.setVendorID(vendorID);
        IDatapoolEquivalenceClass ec = this.getDefaultEquivalenceClass(datapool);
        this.DatapoolTableConstructor(parent, datapoolPart, ec, datapoolFactory);
    }

    public DatapoolTable(Composite parent, IDatapoolPart datapoolPart, IDatapoolEquivalenceClass ec, IDatapoolFactory datapoolFactory, String vendorID) {
        this.vendorID = vendorID;
        ValueClassMap.setVendorID(vendorID);
        this.DatapoolTableConstructor(parent, datapoolPart, ec, datapoolFactory);
    }

    public DatapoolTable(Composite parent, IDatapoolPart datapoolPart, IDatapool datapool, IDatapoolFactory datapoolFactory) {
        IDatapoolEquivalenceClass ec = this.getDefaultEquivalenceClass(datapool);
        this.DatapoolTableConstructor(parent, datapoolPart, ec, datapoolFactory);
    }

    public DatapoolTable(Composite parent, IDatapoolPart datapoolPart, IDatapoolEquivalenceClass ec, IDatapoolFactory datapoolFactory) {
        this.DatapoolTableConstructor(parent, datapoolPart, ec, datapoolFactory);
    }

    private void DatapoolTableConstructor(Composite parent, IDatapoolPart datapoolPart, IDatapoolEquivalenceClass ec, IDatapoolFactory datapoolFactory) {
        if (parent == null || datapoolPart == null || datapoolFactory == null) {
            return;
        }
        this.setEquivalenceClass(ec);
        this.datapoolFactory = datapoolFactory;
        this.parent = new Composite(parent, 0);
        this.parent.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.parent.setLayout((Layout)layout);
        try {
            this.setWaitCursor();
            this.setVendorConfiguration();
            this.datapoolEditorPart = datapoolPart;
            this.datapoolClipboard = new DatapoolClipboard(datapoolPart.getClipboard());
            this.createTable(this.parent);
            this.tableUtil = new DatapoolTableUtil(this);
            this.createMenu();
            this.table.addSelectionListener((SelectionListener)this);
            if (this.equivalenceClass != null) {
                this.getDatapool().addDatapoolListener((IDatapoolListener)this);
            }
            this.datapoolMenuManager = new DatapoolMenuManager(this, this.vendorID, false, this.showVariables, this.showRecords);
            this.setMenuMode(this.datapoolMenuManager);
        }
        finally {
            this.unsetWaitCursor();
        }
    }

    public void init() {
        if (this.datapoolMenuManager == null) {
            this.datapoolMenuManager = new DatapoolMenuManager(this, this.vendorID, false, this.showVariables, this.showRecords);
        }
    }

    private void createMenu() {
        MenuManager menuManager = new MenuManager("#DatapoolEditor");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                DatapoolTable.this.datapoolMenuManager.addActions(menuManager);
                if (DatapoolTable.this.headerSelectionIndex != -1) {
                    DatapoolTable.this.setHeaderMenuMode(DatapoolTable.this.datapoolMenuManager);
                } else {
                    DatapoolTable.this.setMenuMode(DatapoolTable.this.datapoolMenuManager);
                }
            }
        });
        this.contextMenu = menuManager.createContextMenu((Control)this.table);
        this.table.setMenu(this.contextMenu);
        this.table.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Point point = Display.getCurrent().map(null, (Control)DatapoolTable.this.table, new Point(event.x, event.y));
                Rectangle clientArea = DatapoolTable.this.table.getClientArea();
                if (point.y >= clientArea.y && point.y < clientArea.y + DatapoolTable.this.table.getHeaderHeight()) {
                    DatapoolTable.this.headerSelectionIndex = DatapoolTable.this.getColumnIndex(point);
                } else {
                    DatapoolTable.this.headerSelectionIndex = -1;
                }
            }
        });
    }

    private int getColumnIndex(Point point) {
        TableItem tableItem = this.table.getItem(0);
        int counter = 0;
        while (counter < this.table.getColumnCount()) {
            Rectangle clientArea = tableItem.getBounds(counter);
            if (point.x >= clientArea.x && point.x <= clientArea.x + clientArea.width) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    private void setMenuMode(DatapoolMenuManager datapoolMenuManager) {
        if (datapoolMenuManager != null) {
            int displayMode = 0;
            if (this.equivalenceClass != null) {
                boolean isReadOnly = this.datapoolEditorPart.isReadOnly();
                int columnCount = -1;
                int columnSelectionIndex = -1;
                int rowCount = -1;
                int rowSelectionCount = -1;
                if (!this.table.isDisposed()) {
                    columnCount = this.table.getColumnCount();
                    rowCount = this.table.getItemCount();
                    rowSelectionCount = this.getRowSelectionCount();
                }
                if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
                    columnSelectionIndex = this.tableCursor.getColumn();
                }
                if (!isReadOnly) {
                    if (rowSelectionCount <= 1) {
                        displayMode |= 2;
                    }
                    if (rowSelectionCount == 1) {
                        displayMode |= 8;
                    }
                    if (rowSelectionCount >= 1) {
                        displayMode |= 4;
                    }
                    displayMode |= 0x10;
                    if (columnSelectionIndex > 0) {
                        displayMode |= 0x40;
                        displayMode |= 0x1000;
                        if (columnCount > 2) {
                            displayMode |= 0x20;
                        }
                    }
                }
                if (columnSelectionIndex > -1) {
                    boolean enableCutCopy = true;
                    if (columnSelectionIndex == 0) {
                        enableCutCopy = !DatapoolEncryptManager.containsEncryptedVariable((IDatapool)this.getDatapool());
                    } else {
                        boolean bl = enableCutCopy = !DatapoolEncryptManager.isVariableEncrypted((org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable)((IDatapoolVariable)this.table.getColumn(columnSelectionIndex).getData("variable")));
                    }
                    if (enableCutCopy) {
                        if (!isReadOnly) {
                            displayMode |= 0x80;
                        }
                        displayMode |= 0x100;
                    }
                    if (!isReadOnly && !this.datapoolClipboard.isEmpty()) {
                        displayMode |= 0x200;
                    }
                }
                if (rowCount > 0) {
                    displayMode |= 0x400;
                    if (rowSelectionCount < rowCount) {
                        displayMode |= 0x800;
                    }
                }
            }
            datapoolMenuManager.setDisplayMode(displayMode);
        }
    }

    private void setHeaderMenuMode(DatapoolMenuManager datapoolMenuManager) {
        if (datapoolMenuManager != null) {
            int displayMode = 0;
            if (this.equivalenceClass != null) {
                boolean isReadOnly = this.datapoolEditorPart.isReadOnly();
                int rowCount = -1;
                int rowSelectionCount = -1;
                if (!this.table.isDisposed()) {
                    rowCount = this.table.getItemCount();
                    rowSelectionCount = this.getRowSelectionCount();
                }
                if (!isReadOnly) {
                    displayMode |= 0x10;
                    if (this.headerSelectionIndex > 0) {
                        displayMode |= 0x40;
                        if (!this.table.isDisposed() && this.table.getColumnCount() > 2) {
                            displayMode |= 0x20;
                        }
                    }
                }
                if (rowCount > 0) {
                    displayMode |= 0x400;
                    if (rowSelectionCount < rowCount) {
                        displayMode |= 0x800;
                    }
                }
            }
            datapoolMenuManager.setDisplayMode(displayMode);
        }
    }

    private void createTable(Composite parent) {
        this.table = new Table(parent, 268503042);
        this.viewer = new TableViewer(this.table);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 60;
        gd.heightHint = 60;
        this.table.setLayoutData((Object)gd);
        this.makeColumns();
        if (!this.isWithoutRows()) {
            this.makeRows();
        }
        this.createCursor();
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 262144 && (e.stateMask & 0x20000) != 0 || e.keyCode == 131072 && (e.stateMask & 0x40000) != 0 || e.keyCode != 262144 && (e.stateMask & 0x40000) != 0 || e.keyCode != 131072 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                if (e.keyCode == 131072 || (e.stateMask & 0x20000) != 0) {
                    DatapoolTable.this.terminateMultipleSelection();
                }
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if ((e.stateMask & 0x20000) != 0) {
                    DatapoolTable.this.terminateMultipleSelection();
                }
            }
        });
        this.table.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -3) {
                    TableItem[] selection = DatapoolTable.this.table.getSelection();
                    if (selection != null && selection.length > 0 && DatapoolTable.this.tableCursor != null && !DatapoolTable.this.tableCursor.isDisposed()) {
                        try {
                            e.result = selection[0].getText(DatapoolTable.this.tableCursor.getColumn());
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    e.result = UiPluginResourceBundle.W_DATATABLE;
                }
            }
        });
    }

    private void createCursor() {
        if (this.equivalenceClass == null || this.equivalenceClass.getRecordCount() == 0) {
            return;
        }
        this.tableCursor = new TableCursor(this.table, 0);
        this.controlEditor = new ControlEditor((Composite)this.tableCursor);
        this.controlEditor.grabHorizontal = true;
        this.controlEditor.grabVertical = true;
        this.tableCursor.setBackground(Display.getCurrent().getSystemColor(26));
        this.tableCursor.setForeground(Display.getCurrent().getSystemColor(27));
        this.tableCursor.setMenu(this.contextMenu);
        this.tableCursor.addSelectionListener((SelectionListener)new CursorSelectionAdapter(this.tableCursor, this.cellEditor, this.datapoolEditorPart));
        this.tableCursor.addMenuDetectListener((MenuDetectListener)new CursorMenuDetectAdapter());
        this.tableCursor.addKeyListener((KeyListener)new CursorKeyAdapter(this.tableCursor, this.cellEditor, this.datapoolEditorPart));
        this.tableCursor.addTraverseListener((TraverseListener)new CursorTraverseAdapter());
        this.tableCursor.addMouseListener((MouseListener)new CursorMouseAdapter(this.table, this.tableCursor, this.cellEditor, this.datapoolEditorPart));
        this.tableCursor.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                TableItem[] selection = DatapoolTable.this.table.getSelection();
                if (selection != null && selection.length > 0 && DatapoolTable.this.tableCursor != null && !DatapoolTable.this.tableCursor.isDisposed()) {
                    try {
                        e.result = selection[0].getText(DatapoolTable.this.tableCursor.getColumn());
                    }
                    catch (Exception exception) {}
                }
            }
        });
        if (this.table.getItemCount() > 0) {
            this.table.select(0);
            if (this.table.getColumnCount() > 1) {
                this.tableCursor.setSelection(0, 1);
            } else {
                this.tableCursor.setSelection(0, 0);
            }
        }
    }

    private void resetCursor() {
        if (this.tableCursor == null || this.tableCursor.isDisposed()) {
            this.createCursor();
        } else if (this.table.getItemCount() > 0) {
            this.table.select(0);
            this.tableCursor.setSelection(0, 0);
            this.tableCursor.redraw();
        }
    }

    private void setWaitCursor() {
        if (this.parent == null) {
            return;
        }
        Display display = this.parent.getShell().getDisplay();
        Cursor waitCursor = new Cursor((Device)display, 1);
        this.setDisplayCursor(waitCursor);
    }

    private void unsetWaitCursor() {
        this.setDisplayCursor(null);
    }

    private void setDisplayCursor(Cursor c) {
        if (this.parent == null) {
            return;
        }
        Display display = this.parent.getShell().getDisplay();
        Shell[] shells = display.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].setCursor(c);
            ++i;
        }
    }

    public Point getCursorPosition() {
        if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
            TableItem row = this.tableCursor.getRow();
            TableItem[] items = this.table.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i] == row) {
                    return new Point(i, this.tableCursor.getColumn());
                }
                ++i;
            }
        }
        return new Point(0, 0);
    }

    private void startCellEditing(TableItem row, int column) {
        IDatapoolCell[] cells = (IDatapoolCell[])row.getData("data");
        if (column < 1 || column > cells.length) {
            return;
        }
        IDatapoolCell cell = cells[column - 1];
        if (cell == null) {
            return;
        }
        IDatapoolVariable variable = (IDatapoolVariable)cell.getCellVariable();
        IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)variable.getSuggestedType();
        Object rawValue = cell.getCellValue();
        Object object = rawValue = rawValue == null ? "" : rawValue;
        if (suggestedType.getSuggestedType() == 3) {
            String[] enumerationLiterals = suggestedType.getEnumerationLiterals();
            if (enumerationLiterals == null || enumerationLiterals.length == 0) {
                enumerationLiterals = new String[]{};
            }
            String rawValueString = String.valueOf(rawValue);
            this.cellEditor = new ComboBoxCellEditor((Composite)this.tableCursor, enumerationLiterals);
            CCombo cellEditorCombo = (CCombo)this.cellEditor.getControl();
            cellEditorCombo.setText(rawValueString);
            cellEditorCombo.setSelection(new Point(rawValueString.length(), rawValueString.length()));
            this.theValueObject = new ValueObject(rawValue);
        } else if (suggestedType.getSuggestedType() == 2) {
            String rawValueString = String.valueOf(rawValue);
            this.cellEditor = new ComboBoxCellEditor((Composite)this.tableCursor, new String[]{"true", "false"}, 8);
            CCombo cellEditorCombo = (CCombo)this.cellEditor.getControl();
            cellEditorCombo.setText(rawValueString);
            cellEditorCombo.setSelection(new Point(rawValueString.length(), rawValueString.length()));
            this.theValueObject = new ValueObject(rawValue);
        }
        if (this.cellEditor == null) {
            if (rawValue == null || rawValue == "") {
                String typeName = suggestedType.getSuggestedClassName();
                rawValue = typeName == null || typeName.trim().length() == 0 ? new String() : this.createEmptyCellObject(typeName);
            }
            if (DatapoolEncryptManager.isVariableEncrypted((org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable)variable)) {
                String key = null;
                if (this.password != null) {
                    this.cellkey = key = this.password;
                } else {
                    DatapoolInputKeyDialog datapoolInputKeyDialog = new DatapoolInputKeyDialog(Display.getCurrent().getActiveShell(), this.datapool);
                    if (datapoolInputKeyDialog.open() == 0) {
                        this.cellkey = key = datapoolInputKeyDialog.getKey();
                        this.password = key;
                    } else {
                        return;
                    }
                }
                rawValue = EncryptionManager.decrypt((String)rawValue.toString(), (String)key);
                this.theValueObject = new EncryptedValueObject(rawValue);
                this.cellEditor = (CellEditor)this.theValueObject.getEncryptedDisplay((Composite)this.tableCursor);
            } else {
                this.theValueObject = new ValueObject(rawValue);
                this.cellEditor = (CellEditor)this.theValueObject.getPropertyDisplay((Composite)this.tableCursor);
            }
        }
        if (this.cellEditor != null && this.cellEditor.getControl() != null) {
            this.cellEditor.getControl().addKeyListener((KeyListener)new TableCellKeyAdapter(this.cellEditor, this.theValueObject, row, column));
            this.cellEditor.getControl().addTraverseListener((TraverseListener)new TableCellTraverseAdapter(this.cellEditor, this.theValueObject, row, column));
            this.cellEditor.getControl().addPaintListener((PaintListener)new TableCellPaintAdapter());
            this.cellEditor.getControl().setBackground(Display.getCurrent().getSystemColor(25));
            this.cellEditor.getControl().setForeground(Display.getCurrent().getSystemColor(24));
            this.cellEditor.addListener((ICellEditorListener)new TableCellEditorAdapter(this.cellEditor, this.theValueObject, row, column));
            this.controlEditor.setEditor(this.cellEditor.getControl());
            this.cellEditor.setValidator((ICellEditorValidator)new TableCellValidator(ValueClassMap.getValueValidatorClass(rawValue)));
            this.cellEditor.setFocus();
            if (this.cellEditor instanceof TextCellEditor) {
                String currentText = row.getText(column);
                ((Text)this.cellEditor.getControl()).setSelection(currentText.length());
            }
            this.datapoolEditorPart.markDirty();
        }
    }

    private Object createEmptyCellObject(String typeName) {
        Object value;
        IValueClassFactory valueFactory = ValueClassMap.getValueClassFactory(typeName);
        if (valueFactory != null) {
            value = valueFactory.createEmptyObject();
        } else {
            try {
                Class<?> objectClass = Class.forName(typeName);
                Constructor<?> objectConstructor = objectClass.getConstructor(new Class[0]);
                value = objectConstructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                value = new String();
            }
        }
        return value;
    }

    private void applyEditingValue(boolean dispose) {
        if (this.cellEditor != null) {
            if (this.tableCursor != null && this.tableCursor.getColumn() > 0) {
                Object updatedValue = null;
                String newDescription = null;
                boolean update = true;
                TableItem selectedTableItem = this.tableCursor.getRow();
                int selectedColumnIndex = this.tableCursor.getColumn();
                if (selectedTableItem == null || selectedTableItem.isDisposed()) {
                    return;
                }
                IDatapoolCell[] rowData = (IDatapoolCell[])selectedTableItem.getData("data");
                IDatapoolCell cell = rowData[this.tableCursor.getColumn() - 1];
                IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)cell.getCellVariable().getSuggestedType();
                if (suggestedType.getSuggestedType() == 3 || suggestedType.getSuggestedType() == 2) {
                    updatedValue = ((CCombo)this.cellEditor.getControl()).getText();
                    newDescription = updatedValue.toString();
                } else if (this.theValueObject == null) {
                    update = false;
                } else {
                    String oldDescription = this.theValueObject.getDescription();
                    updatedValue = this.theValueObject.updateObject();
                    newDescription = this.theValueObject.getDescription();
                    if (newDescription == null && oldDescription == null || newDescription != null && newDescription.equals(oldDescription)) {
                        update = false;
                    }
                }
                if (update) {
                    if (DatapoolEncryptManager.isVariableEncrypted((org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable)cell.getCellVariable())) {
                        String value = String.valueOf(updatedValue);
                        String encryptValue = DatapoolEncryptManager.encrypt((String)value, (String)this.cellkey);
                        updatedValue = encryptValue;
                    }
                    cell.setCellValue(updatedValue);
                    selectedTableItem.setText(selectedColumnIndex, newDescription);
                    this.tableCursor.setSelection(this.table.getSelectionIndex(), selectedColumnIndex);
                    this.datapoolEditorPart.markDirty();
                }
            }
            if (dispose) {
                this.refreshRows();
            }
            this.clearCellEditor();
        }
    }

    private void makeColumns() {
        this.makeHeaderColumn();
        IDatapool datapool = this.getDatapool();
        if (datapool != null) {
            int counter = 0;
            while (counter < datapool.getVariableCount()) {
                IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(counter);
                String type = DatapoolUtil.getInstance().getVariableTypeInfo(variable);
                String tableColumnText = variable.getName();
                if (type != null && type.trim().length() > 0) {
                    tableColumnText = (String.valueOf(variable.getName()) + "::" + type).trim();
                }
                TableColumn tableColumn = new TableColumn(this.table, 16384, counter + 1);
                tableColumn.setResizable(true);
                tableColumn.setText(tableColumnText);
                tableColumn.setData("variable", (Object)variable);
                tableColumn.setWidth(110);
                tableColumn.addSelectionListener(this.headerListener);
                tableColumn.addControlListener(this.resizeColumnListener);
                if (DatapoolEncryptManager.isVariableEncrypted((org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable)variable)) {
                    tableColumn.setImage(TestUIImages.INSTANCE.getImage("datapool_encrypted_variable_obj.gif"));
                }
                ++counter;
            }
        }
    }

    private void makeHeaderColumn() {
        TableColumn recordTableColumn = new TableColumn(this.table, 0x1000000, 0);
        recordTableColumn.setResizable(true);
        recordTableColumn.setWidth(20);
        recordTableColumn.setData("variable", null);
        recordTableColumn.addControlListener(this.resizeColumnListener);
    }

    private void makeRows() {
        if (this.equivalenceClass != null) {
            int variableCount = this.getDatapool().getVariableCount();
            int recordIndex = 0;
            while (recordIndex < this.equivalenceClass.getRecordCount()) {
                IDatapoolCell[] rowData = new IDatapoolCell[variableCount];
                String[] rowContents = new String[variableCount + 1];
                rowContents[0] = String.valueOf(recordIndex);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)this.equivalenceClass.getRecord(recordIndex);
                int cellIndex = 0;
                while (cellIndex < record.getCellCount()) {
                    IDatapoolCell cell = (IDatapoolCell)record.getCell(cellIndex);
                    String cellDescription = new ValueObject(cell.getCellValue()).getDescription();
                    if (DatapoolEncryptManager.isVariableEncrypted((org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable)cell.getCellVariable()) && cellDescription != null && cellDescription.length() > 0) {
                        cellDescription = cellDescription.replaceAll(".{2}", "*");
                    }
                    rowData[cellIndex] = cell;
                    rowContents[cellIndex + 1] = cellDescription;
                    ++cellIndex;
                }
                TableItem item = new TableItem(this.table, 0);
                item.setText(rowContents);
                item.setData("data", (Object)rowData);
                item.setData("record", (Object)record);
                item.setData("equivalenceClass", (Object)this.equivalenceClass);
                ++recordIndex;
            }
        }
    }

    private boolean isWithoutRows() {
        return this.equivalenceClass == null || this.equivalenceClass.getRecordCount() == 0;
    }

    private int findColumnIndex(String name) {
        int i = 1;
        while (i < this.table.getColumnCount()) {
            TableColumn tableColumn = this.table.getColumn(i);
            IDatapoolVariable variable = (IDatapoolVariable)tableColumn.getData("variable");
            if (variable != null && name.equals(variable.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void widgetSelected(SelectionEvent e) {
        int selectedRowIndex = this.table.getSelectionIndex();
        if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
            int maxColumnIndex;
            int selectedColumnIndex = this.tableCursor.getColumn();
            int columnCount = this.table.getColumnCount();
            int n = maxColumnIndex = columnCount == 0 ? 0 : columnCount - 1;
            if (selectedColumnIndex >= 0 && selectedRowIndex >= 0 && selectedRowIndex < this.table.getItemCount() && selectedColumnIndex >= 0 && selectedColumnIndex <= maxColumnIndex) {
                this.tableCursor.setSelection(selectedRowIndex, selectedColumnIndex);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void insertRow() {
        this.insertRowAfter(0);
    }

    public void addRow() {
        this.insertRowAfter(1);
    }

    private void insertRowAfter(int offset) {
        if (this.equivalenceClass == null) {
            return;
        }
        int newRowIndex = this.table.getSelectionIndex() + offset;
        if (newRowIndex > this.equivalenceClass.getRecordCount() + 1) {
            return;
        }
        if (newRowIndex < 0) {
            newRowIndex = 0;
        }
        try {
            this.setWaitCursor();
            org.eclipse.hyades.edit.datapool.IDatapoolRecord record = this.equivalenceClass.constructRecord();
            this.equivalenceClass.insertRecord(record, newRowIndex);
            this.refreshRows();
            this.tableCursor.redraw();
        }
        finally {
            this.unsetWaitCursor();
        }
    }

    public void deleteRow() {
        if (!this.showRecords) {
            return;
        }
        int[] selectionIndices = this.table.getSelectionIndices();
        if (selectionIndices.length == 0) {
            return;
        }
        try {
            this.setWaitCursor();
            this.refreshRowsScheduled = true;
            Arrays.sort(selectionIndices);
            int counter = 0;
            while (counter < selectionIndices.length) {
                this.equivalenceClass.removeRecord(selectionIndices[counter] - counter);
                ++counter;
            }
            this.refreshRows();
            if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
                this.tableCursor.redraw();
            }
        }
        finally {
            this.unsetWaitCursor();
        }
    }

    public void editRow() {
        if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
            this.editRowAux(this.tableCursor.getRow());
        }
    }

    private void editRowAux(TableItem tableItem) {
        block10: {
            if (this.showRecords && this.getEquivalenceClass().getRecordCount() > 0) {
                DatapoolRowDialog dialog;
                TableItem previousTableItem;
                org.eclipse.hyades.edit.datapool.IDatapoolRecord previousRecord = null;
                int rowIndex = this.table.getSelectionIndex();
                if (rowIndex != 0 && (previousTableItem = this.table.getItem(rowIndex - 1)) != null) {
                    previousRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)previousTableItem.getData("record");
                }
                if ((dialog = new DatapoolRowDialog(Display.getCurrent().getActiveShell(), (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData("record"), previousRecord)).open() == 0) {
                    try {
                        try {
                            this.setWaitCursor();
                            org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData("record");
                            int recordIndex = this.getRecordIndex(this.equivalenceClass, record);
                            int insertionRecordIndex = dialog.getInsertionRecordIndex();
                            if (recordIndex == insertionRecordIndex) break block10;
                            if (insertionRecordIndex == -1) {
                                this.equivalenceClass.moveRecord(recordIndex, 0);
                                break block10;
                            }
                            if (insertionRecordIndex > recordIndex) {
                                this.equivalenceClass.moveRecord(recordIndex, insertionRecordIndex);
                                break block10;
                            }
                            this.equivalenceClass.moveRecord(recordIndex, insertionRecordIndex + 1);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.unsetWaitCursor();
                        }
                    }
                    finally {
                        this.unsetWaitCursor();
                    }
                }
            }
        }
    }

    public void insertColumn() {
        if (!this.showVariables) {
            return;
        }
        if (this.table.getColumnCount() >= DatapoolConstants.MAXIMUM_VARIABLE_LIMIT) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)UiPluginResourceBundle.DatapoolEditor_Variables, (String)NLS.bind((String)UiPluginResourceBundle.DATA_COL_DLG_ERROR_VARIABLE_LIMIT_EXCEEDED, (Object)DatapoolConstants.MAXIMUM_VARIABLE_LIMIT));
            return;
        }
        int selectedColumnIndex = -1;
        if (this.headerSelectionIndex != -1) {
            selectedColumnIndex = this.headerSelectionIndex;
            this.headerSelectionIndex = -1;
        } else if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
            selectedColumnIndex = this.tableCursor.getColumn();
        }
        TableColumn previousTableColumn = null;
        if (selectedColumnIndex > 0) {
            previousTableColumn = this.table.getColumn(selectedColumnIndex - 1);
        }
        IDatapoolVariable previousVariable = null;
        if (previousTableColumn != null) {
            previousVariable = (IDatapoolVariable)previousTableColumn.getData("variable");
        }
        IDatapool datapool = this.getDatapool();
        DatapoolColumnDialog datapoolColumnDialog = new DatapoolColumnDialog(Display.getCurrent().getActiveShell(), datapool, this.password, null, previousVariable);
        if (datapoolColumnDialog.open() == 0) {
            String newKey = datapoolColumnDialog.getNewKey();
            if (newKey != null) {
                this.password = newKey;
                String oldKey = datapoolColumnDialog.getOldKey();
                if (oldKey != null) {
                    DatapoolEncryptManager.changeKeyOfEncryptedCell((IDatapool)datapool, (String)oldKey, (String)this.password);
                }
                DatapoolEncryptManager.changeKey((String)this.password, (IDatapool)datapool);
            }
            try {
                int maxColumnIndex;
                int insertionIndex;
                this.setWaitCursor();
                IDatapoolVariable variable = datapool.constructVariable();
                variable.setName(datapoolColumnDialog.getName());
                IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)variable.getSuggestedType();
                DatapoolSuggestedTypeChecker.getInstance().setVariableType(suggestedType, datapoolColumnDialog.getType());
                variable.setSuggestedType(suggestedType);
                if (variable instanceof DPLVariable) {
                    ((DPLVariable)variable).setEncrypted(datapoolColumnDialog.isEncrypted());
                }
                if ((insertionIndex = this.findColumnIndex(datapoolColumnDialog.getInsertionVariableName())) == -1) {
                    insertionIndex = 0;
                }
                datapool.insertVariable(variable, insertionIndex);
                int row = this.table.getSelectionIndex() > -1 ? this.table.getSelectionIndex() : 0;
                int columnCount = this.table.getColumnCount();
                int n = maxColumnIndex = columnCount == 0 ? 0 : columnCount - 1;
                if (this.tableCursor != null && !this.tableCursor.isDisposed() && row >= 0 && row < this.table.getItemCount() && insertionIndex >= 0 && insertionIndex <= maxColumnIndex) {
                    this.tableCursor.setSelection(row, insertionIndex + 1);
                }
                this.refreshRows();
            }
            finally {
                this.unsetWaitCursor();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteColumn() {
        if (!this.showVariables) {
            return;
        }
        IDatapool datapool = this.getDatapool();
        if (this.tableCursor == null || this.tableCursor.isDisposed()) {
            if (this.table.getItemCount() != 0 || this.tableUtil.getColumnCount() <= 0) return;
            DatapoolDeleteColumnDialog dialog = new DatapoolDeleteColumnDialog(Display.getCurrent().getActiveShell(), datapool);
            if (dialog.open() == 0) {
                try {
                    this.setWaitCursor();
                    String variableID = dialog.getDeletedVariableID();
                    int variableIndex = datapool.getVariableIndexById(variableID);
                    datapool.removeVariable(variableIndex);
                }
                finally {
                    this.unsetWaitCursor();
                }
            }
        } else {
            int selectedColumnIndex = -1;
            if (this.headerSelectionIndex != -1) {
                selectedColumnIndex = this.headerSelectionIndex;
                this.headerSelectionIndex = -1;
            } else if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
                selectedColumnIndex = this.tableCursor.getColumn();
            }
            if (selectedColumnIndex < 1) {
                return;
            }
            try {
                this.setWaitCursor();
                TableColumn tableColumn = this.table.getColumn(selectedColumnIndex);
                IDatapoolVariable variable = (IDatapoolVariable)tableColumn.getData("variable");
                int variableIndex = datapool.getVariableIndexById(variable.getId());
                datapool.removeVariable(variableIndex);
            }
            finally {
                this.unsetWaitCursor();
            }
        }
        if (DatapoolEncryptManager.containsEncryptedVariable((IDatapool)datapool)) return;
        DatapoolEncryptManager.removeKey((IDatapool)datapool);
        this.password = null;
    }

    public void editColumn() {
        int selectedColumnIndex = -1;
        if (this.headerSelectionIndex != -1) {
            selectedColumnIndex = this.headerSelectionIndex;
            this.headerSelectionIndex = -1;
        } else if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
            selectedColumnIndex = this.tableCursor.getColumn();
        }
        this.editColumnAux(this.table.getColumn(selectedColumnIndex));
    }

    private void editColumnAux(TableColumn tableColumn) {
        if (!this.showVariables) {
            return;
        }
        IDatapool datapool = this.getDatapool();
        int columnIndex = this.table.indexOf(tableColumn);
        TableColumn previousTableColumn = null;
        if (columnIndex != 0) {
            previousTableColumn = this.table.getColumn(columnIndex - 1);
        }
        IDatapoolVariable previousVariable = null;
        if (previousTableColumn != null) {
            previousVariable = (IDatapoolVariable)previousTableColumn.getData("variable");
        }
        IDatapoolVariable variable = (IDatapoolVariable)tableColumn.getData("variable");
        DatapoolColumnDialog datapoolColumnDialog = new DatapoolColumnDialog(Display.getCurrent().getActiveShell(), datapool, this.password, variable, previousVariable);
        if (datapoolColumnDialog.open() == 0) {
            String newKey = datapoolColumnDialog.getNewKey();
            if (newKey != null) {
                this.password = newKey;
                String oldKey = datapoolColumnDialog.getOldKey();
                if (oldKey != null) {
                    DatapoolEncryptManager.changeKeyOfEncryptedCell((IDatapool)datapool, (String)oldKey, (String)this.password);
                }
                DatapoolEncryptManager.changeKey((String)this.password, (IDatapool)datapool);
            }
            if (datapoolColumnDialog.isEncrypted() && !DatapoolEncryptManager.isVariableEncrypted((org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable)variable)) {
                DatapoolEncryptManager.encryptedCellInVarible((org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable)variable, (String)this.password, (IDatapool)datapool);
                if (variable instanceof DPLVariable) {
                    ((DPLVariable)variable).setEncrypted(true);
                }
            } else if (!datapoolColumnDialog.isEncrypted() && DatapoolEncryptManager.isVariableEncrypted((org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable)variable)) {
                DatapoolEncryptManager.decryptedCellInVarible((org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable)variable, (String)this.password, (IDatapool)datapool);
                if (variable instanceof DPLVariable) {
                    ((DPLVariable)variable).setEncrypted(false);
                }
                if (!DatapoolEncryptManager.containsEncryptedVariable((IDatapool)datapool)) {
                    DatapoolEncryptManager.removeKey((IDatapool)datapool);
                    this.password = null;
                }
            }
            try {
                this.setWaitCursor();
                String name = datapoolColumnDialog.getName();
                String insertionVariableID = datapoolColumnDialog.getInsertionVariableID();
                IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)variable.getSuggestedType();
                if (name.equals(variable.getName()) && insertionVariableID.equals(variable.getId())) {
                    return;
                }
                variable.setName(datapoolColumnDialog.getName());
                DatapoolSuggestedTypeChecker.getInstance().setVariableType(suggestedType, datapoolColumnDialog.getType());
                variable.setSuggestedType(suggestedType);
                int insertionIndex = this.findColumnIndex(datapoolColumnDialog.getInsertionVariableName());
                if (insertionIndex == columnIndex - 1) {
                    this.refresh(true);
                    return;
                }
                if (insertionIndex == -1) {
                    datapool.moveVariable(columnIndex - 1, 0);
                } else if (insertionIndex > columnIndex) {
                    datapool.moveVariable(columnIndex - 1, insertionIndex - 1);
                } else {
                    datapool.moveVariable(columnIndex - 1, insertionIndex);
                }
                this.refreshRows();
                this.tableCursor.setSelection(0, 0);
            }
            finally {
                this.unsetWaitCursor();
            }
        }
    }

    public void clearCell() {
        this.clearCellEditor();
        if (this.tableCursor != null && !this.tableCursor.isDisposed() && this.tableCursor.getColumn() > 0) {
            TableItem selectedTableItem = this.tableCursor.getRow();
            int selectedColumnIndex = this.tableCursor.getColumn();
            if (selectedTableItem != null && !selectedTableItem.isDisposed()) {
                IDatapoolCell[] rowData = (IDatapoolCell[])selectedTableItem.getData("data");
                IDatapoolCell cell = rowData[this.tableCursor.getColumn() - 1];
                Object value = cell.getCellValue();
                if (value == null) {
                    return;
                }
                if (value instanceof String) {
                    if (((String)value).length() == 0) {
                        return;
                    }
                    value = new String();
                } else {
                    value = this.createEmptyCellObject(value.getClass().getName());
                }
                cell.setCellValue(value);
                selectedTableItem.setText(selectedColumnIndex, new ValueObject(value).getDescription());
                this.tableCursor.setSelection(this.table.getSelectionIndex(), selectedColumnIndex);
                this.tableCursor.redraw();
                this.datapoolEditorPart.markDirty();
            }
        }
    }

    private void clearRecords() {
        TableItem[] tableItems;
        if (this.getRowSelectionCount() > 0 && (tableItems = this.table.getSelection()) != null) {
            int recordIndex = 0;
            while (recordIndex < tableItems.length) {
                org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItems[recordIndex].getData("record");
                if (record != null && record.getCellCount() > 0) {
                    int cellIndex = 0;
                    while (cellIndex < record.getCellCount()) {
                        ((IDatapoolCell)record.getCell(cellIndex)).setCellValue(null);
                        tableItems[recordIndex].setText(cellIndex + 1, new String());
                        ++cellIndex;
                    }
                    this.datapoolEditorPart.markDirty();
                }
                ++recordIndex;
            }
        }
    }

    public IDatapoolCell getSelectedCell() {
        TableItem selectedTableItem;
        IDatapoolCell selectedCell = null;
        if (this.tableCursor != null && this.tableCursor.getColumn() > 0 && (selectedTableItem = this.tableCursor.getRow()) != null && !selectedTableItem.isDisposed()) {
            selectedCell = ((IDatapoolCell[])selectedTableItem.getData("data"))[this.tableCursor.getColumn() - 1];
        }
        return selectedCell;
    }

    public int getRowSelectionCount() {
        if (this.table != null && !this.table.isDisposed()) {
            return this.table.getSelectionCount();
        }
        return -1;
    }

    public void variableAdded(IDatapool datapool, int newVariableIndex) {
        int selectedRowIndex;
        IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(newVariableIndex);
        String type = DatapoolUtil.getInstance().getVariableTypeInfo(variable);
        String tableColumnText = variable.getName();
        if (type != null && type.trim().length() > 0) {
            tableColumnText = (String.valueOf(variable.getName()) + "::" + type).trim();
        }
        TableColumn tableColumn = new TableColumn(this.table, 16384, newVariableIndex + 1);
        tableColumn.setResizable(true);
        tableColumn.setText(tableColumnText);
        tableColumn.setData("variable", (Object)variable);
        tableColumn.setWidth(110);
        tableColumn.addSelectionListener(this.headerListener);
        tableColumn.addControlListener(this.resizeColumnListener);
        if (DatapoolEncryptManager.isVariableEncrypted((org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable)variable)) {
            tableColumn.setImage(TestUIImages.INSTANCE.getImage("datapool_encrypted_variable_obj.gif"));
        }
        this.tableUtil.insertColumn(tableColumn, newVariableIndex);
        if (this.tableCursor != null && !this.tableCursor.isDisposed() && (selectedRowIndex = this.table.getSelectionIndex()) >= 0) {
            this.table.setSelection(selectedRowIndex);
            this.tableCursor.setSelection(selectedRowIndex, newVariableIndex + 1);
            this.tableCursor.setFocus();
        }
        this.datapoolEditorPart.markDirty();
    }

    public void variableRemoved(IDatapool datapool, int variableIndex) {
        this.tableUtil.deleteColumn(variableIndex + 1);
        if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
            if (variableIndex >= 0) {
                int selectedRowIndex = this.table.getSelectionIndex();
                if (selectedRowIndex >= 0) {
                    this.table.select(selectedRowIndex);
                    this.tableCursor.setSelection(selectedRowIndex, variableIndex);
                }
            } else {
                this.table.deselectAll();
            }
        }
        this.datapoolEditorPart.markDirty();
    }

    public void variableMoved(IDatapool datapool, int sourceVariableIndex, int targetVariableIndex) {
        int selectedIndex;
        this.tableUtil.moveColumn(sourceVariableIndex + 1, targetVariableIndex + 1);
        if (this.tableCursor != null && !this.tableCursor.isDisposed() && targetVariableIndex > 0 && (selectedIndex = this.table.getSelectionIndex()) >= 0) {
            this.table.select(selectedIndex);
            this.tableCursor.setSelection(selectedIndex, targetVariableIndex);
        }
        this.datapoolEditorPart.markDirty();
    }

    public void variableChanged(IDatapool datapool, int variableIndex) {
        IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(variableIndex);
        String type = DatapoolUtil.getInstance().getVariableTypeInfo(variable);
        String tableColumnText = variable.getName();
        if (type != null && type.trim().length() > 0) {
            tableColumnText = (String.valueOf(variable.getName()) + "::" + type).trim();
        }
        TableColumn tableColumn = this.table.getColumn(this.findColumnIndex(variable.getName()));
        tableColumn.setText(tableColumnText);
        tableColumn.setData("variable", (Object)variable);
        if (DatapoolEncryptManager.isVariableEncrypted((org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable)variable)) {
            tableColumn.setImage(TestUIImages.INSTANCE.getImage("datapool_encrypted_variable_obj.gif"));
        } else {
            tableColumn.setImage(null);
        }
        this.datapoolEditorPart.markDirty();
    }

    public void variableChanged(IDatapool datapool, int variableIndex, String oldName) {
        this.variableChanged(datapool, variableIndex);
    }

    public void equivalenceClassChanged(IDatapool datapool, int equivalenceClassIndex) {
        if (this.getEquivalenceClassIndex() == equivalenceClassIndex) {
            this.refreshRows();
        }
    }

    public void equivalenceClassChanged(IDatapool datapool, int equivalenceClassIndex, String oldName) {
    }

    public void equivalenceClassAdded(IDatapool datapool, int newEquivalenceClassIndex) {
    }

    public void equivalenceClassRemoved(IDatapool datapool, int equivalenceClassIndex) {
    }

    public void equivalenceClassMoved(IDatapool datapool, int sourceEquivalenceClassIndex, int targetEquivalenceClassIndex) {
        if (this.getEquivalenceClassIndex() == sourceEquivalenceClassIndex) {
            this.setEquivalenceClass((IDatapoolEquivalenceClass)datapool.getEquivalenceClass(targetEquivalenceClassIndex));
            this.refreshRows();
        }
    }

    public void recordAdded(IDatapool datapool, int equivalenceClassIndex, int newRecordIndex) {
        if (this.getEquivalenceClassIndex() == equivalenceClassIndex) {
            this.recordAdded(newRecordIndex);
        }
    }

    protected void recordAdded(int newRecordIndex) {
        if (this.equivalenceClass == null) {
            return;
        }
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)this.equivalenceClass.getRecord(newRecordIndex);
        String[] rowContents = new String[this.table.getColumnCount()];
        IDatapoolCell[] rowData = new IDatapoolCell[this.table.getColumnCount() - 1];
        rowContents[0] = String.valueOf(newRecordIndex);
        int i = 0;
        while (i < record.getCellCount()) {
            IDatapoolCell cell = (IDatapoolCell)record.getCell(i);
            org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable cellVariable = cell.getCellVariable();
            int index = this.findColumnIndex(cellVariable.getName());
            rowContents[index] = new ValueObject(cell.getCellValue()).getDescription();
            rowData[index - 1] = cell;
            ++i;
        }
        TableItem tableItem = new TableItem(this.table, 0, newRecordIndex);
        tableItem.setText(rowContents);
        tableItem.setData("data", (Object)rowData);
        tableItem.setData("record", (Object)record);
        tableItem.setData("equivalenceClass", (Object)this.equivalenceClass);
        this.repopulateRowLabels();
        if (this.table.getItemCount() == 1) {
            this.createCursor();
        }
        if (this.tableCursor != null && !this.tableCursor.isDisposed() && this.table != null) {
            this.table.setSelection(newRecordIndex);
            this.tableCursor.setSelection(newRecordIndex, this.tableCursor.getColumn());
            this.tableCursor.setFocus();
        }
        this.datapoolEditorPart.markDirty();
    }

    public void recordRemoved(IDatapool datapool, int equivalenceClassIndex, int recordIndex) {
        if (this.getEquivalenceClassIndex() == equivalenceClassIndex) {
            this.recordRemoved(recordIndex);
        }
    }

    protected void recordRemoved(int recordIndex) {
        this.table.remove(recordIndex);
        if (!this.refreshRowsScheduled) {
            this.repopulateRowLabels();
        }
        this.datapoolEditorPart.markDirty();
        if (this.tableCursor != null && !this.tableCursor.isDisposed() && this.table != null) {
            int tableSize = this.table.getItemCount();
            if (tableSize == 0) {
                this.table.deselectAll();
                this.tableCursor.setVisible(false);
                return;
            }
            if (tableSize > recordIndex) {
                this.table.setSelection(recordIndex);
                this.tableCursor.setSelection(recordIndex, 0);
                return;
            }
            if (tableSize > recordIndex - 1) {
                this.table.setSelection(recordIndex - 1);
                this.tableCursor.setSelection(recordIndex - 1, 0);
            }
        }
    }

    public void recordMoved(IDatapool datapool, int equivalenceClassIndex, int sourceRecordIndex, int targetRecordIndex) {
        if (this.getEquivalenceClassIndex() == equivalenceClassIndex) {
            this.recordMoved(sourceRecordIndex, targetRecordIndex);
        }
    }

    protected void recordMoved(int sourceRecordIndex, int targetRecordIndex) {
        this.tableUtil.moveRow(sourceRecordIndex, targetRecordIndex);
        this.repopulateRowLabels();
        this.tableCursor.redraw();
        this.datapoolEditorPart.markDirty();
    }

    public void cellChanged(IDatapool datapool, int equivalenceClassIndex, int recordIndex, int variableIndex) {
        if (this.getEquivalenceClassIndex() == equivalenceClassIndex) {
            this.cellChanged(recordIndex, variableIndex);
        }
    }

    protected void cellChanged(int recordIndex, int variableIndex) {
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)this.equivalenceClass.getRecord(recordIndex);
        IDatapoolVariable variable = (IDatapoolVariable)this.getDatapool().getVariable(variableIndex);
        IDatapoolCell cell = null;
        int i = 0;
        while (i < record.getCellCount()) {
            cell = (IDatapoolCell)record.getCell(i);
            if (cell.getCellVariable().equals(variable)) break;
            cell = null;
            ++i;
        }
        if (cell != null) {
            TableItem tableItem = this.table.getItem(recordIndex);
            tableItem.setText(variableIndex + 1, new ValueObject(cell.getCellValue()).getDescription());
            this.tableCursor.setSelection(recordIndex, variableIndex + 1);
            this.datapoolEditorPart.markDirty();
        }
        this.datapoolEditorPart.markDirty();
    }

    public void equivalenceClassReordered(IDatapool datapool, int equivalenceClassIndex) {
        if (this.getEquivalenceClassIndex() == equivalenceClassIndex) {
            this.equivalenceClassReordered();
        }
    }

    protected void equivalenceClassReordered() {
        boolean changed = false;
        int i = 0;
        while (i < this.equivalenceClass.getRecordCount()) {
            org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)this.equivalenceClass.getRecord(i);
            int oldTableRowIndex = this.findRowIndex(record);
            if (oldTableRowIndex != i) {
                this.tableUtil.swapRow(oldTableRowIndex, i);
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.datapoolEditorPart.markDirty();
        }
    }

    public void recordChanged(IDatapool datapool, int EquivClassIndex, int recordIndex) {
    }

    public void save(IDatapool datapool) {
    }

    private int findRowIndex(org.eclipse.hyades.edit.datapool.IDatapoolRecord record) {
        int i = 0;
        while (i < this.equivalenceClass.getRecordCount()) {
            org.eclipse.hyades.edit.datapool.IDatapoolRecord currentRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)this.equivalenceClass.getRecord(i);
            if (currentRecord.equals(record)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void repopulateRowLabels() {
        int i = 0;
        while (i < this.equivalenceClass.getRecordCount()) {
            TableItem tableItem = this.table.getItem(i);
            tableItem.setText(0, String.valueOf(i));
            ++i;
        }
    }

    private int getRecordIndex(IDatapoolEquivalenceClass equivalenceClass, org.eclipse.hyades.edit.datapool.IDatapoolRecord record) {
        int i = 0;
        while (i < equivalenceClass.getRecordCount()) {
            IDatapoolRecord compRecord = equivalenceClass.getRecord(i);
            if (compRecord.equals(record)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected Object[] createCells(IDatapool datapool) {
        Object[] cells = new Object[datapool.getVariableCount()];
        int i = 0;
        while (i < datapool.getVariableCount()) {
            cells[i] = new String();
            ++i;
        }
        return cells;
    }

    private void setVendorConfiguration() {
        if (this.vendorID == null) {
            return;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(UiPlugin.getID()) + ".vendorConfigurationExtension");
        if (extensionPoint != null) {
            try {
                IConfigurationElement[] extensionPoints = extensionPoint.getConfigurationElements();
                int i = 0;
                while (i < extensionPoints.length) {
                    String extVendorID = extensionPoints[i].getAttribute("vendorID");
                    if (this.vendorID.equals(extVendorID)) {
                        String strShowVar = extensionPoints[i].getAttribute("showVariableCommands");
                        Boolean boolShowVar = Boolean.valueOf(strShowVar);
                        this.showVariables = boolShowVar;
                        this.showRecords = boolShowVar;
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public TableCursor getTableCursor() {
        return this.tableCursor;
    }

    public void save() {
        IDatapool datapool = this.getDatapool();
        this.datapoolFactory.save(datapool);
    }

    public void dispose() {
        this.clearCellEditor();
        if (this.table != null && !this.table.isDisposed()) {
            this.table.dispose();
        }
        if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
            this.tableCursor.dispose();
        }
        if (this.contextMenu != null && !this.contextMenu.isDisposed()) {
            this.contextMenu.dispose();
        }
        if (this.viewer != null) {
            this.viewer = null;
        }
        if (this.getDatapool() != null) {
            this.getDatapool().removeDatapoolListener((IDatapoolListener)this);
        }
        this.equivalenceClass = null;
        this.datapool = null;
        this.tableUtil = null;
        this.datapoolEditorPart = null;
        this.datapoolFactory = null;
        this.vendorID = null;
        this.controlEditor = null;
    }

    public IDatapool getDatapool() {
        return this.datapool;
    }

    public void cut() {
        if (this.isF2Mode) {
            this.cellEditor.performCut();
        } else if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
            int columnIndex = this.tableCursor.getColumn();
            if (columnIndex == 0) {
                this.cutRecords();
            } else if (columnIndex > 0) {
                this.cutCell();
            }
        }
    }

    public void copy() {
        if (this.isF2Mode) {
            this.cellEditor.performCopy();
        } else if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
            int columnIndex = this.tableCursor.getColumn();
            if (columnIndex == 0) {
                this.copyRecords();
            } else if (columnIndex > 0) {
                this.copyCell();
            }
        }
    }

    public void paste() {
        if (this.isF2Mode) {
            this.cellEditor.performPaste();
        } else if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
            int columnIndex = this.tableCursor.getColumn();
            if (columnIndex == 0) {
                this.pasteRecords();
            } else if (columnIndex > 0) {
                this.pasteCell();
            }
        }
    }

    private void cutCell() {
        this.copyCell();
        this.clearCell();
    }

    private void copyCell() {
        if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
            int columnIndex;
            int rowIndex = -1;
            TableItem row = this.tableCursor.getRow();
            if (row != null) {
                rowIndex = this.table.indexOf(row);
            }
            if ((columnIndex = this.tableCursor.getColumn()) > 0 && rowIndex != -1) {
                this.datapoolClipboard.setCellContents((IDatapoolCell)((org.eclipse.hyades.edit.datapool.IDatapoolRecord)row.getData("record")).getCell(columnIndex - 1));
            }
        }
    }

    private void pasteCell() {
        if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
            int rowIndex;
            int columnIndex = this.tableCursor.getColumn();
            TableItem row = this.tableCursor.getRow();
            if (columnIndex != -1 && row != null && (rowIndex = this.table.indexOf(row)) != -1) {
                IDatapoolCell cell = (IDatapoolCell)((org.eclipse.hyades.edit.datapool.IDatapoolRecord)row.getData("record")).getCell(columnIndex - 1);
                String cellContents = this.datapoolClipboard.getCellContents();
                if (cellContents != null) {
                    String cellText = this.setCellValue(cellContents, cell);
                    if (cellText != null) {
                        row.setText(columnIndex, cellText);
                        this.tableCursor.setSelection(this.table.getSelectionIndex(), columnIndex);
                        this.datapoolEditorPart.markDirty();
                        this.tableCursor.redraw();
                    }
                } else {
                    String[][] recordContents = this.datapoolClipboard.getRecordContents();
                    if (recordContents != null) {
                        if (columnIndex == 1) {
                            this.pasteRecords(new TableItem[]{row});
                            this.tableCursor.redraw();
                        } else if (columnIndex > 1) {
                            MessageDialog messageDialog = new MessageDialog(this.parent.getShell(), UiPluginResourceBundle.PASTE_TEXT, null, UiPluginResourceBundle.DATA_PASTE_DIFF_SIZE, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
                            messageDialog.open();
                        }
                    } else {
                        String cellText;
                        String stringContents = this.datapoolClipboard.getStringContents();
                        if (stringContents != null && (cellText = this.setCellValue(stringContents, cell)) != null) {
                            row.setText(columnIndex, cellText);
                            this.tableCursor.setSelection(this.table.getSelectionIndex(), columnIndex);
                            this.datapoolEditorPart.markDirty();
                            this.tableCursor.redraw();
                        }
                    }
                }
            }
        }
    }

    private void cutRecords() {
        this.copyRecords();
        this.clearRecords();
    }

    private void copyRecords() {
        TableItem[] tableItems;
        if (this.getRowSelectionCount() > 0 && (tableItems = this.table.getSelection()) != null) {
            org.eclipse.hyades.edit.datapool.IDatapoolRecord[] records = new org.eclipse.hyades.edit.datapool.IDatapoolRecord[tableItems.length];
            int counter = 0;
            while (counter < tableItems.length) {
                records[counter] = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItems[counter].getData("record");
                ++counter;
            }
            this.datapoolClipboard.setRecordContents(records);
        }
    }

    private void pasteRecords() {
        if (this.getRowSelectionCount() > 0) {
            this.pasteRecords(this.table.getSelection());
        }
    }

    private void pasteRecords(TableItem[] tableItems) {
        if (this.table.getColumnCount() <= 1) {
            return;
        }
        if (tableItems == null || tableItems.length == 0) {
            return;
        }
        boolean isEmpty = true;
        int i = 0;
        while (i < tableItems.length) {
            int j = 1;
            while (j < this.table.getColumnCount()) {
                if (tableItems[i].getText(j).length() > 0) {
                    isEmpty = false;
                    break;
                }
                ++j;
            }
            if (!isEmpty) break;
            ++i;
        }
        if (!isEmpty) {
            Object[] messageElements = new Object[]{UiPluginResourceBundle.DATA_PASTE_OVERWRITE};
            String message = NLS.bind((String)"{0}", (Object[])messageElements);
            MessageDialog overwriteDialog = new MessageDialog(this.parent.getShell(), UiPluginResourceBundle.PASTE_TEXT, null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            if (overwriteDialog.open() != 0) {
                return;
            }
        }
        TableItem firstItem = tableItems[0];
        int firstItemIndex = this.table.indexOf(firstItem);
        String[][] recordContents = this.datapoolClipboard.getRecordContents();
        if (recordContents == null || recordContents.length == 0) {
            String cellContents = this.datapoolClipboard.getCellContents();
            if (cellContents != null) {
                this.pasteDataToCell(cellContents, firstItem, 1);
            } else {
                String stringConents = this.datapoolClipboard.getStringContents();
                if (stringConents != null) {
                    this.pasteDataToCell(stringConents, firstItem, 1);
                }
            }
            return;
        }
        int i2 = 0;
        while (i2 < recordContents.length) {
            String[] recordData;
            if (firstItemIndex + i2 < this.table.getItemCount() && (recordData = recordContents[i2]) != null) {
                TableItem tableItem = this.table.getItem(firstItemIndex + i2);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData("record");
                int j = 0;
                while (j < recordData.length) {
                    if (j < record.getCellCount()) {
                        this.pasteDataToCell(recordData[j], tableItem, j + 1);
                    }
                    ++j;
                }
            }
            ++i2;
        }
    }

    private void pasteDataToCell(String data, TableItem tableItem, int index) {
        String cellText;
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData("record");
        if (index - 1 < record.getCellCount() && (cellText = this.setCellValue(data, (IDatapoolCell)record.getCell(index - 1))) != null) {
            tableItem.setText(index, cellText);
            this.datapoolEditorPart.markDirty();
        }
    }

    private String setCellValue(String cellValue, IDatapoolCell cell) {
        if (DatapoolEncryptManager.isVariableEncrypted((org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable)cell.getCellVariable())) {
            if (this.password == null) {
                DatapoolInputKeyDialog datapoolInputKeyDialog = new DatapoolInputKeyDialog(Display.getCurrent().getActiveShell(), this.datapool);
                if (datapoolInputKeyDialog.open() == 0) {
                    this.password = datapoolInputKeyDialog.getKey();
                } else {
                    return null;
                }
            }
            cell.setCellValue((Object)DatapoolEncryptManager.encrypt((String)cellValue, (String)this.password));
            return new ValueObject(cell.getCellValue()).getDescription().replaceAll(".{2}", "*");
        }
        cell.setCellValue((Object)cellValue);
        return new ValueObject(cell.getCellValue()).getDescription();
    }

    public IDatapoolPart getIDatapoolPart() {
        return this.datapoolEditorPart;
    }

    public void refresh() {
        this.refresh(true);
    }

    public void refresh(boolean reload) {
        try {
            this.setWaitCursor();
            this.clearCellEditor();
            if (this.equivalenceClass == null) {
                this.hideTable();
            } else {
                this.restoreTable();
                if (reload) {
                    this.refreshColumns();
                    this.refreshRows();
                }
                this.resetCursor();
            }
        }
        finally {
            this.unsetWaitCursor();
        }
    }

    public void refresh(IDatapool datapool) {
        this.refresh(this.getDefaultEquivalenceClass(datapool));
    }

    public void refresh(IDatapoolEquivalenceClass ec) {
        if (this.equivalenceClass != ec) {
            IDatapool dp = (IDatapool)ec.getDatapool();
            if (this.datapool != null && this.datapool != dp) {
                this.datapool.removeDatapoolListener((IDatapoolListener)this);
            }
            if (dp != null && dp != this.datapool) {
                dp.addDatapoolListener((IDatapoolListener)this);
            }
            this.setEquivalenceClass(ec);
            this.refresh(true);
        } else {
            this.refresh(false);
        }
    }

    private void hideTable() {
        this.table.setVisible(false);
        this.table.setEnabled(false);
        this.table.setHeaderVisible(false);
        this.datapoolMenuManager.setTable(null);
    }

    private void restoreTable() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.setEnabled(true);
            this.table.setVisible(true);
            this.table.setHeaderVisible(true);
            this.datapoolMenuManager.setTable(this);
        }
    }

    private void refreshColumns() {
        TableItem selectedItem;
        IDatapool datapool = this.getDatapool();
        int newColumnCount = datapool.getVariableCount();
        int oldColumnCount = this.tableUtil.getColumnCount() - 1;
        if (this.tableCursor != null && !this.tableCursor.isDisposed() && (selectedItem = this.tableCursor.getRow()) != null) {
            int selectedColumnIndex = this.tableCursor.getColumn();
            if (selectedColumnIndex > newColumnCount) {
                this.tableCursor.setSelection(selectedItem, newColumnCount);
            } else {
                this.tableCursor.setSelection(selectedItem, selectedColumnIndex);
            }
        }
        if (oldColumnCount > newColumnCount) {
            int numberToDelete = oldColumnCount - newColumnCount;
            int i = 0;
            while (i < numberToDelete) {
                this.tableUtil.deleteColumn(newColumnCount + 1);
                ++i;
            }
        }
        int counter = 0;
        while (counter < newColumnCount) {
            TableColumn tableColumn = null;
            if (counter + 1 < this.tableUtil.getColumnCount()) {
                tableColumn = this.table.getColumn(counter + 1);
            } else {
                tableColumn = new TableColumn(this.table, 16384, counter + 1);
                tableColumn.setWidth(110);
                tableColumn.addSelectionListener(this.headerListener);
                tableColumn.addControlListener(this.resizeColumnListener);
            }
            IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(counter);
            String type = DatapoolUtil.getInstance().getVariableTypeInfo(variable);
            String tableColumnText = variable.getName();
            if (type != null && type.trim().length() > 0) {
                tableColumnText = (String.valueOf(variable.getName()) + "::" + type).trim();
            }
            tableColumn.setResizable(true);
            tableColumn.setText(tableColumnText);
            tableColumn.setData("variable", (Object)variable);
            if (DatapoolEncryptManager.isVariableEncrypted((org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable)variable)) {
                tableColumn.setImage(TestUIImages.INSTANCE.getImage("datapool_encrypted_variable_obj.gif"));
            } else {
                tableColumn.setImage(null);
            }
            ++counter;
        }
    }

    private void refreshRows() {
        TableItem selectedItem;
        this.refreshRowsScheduled = false;
        int rowIndex = 0;
        int oldRowCount = this.table.getItemCount();
        int columnCount = this.table.getColumnCount();
        int variableCount = this.getDatapool().getVariableCount();
        HashMap<String, Integer> columnIndexes = new HashMap<String, Integer>(columnCount - 1);
        int columnIndex = 1;
        while (columnIndex < columnCount) {
            IDatapoolVariable variable = (IDatapoolVariable)this.table.getColumn(columnIndex).getData("variable");
            if (variable != null) {
                columnIndexes.put(variable.getId(), new Integer(columnIndex));
            }
            ++columnIndex;
        }
        int i = 0;
        while (i < this.equivalenceClass.getRecordCount()) {
            org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)this.equivalenceClass.getRecord(i);
            String[] rowContents = new String[variableCount + 1];
            rowContents[0] = String.valueOf(i);
            IDatapoolCell[] rowData = new IDatapoolCell[variableCount];
            int k = 0;
            while (k < record.getCellCount()) {
                IDatapoolCell cell = (IDatapoolCell)record.getCell(k);
                String cellDescription = new ValueObject(cell.getCellValue()).getDescription();
                if (DatapoolEncryptManager.isVariableEncrypted((org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable)cell.getCellVariable()) && cellDescription != null && cellDescription.length() > 0) {
                    cellDescription = cellDescription.replaceAll(".{2}", "*");
                }
                int columnIndex2 = (Integer)columnIndexes.get(cell.getCellVariable().getId());
                rowData[columnIndex2 - 1] = cell;
                rowContents[columnIndex2] = cellDescription;
                ++k;
            }
            TableItem item = null;
            item = rowIndex < this.table.getItemCount() ? this.table.getItem(rowIndex) : new TableItem(this.table, 0);
            item.setText(rowContents);
            item.setData("data", (Object)rowData);
            item.setData("record", (Object)record);
            item.setData("equivalenceClass", (Object)this.equivalenceClass);
            ++rowIndex;
            ++i;
        }
        try {
            if (this.tableCursor == null || this.tableCursor.isDisposed()) {
                this.createCursor();
            }
        }
        catch (Exception exception) {}
        int newRowCount = rowIndex;
        if (this.tableCursor != null && !this.tableCursor.isDisposed() && (selectedItem = this.tableCursor.getRow()) != null) {
            int selectedColumnIndex = this.tableCursor.getColumn();
            int selectedRowIndex = this.table.indexOf(selectedItem);
            if (selectedRowIndex > newRowCount - 1) {
                if (newRowCount - 1 < 0) {
                    this.table.deselectAll();
                    if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
                        this.tableCursor.dispose();
                    }
                } else {
                    this.table.setSelection(newRowCount - 1);
                    this.tableCursor.setSelection(newRowCount - 1, selectedColumnIndex);
                }
            } else {
                this.tableCursor.setSelection(selectedRowIndex, selectedColumnIndex);
            }
        }
        if (oldRowCount > newRowCount) {
            int numberToDelete = oldRowCount - newRowCount;
            int i2 = 0;
            while (i2 < numberToDelete) {
                this.table.remove(newRowCount);
                ++i2;
            }
        }
    }

    private IDatapoolEquivalenceClass getDefaultEquivalenceClass(IDatapool datapool) {
        if (datapool == null) {
            return null;
        }
        int newECIndex = datapool.getDefaultEquivalenceClassIndex();
        if (newECIndex == -1) {
            if (datapool.getEquivalenceClassCount() == 0) {
                datapool.appendEquivalenceClass(datapool.constructEquivalenceClass());
            }
            newECIndex = 0;
        }
        return (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(newECIndex);
    }

    private void setEquivalenceClass(IDatapoolEquivalenceClass ec) {
        if (this.equivalenceClass == ec) {
            return;
        }
        this.equivalenceClass = ec;
        this.datapool = ec == null ? null : (IDatapool)ec.getDatapool();
    }

    private int getEquivalenceClassIndex() {
        if (this.datapool != null && this.equivalenceClass != null) {
            return this.datapool.getEquivalenceClassIndexById(this.getEquivalenceClass().getId());
        }
        return -1;
    }

    public IDatapoolEquivalenceClass getEquivalenceClass() {
        return this.equivalenceClass;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private void clearCellEditor() {
        if (this.cellEditor == null) {
            return;
        }
        this.isF2Mode = false;
        if (this.cellEditor != null) {
            this.cellEditor.dispose();
            this.cellEditor = null;
        }
        if (this.theValueObject != null) {
            this.theValueObject = null;
        }
        if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
            this.tableCursor.setFocus();
        }
    }

    private void terminateMultipleSelection() {
        if (this.table.getItemCount() > 0) {
            int[] selectionIndices = this.table.getSelectionIndices();
            if (selectionIndices.length > 1) {
                Arrays.sort(selectionIndices);
                TableItem row = this.table.getItem(selectionIndices[0]);
                this.table.showItem(row);
                if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
                    this.tableCursor.setSelection(row, 0);
                }
            }
            if (this.tableCursor != null && !this.tableCursor.isDisposed()) {
                if (!this.tableCursor.isVisible()) {
                    this.tableCursor.setVisible(true);
                }
                this.tableCursor.setFocus();
            }
        }
    }

    public void selectAll() {
        this.table.selectAll();
        this.tableCursor.setSelection(0, 0);
        this.tableCursor.setFocus();
    }

    abstract class AbstractTraverseAdapter
    implements TraverseListener {
        private AbstractTraverseAdapter() {
        }

        protected void preTraverse() {
        }

        protected abstract TableCursor getCursor();

        protected abstract int getColumn();

        protected abstract int getRow();

        public void keyTraversed(TraverseEvent e) {
            if (!DatapoolTable.this.isInputValid || DatapoolTable.this.tableCursor == null || DatapoolTable.this.tableCursor.isDisposed()) {
                e.doit = false;
                return;
            }
            if ((e.stateMask & 0x40000) != 0) {
                e.doit = true;
                return;
            }
            if (e.detail == 16 || e.detail == 8 || e.detail == 4) {
                e.doit = false;
                this.preTraverse();
                if (e.detail == 16) {
                    if (this.getColumn() + 1 == DatapoolTable.this.tableUtil.getColumnCount()) {
                        DatapoolTable.this.insertColumn();
                    } else {
                        this.traverseRight();
                    }
                }
                if (e.detail == 8) {
                    this.traverseLeft();
                }
                if (e.detail == 4) {
                    if (this.getRow() + 1 == DatapoolTable.this.table.getItemCount()) {
                        DatapoolTable.this.addRow();
                    }
                    this.traverseDown();
                }
            }
        }

        protected void traverseRight() {
            if (this.getColumn() + 1 < DatapoolTable.this.tableUtil.getColumnCount()) {
                DatapoolTable.this.tableCursor.setSelection(this.getRow(), this.getColumn() + 1);
            }
        }

        protected void traverseLeft() {
            if (this.getColumn() > 0) {
                DatapoolTable.this.tableCursor.setSelection(this.getRow(), this.getColumn() - 1);
            }
        }

        protected void traverseUp() {
            if (this.getRow() > 0) {
                DatapoolTable.this.table.setSelection(this.getRow() - 1);
                DatapoolTable.this.tableCursor.setSelection(this.getRow() - 1, this.getColumn());
            }
        }

        protected void traverseDown() {
            int newRowIndex = this.getRow() + 1;
            if (newRowIndex < DatapoolTable.this.table.getItemCount()) {
                DatapoolTable.this.table.setSelection(newRowIndex);
                DatapoolTable.this.tableCursor.setSelection(newRowIndex, this.getColumn());
            }
        }
    }

    class CursorKeyAdapter
    implements KeyListener {
        private TableCursor cursor = null;
        private IDatapoolPart datapoolPart = null;

        public CursorKeyAdapter(TableCursor cursor, CellEditor cellEditor, IDatapoolPart datapoolPart) {
            this.cursor = cursor;
            this.datapoolPart = datapoolPart;
        }

        public void keyPressed(KeyEvent e) {
            if (DatapoolTable.this.equivalenceClass == null) {
                return;
            }
            if (e.keyCode == 65536) {
                DatapoolTable.this.altKeyDown = true;
                return;
            }
            if (e.keyCode == 131072 || (e.stateMask & 0x20000) != 0) {
                this.cursor.setVisible(false);
                return;
            }
            if (e.keyCode == 27 || e.keyCode == 262144 || e.keyCode == 0x100000A || e.keyCode == 9 || e.keyCode >= 0x100000C && e.keyCode <= 0x1000015 || e.keyCode == 0x1000013 && (e.stateMask & 0x20000) != 0) {
                return;
            }
            int newColumnSelectionIndex = this.cursor.getColumn();
            TableItem newRowSelection = this.cursor.getRow();
            if (newRowSelection == null) {
                return;
            }
            if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001 || e.keyCode == 0x1000006 || e.keyCode == 0x1000005 || e.keyCode == 0x1000007 || e.keyCode == 0x1000008 || e.keyCode == 13 || e.keyCode == 0x1000050) {
                int newRowSelectionIndex = DatapoolTable.this.table.indexOf(newRowSelection);
                if (newRowSelectionIndex > -1 && !DatapoolTable.this.table.isSelected(newRowSelectionIndex)) {
                    DatapoolTable.this.table.setSelection(newRowSelectionIndex);
                }
                return;
            }
            if (e.keyCode == 0x1000003 || e.keyCode == 0x1000004) {
                int newRowSelectionIndex = DatapoolTable.this.table.indexOf(newRowSelection);
                if (newRowSelectionIndex > -1) {
                    DatapoolTable.this.table.setSelection(newRowSelectionIndex);
                }
                return;
            }
            if (this.datapoolPart.isReadOnly()) {
                return;
            }
            if (e.keyCode == 0x1000009 && (e.stateMask & 0x40000) != 0) {
                if (newColumnSelectionIndex >= 0) {
                    DatapoolTable.this.insertColumn();
                }
                return;
            }
            if (e.keyCode == 127) {
                if ((e.stateMask & 0x40000) != 0) {
                    if (newColumnSelectionIndex == 0) {
                        DatapoolTable.this.deleteRow();
                    } else if (newColumnSelectionIndex > 0 && DatapoolTable.this.table.getColumnCount() > 2) {
                        DatapoolTable.this.deleteColumn();
                    }
                }
                return;
            }
            if ((e.stateMask & 0x40000) != 0 || (e.stateMask & 0x10000) != 0) {
                return;
            }
            if (e.keyCode == 0x1000009) {
                if (newColumnSelectionIndex >= 0) {
                    DatapoolTable.this.insertRow();
                }
                return;
            }
            if (newColumnSelectionIndex != 0) {
                String inputString = String.valueOf(e.character);
                if (DatapoolTable.this.cellEditor != null && DatapoolTable.this.cellEditor.getControl() != null) {
                    if (DatapoolTable.this.cellEditor instanceof TextCellEditor) {
                        inputString = String.valueOf(((Text)DatapoolTable.this.cellEditor.getControl()).getText()) + inputString;
                    } else if (DatapoolTable.this.cellEditor instanceof ComboBoxCellEditor && (DatapoolTable.this.cellEditor.getStyle() & 8) == 0) {
                        inputString = String.valueOf(((CCombo)DatapoolTable.this.cellEditor.getControl()).getText()) + inputString;
                    }
                }
                this.datapoolPart.notifyEdit();
                DatapoolTable.this.startCellEditing(newRowSelection, newColumnSelectionIndex);
                if (DatapoolTable.this.cellEditor != null && DatapoolTable.this.cellEditor.getControl() != null) {
                    DatapoolTable.this.isF2Mode = true;
                    if (e.keyCode == 8) {
                        if (DatapoolTable.this.cellEditor instanceof TextCellEditor) {
                            Text cellEditorText = (Text)DatapoolTable.this.cellEditor.getControl();
                            cellEditorText.setText(new String());
                            cellEditorText.setSelection(0);
                        } else if (DatapoolTable.this.cellEditor instanceof ComboBoxCellEditor) {
                            CCombo cellEditorCombo = (CCombo)DatapoolTable.this.cellEditor.getControl();
                            cellEditorCombo.setText(new String());
                            cellEditorCombo.setSelection(new Point(0, 0));
                        }
                    } else if (e.keyCode == 0x100000B) {
                        if (DatapoolTable.this.cellEditor instanceof TextCellEditor) {
                            Text cellEditorText = (Text)DatapoolTable.this.cellEditor.getControl();
                            cellEditorText.setSelection(cellEditorText.getText().length());
                        } else if (DatapoolTable.this.cellEditor instanceof ComboBoxCellEditor) {
                            CCombo cellEditorCombo = (CCombo)DatapoolTable.this.cellEditor.getControl();
                            int textLength = cellEditorCombo.getText().length();
                            cellEditorCombo.setSelection(new Point(textLength, textLength));
                        }
                    } else {
                        if (DatapoolTable.this.cellEditor.getValidator() != null && DatapoolTable.this.cellEditor.getValidator().isValid((Object)inputString) != null) {
                            DatapoolTable.this.isInputValid = false;
                        }
                        if (DatapoolTable.this.cellEditor instanceof TextCellEditor) {
                            Text cellEditorText = (Text)DatapoolTable.this.cellEditor.getControl();
                            cellEditorText.setText(inputString);
                            cellEditorText.setSelection(inputString.length());
                        } else if (DatapoolTable.this.cellEditor instanceof ComboBoxCellEditor && (DatapoolTable.this.cellEditor.getStyle() & 8) == 0) {
                            CCombo cellEditorCombo = (CCombo)DatapoolTable.this.cellEditor.getControl();
                            cellEditorCombo.setText(inputString);
                            cellEditorCombo.setSelection(new Point(inputString.length(), inputString.length()));
                        }
                    }
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 262144 || (e.stateMask & 0x40000) != 0) {
                DatapoolTable.this.terminateMultipleSelection();
            }
            if (DatapoolTable.this.altKeyDown) {
                DatapoolTable.this.altKeyDown = false;
                return;
            }
            if (e.keyCode == 0x1000009 && (e.stateMask & 0x40000) != 0) {
                int selectedColumnIndex = this.cursor.getColumn();
                if (selectedColumnIndex >= 0) {
                    DatapoolTable.this.insertColumn();
                }
                return;
            }
        }
    }

    class CursorMenuDetectAdapter
    implements MenuDetectListener {
        CursorMenuDetectAdapter() {
        }

        public void menuDetected(MenuDetectEvent e) {
            if (DatapoolTable.this.equivalenceClass != null) {
                if (DatapoolTable.this.contextMenu == null || DatapoolTable.this.contextMenu.isDisposed()) {
                    DatapoolTable.this.createMenu();
                }
                DatapoolTable.this.contextMenu.setEnabled(true);
                DatapoolTable.this.contextMenu.setVisible(true);
                DatapoolTable.this.headerSelectionIndex = -1;
            }
        }
    }

    class CursorMouseAdapter
    extends MouseAdapter {
        private Table table = null;
        private TableCursor cursor = null;
        private IDatapoolPart datapoolPart = null;

        public CursorMouseAdapter(Table table, TableCursor cursor, CellEditor cellEditor, IDatapoolPart datapoolPart) {
            this.table = table;
            this.cursor = cursor;
            this.datapoolPart = datapoolPart;
        }

        public void mouseDown(MouseEvent event) {
            if (event.button == 1) {
                DatapoolTable.this.clearCellEditor();
                if (DatapoolTable.this.equivalenceClass != null) {
                    this.datapoolPart.notifyEdit();
                    if (!this.datapoolPart.isReadOnly()) {
                        TableItem row = this.cursor.getRow();
                        int column = this.cursor.getColumn();
                        if (column == 0) {
                            DatapoolTable.this.editRowAux(row);
                        } else {
                            DatapoolTable.this.startCellEditing(row, column);
                            if (DatapoolTable.this.cellEditor != null && DatapoolTable.this.cellEditor.getControl() != null) {
                                DatapoolTable.this.isF2Mode = true;
                                if (DatapoolTable.this.cellEditor instanceof TextCellEditor) {
                                    Text cellEditorText = (Text)DatapoolTable.this.cellEditor.getControl();
                                    cellEditorText.setSelection(cellEditorText.getText().length());
                                } else if (DatapoolTable.this.cellEditor instanceof ComboBoxCellEditor) {
                                    CCombo cellEditorCombo = (CCombo)DatapoolTable.this.cellEditor.getControl();
                                    int textLength = cellEditorCombo.getText().length();
                                    cellEditorCombo.setSelection(new Point(textLength, textLength));
                                }
                            }
                        }
                    }
                }
            }
        }

        public void mouseUp(MouseEvent event) {
            if (event.button > 1 && this.cursor.getColumn() > 0) {
                this.table.setSelection(this.cursor.getRow());
            }
        }
    }

    class CursorSelectionAdapter
    implements SelectionListener {
        private IDatapoolPart datapoolPart = null;

        public CursorSelectionAdapter(TableCursor cursor, CellEditor cellEditor, IDatapoolPart datapoolPart) {
            this.datapoolPart = datapoolPart;
        }

        public void widgetSelected(SelectionEvent event) {
            if (this.datapoolPart.isReadOnly()) {
                return;
            }
            DatapoolTable.this.clearCellEditor();
            if (!DatapoolTable.this.isInputValid) {
                return;
            }
            if (DatapoolTable.this.datapoolMenuManager != null) {
                DatapoolTable.this.setMenuMode(DatapoolTable.this.datapoolMenuManager);
            }
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }
    }

    private class CursorTraverseAdapter
    extends AbstractTraverseAdapter {
        private CursorTraverseAdapter() {
        }

        protected int getColumn() {
            return DatapoolTable.this.tableCursor.getColumn();
        }

        protected int getRow() {
            return DatapoolTable.this.table.indexOf(DatapoolTable.this.tableCursor.getRow());
        }

        protected TableCursor getCursor() {
            return DatapoolTable.this.tableCursor;
        }
    }

    class TableCellEditorAdapter
    implements ICellEditorListener {
        private CellEditor editor = null;

        public TableCellEditorAdapter(CellEditor cellEditor, ValueObject valueObject, TableItem row, int column) {
            this.editor = cellEditor;
        }

        public void applyEditorValue() {
            DatapoolTable.this.isF2Mode = false;
            if (!DatapoolTable.this.isInputValid) {
                return;
            }
            DatapoolTable.this.applyEditingValue(true);
        }

        public void cancelEditor() {
            DatapoolTable.this.isF2Mode = false;
        }

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            if (!newValidState) {
                DatapoolTable.this.isInputValid = false;
            } else {
                DatapoolTable.this.isInputValid = true;
            }
            this.editor.getControl().redraw();
        }
    }

    class TableCellKeyAdapter
    implements KeyListener {
        private int rowIndex = -1;
        private int column = -1;

        public TableCellKeyAdapter(CellEditor cellEditor, ValueObject valueObject, TableItem row, int column) {
            this.column = column;
            if (row != null) {
                this.rowIndex = DatapoolTable.this.table.indexOf(row);
            }
        }

        public void keyPressed(KeyEvent e) {
            if (DatapoolTable.this.equivalenceClass == null) {
                return;
            }
            if (e.character == '\r' || e.character == '\u1000050') {
                if (!DatapoolTable.this.isInputValid) {
                    e.doit = false;
                    return;
                }
                return;
            }
            if (e.keyCode == 0x1000013 && (e.stateMask & 0x20000) != 0) {
                return;
            }
            if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001 || e.keyCode == 0x1000003 || e.keyCode == 0x1000004) {
                if (!DatapoolTable.this.isInputValid) {
                    e.doit = false;
                    return;
                }
                DatapoolTable.this.applyEditingValue(true);
                if (DatapoolTable.this.tableCursor != null && !DatapoolTable.this.tableCursor.isDisposed()) {
                    if (e.keyCode == 0x1000002 && this.rowIndex + 1 < DatapoolTable.this.table.getItemCount()) {
                        DatapoolTable.this.table.setSelection(this.rowIndex + 1);
                        DatapoolTable.this.tableCursor.setSelection(this.rowIndex + 1, this.column);
                    }
                    if (e.keyCode == 0x1000001 && this.rowIndex > 0) {
                        DatapoolTable.this.table.setSelection(this.rowIndex - 1);
                        DatapoolTable.this.tableCursor.setSelection(this.rowIndex - 1, this.column);
                    }
                    if (e.keyCode == 0x1000004 && this.column + 1 < DatapoolTable.this.tableUtil.getColumnCount()) {
                        DatapoolTable.this.tableCursor.setSelection(this.rowIndex, this.column + 1);
                    }
                    if (e.keyCode == 0x1000003 && this.column > 0) {
                        DatapoolTable.this.tableCursor.setSelection(this.rowIndex, this.column - 1);
                    }
                    DatapoolTable.this.tableCursor.setFocus();
                }
                return;
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.character == '\u001b') {
                DatapoolTable.this.clearCellEditor();
                return;
            }
            if (!(e.keyCode != 0x1000002 && e.keyCode != 0x1000001 && e.keyCode != 0x1000003 && e.keyCode != 0x1000004 || DatapoolTable.this.isInputValid)) {
                e.doit = false;
                return;
            }
        }
    }

    class TableCellPaintAdapter
    implements PaintListener {
        TableCellPaintAdapter() {
        }

        public void paintControl(PaintEvent event) {
            if (!DatapoolTable.this.isInputValid) {
                this.drawPolyline(event.gc, (Widget)event.getSource());
            }
        }

        private void drawPolyline(GC gc, Widget widget) {
            if (gc == null) {
                return;
            }
            Rectangle rect = gc.getClipping();
            String str = "";
            if (widget instanceof Text) {
                str = ((Text)widget).getText();
            } else if (widget instanceof CCombo) {
                str = ((CCombo)widget).getText();
            } else if (widget instanceof Combo) {
                str = ((Combo)widget).getText();
            } else {
                return;
            }
            int offset = 2;
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                if (!Character.isWhitespace(c)) break;
                offset += gc.getAdvanceWidth(c);
                ++i;
            }
            int length = gc.textExtent((String)str.trim()).x;
            Point left = new Point(offset, 0);
            Point right = new Point(length + offset + 2, 0);
            gc.setForeground(Display.getCurrent().getSystemColor(3));
            int[] polyline = this.computePolyline(left, right, rect.height);
            gc.drawPolyline(polyline);
        }

        private int[] computePolyline(Point left, Point right, int height) {
            int leftX = left.x;
            int peeks = (right.x - left.x) / 4;
            int length = (2 * peeks + 1) * 2;
            if (length < 0) {
                return new int[0];
            }
            int[] coordinates = new int[length];
            int bottom = left.y + height - 1;
            int top = bottom - 2;
            int i = 0;
            while (i < peeks) {
                int index = 4 * i;
                coordinates[index] = leftX + 4 * i;
                coordinates[index + 1] = bottom;
                coordinates[index + 2] = coordinates[index] + 2;
                coordinates[index + 3] = top;
                ++i;
            }
            coordinates[length - 2] = left.x + 4 * peeks;
            coordinates[length - 1] = bottom;
            return coordinates;
        }
    }

    class TableCellTraverseAdapter
    extends AbstractTraverseAdapter {
        private ValueObject valueObject;
        private int row;
        private int column;

        private TableCellTraverseAdapter(CellEditor editor, ValueObject valueObject, TableItem row, int column) {
            this.valueObject = valueObject;
            this.row = DatapoolTable.this.table.indexOf(row);
            this.column = column;
        }

        public void keyTraversed(TraverseEvent e) {
            super.keyTraversed(e);
            if (e.detail == 64 || e.detail == 32) {
                if (DatapoolTable.this.isF2Mode) {
                    return;
                }
                e.doit = false;
                this.preTraverse();
                if (e.keyCode == 0x1000004) {
                    this.traverseRight();
                }
                if (e.keyCode == 0x1000003) {
                    this.traverseLeft();
                }
                if (e.keyCode == 0x1000001) {
                    this.traverseUp();
                }
                if (e.keyCode == 0x1000002) {
                    this.traverseDown();
                }
            }
        }

        protected void preTraverse() {
            if (this.valueObject != null) {
                DatapoolTable.this.applyEditingValue(true);
            }
        }

        protected int getColumn() {
            return this.column;
        }

        protected int getRow() {
            return this.row;
        }

        protected TableCursor getCursor() {
            return DatapoolTable.this.tableCursor;
        }
    }

    class TableCellValidator
    implements ICellEditorValidator {
        IValidateValueClass validator = null;

        public TableCellValidator(IValidateValueClass validator) {
            this.validator = validator;
        }

        public String isValid(Object value) {
            if (this.validator == null) {
                return null;
            }
            if (this.validator.checkValue(value)) {
                return null;
            }
            Error error = this.validator.getError();
            if (error != null) {
                return error.toString();
            }
            return "Error";
        }
    }
}

