/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.models.common.datapool.util.DatapoolEncryptManager;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolBaseDialog;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DatapoolInputKeyDialog
extends DatapoolBaseDialog {
    private IDatapool datapool = null;
    private String key = null;
    private Label errorLabel = null;

    public DatapoolInputKeyDialog(Shell parentShell, IDatapool datapool) {
        super(parentShell);
        this.datapool = datapool;
    }

    public String getKey() {
        return this.key;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(UiPluginResourceBundle.DatapoolDialog_INPUTKEYDIALGOTITLE);
        GridData gridData = GridDataUtil.createFill();
        gridData.minimumWidth = 300;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        parentComposite.setLayoutData((Object)gridData);
        parentComposite.setLayout((Layout)gridLayout);
        Label keyLabel = new Label(parentComposite, 0);
        keyLabel.setText(UiPluginResourceBundle.DatapoolDialog_INPUTKEYLABEL);
        final Text keyText = new Text(parentComposite, 0x400804);
        keyText.setLayoutData((Object)new GridData(768));
        keyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatapoolInputKeyDialog.this.key = keyText.getText();
                DatapoolInputKeyDialog.this.enableOK();
            }
        });
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.errorLabel = new Label(parentComposite, 0);
        this.errorLabel.setText(UiPluginResourceBundle.DatapoolDialog_WRONGLOGONKEYMES);
        this.errorLabel.setLayoutData((Object)gridData);
        this.errorLabel.setForeground(Display.getDefault().getSystemColor(3));
        this.errorLabel.setVisible(false);
        parentComposite.pack();
        return parentComposite;
    }

    private void enableOK() {
        boolean enableOK = true;
        if (this.key == null || this.key.equals("") || !DatapoolEncryptManager.isKeyCorrect((IDatapool)this.datapool, (String)this.key)) {
            enableOK = false;
            this.errorLabel.setText(UiPluginResourceBundle.DatapoolDialog_WRONGLOGONKEYMES);
        }
        this.errorLabel.setVisible(!enableOK);
        this.getButton(0).setEnabled(enableOK);
    }
}

