/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import java.util.ArrayList;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolBaseDialog;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DatapoolRowDialog
extends DatapoolBaseDialog {
    private IDatapoolRecord selectedRecord = null;
    private IDatapoolRecord previousRecord = null;
    private int insertionRecordIndex = -1;

    public DatapoolRowDialog(Shell parentShell, IDatapoolRecord selectedRecord, IDatapoolRecord previousRecord) {
        super(parentShell);
        this.selectedRecord = selectedRecord;
        this.previousRecord = previousRecord;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getOKButton().setEnabled(false);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(UiPluginResourceBundle.DATA_ROW_DLG_TITLE_EDIT);
        GridData gridData = GridDataUtil.createFill();
        gridData.minimumWidth = 200;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        Composite superComposite = (Composite)super.createDialogArea(parent);
        superComposite.setLayoutData((Object)gridData);
        superComposite.setLayout((Layout)gridLayout);
        Label recordIndexLabel = new Label(superComposite, 0);
        recordIndexLabel.setText(UiPluginResourceBundle.DATA_DLG_POSITION);
        String[] recordLabels = this.getRecordLabels();
        final Combo recordIndexCombo = new Combo(superComposite, 12);
        recordIndexCombo.setItems(recordLabels);
        recordIndexCombo.setLayoutData((Object)new GridData(768));
        recordIndexCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatapoolRowDialog.this.insertionRecordIndex = -1;
                int selectionIndex = recordIndexCombo.getSelectionIndex();
                if (selectionIndex > 0) {
                    String selectionText = recordIndexCombo.getItem(selectionIndex);
                    if (selectionText.startsWith(NLS.bind((String)UiPluginResourceBundle.DATA_DLG_BEFORE, (Object)""))) {
                        DatapoolRowDialog.this.insertionRecordIndex = Integer.parseInt(selectionText.substring(NLS.bind((String)UiPluginResourceBundle.DATA_DLG_BEFORE, (Object)"").length()).trim());
                    } else if (selectionText.startsWith(NLS.bind((String)UiPluginResourceBundle.DATA_DLG_AFTER, (Object)""))) {
                        DatapoolRowDialog.this.insertionRecordIndex = Integer.parseInt(selectionText.substring(NLS.bind((String)UiPluginResourceBundle.DATA_DLG_AFTER, (Object)"").length()).trim());
                    }
                }
                DatapoolRowDialog.this.getOKButton().setEnabled(true);
            }
        });
        this.insertionRecordIndex = -1;
        int previousRecordLastIndex = this.getPreviousRecordLastIndex(recordLabels);
        if (previousRecordLastIndex == -1) {
            recordIndexCombo.select(0);
        } else {
            recordIndexCombo.select(previousRecordLastIndex);
            if (recordLabels[previousRecordLastIndex].startsWith(NLS.bind((String)UiPluginResourceBundle.DATA_DLG_BEFORE, (Object)""))) {
                this.insertionRecordIndex = Integer.parseInt(recordLabels[previousRecordLastIndex].substring(NLS.bind((String)UiPluginResourceBundle.DATA_DLG_BEFORE, (Object)"").length()).trim());
            } else if (recordLabels[previousRecordLastIndex].startsWith(NLS.bind((String)UiPluginResourceBundle.DATA_DLG_AFTER, (Object)""))) {
                this.insertionRecordIndex = Integer.parseInt(recordLabels[previousRecordLastIndex].substring(NLS.bind((String)UiPluginResourceBundle.DATA_DLG_AFTER, (Object)"").length()).trim());
            }
        }
        superComposite.pack();
        return superComposite;
    }

    private String[] getRecordLabels() {
        String[] recordLabels = null;
        IDatapoolEquivalenceClass equivalenceClass = this.selectedRecord.getEquivalenceClass();
        if (equivalenceClass != null) {
            ArrayList<String> recordLabelsList = new ArrayList<String>();
            int selectedRecordIndex = this.getRecordIndex(equivalenceClass, this.selectedRecord);
            int counter = 0;
            while (counter < equivalenceClass.getRecordCount()) {
                if (counter != selectedRecordIndex) {
                    if (recordLabelsList.size() == 0) {
                        recordLabelsList.add(NLS.bind((String)UiPluginResourceBundle.DATA_DLG_BEFORE, (Object)new Integer(counter)));
                    }
                    recordLabelsList.add(NLS.bind((String)UiPluginResourceBundle.DATA_DLG_AFTER, (Object)new Integer(counter)));
                }
                ++counter;
            }
            recordLabels = recordLabelsList.size() == 0 ? new String[]{UiPluginResourceBundle.DATA_DLG_FIRST_RECORD} : recordLabelsList.toArray(new String[recordLabelsList.size()]);
        }
        return recordLabels;
    }

    private int getPreviousRecordLastIndex(String[] recordLabels) {
        int index = -1;
        if (recordLabels != null && this.previousRecord != null) {
            String previousRecordIndex = String.valueOf(this.getRecordIndex(this.previousRecord.getEquivalenceClass(), this.previousRecord));
            int counter = 0;
            while (counter < recordLabels.length) {
                if (recordLabels[counter].endsWith(previousRecordIndex)) {
                    if (index != -1) {
                        index = counter;
                        break;
                    }
                    index = counter;
                }
                ++counter;
            }
        }
        return index;
    }

    private int getRecordIndex(IDatapoolEquivalenceClass equivalenceClass, IDatapoolRecord record) {
        int counter = 0;
        while (counter < equivalenceClass.getRecordCount()) {
            if (equivalenceClass.getRecord(counter).equals(record)) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    public int getInsertionRecordIndex() {
        return this.insertionRecordIndex;
    }
}

